<?php
namespace metastore;
/**
 * Autogenerated by Thrift Compiler (0.9.3)
 *
 * DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
 *  @generated
 */
use Thrift\Base\TBase;
use Thrift\Type\TType;
use Thrift\Type\TMessageType;
use Thrift\Exception\TException;
use Thrift\Exception\TProtocolException;
use Thrift\Protocol\TProtocol;
use Thrift\Protocol\TBinaryProtocolAccelerated;
use Thrift\Exception\TApplicationException;


/**
 * This interface is live.
 */
interface ThriftHiveMetastoreIf extends \FacebookServiceIf {
  /**
   * @param string $key
   * @return string
   * @throws \metastore\MetaException
   */
  public function getMetaConf($key);
  /**
   * @param string $key
   * @param string $value
   * @throws \metastore\MetaException
   */
  public function setMetaConf($key, $value);
  /**
   * @param \metastore\Database $database
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   */
  public function create_database(\metastore\Database $database);
  /**
   * @param string $name
   * @return \metastore\Database
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_database($name);
  /**
   * @param string $name
   * @param bool $deleteData
   * @param bool $cascade
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function drop_database($name, $deleteData, $cascade);
  /**
   * @param string $pattern
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_databases($pattern);
  /**
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_all_databases();
  /**
   * @param string $dbname
   * @param \metastore\Database $db
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function alter_database($dbname, \metastore\Database $db);
  /**
   * @param string $name
   * @return \metastore\Type
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_type($name);
  /**
   * @param \metastore\Type $type
   * @return bool
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   */
  public function create_type(\metastore\Type $type);
  /**
   * @param string $type
   * @return bool
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function drop_type($type);
  /**
   * @param string $name
   * @return array
   * @throws \metastore\MetaException
   */
  public function get_type_all($name);
  /**
   * @param string $db_name
   * @param string $table_name
   * @return \metastore\FieldSchema[]
   * @throws \metastore\MetaException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownDBException
   */
  public function get_fields($db_name, $table_name);
  /**
   * @param string $db_name
   * @param string $table_name
   * @param \metastore\EnvironmentContext $environment_context
   * @return \metastore\FieldSchema[]
   * @throws \metastore\MetaException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownDBException
   */
  public function get_fields_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $table_name
   * @return \metastore\FieldSchema[]
   * @throws \metastore\MetaException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownDBException
   */
  public function get_schema($db_name, $table_name);
  /**
   * @param string $db_name
   * @param string $table_name
   * @param \metastore\EnvironmentContext $environment_context
   * @return \metastore\FieldSchema[]
   * @throws \metastore\MetaException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownDBException
   */
  public function get_schema_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context);
  /**
   * @param \metastore\Table $tbl
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function create_table(\metastore\Table $tbl);
  /**
   * @param \metastore\Table $tbl
   * @param \metastore\EnvironmentContext $environment_context
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function create_table_with_environment_context(\metastore\Table $tbl, \metastore\EnvironmentContext $environment_context);
  /**
   * @param \metastore\Table $tbl
   * @param \metastore\SQLPrimaryKey[] $primaryKeys
   * @param \metastore\SQLForeignKey[] $foreignKeys
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function create_table_with_constraints(\metastore\Table $tbl, array $primaryKeys, array $foreignKeys);
  /**
   * @param \metastore\DropConstraintRequest $req
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_constraint(\metastore\DropConstraintRequest $req);
  /**
   * @param \metastore\AddPrimaryKeyRequest $req
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function add_primary_key(\metastore\AddPrimaryKeyRequest $req);
  /**
   * @param \metastore\AddForeignKeyRequest $req
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function add_foreign_key(\metastore\AddForeignKeyRequest $req);
  /**
   * @param string $dbname
   * @param string $name
   * @param bool $deleteData
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_table($dbname, $name, $deleteData);
  /**
   * @param string $dbname
   * @param string $name
   * @param bool $deleteData
   * @param \metastore\EnvironmentContext $environment_context
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_table_with_environment_context($dbname, $name, $deleteData, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $pattern
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_tables($db_name, $pattern);
  /**
   * @param string $db_name
   * @param string $pattern
   * @param string $tableType
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_tables_by_type($db_name, $pattern, $tableType);
  /**
   * @param string $db_patterns
   * @param string $tbl_patterns
   * @param string[] $tbl_types
   * @return \metastore\TableMeta[]
   * @throws \metastore\MetaException
   */
  public function get_table_meta($db_patterns, $tbl_patterns, array $tbl_types);
  /**
   * @param string $db_name
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_all_tables($db_name);
  /**
   * @param string $dbname
   * @param string $tbl_name
   * @return \metastore\Table
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_table($dbname, $tbl_name);
  /**
   * @param string $dbname
   * @param string[] $tbl_names
   * @return \metastore\Table[]
   */
  public function get_table_objects_by_name($dbname, array $tbl_names);
  /**
   * @param \metastore\GetTableRequest $req
   * @return \metastore\GetTableResult
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_table_req(\metastore\GetTableRequest $req);
  /**
   * @param \metastore\GetTablesRequest $req
   * @return \metastore\GetTablesResult
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\UnknownDBException
   */
  public function get_table_objects_by_name_req(\metastore\GetTablesRequest $req);
  /**
   * @param string $dbname
   * @param string $filter
   * @param int $max_tables
   * @return string[]
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\UnknownDBException
   */
  public function get_table_names_by_filter($dbname, $filter, $max_tables);
  /**
   * @param string $dbname
   * @param string $tbl_name
   * @param \metastore\Table $new_tbl
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_table($dbname, $tbl_name, \metastore\Table $new_tbl);
  /**
   * @param string $dbname
   * @param string $tbl_name
   * @param \metastore\Table $new_tbl
   * @param \metastore\EnvironmentContext $environment_context
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_table_with_environment_context($dbname, $tbl_name, \metastore\Table $new_tbl, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $dbname
   * @param string $tbl_name
   * @param \metastore\Table $new_tbl
   * @param bool $cascade
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_table_with_cascade($dbname, $tbl_name, \metastore\Table $new_tbl, $cascade);
  /**
   * @param \metastore\Partition $new_part
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_partition(\metastore\Partition $new_part);
  /**
   * @param \metastore\Partition $new_part
   * @param \metastore\EnvironmentContext $environment_context
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_partition_with_environment_context(\metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context);
  /**
   * @param \metastore\Partition[] $new_parts
   * @return int
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_partitions(array $new_parts);
  /**
   * @param \metastore\PartitionSpec[] $new_parts
   * @return int
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_partitions_pspec(array $new_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function append_partition($db_name, $tbl_name, array $part_vals);
  /**
   * @param \metastore\AddPartitionsRequest $request
   * @return \metastore\AddPartitionsResult
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_partitions_req(\metastore\AddPartitionsRequest $request);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param \metastore\EnvironmentContext $environment_context
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function append_partition_with_environment_context($db_name, $tbl_name, array $part_vals, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function append_partition_by_name($db_name, $tbl_name, $part_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @param \metastore\EnvironmentContext $environment_context
   * @return \metastore\Partition
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param bool $deleteData
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_partition($db_name, $tbl_name, array $part_vals, $deleteData);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param bool $deleteData
   * @param \metastore\EnvironmentContext $environment_context
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_partition_with_environment_context($db_name, $tbl_name, array $part_vals, $deleteData, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @param bool $deleteData
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @param bool $deleteData
   * @param \metastore\EnvironmentContext $environment_context
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, \metastore\EnvironmentContext $environment_context);
  /**
   * @param \metastore\DropPartitionsRequest $req
   * @return \metastore\DropPartitionsResult
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_partitions_req(\metastore\DropPartitionsRequest $req);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @return \metastore\Partition
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partition($db_name, $tbl_name, array $part_vals);
  /**
   * @param array $partitionSpecs
   * @param string $source_db
   * @param string $source_table_name
   * @param string $dest_db
   * @param string $dest_table_name
   * @return \metastore\Partition
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\InvalidInputException
   */
  public function exchange_partition(array $partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name);
  /**
   * @param array $partitionSpecs
   * @param string $source_db
   * @param string $source_table_name
   * @param string $dest_db
   * @param string $dest_table_name
   * @return \metastore\Partition[]
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\InvalidInputException
   */
  public function exchange_partitions(array $partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param string $user_name
   * @param string[] $group_names
   * @return \metastore\Partition
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partition_with_auth($db_name, $tbl_name, array $part_vals, $user_name, array $group_names);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @return \metastore\Partition
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partition_by_name($db_name, $tbl_name, $part_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_parts
   * @return \metastore\Partition[]
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_partitions($db_name, $tbl_name, $max_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_parts
   * @param string $user_name
   * @param string[] $group_names
   * @return \metastore\Partition[]
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, array $group_names);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_parts
   * @return \metastore\PartitionSpec[]
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_partitions_pspec($db_name, $tbl_name, $max_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_parts
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_partition_names($db_name, $tbl_name, $max_parts);
  /**
   * @param \metastore\PartitionValuesRequest $request
   * @return \metastore\PartitionValuesResponse
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partition_values(\metastore\PartitionValuesRequest $request);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param int $max_parts
   * @return \metastore\Partition[]
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partitions_ps($db_name, $tbl_name, array $part_vals, $max_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param int $max_parts
   * @param string $user_name
   * @param string[] $group_names
   * @return \metastore\Partition[]
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_partitions_ps_with_auth($db_name, $tbl_name, array $part_vals, $max_parts, $user_name, array $group_names);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param int $max_parts
   * @return string[]
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partition_names_ps($db_name, $tbl_name, array $part_vals, $max_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $filter
   * @param int $max_parts
   * @return \metastore\Partition[]
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $filter
   * @param int $max_parts
   * @return \metastore\PartitionSpec[]
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_part_specs_by_filter($db_name, $tbl_name, $filter, $max_parts);
  /**
   * @param \metastore\PartitionsByExprRequest $req
   * @return \metastore\PartitionsByExprResult
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partitions_by_expr(\metastore\PartitionsByExprRequest $req);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $filter
   * @return int
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_num_partitions_by_filter($db_name, $tbl_name, $filter);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $names
   * @return \metastore\Partition[]
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_partitions_by_names($db_name, $tbl_name, array $names);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param \metastore\Partition $new_part
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_partition($db_name, $tbl_name, \metastore\Partition $new_part);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param \metastore\Partition[] $new_parts
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_partitions($db_name, $tbl_name, array $new_parts);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param \metastore\Partition[] $new_parts
   * @param \metastore\EnvironmentContext $environment_context
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_partitions_with_environment_context($db_name, $tbl_name, array $new_parts, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param \metastore\Partition $new_part
   * @param \metastore\EnvironmentContext $environment_context
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_partition_with_environment_context($db_name, $tbl_name, \metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string[] $part_vals
   * @param \metastore\Partition $new_part
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function rename_partition($db_name, $tbl_name, array $part_vals, \metastore\Partition $new_part);
  /**
   * @param string[] $part_vals
   * @param bool $throw_exception
   * @return bool
   * @throws \metastore\MetaException
   */
  public function partition_name_has_valid_characters(array $part_vals, $throw_exception);
  /**
   * @param string $name
   * @param string $defaultValue
   * @return string
   * @throws \metastore\ConfigValSecurityException
   */
  public function get_config_value($name, $defaultValue);
  /**
   * @param string $part_name
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function partition_name_to_vals($part_name);
  /**
   * @param string $part_name
   * @return array
   * @throws \metastore\MetaException
   */
  public function partition_name_to_spec($part_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param array $part_vals
   * @param int $eventType
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\UnknownDBException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownPartitionException
   * @throws \metastore\InvalidPartitionException
   */
  public function markPartitionForEvent($db_name, $tbl_name, array $part_vals, $eventType);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param array $part_vals
   * @param int $eventType
   * @return bool
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\UnknownDBException
   * @throws \metastore\UnknownTableException
   * @throws \metastore\UnknownPartitionException
   * @throws \metastore\InvalidPartitionException
   */
  public function isPartitionMarkedForEvent($db_name, $tbl_name, array $part_vals, $eventType);
  /**
   * @param \metastore\Index $new_index
   * @param \metastore\Table $index_table
   * @return \metastore\Index
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\MetaException
   */
  public function add_index(\metastore\Index $new_index, \metastore\Table $index_table);
  /**
   * @param string $dbname
   * @param string $base_tbl_name
   * @param string $idx_name
   * @param \metastore\Index $new_idx
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_index($dbname, $base_tbl_name, $idx_name, \metastore\Index $new_idx);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $index_name
   * @param bool $deleteData
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $index_name
   * @return \metastore\Index
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_index_by_name($db_name, $tbl_name, $index_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_indexes
   * @return \metastore\Index[]
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_indexes($db_name, $tbl_name, $max_indexes);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param int $max_indexes
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_index_names($db_name, $tbl_name, $max_indexes);
  /**
   * @param \metastore\PrimaryKeysRequest $request
   * @return \metastore\PrimaryKeysResponse
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_primary_keys(\metastore\PrimaryKeysRequest $request);
  /**
   * @param \metastore\ForeignKeysRequest $request
   * @return \metastore\ForeignKeysResponse
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_foreign_keys(\metastore\ForeignKeysRequest $request);
  /**
   * @param \metastore\ColumnStatistics $stats_obj
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidInputException
   */
  public function update_table_column_statistics(\metastore\ColumnStatistics $stats_obj);
  /**
   * @param \metastore\ColumnStatistics $stats_obj
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidInputException
   */
  public function update_partition_column_statistics(\metastore\ColumnStatistics $stats_obj);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $col_name
   * @return \metastore\ColumnStatistics
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidInputException
   * @throws \metastore\InvalidObjectException
   */
  public function get_table_column_statistics($db_name, $tbl_name, $col_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @param string $col_name
   * @return \metastore\ColumnStatistics
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidInputException
   * @throws \metastore\InvalidObjectException
   */
  public function get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
  /**
   * @param \metastore\TableStatsRequest $request
   * @return \metastore\TableStatsResult
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_table_statistics_req(\metastore\TableStatsRequest $request);
  /**
   * @param \metastore\PartitionsStatsRequest $request
   * @return \metastore\PartitionsStatsResult
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_partitions_statistics_req(\metastore\PartitionsStatsRequest $request);
  /**
   * @param \metastore\PartitionsStatsRequest $request
   * @return \metastore\AggrStats
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function get_aggr_stats_for(\metastore\PartitionsStatsRequest $request);
  /**
   * @param \metastore\SetPartitionsStatsRequest $request
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidInputException
   */
  public function set_aggr_stats_for(\metastore\SetPartitionsStatsRequest $request);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $part_name
   * @param string $col_name
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\InvalidInputException
   */
  public function delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
  /**
   * @param string $db_name
   * @param string $tbl_name
   * @param string $col_name
   * @return bool
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\InvalidInputException
   */
  public function delete_table_column_statistics($db_name, $tbl_name, $col_name);
  /**
   * @param \metastore\Function $func
   * @throws \metastore\AlreadyExistsException
   * @throws \metastore\InvalidObjectException
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function create_function(\metastore\Function $func);
  /**
   * @param string $dbName
   * @param string $funcName
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function drop_function($dbName, $funcName);
  /**
   * @param string $dbName
   * @param string $funcName
   * @param \metastore\Function $newFunc
   * @throws \metastore\InvalidOperationException
   * @throws \metastore\MetaException
   */
  public function alter_function($dbName, $funcName, \metastore\Function $newFunc);
  /**
   * @param string $dbName
   * @param string $pattern
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_functions($dbName, $pattern);
  /**
   * @param string $dbName
   * @param string $funcName
   * @return \metastore\Function
   * @throws \metastore\MetaException
   * @throws \metastore\NoSuchObjectException
   */
  public function get_function($dbName, $funcName);
  /**
   * @return \metastore\GetAllFunctionsResponse
   * @throws \metastore\MetaException
   */
  public function get_all_functions();
  /**
   * @param \metastore\Role $role
   * @return bool
   * @throws \metastore\MetaException
   */
  public function create_role(\metastore\Role $role);
  /**
   * @param string $role_name
   * @return bool
   * @throws \metastore\MetaException
   */
  public function drop_role($role_name);
  /**
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function get_role_names();
  /**
   * @param string $role_name
   * @param string $principal_name
   * @param int $principal_type
   * @param string $grantor
   * @param int $grantorType
   * @param bool $grant_option
   * @return bool
   * @throws \metastore\MetaException
   */
  public function grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option);
  /**
   * @param string $role_name
   * @param string $principal_name
   * @param int $principal_type
   * @return bool
   * @throws \metastore\MetaException
   */
  public function revoke_role($role_name, $principal_name, $principal_type);
  /**
   * @param string $principal_name
   * @param int $principal_type
   * @return \metastore\Role[]
   * @throws \metastore\MetaException
   */
  public function list_roles($principal_name, $principal_type);
  /**
   * @param \metastore\GrantRevokeRoleRequest $request
   * @return \metastore\GrantRevokeRoleResponse
   * @throws \metastore\MetaException
   */
  public function grant_revoke_role(\metastore\GrantRevokeRoleRequest $request);
  /**
   * @param \metastore\GetPrincipalsInRoleRequest $request
   * @return \metastore\GetPrincipalsInRoleResponse
   * @throws \metastore\MetaException
   */
  public function get_principals_in_role(\metastore\GetPrincipalsInRoleRequest $request);
  /**
   * @param \metastore\GetRoleGrantsForPrincipalRequest $request
   * @return \metastore\GetRoleGrantsForPrincipalResponse
   * @throws \metastore\MetaException
   */
  public function get_role_grants_for_principal(\metastore\GetRoleGrantsForPrincipalRequest $request);
  /**
   * @param \metastore\HiveObjectRef $hiveObject
   * @param string $user_name
   * @param string[] $group_names
   * @return \metastore\PrincipalPrivilegeSet
   * @throws \metastore\MetaException
   */
  public function get_privilege_set(\metastore\HiveObjectRef $hiveObject, $user_name, array $group_names);
  /**
   * @param string $principal_name
   * @param int $principal_type
   * @param \metastore\HiveObjectRef $hiveObject
   * @return \metastore\HiveObjectPrivilege[]
   * @throws \metastore\MetaException
   */
  public function list_privileges($principal_name, $principal_type, \metastore\HiveObjectRef $hiveObject);
  /**
   * @param \metastore\PrivilegeBag $privileges
   * @return bool
   * @throws \metastore\MetaException
   */
  public function grant_privileges(\metastore\PrivilegeBag $privileges);
  /**
   * @param \metastore\PrivilegeBag $privileges
   * @return bool
   * @throws \metastore\MetaException
   */
  public function revoke_privileges(\metastore\PrivilegeBag $privileges);
  /**
   * @param \metastore\GrantRevokePrivilegeRequest $request
   * @return \metastore\GrantRevokePrivilegeResponse
   * @throws \metastore\MetaException
   */
  public function grant_revoke_privileges(\metastore\GrantRevokePrivilegeRequest $request);
  /**
   * @param string $user_name
   * @param string[] $group_names
   * @return string[]
   * @throws \metastore\MetaException
   */
  public function set_ugi($user_name, array $group_names);
  /**
   * @param string $token_owner
   * @param string $renewer_kerberos_principal_name
   * @return string
   * @throws \metastore\MetaException
   */
  public function get_delegation_token($token_owner, $renewer_kerberos_principal_name);
  /**
   * @param string $token_str_form
   * @return int
   * @throws \metastore\MetaException
   */
  public function renew_delegation_token($token_str_form);
  /**
   * @param string $token_str_form
   * @throws \metastore\MetaException
   */
  public function cancel_delegation_token($token_str_form);
  /**
   * @param string $token_identifier
   * @param string $delegation_token
   * @return bool
   */
  public function add_token($token_identifier, $delegation_token);
  /**
   * @param string $token_identifier
   * @return bool
   */
  public function remove_token($token_identifier);
  /**
   * @param string $token_identifier
   * @return string
   */
  public function get_token($token_identifier);
  /**
   * @return string[]
   */
  public function get_all_token_identifiers();
  /**
   * @param string $key
   * @return int
   * @throws \metastore\MetaException
   */
  public function add_master_key($key);
  /**
   * @param int $seq_number
   * @param string $key
   * @throws \metastore\NoSuchObjectException
   * @throws \metastore\MetaException
   */
  public function update_master_key($seq_number, $key);
  /**
   * @param int $key_seq
   * @return bool
   */
  public function remove_master_key($key_seq);
  /**
   * @return string[]
   */
  public function get_master_keys();
  /**
   * @return \metastore\GetOpenTxnsResponse
   */
  public function get_open_txns();
  /**
   * @return \metastore\GetOpenTxnsInfoResponse
   */
  public function get_open_txns_info();
  /**
   * @param \metastore\OpenTxnRequest $rqst
   * @return \metastore\OpenTxnsResponse
   */
  public function open_txns(\metastore\OpenTxnRequest $rqst);
  /**
   * @param \metastore\AbortTxnRequest $rqst
   * @throws \metastore\NoSuchTxnException
   */
  public function abort_txn(\metastore\AbortTxnRequest $rqst);
  /**
   * @param \metastore\AbortTxnsRequest $rqst
   * @throws \metastore\NoSuchTxnException
   */
  public function abort_txns(\metastore\AbortTxnsRequest $rqst);
  /**
   * @param \metastore\CommitTxnRequest $rqst
   * @throws \metastore\NoSuchTxnException
   * @throws \metastore\TxnAbortedException
   */
  public function commit_txn(\metastore\CommitTxnRequest $rqst);
  /**
   * @param \metastore\LockRequest $rqst
   * @return \metastore\LockResponse
   * @throws \metastore\NoSuchTxnException
   * @throws \metastore\TxnAbortedException
   */
  public function lock(\metastore\LockRequest $rqst);
  /**
   * @param \metastore\CheckLockRequest $rqst
   * @return \metastore\LockResponse
   * @throws \metastore\NoSuchTxnException
   * @throws \metastore\TxnAbortedException
   * @throws \metastore\NoSuchLockException
   */
  public function check_lock(\metastore\CheckLockRequest $rqst);
  /**
   * @param \metastore\UnlockRequest $rqst
   * @throws \metastore\NoSuchLockException
   * @throws \metastore\TxnOpenException
   */
  public function unlock(\metastore\UnlockRequest $rqst);
  /**
   * @param \metastore\ShowLocksRequest $rqst
   * @return \metastore\ShowLocksResponse
   */
  public function show_locks(\metastore\ShowLocksRequest $rqst);
  /**
   * @param \metastore\HeartbeatRequest $ids
   * @throws \metastore\NoSuchLockException
   * @throws \metastore\NoSuchTxnException
   * @throws \metastore\TxnAbortedException
   */
  public function heartbeat(\metastore\HeartbeatRequest $ids);
  /**
   * @param \metastore\HeartbeatTxnRangeRequest $txns
   * @return \metastore\HeartbeatTxnRangeResponse
   */
  public function heartbeat_txn_range(\metastore\HeartbeatTxnRangeRequest $txns);
  /**
   * @param \metastore\CompactionRequest $rqst
   */
  public function compact(\metastore\CompactionRequest $rqst);
  /**
   * @param \metastore\CompactionRequest $rqst
   * @return \metastore\CompactionResponse
   */
  public function compact2(\metastore\CompactionRequest $rqst);
  /**
   * @param \metastore\ShowCompactRequest $rqst
   * @return \metastore\ShowCompactResponse
   */
  public function show_compact(\metastore\ShowCompactRequest $rqst);
  /**
   * @param \metastore\AddDynamicPartitions $rqst
   * @throws \metastore\NoSuchTxnException
   * @throws \metastore\TxnAbortedException
   */
  public function add_dynamic_partitions(\metastore\AddDynamicPartitions $rqst);
  /**
   * @param \metastore\NotificationEventRequest $rqst
   * @return \metastore\NotificationEventResponse
   */
  public function get_next_notification(\metastore\NotificationEventRequest $rqst);
  /**
   * @return \metastore\CurrentNotificationEventId
   */
  public function get_current_notificationEventId();
  /**
   * @param \metastore\FireEventRequest $rqst
   * @return \metastore\FireEventResponse
   */
  public function fire_listener_event(\metastore\FireEventRequest $rqst);
  /**
   */
  public function flushCache();
  /**
   * @param \metastore\GetFileMetadataByExprRequest $req
   * @return \metastore\GetFileMetadataByExprResult
   */
  public function get_file_metadata_by_expr(\metastore\GetFileMetadataByExprRequest $req);
  /**
   * @param \metastore\GetFileMetadataRequest $req
   * @return \metastore\GetFileMetadataResult
   */
  public function get_file_metadata(\metastore\GetFileMetadataRequest $req);
  /**
   * @param \metastore\PutFileMetadataRequest $req
   * @return \metastore\PutFileMetadataResult
   */
  public function put_file_metadata(\metastore\PutFileMetadataRequest $req);
  /**
   * @param \metastore\ClearFileMetadataRequest $req
   * @return \metastore\ClearFileMetadataResult
   */
  public function clear_file_metadata(\metastore\ClearFileMetadataRequest $req);
  /**
   * @param \metastore\CacheFileMetadataRequest $req
   * @return \metastore\CacheFileMetadataResult
   */
  public function cache_file_metadata(\metastore\CacheFileMetadataRequest $req);
}

class ThriftHiveMetastoreClient extends \FacebookServiceClient implements \metastore\ThriftHiveMetastoreIf {
  public function __construct($input, $output=null) {
    parent::__construct($input, $output);
  }

  public function getMetaConf($key)
  {
    $this->send_getMetaConf($key);
    return $this->recv_getMetaConf();
  }

  public function send_getMetaConf($key)
  {
    $args = new \metastore\ThriftHiveMetastore_getMetaConf_args();
    $args->key = $key;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'getMetaConf', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('getMetaConf', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_getMetaConf()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_getMetaConf_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_getMetaConf_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("getMetaConf failed: unknown result");
  }

  public function setMetaConf($key, $value)
  {
    $this->send_setMetaConf($key, $value);
    $this->recv_setMetaConf();
  }

  public function send_setMetaConf($key, $value)
  {
    $args = new \metastore\ThriftHiveMetastore_setMetaConf_args();
    $args->key = $key;
    $args->value = $value;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'setMetaConf', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('setMetaConf', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_setMetaConf()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_setMetaConf_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_setMetaConf_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    return;
  }

  public function create_database(\metastore\Database $database)
  {
    $this->send_create_database($database);
    $this->recv_create_database();
  }

  public function send_create_database(\metastore\Database $database)
  {
    $args = new \metastore\ThriftHiveMetastore_create_database_args();
    $args->database = $database;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_database()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function get_database($name)
  {
    $this->send_get_database($name);
    return $this->recv_get_database();
  }

  public function send_get_database($name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_database_args();
    $args->name = $name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_database()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_database failed: unknown result");
  }

  public function drop_database($name, $deleteData, $cascade)
  {
    $this->send_drop_database($name, $deleteData, $cascade);
    $this->recv_drop_database();
  }

  public function send_drop_database($name, $deleteData, $cascade)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_database_args();
    $args->name = $name;
    $args->deleteData = $deleteData;
    $args->cascade = $cascade;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_database()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function get_databases($pattern)
  {
    $this->send_get_databases($pattern);
    return $this->recv_get_databases();
  }

  public function send_get_databases($pattern)
  {
    $args = new \metastore\ThriftHiveMetastore_get_databases_args();
    $args->pattern = $pattern;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_databases', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_databases', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_databases()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_databases_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_databases_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_databases failed: unknown result");
  }

  public function get_all_databases()
  {
    $this->send_get_all_databases();
    return $this->recv_get_all_databases();
  }

  public function send_get_all_databases()
  {
    $args = new \metastore\ThriftHiveMetastore_get_all_databases_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_all_databases', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_all_databases', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_all_databases()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_all_databases_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_all_databases_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_all_databases failed: unknown result");
  }

  public function alter_database($dbname, \metastore\Database $db)
  {
    $this->send_alter_database($dbname, $db);
    $this->recv_alter_database();
  }

  public function send_alter_database($dbname, \metastore\Database $db)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_database_args();
    $args->dbname = $dbname;
    $args->db = $db;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_database', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_database', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_database()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_database_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_database_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function get_type($name)
  {
    $this->send_get_type($name);
    return $this->recv_get_type();
  }

  public function send_get_type($name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_type_args();
    $args->name = $name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_type', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_type', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_type()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_type_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_type_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_type failed: unknown result");
  }

  public function create_type(\metastore\Type $type)
  {
    $this->send_create_type($type);
    return $this->recv_create_type();
  }

  public function send_create_type(\metastore\Type $type)
  {
    $args = new \metastore\ThriftHiveMetastore_create_type_args();
    $args->type = $type;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_type', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_type', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_type()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_type_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_type_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("create_type failed: unknown result");
  }

  public function drop_type($type)
  {
    $this->send_drop_type($type);
    return $this->recv_drop_type();
  }

  public function send_drop_type($type)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_type_args();
    $args->type = $type;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_type', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_type', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_type()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_type_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_type_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_type failed: unknown result");
  }

  public function get_type_all($name)
  {
    $this->send_get_type_all($name);
    return $this->recv_get_type_all();
  }

  public function send_get_type_all($name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_type_all_args();
    $args->name = $name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_type_all', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_type_all', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_type_all()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_type_all_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_type_all_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_type_all failed: unknown result");
  }

  public function get_fields($db_name, $table_name)
  {
    $this->send_get_fields($db_name, $table_name);
    return $this->recv_get_fields();
  }

  public function send_get_fields($db_name, $table_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_fields_args();
    $args->db_name = $db_name;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_fields', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_fields', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_fields()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_fields_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_fields_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_fields failed: unknown result");
  }

  public function get_fields_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_get_fields_with_environment_context($db_name, $table_name, $environment_context);
    return $this->recv_get_fields_with_environment_context();
  }

  public function send_get_fields_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_get_fields_with_environment_context_args();
    $args->db_name = $db_name;
    $args->table_name = $table_name;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_fields_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_fields_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_fields_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_fields_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_fields_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_fields_with_environment_context failed: unknown result");
  }

  public function get_schema($db_name, $table_name)
  {
    $this->send_get_schema($db_name, $table_name);
    return $this->recv_get_schema();
  }

  public function send_get_schema($db_name, $table_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_schema_args();
    $args->db_name = $db_name;
    $args->table_name = $table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_schema', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_schema', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_schema()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_schema_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_schema_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_schema failed: unknown result");
  }

  public function get_schema_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_get_schema_with_environment_context($db_name, $table_name, $environment_context);
    return $this->recv_get_schema_with_environment_context();
  }

  public function send_get_schema_with_environment_context($db_name, $table_name, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_get_schema_with_environment_context_args();
    $args->db_name = $db_name;
    $args->table_name = $table_name;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_schema_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_schema_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_schema_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_schema_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_schema_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_schema_with_environment_context failed: unknown result");
  }

  public function create_table(\metastore\Table $tbl)
  {
    $this->send_create_table($tbl);
    $this->recv_create_table();
  }

  public function send_create_table(\metastore\Table $tbl)
  {
    $args = new \metastore\ThriftHiveMetastore_create_table_args();
    $args->tbl = $tbl;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    return;
  }

  public function create_table_with_environment_context(\metastore\Table $tbl, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_create_table_with_environment_context($tbl, $environment_context);
    $this->recv_create_table_with_environment_context();
  }

  public function send_create_table_with_environment_context(\metastore\Table $tbl, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_create_table_with_environment_context_args();
    $args->tbl = $tbl;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_table_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_table_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_table_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_table_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_table_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    return;
  }

  public function create_table_with_constraints(\metastore\Table $tbl, array $primaryKeys, array $foreignKeys)
  {
    $this->send_create_table_with_constraints($tbl, $primaryKeys, $foreignKeys);
    $this->recv_create_table_with_constraints();
  }

  public function send_create_table_with_constraints(\metastore\Table $tbl, array $primaryKeys, array $foreignKeys)
  {
    $args = new \metastore\ThriftHiveMetastore_create_table_with_constraints_args();
    $args->tbl = $tbl;
    $args->primaryKeys = $primaryKeys;
    $args->foreignKeys = $foreignKeys;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_table_with_constraints', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_table_with_constraints', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_table_with_constraints()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_table_with_constraints_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_table_with_constraints_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    return;
  }

  public function drop_constraint(\metastore\DropConstraintRequest $req)
  {
    $this->send_drop_constraint($req);
    $this->recv_drop_constraint();
  }

  public function send_drop_constraint(\metastore\DropConstraintRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_constraint_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_constraint', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_constraint', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_constraint()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_constraint_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_constraint_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function add_primary_key(\metastore\AddPrimaryKeyRequest $req)
  {
    $this->send_add_primary_key($req);
    $this->recv_add_primary_key();
  }

  public function send_add_primary_key(\metastore\AddPrimaryKeyRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_add_primary_key_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_primary_key', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_primary_key', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_primary_key()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_primary_key_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_primary_key_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function add_foreign_key(\metastore\AddForeignKeyRequest $req)
  {
    $this->send_add_foreign_key($req);
    $this->recv_add_foreign_key();
  }

  public function send_add_foreign_key(\metastore\AddForeignKeyRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_add_foreign_key_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_foreign_key', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_foreign_key', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_foreign_key()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_foreign_key_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_foreign_key_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function drop_table($dbname, $name, $deleteData)
  {
    $this->send_drop_table($dbname, $name, $deleteData);
    $this->recv_drop_table();
  }

  public function send_drop_table($dbname, $name, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_table_args();
    $args->dbname = $dbname;
    $args->name = $name;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function drop_table_with_environment_context($dbname, $name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_drop_table_with_environment_context($dbname, $name, $deleteData, $environment_context);
    $this->recv_drop_table_with_environment_context();
  }

  public function send_drop_table_with_environment_context($dbname, $name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_table_with_environment_context_args();
    $args->dbname = $dbname;
    $args->name = $name;
    $args->deleteData = $deleteData;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_table_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_table_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_table_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_table_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_table_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function get_tables($db_name, $pattern)
  {
    $this->send_get_tables($db_name, $pattern);
    return $this->recv_get_tables();
  }

  public function send_get_tables($db_name, $pattern)
  {
    $args = new \metastore\ThriftHiveMetastore_get_tables_args();
    $args->db_name = $db_name;
    $args->pattern = $pattern;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_tables', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_tables', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_tables()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_tables_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_tables_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_tables failed: unknown result");
  }

  public function get_tables_by_type($db_name, $pattern, $tableType)
  {
    $this->send_get_tables_by_type($db_name, $pattern, $tableType);
    return $this->recv_get_tables_by_type();
  }

  public function send_get_tables_by_type($db_name, $pattern, $tableType)
  {
    $args = new \metastore\ThriftHiveMetastore_get_tables_by_type_args();
    $args->db_name = $db_name;
    $args->pattern = $pattern;
    $args->tableType = $tableType;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_tables_by_type', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_tables_by_type', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_tables_by_type()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_tables_by_type_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_tables_by_type_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_tables_by_type failed: unknown result");
  }

  public function get_table_meta($db_patterns, $tbl_patterns, array $tbl_types)
  {
    $this->send_get_table_meta($db_patterns, $tbl_patterns, $tbl_types);
    return $this->recv_get_table_meta();
  }

  public function send_get_table_meta($db_patterns, $tbl_patterns, array $tbl_types)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_meta_args();
    $args->db_patterns = $db_patterns;
    $args->tbl_patterns = $tbl_patterns;
    $args->tbl_types = $tbl_types;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_meta', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_meta', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_meta()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_meta_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_meta_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_table_meta failed: unknown result");
  }

  public function get_all_tables($db_name)
  {
    $this->send_get_all_tables($db_name);
    return $this->recv_get_all_tables();
  }

  public function send_get_all_tables($db_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_all_tables_args();
    $args->db_name = $db_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_all_tables', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_all_tables', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_all_tables()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_all_tables_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_all_tables_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_all_tables failed: unknown result");
  }

  public function get_table($dbname, $tbl_name)
  {
    $this->send_get_table($dbname, $tbl_name);
    return $this->recv_get_table();
  }

  public function send_get_table($dbname, $tbl_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_args();
    $args->dbname = $dbname;
    $args->tbl_name = $tbl_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_table failed: unknown result");
  }

  public function get_table_objects_by_name($dbname, array $tbl_names)
  {
    $this->send_get_table_objects_by_name($dbname, $tbl_names);
    return $this->recv_get_table_objects_by_name();
  }

  public function send_get_table_objects_by_name($dbname, array $tbl_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_objects_by_name_args();
    $args->dbname = $dbname;
    $args->tbl_names = $tbl_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_objects_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_objects_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_objects_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_objects_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_objects_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_table_objects_by_name failed: unknown result");
  }

  public function get_table_req(\metastore\GetTableRequest $req)
  {
    $this->send_get_table_req($req);
    return $this->recv_get_table_req();
  }

  public function send_get_table_req(\metastore\GetTableRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_req_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_req', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_req', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_req()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_req_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_req_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_table_req failed: unknown result");
  }

  public function get_table_objects_by_name_req(\metastore\GetTablesRequest $req)
  {
    $this->send_get_table_objects_by_name_req($req);
    return $this->recv_get_table_objects_by_name_req();
  }

  public function send_get_table_objects_by_name_req(\metastore\GetTablesRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_objects_by_name_req_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_objects_by_name_req', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_objects_by_name_req', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_objects_by_name_req()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_objects_by_name_req_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_objects_by_name_req_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_table_objects_by_name_req failed: unknown result");
  }

  public function get_table_names_by_filter($dbname, $filter, $max_tables)
  {
    $this->send_get_table_names_by_filter($dbname, $filter, $max_tables);
    return $this->recv_get_table_names_by_filter();
  }

  public function send_get_table_names_by_filter($dbname, $filter, $max_tables)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_names_by_filter_args();
    $args->dbname = $dbname;
    $args->filter = $filter;
    $args->max_tables = $max_tables;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_names_by_filter', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_names_by_filter', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_names_by_filter()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_names_by_filter_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_names_by_filter_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("get_table_names_by_filter failed: unknown result");
  }

  public function alter_table($dbname, $tbl_name, \metastore\Table $new_tbl)
  {
    $this->send_alter_table($dbname, $tbl_name, $new_tbl);
    $this->recv_alter_table();
  }

  public function send_alter_table($dbname, $tbl_name, \metastore\Table $new_tbl)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_table_args();
    $args->dbname = $dbname;
    $args->tbl_name = $tbl_name;
    $args->new_tbl = $new_tbl;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_table', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_table', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_table()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_table_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_table_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_table_with_environment_context($dbname, $tbl_name, \metastore\Table $new_tbl, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_alter_table_with_environment_context($dbname, $tbl_name, $new_tbl, $environment_context);
    $this->recv_alter_table_with_environment_context();
  }

  public function send_alter_table_with_environment_context($dbname, $tbl_name, \metastore\Table $new_tbl, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_table_with_environment_context_args();
    $args->dbname = $dbname;
    $args->tbl_name = $tbl_name;
    $args->new_tbl = $new_tbl;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_table_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_table_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_table_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_table_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_table_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_table_with_cascade($dbname, $tbl_name, \metastore\Table $new_tbl, $cascade)
  {
    $this->send_alter_table_with_cascade($dbname, $tbl_name, $new_tbl, $cascade);
    $this->recv_alter_table_with_cascade();
  }

  public function send_alter_table_with_cascade($dbname, $tbl_name, \metastore\Table $new_tbl, $cascade)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_table_with_cascade_args();
    $args->dbname = $dbname;
    $args->tbl_name = $tbl_name;
    $args->new_tbl = $new_tbl;
    $args->cascade = $cascade;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_table_with_cascade', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_table_with_cascade', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_table_with_cascade()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_table_with_cascade_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_table_with_cascade_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function add_partition(\metastore\Partition $new_part)
  {
    $this->send_add_partition($new_part);
    return $this->recv_add_partition();
  }

  public function send_add_partition(\metastore\Partition $new_part)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partition_args();
    $args->new_part = $new_part;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partition failed: unknown result");
  }

  public function add_partition_with_environment_context(\metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_add_partition_with_environment_context($new_part, $environment_context);
    return $this->recv_add_partition_with_environment_context();
  }

  public function send_add_partition_with_environment_context(\metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partition_with_environment_context_args();
    $args->new_part = $new_part;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partition_with_environment_context failed: unknown result");
  }

  public function add_partitions(array $new_parts)
  {
    $this->send_add_partitions($new_parts);
    return $this->recv_add_partitions();
  }

  public function send_add_partitions(array $new_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partitions_args();
    $args->new_parts = $new_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partitions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partitions failed: unknown result");
  }

  public function add_partitions_pspec(array $new_parts)
  {
    $this->send_add_partitions_pspec($new_parts);
    return $this->recv_add_partitions_pspec();
  }

  public function send_add_partitions_pspec(array $new_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partitions_pspec_args();
    $args->new_parts = $new_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partitions_pspec', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partitions_pspec', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partitions_pspec()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partitions_pspec_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partitions_pspec_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partitions_pspec failed: unknown result");
  }

  public function append_partition($db_name, $tbl_name, array $part_vals)
  {
    $this->send_append_partition($db_name, $tbl_name, $part_vals);
    return $this->recv_append_partition();
  }

  public function send_append_partition($db_name, $tbl_name, array $part_vals)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition failed: unknown result");
  }

  public function add_partitions_req(\metastore\AddPartitionsRequest $request)
  {
    $this->send_add_partitions_req($request);
    return $this->recv_add_partitions_req();
  }

  public function send_add_partitions_req(\metastore\AddPartitionsRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_add_partitions_req_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_partitions_req', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_partitions_req', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_partitions_req()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_partitions_req_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_partitions_req_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_partitions_req failed: unknown result");
  }

  public function append_partition_with_environment_context($db_name, $tbl_name, array $part_vals, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_append_partition_with_environment_context($db_name, $tbl_name, $part_vals, $environment_context);
    return $this->recv_append_partition_with_environment_context();
  }

  public function send_append_partition_with_environment_context($db_name, $tbl_name, array $part_vals, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition_with_environment_context failed: unknown result");
  }

  public function append_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $this->send_append_partition_by_name($db_name, $tbl_name, $part_name);
    return $this->recv_append_partition_by_name();
  }

  public function send_append_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition_by_name failed: unknown result");
  }

  public function append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $environment_context);
    return $this->recv_append_partition_by_name_with_environment_context();
  }

  public function send_append_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_append_partition_by_name_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'append_partition_by_name_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('append_partition_by_name_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_append_partition_by_name_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_append_partition_by_name_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_append_partition_by_name_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("append_partition_by_name_with_environment_context failed: unknown result");
  }

  public function drop_partition($db_name, $tbl_name, array $part_vals, $deleteData)
  {
    $this->send_drop_partition($db_name, $tbl_name, $part_vals, $deleteData);
    return $this->recv_drop_partition();
  }

  public function send_drop_partition($db_name, $tbl_name, array $part_vals, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition failed: unknown result");
  }

  public function drop_partition_with_environment_context($db_name, $tbl_name, array $part_vals, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_drop_partition_with_environment_context($db_name, $tbl_name, $part_vals, $deleteData, $environment_context);
    return $this->recv_drop_partition_with_environment_context();
  }

  public function send_drop_partition_with_environment_context($db_name, $tbl_name, array $part_vals, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->deleteData = $deleteData;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition_with_environment_context failed: unknown result");
  }

  public function drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData)
  {
    $this->send_drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData);
    return $this->recv_drop_partition_by_name();
  }

  public function send_drop_partition_by_name($db_name, $tbl_name, $part_name, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition_by_name failed: unknown result");
  }

  public function drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, $environment_context);
    return $this->recv_drop_partition_by_name_with_environment_context();
  }

  public function send_drop_partition_by_name_with_environment_context($db_name, $tbl_name, $part_name, $deleteData, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->deleteData = $deleteData;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partition_by_name_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partition_by_name_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partition_by_name_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partition_by_name_with_environment_context failed: unknown result");
  }

  public function drop_partitions_req(\metastore\DropPartitionsRequest $req)
  {
    $this->send_drop_partitions_req($req);
    return $this->recv_drop_partitions_req();
  }

  public function send_drop_partitions_req(\metastore\DropPartitionsRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_partitions_req_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_partitions_req', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_partitions_req', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_partitions_req()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_partitions_req_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_partitions_req_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_partitions_req failed: unknown result");
  }

  public function get_partition($db_name, $tbl_name, array $part_vals)
  {
    $this->send_get_partition($db_name, $tbl_name, $part_vals);
    return $this->recv_get_partition();
  }

  public function send_get_partition($db_name, $tbl_name, array $part_vals)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition failed: unknown result");
  }

  public function exchange_partition(array $partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name)
  {
    $this->send_exchange_partition($partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name);
    return $this->recv_exchange_partition();
  }

  public function send_exchange_partition(array $partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name)
  {
    $args = new \metastore\ThriftHiveMetastore_exchange_partition_args();
    $args->partitionSpecs = $partitionSpecs;
    $args->source_db = $source_db;
    $args->source_table_name = $source_table_name;
    $args->dest_db = $dest_db;
    $args->dest_table_name = $dest_table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'exchange_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('exchange_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_exchange_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_exchange_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_exchange_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("exchange_partition failed: unknown result");
  }

  public function exchange_partitions(array $partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name)
  {
    $this->send_exchange_partitions($partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name);
    return $this->recv_exchange_partitions();
  }

  public function send_exchange_partitions(array $partitionSpecs, $source_db, $source_table_name, $dest_db, $dest_table_name)
  {
    $args = new \metastore\ThriftHiveMetastore_exchange_partitions_args();
    $args->partitionSpecs = $partitionSpecs;
    $args->source_db = $source_db;
    $args->source_table_name = $source_table_name;
    $args->dest_db = $dest_db;
    $args->dest_table_name = $dest_table_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'exchange_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('exchange_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_exchange_partitions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_exchange_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_exchange_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("exchange_partitions failed: unknown result");
  }

  public function get_partition_with_auth($db_name, $tbl_name, array $part_vals, $user_name, array $group_names)
  {
    $this->send_get_partition_with_auth($db_name, $tbl_name, $part_vals, $user_name, $group_names);
    return $this->recv_get_partition_with_auth();
  }

  public function send_get_partition_with_auth($db_name, $tbl_name, array $part_vals, $user_name, array $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_with_auth_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_with_auth', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_with_auth', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_with_auth()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_with_auth_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_with_auth_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_with_auth failed: unknown result");
  }

  public function get_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $this->send_get_partition_by_name($db_name, $tbl_name, $part_name);
    return $this->recv_get_partition_by_name();
  }

  public function send_get_partition_by_name($db_name, $tbl_name, $part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_by_name failed: unknown result");
  }

  public function get_partitions($db_name, $tbl_name, $max_parts)
  {
    $this->send_get_partitions($db_name, $tbl_name, $max_parts);
    return $this->recv_get_partitions();
  }

  public function send_get_partitions($db_name, $tbl_name, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions failed: unknown result");
  }

  public function get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, array $group_names)
  {
    $this->send_get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, $group_names);
    return $this->recv_get_partitions_with_auth();
  }

  public function send_get_partitions_with_auth($db_name, $tbl_name, $max_parts, $user_name, array $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_with_auth_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_parts = $max_parts;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_with_auth', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_with_auth', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_with_auth()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_with_auth_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_with_auth_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_with_auth failed: unknown result");
  }

  public function get_partitions_pspec($db_name, $tbl_name, $max_parts)
  {
    $this->send_get_partitions_pspec($db_name, $tbl_name, $max_parts);
    return $this->recv_get_partitions_pspec();
  }

  public function send_get_partitions_pspec($db_name, $tbl_name, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_pspec_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_pspec', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_pspec', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_pspec()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_pspec_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_pspec_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_pspec failed: unknown result");
  }

  public function get_partition_names($db_name, $tbl_name, $max_parts)
  {
    $this->send_get_partition_names($db_name, $tbl_name, $max_parts);
    return $this->recv_get_partition_names();
  }

  public function send_get_partition_names($db_name, $tbl_name, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_names_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_names()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_names failed: unknown result");
  }

  public function get_partition_values(\metastore\PartitionValuesRequest $request)
  {
    $this->send_get_partition_values($request);
    return $this->recv_get_partition_values();
  }

  public function send_get_partition_values(\metastore\PartitionValuesRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_values_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_values', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_values', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_values()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_values_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_values_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_values failed: unknown result");
  }

  public function get_partitions_ps($db_name, $tbl_name, array $part_vals, $max_parts)
  {
    $this->send_get_partitions_ps($db_name, $tbl_name, $part_vals, $max_parts);
    return $this->recv_get_partitions_ps();
  }

  public function send_get_partitions_ps($db_name, $tbl_name, array $part_vals, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_ps_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_ps', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_ps', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_ps()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_ps_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_ps_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_ps failed: unknown result");
  }

  public function get_partitions_ps_with_auth($db_name, $tbl_name, array $part_vals, $max_parts, $user_name, array $group_names)
  {
    $this->send_get_partitions_ps_with_auth($db_name, $tbl_name, $part_vals, $max_parts, $user_name, $group_names);
    return $this->recv_get_partitions_ps_with_auth();
  }

  public function send_get_partitions_ps_with_auth($db_name, $tbl_name, array $part_vals, $max_parts, $user_name, array $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_ps_with_auth_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->max_parts = $max_parts;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_ps_with_auth', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_ps_with_auth', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_ps_with_auth()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_ps_with_auth_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_ps_with_auth_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_ps_with_auth failed: unknown result");
  }

  public function get_partition_names_ps($db_name, $tbl_name, array $part_vals, $max_parts)
  {
    $this->send_get_partition_names_ps($db_name, $tbl_name, $part_vals, $max_parts);
    return $this->recv_get_partition_names_ps();
  }

  public function send_get_partition_names_ps($db_name, $tbl_name, array $part_vals, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_names_ps_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_names_ps', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_names_ps', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_names_ps()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_names_ps_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_names_ps_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partition_names_ps failed: unknown result");
  }

  public function get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts)
  {
    $this->send_get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts);
    return $this->recv_get_partitions_by_filter();
  }

  public function send_get_partitions_by_filter($db_name, $tbl_name, $filter, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_by_filter_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->filter = $filter;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_by_filter', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_by_filter', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_by_filter()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_by_filter_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_by_filter_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_by_filter failed: unknown result");
  }

  public function get_part_specs_by_filter($db_name, $tbl_name, $filter, $max_parts)
  {
    $this->send_get_part_specs_by_filter($db_name, $tbl_name, $filter, $max_parts);
    return $this->recv_get_part_specs_by_filter();
  }

  public function send_get_part_specs_by_filter($db_name, $tbl_name, $filter, $max_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_get_part_specs_by_filter_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->filter = $filter;
    $args->max_parts = $max_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_part_specs_by_filter', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_part_specs_by_filter', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_part_specs_by_filter()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_part_specs_by_filter_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_part_specs_by_filter_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_part_specs_by_filter failed: unknown result");
  }

  public function get_partitions_by_expr(\metastore\PartitionsByExprRequest $req)
  {
    $this->send_get_partitions_by_expr($req);
    return $this->recv_get_partitions_by_expr();
  }

  public function send_get_partitions_by_expr(\metastore\PartitionsByExprRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_by_expr_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_by_expr', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_by_expr', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_by_expr()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_by_expr_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_by_expr_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_by_expr failed: unknown result");
  }

  public function get_num_partitions_by_filter($db_name, $tbl_name, $filter)
  {
    $this->send_get_num_partitions_by_filter($db_name, $tbl_name, $filter);
    return $this->recv_get_num_partitions_by_filter();
  }

  public function send_get_num_partitions_by_filter($db_name, $tbl_name, $filter)
  {
    $args = new \metastore\ThriftHiveMetastore_get_num_partitions_by_filter_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->filter = $filter;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_num_partitions_by_filter', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_num_partitions_by_filter', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_num_partitions_by_filter()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_num_partitions_by_filter_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_num_partitions_by_filter_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_num_partitions_by_filter failed: unknown result");
  }

  public function get_partitions_by_names($db_name, $tbl_name, array $names)
  {
    $this->send_get_partitions_by_names($db_name, $tbl_name, $names);
    return $this->recv_get_partitions_by_names();
  }

  public function send_get_partitions_by_names($db_name, $tbl_name, array $names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_by_names_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->names = $names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_by_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_by_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_by_names()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_by_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_by_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_by_names failed: unknown result");
  }

  public function alter_partition($db_name, $tbl_name, \metastore\Partition $new_part)
  {
    $this->send_alter_partition($db_name, $tbl_name, $new_part);
    $this->recv_alter_partition();
  }

  public function send_alter_partition($db_name, $tbl_name, \metastore\Partition $new_part)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->new_part = $new_part;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_partitions($db_name, $tbl_name, array $new_parts)
  {
    $this->send_alter_partitions($db_name, $tbl_name, $new_parts);
    $this->recv_alter_partitions();
  }

  public function send_alter_partitions($db_name, $tbl_name, array $new_parts)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_partitions_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->new_parts = $new_parts;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_partitions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_partitions_with_environment_context($db_name, $tbl_name, array $new_parts, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_alter_partitions_with_environment_context($db_name, $tbl_name, $new_parts, $environment_context);
    $this->recv_alter_partitions_with_environment_context();
  }

  public function send_alter_partitions_with_environment_context($db_name, $tbl_name, array $new_parts, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_partitions_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->new_parts = $new_parts;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_partitions_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_partitions_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_partitions_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_partitions_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_partitions_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function alter_partition_with_environment_context($db_name, $tbl_name, \metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $this->send_alter_partition_with_environment_context($db_name, $tbl_name, $new_part, $environment_context);
    $this->recv_alter_partition_with_environment_context();
  }

  public function send_alter_partition_with_environment_context($db_name, $tbl_name, \metastore\Partition $new_part, \metastore\EnvironmentContext $environment_context)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_partition_with_environment_context_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->new_part = $new_part;
    $args->environment_context = $environment_context;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_partition_with_environment_context', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_partition_with_environment_context', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_partition_with_environment_context()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_partition_with_environment_context_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_partition_with_environment_context_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function rename_partition($db_name, $tbl_name, array $part_vals, \metastore\Partition $new_part)
  {
    $this->send_rename_partition($db_name, $tbl_name, $part_vals, $new_part);
    $this->recv_rename_partition();
  }

  public function send_rename_partition($db_name, $tbl_name, array $part_vals, \metastore\Partition $new_part)
  {
    $args = new \metastore\ThriftHiveMetastore_rename_partition_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->new_part = $new_part;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'rename_partition', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('rename_partition', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_rename_partition()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_rename_partition_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_rename_partition_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function partition_name_has_valid_characters(array $part_vals, $throw_exception)
  {
    $this->send_partition_name_has_valid_characters($part_vals, $throw_exception);
    return $this->recv_partition_name_has_valid_characters();
  }

  public function send_partition_name_has_valid_characters(array $part_vals, $throw_exception)
  {
    $args = new \metastore\ThriftHiveMetastore_partition_name_has_valid_characters_args();
    $args->part_vals = $part_vals;
    $args->throw_exception = $throw_exception;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'partition_name_has_valid_characters', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('partition_name_has_valid_characters', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_partition_name_has_valid_characters()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_partition_name_has_valid_characters_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_partition_name_has_valid_characters_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("partition_name_has_valid_characters failed: unknown result");
  }

  public function get_config_value($name, $defaultValue)
  {
    $this->send_get_config_value($name, $defaultValue);
    return $this->recv_get_config_value();
  }

  public function send_get_config_value($name, $defaultValue)
  {
    $args = new \metastore\ThriftHiveMetastore_get_config_value_args();
    $args->name = $name;
    $args->defaultValue = $defaultValue;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_config_value', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_config_value', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_config_value()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_config_value_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_config_value_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_config_value failed: unknown result");
  }

  public function partition_name_to_vals($part_name)
  {
    $this->send_partition_name_to_vals($part_name);
    return $this->recv_partition_name_to_vals();
  }

  public function send_partition_name_to_vals($part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_partition_name_to_vals_args();
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'partition_name_to_vals', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('partition_name_to_vals', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_partition_name_to_vals()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_partition_name_to_vals_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_partition_name_to_vals_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("partition_name_to_vals failed: unknown result");
  }

  public function partition_name_to_spec($part_name)
  {
    $this->send_partition_name_to_spec($part_name);
    return $this->recv_partition_name_to_spec();
  }

  public function send_partition_name_to_spec($part_name)
  {
    $args = new \metastore\ThriftHiveMetastore_partition_name_to_spec_args();
    $args->part_name = $part_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'partition_name_to_spec', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('partition_name_to_spec', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_partition_name_to_spec()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_partition_name_to_spec_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_partition_name_to_spec_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("partition_name_to_spec failed: unknown result");
  }

  public function markPartitionForEvent($db_name, $tbl_name, array $part_vals, $eventType)
  {
    $this->send_markPartitionForEvent($db_name, $tbl_name, $part_vals, $eventType);
    $this->recv_markPartitionForEvent();
  }

  public function send_markPartitionForEvent($db_name, $tbl_name, array $part_vals, $eventType)
  {
    $args = new \metastore\ThriftHiveMetastore_markPartitionForEvent_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->eventType = $eventType;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'markPartitionForEvent', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('markPartitionForEvent', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_markPartitionForEvent()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_markPartitionForEvent_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_markPartitionForEvent_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    if ($result->o5 !== null) {
      throw $result->o5;
    }
    if ($result->o6 !== null) {
      throw $result->o6;
    }
    return;
  }

  public function isPartitionMarkedForEvent($db_name, $tbl_name, array $part_vals, $eventType)
  {
    $this->send_isPartitionMarkedForEvent($db_name, $tbl_name, $part_vals, $eventType);
    return $this->recv_isPartitionMarkedForEvent();
  }

  public function send_isPartitionMarkedForEvent($db_name, $tbl_name, array $part_vals, $eventType)
  {
    $args = new \metastore\ThriftHiveMetastore_isPartitionMarkedForEvent_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_vals = $part_vals;
    $args->eventType = $eventType;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'isPartitionMarkedForEvent', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('isPartitionMarkedForEvent', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_isPartitionMarkedForEvent()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_isPartitionMarkedForEvent_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_isPartitionMarkedForEvent_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    if ($result->o5 !== null) {
      throw $result->o5;
    }
    if ($result->o6 !== null) {
      throw $result->o6;
    }
    throw new \Exception("isPartitionMarkedForEvent failed: unknown result");
  }

  public function add_index(\metastore\Index $new_index, \metastore\Table $index_table)
  {
    $this->send_add_index($new_index, $index_table);
    return $this->recv_add_index();
  }

  public function send_add_index(\metastore\Index $new_index, \metastore\Table $index_table)
  {
    $args = new \metastore\ThriftHiveMetastore_add_index_args();
    $args->new_index = $new_index;
    $args->index_table = $index_table;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_index', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_index', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_index()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_index_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_index_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("add_index failed: unknown result");
  }

  public function alter_index($dbname, $base_tbl_name, $idx_name, \metastore\Index $new_idx)
  {
    $this->send_alter_index($dbname, $base_tbl_name, $idx_name, $new_idx);
    $this->recv_alter_index();
  }

  public function send_alter_index($dbname, $base_tbl_name, $idx_name, \metastore\Index $new_idx)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_index_args();
    $args->dbname = $dbname;
    $args->base_tbl_name = $base_tbl_name;
    $args->idx_name = $idx_name;
    $args->new_idx = $new_idx;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_index', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_index', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_index()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_index_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_index_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData)
  {
    $this->send_drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData);
    return $this->recv_drop_index_by_name();
  }

  public function send_drop_index_by_name($db_name, $tbl_name, $index_name, $deleteData)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_index_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->index_name = $index_name;
    $args->deleteData = $deleteData;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_index_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_index_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_index_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_index_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_index_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("drop_index_by_name failed: unknown result");
  }

  public function get_index_by_name($db_name, $tbl_name, $index_name)
  {
    $this->send_get_index_by_name($db_name, $tbl_name, $index_name);
    return $this->recv_get_index_by_name();
  }

  public function send_get_index_by_name($db_name, $tbl_name, $index_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_index_by_name_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->index_name = $index_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_index_by_name', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_index_by_name', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_index_by_name()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_index_by_name_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_index_by_name_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_index_by_name failed: unknown result");
  }

  public function get_indexes($db_name, $tbl_name, $max_indexes)
  {
    $this->send_get_indexes($db_name, $tbl_name, $max_indexes);
    return $this->recv_get_indexes();
  }

  public function send_get_indexes($db_name, $tbl_name, $max_indexes)
  {
    $args = new \metastore\ThriftHiveMetastore_get_indexes_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_indexes = $max_indexes;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_indexes', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_indexes', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_indexes()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_indexes_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_indexes_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_indexes failed: unknown result");
  }

  public function get_index_names($db_name, $tbl_name, $max_indexes)
  {
    $this->send_get_index_names($db_name, $tbl_name, $max_indexes);
    return $this->recv_get_index_names();
  }

  public function send_get_index_names($db_name, $tbl_name, $max_indexes)
  {
    $args = new \metastore\ThriftHiveMetastore_get_index_names_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->max_indexes = $max_indexes;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_index_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_index_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_index_names()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_index_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_index_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_index_names failed: unknown result");
  }

  public function get_primary_keys(\metastore\PrimaryKeysRequest $request)
  {
    $this->send_get_primary_keys($request);
    return $this->recv_get_primary_keys();
  }

  public function send_get_primary_keys(\metastore\PrimaryKeysRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_primary_keys_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_primary_keys', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_primary_keys', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_primary_keys()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_primary_keys_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_primary_keys_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_primary_keys failed: unknown result");
  }

  public function get_foreign_keys(\metastore\ForeignKeysRequest $request)
  {
    $this->send_get_foreign_keys($request);
    return $this->recv_get_foreign_keys();
  }

  public function send_get_foreign_keys(\metastore\ForeignKeysRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_foreign_keys_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_foreign_keys', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_foreign_keys', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_foreign_keys()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_foreign_keys_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_foreign_keys_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_foreign_keys failed: unknown result");
  }

  public function update_table_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $this->send_update_table_column_statistics($stats_obj);
    return $this->recv_update_table_column_statistics();
  }

  public function send_update_table_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $args = new \metastore\ThriftHiveMetastore_update_table_column_statistics_args();
    $args->stats_obj = $stats_obj;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'update_table_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('update_table_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_update_table_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_update_table_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_update_table_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("update_table_column_statistics failed: unknown result");
  }

  public function update_partition_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $this->send_update_partition_column_statistics($stats_obj);
    return $this->recv_update_partition_column_statistics();
  }

  public function send_update_partition_column_statistics(\metastore\ColumnStatistics $stats_obj)
  {
    $args = new \metastore\ThriftHiveMetastore_update_partition_column_statistics_args();
    $args->stats_obj = $stats_obj;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'update_partition_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('update_partition_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_update_partition_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_update_partition_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_update_partition_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("update_partition_column_statistics failed: unknown result");
  }

  public function get_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $this->send_get_table_column_statistics($db_name, $tbl_name, $col_name);
    return $this->recv_get_table_column_statistics();
  }

  public function send_get_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("get_table_column_statistics failed: unknown result");
  }

  public function get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $this->send_get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
    return $this->recv_get_partition_column_statistics();
  }

  public function send_get_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partition_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partition_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partition_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partition_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partition_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partition_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("get_partition_column_statistics failed: unknown result");
  }

  public function get_table_statistics_req(\metastore\TableStatsRequest $request)
  {
    $this->send_get_table_statistics_req($request);
    return $this->recv_get_table_statistics_req();
  }

  public function send_get_table_statistics_req(\metastore\TableStatsRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_table_statistics_req_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_table_statistics_req', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_table_statistics_req', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_table_statistics_req()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_table_statistics_req_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_table_statistics_req_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_table_statistics_req failed: unknown result");
  }

  public function get_partitions_statistics_req(\metastore\PartitionsStatsRequest $request)
  {
    $this->send_get_partitions_statistics_req($request);
    return $this->recv_get_partitions_statistics_req();
  }

  public function send_get_partitions_statistics_req(\metastore\PartitionsStatsRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_partitions_statistics_req_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_partitions_statistics_req', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_partitions_statistics_req', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_partitions_statistics_req()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_partitions_statistics_req_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_partitions_statistics_req_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_partitions_statistics_req failed: unknown result");
  }

  public function get_aggr_stats_for(\metastore\PartitionsStatsRequest $request)
  {
    $this->send_get_aggr_stats_for($request);
    return $this->recv_get_aggr_stats_for();
  }

  public function send_get_aggr_stats_for(\metastore\PartitionsStatsRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_aggr_stats_for_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_aggr_stats_for', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_aggr_stats_for', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_aggr_stats_for()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_aggr_stats_for_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_aggr_stats_for_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_aggr_stats_for failed: unknown result");
  }

  public function set_aggr_stats_for(\metastore\SetPartitionsStatsRequest $request)
  {
    $this->send_set_aggr_stats_for($request);
    return $this->recv_set_aggr_stats_for();
  }

  public function send_set_aggr_stats_for(\metastore\SetPartitionsStatsRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_set_aggr_stats_for_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_aggr_stats_for', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_aggr_stats_for', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_aggr_stats_for()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_set_aggr_stats_for_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_set_aggr_stats_for_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("set_aggr_stats_for failed: unknown result");
  }

  public function delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $this->send_delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name);
    return $this->recv_delete_partition_column_statistics();
  }

  public function send_delete_partition_column_statistics($db_name, $tbl_name, $part_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_delete_partition_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->part_name = $part_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'delete_partition_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('delete_partition_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_delete_partition_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_delete_partition_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_delete_partition_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("delete_partition_column_statistics failed: unknown result");
  }

  public function delete_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $this->send_delete_table_column_statistics($db_name, $tbl_name, $col_name);
    return $this->recv_delete_table_column_statistics();
  }

  public function send_delete_table_column_statistics($db_name, $tbl_name, $col_name)
  {
    $args = new \metastore\ThriftHiveMetastore_delete_table_column_statistics_args();
    $args->db_name = $db_name;
    $args->tbl_name = $tbl_name;
    $args->col_name = $col_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'delete_table_column_statistics', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('delete_table_column_statistics', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_delete_table_column_statistics()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_delete_table_column_statistics_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_delete_table_column_statistics_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    throw new \Exception("delete_table_column_statistics failed: unknown result");
  }

  public function create_function(\metastore\Function $func)
  {
    $this->send_create_function($func);
    $this->recv_create_function();
  }

  public function send_create_function(\metastore\Function $func)
  {
    $args = new \metastore\ThriftHiveMetastore_create_function_args();
    $args->func = $func;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_function', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_function', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_function()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_function_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_function_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    if ($result->o4 !== null) {
      throw $result->o4;
    }
    return;
  }

  public function drop_function($dbName, $funcName)
  {
    $this->send_drop_function($dbName, $funcName);
    $this->recv_drop_function();
  }

  public function send_drop_function($dbName, $funcName)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_function_args();
    $args->dbName = $dbName;
    $args->funcName = $funcName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_function', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_function', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_function()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_function_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_function_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function alter_function($dbName, $funcName, \metastore\Function $newFunc)
  {
    $this->send_alter_function($dbName, $funcName, $newFunc);
    $this->recv_alter_function();
  }

  public function send_alter_function($dbName, $funcName, \metastore\Function $newFunc)
  {
    $args = new \metastore\ThriftHiveMetastore_alter_function_args();
    $args->dbName = $dbName;
    $args->funcName = $funcName;
    $args->newFunc = $newFunc;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'alter_function', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('alter_function', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_alter_function()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_alter_function_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_alter_function_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function get_functions($dbName, $pattern)
  {
    $this->send_get_functions($dbName, $pattern);
    return $this->recv_get_functions();
  }

  public function send_get_functions($dbName, $pattern)
  {
    $args = new \metastore\ThriftHiveMetastore_get_functions_args();
    $args->dbName = $dbName;
    $args->pattern = $pattern;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_functions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_functions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_functions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_functions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_functions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_functions failed: unknown result");
  }

  public function get_function($dbName, $funcName)
  {
    $this->send_get_function($dbName, $funcName);
    return $this->recv_get_function();
  }

  public function send_get_function($dbName, $funcName)
  {
    $args = new \metastore\ThriftHiveMetastore_get_function_args();
    $args->dbName = $dbName;
    $args->funcName = $funcName;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_function', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_function', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_function()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_function_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_function_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("get_function failed: unknown result");
  }

  public function get_all_functions()
  {
    $this->send_get_all_functions();
    return $this->recv_get_all_functions();
  }

  public function send_get_all_functions()
  {
    $args = new \metastore\ThriftHiveMetastore_get_all_functions_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_all_functions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_all_functions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_all_functions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_all_functions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_all_functions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_all_functions failed: unknown result");
  }

  public function create_role(\metastore\Role $role)
  {
    $this->send_create_role($role);
    return $this->recv_create_role();
  }

  public function send_create_role(\metastore\Role $role)
  {
    $args = new \metastore\ThriftHiveMetastore_create_role_args();
    $args->role = $role;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'create_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('create_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_create_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_create_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_create_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("create_role failed: unknown result");
  }

  public function drop_role($role_name)
  {
    $this->send_drop_role($role_name);
    return $this->recv_drop_role();
  }

  public function send_drop_role($role_name)
  {
    $args = new \metastore\ThriftHiveMetastore_drop_role_args();
    $args->role_name = $role_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'drop_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('drop_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_drop_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_drop_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_drop_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("drop_role failed: unknown result");
  }

  public function get_role_names()
  {
    $this->send_get_role_names();
    return $this->recv_get_role_names();
  }

  public function send_get_role_names()
  {
    $args = new \metastore\ThriftHiveMetastore_get_role_names_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_role_names', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_role_names', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_role_names()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_role_names_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_role_names_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_role_names failed: unknown result");
  }

  public function grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option)
  {
    $this->send_grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option);
    return $this->recv_grant_role();
  }

  public function send_grant_role($role_name, $principal_name, $principal_type, $grantor, $grantorType, $grant_option)
  {
    $args = new \metastore\ThriftHiveMetastore_grant_role_args();
    $args->role_name = $role_name;
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $args->grantor = $grantor;
    $args->grantorType = $grantorType;
    $args->grant_option = $grant_option;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'grant_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('grant_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_grant_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_grant_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_grant_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("grant_role failed: unknown result");
  }

  public function revoke_role($role_name, $principal_name, $principal_type)
  {
    $this->send_revoke_role($role_name, $principal_name, $principal_type);
    return $this->recv_revoke_role();
  }

  public function send_revoke_role($role_name, $principal_name, $principal_type)
  {
    $args = new \metastore\ThriftHiveMetastore_revoke_role_args();
    $args->role_name = $role_name;
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'revoke_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('revoke_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_revoke_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_revoke_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_revoke_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("revoke_role failed: unknown result");
  }

  public function list_roles($principal_name, $principal_type)
  {
    $this->send_list_roles($principal_name, $principal_type);
    return $this->recv_list_roles();
  }

  public function send_list_roles($principal_name, $principal_type)
  {
    $args = new \metastore\ThriftHiveMetastore_list_roles_args();
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'list_roles', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('list_roles', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_list_roles()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_list_roles_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_list_roles_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("list_roles failed: unknown result");
  }

  public function grant_revoke_role(\metastore\GrantRevokeRoleRequest $request)
  {
    $this->send_grant_revoke_role($request);
    return $this->recv_grant_revoke_role();
  }

  public function send_grant_revoke_role(\metastore\GrantRevokeRoleRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_grant_revoke_role_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'grant_revoke_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('grant_revoke_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_grant_revoke_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_grant_revoke_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_grant_revoke_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("grant_revoke_role failed: unknown result");
  }

  public function get_principals_in_role(\metastore\GetPrincipalsInRoleRequest $request)
  {
    $this->send_get_principals_in_role($request);
    return $this->recv_get_principals_in_role();
  }

  public function send_get_principals_in_role(\metastore\GetPrincipalsInRoleRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_principals_in_role_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_principals_in_role', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_principals_in_role', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_principals_in_role()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_principals_in_role_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_principals_in_role_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_principals_in_role failed: unknown result");
  }

  public function get_role_grants_for_principal(\metastore\GetRoleGrantsForPrincipalRequest $request)
  {
    $this->send_get_role_grants_for_principal($request);
    return $this->recv_get_role_grants_for_principal();
  }

  public function send_get_role_grants_for_principal(\metastore\GetRoleGrantsForPrincipalRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_get_role_grants_for_principal_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_role_grants_for_principal', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_role_grants_for_principal', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_role_grants_for_principal()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_role_grants_for_principal_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_role_grants_for_principal_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_role_grants_for_principal failed: unknown result");
  }

  public function get_privilege_set(\metastore\HiveObjectRef $hiveObject, $user_name, array $group_names)
  {
    $this->send_get_privilege_set($hiveObject, $user_name, $group_names);
    return $this->recv_get_privilege_set();
  }

  public function send_get_privilege_set(\metastore\HiveObjectRef $hiveObject, $user_name, array $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_get_privilege_set_args();
    $args->hiveObject = $hiveObject;
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_privilege_set', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_privilege_set', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_privilege_set()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_privilege_set_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_privilege_set_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_privilege_set failed: unknown result");
  }

  public function list_privileges($principal_name, $principal_type, \metastore\HiveObjectRef $hiveObject)
  {
    $this->send_list_privileges($principal_name, $principal_type, $hiveObject);
    return $this->recv_list_privileges();
  }

  public function send_list_privileges($principal_name, $principal_type, \metastore\HiveObjectRef $hiveObject)
  {
    $args = new \metastore\ThriftHiveMetastore_list_privileges_args();
    $args->principal_name = $principal_name;
    $args->principal_type = $principal_type;
    $args->hiveObject = $hiveObject;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'list_privileges', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('list_privileges', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_list_privileges()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_list_privileges_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_list_privileges_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("list_privileges failed: unknown result");
  }

  public function grant_privileges(\metastore\PrivilegeBag $privileges)
  {
    $this->send_grant_privileges($privileges);
    return $this->recv_grant_privileges();
  }

  public function send_grant_privileges(\metastore\PrivilegeBag $privileges)
  {
    $args = new \metastore\ThriftHiveMetastore_grant_privileges_args();
    $args->privileges = $privileges;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'grant_privileges', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('grant_privileges', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_grant_privileges()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_grant_privileges_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_grant_privileges_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("grant_privileges failed: unknown result");
  }

  public function revoke_privileges(\metastore\PrivilegeBag $privileges)
  {
    $this->send_revoke_privileges($privileges);
    return $this->recv_revoke_privileges();
  }

  public function send_revoke_privileges(\metastore\PrivilegeBag $privileges)
  {
    $args = new \metastore\ThriftHiveMetastore_revoke_privileges_args();
    $args->privileges = $privileges;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'revoke_privileges', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('revoke_privileges', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_revoke_privileges()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_revoke_privileges_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_revoke_privileges_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("revoke_privileges failed: unknown result");
  }

  public function grant_revoke_privileges(\metastore\GrantRevokePrivilegeRequest $request)
  {
    $this->send_grant_revoke_privileges($request);
    return $this->recv_grant_revoke_privileges();
  }

  public function send_grant_revoke_privileges(\metastore\GrantRevokePrivilegeRequest $request)
  {
    $args = new \metastore\ThriftHiveMetastore_grant_revoke_privileges_args();
    $args->request = $request;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'grant_revoke_privileges', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('grant_revoke_privileges', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_grant_revoke_privileges()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_grant_revoke_privileges_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_grant_revoke_privileges_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("grant_revoke_privileges failed: unknown result");
  }

  public function set_ugi($user_name, array $group_names)
  {
    $this->send_set_ugi($user_name, $group_names);
    return $this->recv_set_ugi();
  }

  public function send_set_ugi($user_name, array $group_names)
  {
    $args = new \metastore\ThriftHiveMetastore_set_ugi_args();
    $args->user_name = $user_name;
    $args->group_names = $group_names;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'set_ugi', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('set_ugi', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_set_ugi()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_set_ugi_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_set_ugi_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("set_ugi failed: unknown result");
  }

  public function get_delegation_token($token_owner, $renewer_kerberos_principal_name)
  {
    $this->send_get_delegation_token($token_owner, $renewer_kerberos_principal_name);
    return $this->recv_get_delegation_token();
  }

  public function send_get_delegation_token($token_owner, $renewer_kerberos_principal_name)
  {
    $args = new \metastore\ThriftHiveMetastore_get_delegation_token_args();
    $args->token_owner = $token_owner;
    $args->renewer_kerberos_principal_name = $renewer_kerberos_principal_name;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_delegation_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_delegation_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_delegation_token()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_delegation_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_delegation_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("get_delegation_token failed: unknown result");
  }

  public function renew_delegation_token($token_str_form)
  {
    $this->send_renew_delegation_token($token_str_form);
    return $this->recv_renew_delegation_token();
  }

  public function send_renew_delegation_token($token_str_form)
  {
    $args = new \metastore\ThriftHiveMetastore_renew_delegation_token_args();
    $args->token_str_form = $token_str_form;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'renew_delegation_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('renew_delegation_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_renew_delegation_token()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_renew_delegation_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_renew_delegation_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("renew_delegation_token failed: unknown result");
  }

  public function cancel_delegation_token($token_str_form)
  {
    $this->send_cancel_delegation_token($token_str_form);
    $this->recv_cancel_delegation_token();
  }

  public function send_cancel_delegation_token($token_str_form)
  {
    $args = new \metastore\ThriftHiveMetastore_cancel_delegation_token_args();
    $args->token_str_form = $token_str_form;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'cancel_delegation_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('cancel_delegation_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_cancel_delegation_token()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_cancel_delegation_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_cancel_delegation_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    return;
  }

  public function add_token($token_identifier, $delegation_token)
  {
    $this->send_add_token($token_identifier, $delegation_token);
    return $this->recv_add_token();
  }

  public function send_add_token($token_identifier, $delegation_token)
  {
    $args = new \metastore\ThriftHiveMetastore_add_token_args();
    $args->token_identifier = $token_identifier;
    $args->delegation_token = $delegation_token;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_token()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("add_token failed: unknown result");
  }

  public function remove_token($token_identifier)
  {
    $this->send_remove_token($token_identifier);
    return $this->recv_remove_token();
  }

  public function send_remove_token($token_identifier)
  {
    $args = new \metastore\ThriftHiveMetastore_remove_token_args();
    $args->token_identifier = $token_identifier;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'remove_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('remove_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_remove_token()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_remove_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_remove_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("remove_token failed: unknown result");
  }

  public function get_token($token_identifier)
  {
    $this->send_get_token($token_identifier);
    return $this->recv_get_token();
  }

  public function send_get_token($token_identifier)
  {
    $args = new \metastore\ThriftHiveMetastore_get_token_args();
    $args->token_identifier = $token_identifier;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_token', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_token', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_token()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_token_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_token_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_token failed: unknown result");
  }

  public function get_all_token_identifiers()
  {
    $this->send_get_all_token_identifiers();
    return $this->recv_get_all_token_identifiers();
  }

  public function send_get_all_token_identifiers()
  {
    $args = new \metastore\ThriftHiveMetastore_get_all_token_identifiers_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_all_token_identifiers', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_all_token_identifiers', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_all_token_identifiers()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_all_token_identifiers_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_all_token_identifiers_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_all_token_identifiers failed: unknown result");
  }

  public function add_master_key($key)
  {
    $this->send_add_master_key($key);
    return $this->recv_add_master_key();
  }

  public function send_add_master_key($key)
  {
    $args = new \metastore\ThriftHiveMetastore_add_master_key_args();
    $args->key = $key;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_master_key', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_master_key', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_master_key()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_master_key_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_master_key_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    throw new \Exception("add_master_key failed: unknown result");
  }

  public function update_master_key($seq_number, $key)
  {
    $this->send_update_master_key($seq_number, $key);
    $this->recv_update_master_key();
  }

  public function send_update_master_key($seq_number, $key)
  {
    $args = new \metastore\ThriftHiveMetastore_update_master_key_args();
    $args->seq_number = $seq_number;
    $args->key = $key;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'update_master_key', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('update_master_key', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_update_master_key()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_update_master_key_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_update_master_key_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function remove_master_key($key_seq)
  {
    $this->send_remove_master_key($key_seq);
    return $this->recv_remove_master_key();
  }

  public function send_remove_master_key($key_seq)
  {
    $args = new \metastore\ThriftHiveMetastore_remove_master_key_args();
    $args->key_seq = $key_seq;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'remove_master_key', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('remove_master_key', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_remove_master_key()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_remove_master_key_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_remove_master_key_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("remove_master_key failed: unknown result");
  }

  public function get_master_keys()
  {
    $this->send_get_master_keys();
    return $this->recv_get_master_keys();
  }

  public function send_get_master_keys()
  {
    $args = new \metastore\ThriftHiveMetastore_get_master_keys_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_master_keys', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_master_keys', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_master_keys()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_master_keys_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_master_keys_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_master_keys failed: unknown result");
  }

  public function get_open_txns()
  {
    $this->send_get_open_txns();
    return $this->recv_get_open_txns();
  }

  public function send_get_open_txns()
  {
    $args = new \metastore\ThriftHiveMetastore_get_open_txns_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_open_txns', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_open_txns', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_open_txns()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_open_txns_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_open_txns_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_open_txns failed: unknown result");
  }

  public function get_open_txns_info()
  {
    $this->send_get_open_txns_info();
    return $this->recv_get_open_txns_info();
  }

  public function send_get_open_txns_info()
  {
    $args = new \metastore\ThriftHiveMetastore_get_open_txns_info_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_open_txns_info', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_open_txns_info', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_open_txns_info()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_open_txns_info_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_open_txns_info_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_open_txns_info failed: unknown result");
  }

  public function open_txns(\metastore\OpenTxnRequest $rqst)
  {
    $this->send_open_txns($rqst);
    return $this->recv_open_txns();
  }

  public function send_open_txns(\metastore\OpenTxnRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_open_txns_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'open_txns', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('open_txns', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_open_txns()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_open_txns_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_open_txns_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("open_txns failed: unknown result");
  }

  public function abort_txn(\metastore\AbortTxnRequest $rqst)
  {
    $this->send_abort_txn($rqst);
    $this->recv_abort_txn();
  }

  public function send_abort_txn(\metastore\AbortTxnRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_abort_txn_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'abort_txn', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('abort_txn', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_abort_txn()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_abort_txn_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_abort_txn_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    return;
  }

  public function abort_txns(\metastore\AbortTxnsRequest $rqst)
  {
    $this->send_abort_txns($rqst);
    $this->recv_abort_txns();
  }

  public function send_abort_txns(\metastore\AbortTxnsRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_abort_txns_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'abort_txns', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('abort_txns', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_abort_txns()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_abort_txns_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_abort_txns_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    return;
  }

  public function commit_txn(\metastore\CommitTxnRequest $rqst)
  {
    $this->send_commit_txn($rqst);
    $this->recv_commit_txn();
  }

  public function send_commit_txn(\metastore\CommitTxnRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_commit_txn_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'commit_txn', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('commit_txn', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_commit_txn()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_commit_txn_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_commit_txn_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function lock(\metastore\LockRequest $rqst)
  {
    $this->send_lock($rqst);
    return $this->recv_lock();
  }

  public function send_lock(\metastore\LockRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_lock_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'lock', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('lock', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_lock()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_lock_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_lock_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    throw new \Exception("lock failed: unknown result");
  }

  public function check_lock(\metastore\CheckLockRequest $rqst)
  {
    $this->send_check_lock($rqst);
    return $this->recv_check_lock();
  }

  public function send_check_lock(\metastore\CheckLockRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_check_lock_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'check_lock', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('check_lock', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_check_lock()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_check_lock_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_check_lock_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    throw new \Exception("check_lock failed: unknown result");
  }

  public function unlock(\metastore\UnlockRequest $rqst)
  {
    $this->send_unlock($rqst);
    $this->recv_unlock();
  }

  public function send_unlock(\metastore\UnlockRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_unlock_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'unlock', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('unlock', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_unlock()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_unlock_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_unlock_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function show_locks(\metastore\ShowLocksRequest $rqst)
  {
    $this->send_show_locks($rqst);
    return $this->recv_show_locks();
  }

  public function send_show_locks(\metastore\ShowLocksRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_show_locks_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'show_locks', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('show_locks', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_show_locks()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_show_locks_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_show_locks_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("show_locks failed: unknown result");
  }

  public function heartbeat(\metastore\HeartbeatRequest $ids)
  {
    $this->send_heartbeat($ids);
    $this->recv_heartbeat();
  }

  public function send_heartbeat(\metastore\HeartbeatRequest $ids)
  {
    $args = new \metastore\ThriftHiveMetastore_heartbeat_args();
    $args->ids = $ids;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'heartbeat', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('heartbeat', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_heartbeat()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_heartbeat_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_heartbeat_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    if ($result->o3 !== null) {
      throw $result->o3;
    }
    return;
  }

  public function heartbeat_txn_range(\metastore\HeartbeatTxnRangeRequest $txns)
  {
    $this->send_heartbeat_txn_range($txns);
    return $this->recv_heartbeat_txn_range();
  }

  public function send_heartbeat_txn_range(\metastore\HeartbeatTxnRangeRequest $txns)
  {
    $args = new \metastore\ThriftHiveMetastore_heartbeat_txn_range_args();
    $args->txns = $txns;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'heartbeat_txn_range', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('heartbeat_txn_range', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_heartbeat_txn_range()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_heartbeat_txn_range_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_heartbeat_txn_range_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("heartbeat_txn_range failed: unknown result");
  }

  public function compact(\metastore\CompactionRequest $rqst)
  {
    $this->send_compact($rqst);
    $this->recv_compact();
  }

  public function send_compact(\metastore\CompactionRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_compact_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'compact', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('compact', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_compact()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_compact_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_compact_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    return;
  }

  public function compact2(\metastore\CompactionRequest $rqst)
  {
    $this->send_compact2($rqst);
    return $this->recv_compact2();
  }

  public function send_compact2(\metastore\CompactionRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_compact2_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'compact2', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('compact2', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_compact2()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_compact2_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_compact2_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("compact2 failed: unknown result");
  }

  public function show_compact(\metastore\ShowCompactRequest $rqst)
  {
    $this->send_show_compact($rqst);
    return $this->recv_show_compact();
  }

  public function send_show_compact(\metastore\ShowCompactRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_show_compact_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'show_compact', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('show_compact', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_show_compact()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_show_compact_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_show_compact_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("show_compact failed: unknown result");
  }

  public function add_dynamic_partitions(\metastore\AddDynamicPartitions $rqst)
  {
    $this->send_add_dynamic_partitions($rqst);
    $this->recv_add_dynamic_partitions();
  }

  public function send_add_dynamic_partitions(\metastore\AddDynamicPartitions $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_add_dynamic_partitions_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'add_dynamic_partitions', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('add_dynamic_partitions', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_add_dynamic_partitions()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_add_dynamic_partitions_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_add_dynamic_partitions_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->o1 !== null) {
      throw $result->o1;
    }
    if ($result->o2 !== null) {
      throw $result->o2;
    }
    return;
  }

  public function get_next_notification(\metastore\NotificationEventRequest $rqst)
  {
    $this->send_get_next_notification($rqst);
    return $this->recv_get_next_notification();
  }

  public function send_get_next_notification(\metastore\NotificationEventRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_get_next_notification_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_next_notification', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_next_notification', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_next_notification()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_next_notification_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_next_notification_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_next_notification failed: unknown result");
  }

  public function get_current_notificationEventId()
  {
    $this->send_get_current_notificationEventId();
    return $this->recv_get_current_notificationEventId();
  }

  public function send_get_current_notificationEventId()
  {
    $args = new \metastore\ThriftHiveMetastore_get_current_notificationEventId_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_current_notificationEventId', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_current_notificationEventId', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_current_notificationEventId()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_current_notificationEventId_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_current_notificationEventId_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_current_notificationEventId failed: unknown result");
  }

  public function fire_listener_event(\metastore\FireEventRequest $rqst)
  {
    $this->send_fire_listener_event($rqst);
    return $this->recv_fire_listener_event();
  }

  public function send_fire_listener_event(\metastore\FireEventRequest $rqst)
  {
    $args = new \metastore\ThriftHiveMetastore_fire_listener_event_args();
    $args->rqst = $rqst;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'fire_listener_event', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('fire_listener_event', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_fire_listener_event()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_fire_listener_event_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_fire_listener_event_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("fire_listener_event failed: unknown result");
  }

  public function flushCache()
  {
    $this->send_flushCache();
    $this->recv_flushCache();
  }

  public function send_flushCache()
  {
    $args = new \metastore\ThriftHiveMetastore_flushCache_args();
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'flushCache', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('flushCache', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_flushCache()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_flushCache_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_flushCache_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    return;
  }

  public function get_file_metadata_by_expr(\metastore\GetFileMetadataByExprRequest $req)
  {
    $this->send_get_file_metadata_by_expr($req);
    return $this->recv_get_file_metadata_by_expr();
  }

  public function send_get_file_metadata_by_expr(\metastore\GetFileMetadataByExprRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_get_file_metadata_by_expr_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_file_metadata_by_expr', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_file_metadata_by_expr', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_file_metadata_by_expr()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_file_metadata_by_expr_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_file_metadata_by_expr_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_file_metadata_by_expr failed: unknown result");
  }

  public function get_file_metadata(\metastore\GetFileMetadataRequest $req)
  {
    $this->send_get_file_metadata($req);
    return $this->recv_get_file_metadata();
  }

  public function send_get_file_metadata(\metastore\GetFileMetadataRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_get_file_metadata_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'get_file_metadata', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('get_file_metadata', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_get_file_metadata()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_get_file_metadata_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_get_file_metadata_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("get_file_metadata failed: unknown result");
  }

  public function put_file_metadata(\metastore\PutFileMetadataRequest $req)
  {
    $this->send_put_file_metadata($req);
    return $this->recv_put_file_metadata();
  }

  public function send_put_file_metadata(\metastore\PutFileMetadataRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_put_file_metadata_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'put_file_metadata', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('put_file_metadata', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_put_file_metadata()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_put_file_metadata_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_put_file_metadata_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("put_file_metadata failed: unknown result");
  }

  public function clear_file_metadata(\metastore\ClearFileMetadataRequest $req)
  {
    $this->send_clear_file_metadata($req);
    return $this->recv_clear_file_metadata();
  }

  public function send_clear_file_metadata(\metastore\ClearFileMetadataRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_clear_file_metadata_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'clear_file_metadata', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('clear_file_metadata', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_clear_file_metadata()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_clear_file_metadata_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_clear_file_metadata_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("clear_file_metadata failed: unknown result");
  }

  public function cache_file_metadata(\metastore\CacheFileMetadataRequest $req)
  {
    $this->send_cache_file_metadata($req);
    return $this->recv_cache_file_metadata();
  }

  public function send_cache_file_metadata(\metastore\CacheFileMetadataRequest $req)
  {
    $args = new \metastore\ThriftHiveMetastore_cache_file_metadata_args();
    $args->req = $req;
    $bin_accel = ($this->output_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_write_binary');
    if ($bin_accel)
    {
      thrift_protocol_write_binary($this->output_, 'cache_file_metadata', TMessageType::CALL, $args, $this->seqid_, $this->output_->isStrictWrite());
    }
    else
    {
      $this->output_->writeMessageBegin('cache_file_metadata', TMessageType::CALL, $this->seqid_);
      $args->write($this->output_);
      $this->output_->writeMessageEnd();
      $this->output_->getTransport()->flush();
    }
  }

  public function recv_cache_file_metadata()
  {
    $bin_accel = ($this->input_ instanceof TBinaryProtocolAccelerated) && function_exists('thrift_protocol_read_binary');
    if ($bin_accel) $result = thrift_protocol_read_binary($this->input_, '\metastore\ThriftHiveMetastore_cache_file_metadata_result', $this->input_->isStrictRead());
    else
    {
      $rseqid = 0;
      $fname = null;
      $mtype = 0;

      $this->input_->readMessageBegin($fname, $mtype, $rseqid);
      if ($mtype == TMessageType::EXCEPTION) {
        $x = new TApplicationException();
        $x->read($this->input_);
        $this->input_->readMessageEnd();
        throw $x;
      }
      $result = new \metastore\ThriftHiveMetastore_cache_file_metadata_result();
      $result->read($this->input_);
      $this->input_->readMessageEnd();
    }
    if ($result->success !== null) {
      return $result->success;
    }
    throw new \Exception("cache_file_metadata failed: unknown result");
  }

}

// HELPER FUNCTIONS AND STRUCTURES

class ThriftHiveMetastore_getMetaConf_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $key = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'key',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_getMetaConf_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->key);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_getMetaConf_args');
    if ($this->key !== null) {
      $xfer += $output->writeFieldBegin('key', TType::STRING, 1);
      $xfer += $output->writeString($this->key);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_getMetaConf_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_getMetaConf_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_getMetaConf_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_setMetaConf_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $key = null;
  /**
   * @var string
   */
  public $value = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'key',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'value',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['key'])) {
        $this->key = $vals['key'];
      }
      if (isset($vals['value'])) {
        $this->value = $vals['value'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_setMetaConf_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->key);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->value);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_setMetaConf_args');
    if ($this->key !== null) {
      $xfer += $output->writeFieldBegin('key', TType::STRING, 1);
      $xfer += $output->writeString($this->key);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->value !== null) {
      $xfer += $output->writeFieldBegin('value', TType::STRING, 2);
      $xfer += $output->writeString($this->value);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_setMetaConf_result {
  static $_TSPEC;

  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_setMetaConf_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_setMetaConf_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_database_args {
  static $_TSPEC;

  /**
   * @var \metastore\Database
   */
  public $database = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'database',
          'type' => TType::STRUCT,
          'class' => '\metastore\Database',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['database'])) {
        $this->database = $vals['database'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->database = new \metastore\Database();
            $xfer += $this->database->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_database_args');
    if ($this->database !== null) {
      if (!is_object($this->database)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('database', TType::STRUCT, 1);
      $xfer += $this->database->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_database_result {
  static $_TSPEC;

  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_database_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_database_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_database_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_database_result {
  static $_TSPEC;

  /**
   * @var \metastore\Database
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Database',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Database();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_database_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_database_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $name = null;
  /**
   * @var bool
   */
  public $deleteData = null;
  /**
   * @var bool
   */
  public $cascade = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        3 => array(
          'var' => 'cascade',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['cascade'])) {
        $this->cascade = $vals['cascade'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->cascade);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_database_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 2);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cascade !== null) {
      $xfer += $output->writeFieldBegin('cascade', TType::BOOL, 3);
      $xfer += $output->writeBool($this->cascade);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_database_result {
  static $_TSPEC;

  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidOperationException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidOperationException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_database_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_databases_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $pattern = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'pattern',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['pattern'])) {
        $this->pattern = $vals['pattern'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_databases_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->pattern);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_databases_args');
    if ($this->pattern !== null) {
      $xfer += $output->writeFieldBegin('pattern', TType::STRING, 1);
      $xfer += $output->writeString($this->pattern);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_databases_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_databases_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size625 = 0;
            $_etype628 = 0;
            $xfer += $input->readListBegin($_etype628, $_size625);
            for ($_i629 = 0; $_i629 < $_size625; ++$_i629)
            {
              $elem630 = null;
              $xfer += $input->readString($elem630);
              $this->success []= $elem630;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_databases_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter631)
          {
            $xfer += $output->writeString($iter631);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_databases_args {
  static $_TSPEC;


  public function __construct() {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        );
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_databases_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_databases_args');
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_databases_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_databases_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size632 = 0;
            $_etype635 = 0;
            $xfer += $input->readListBegin($_etype635, $_size632);
            for ($_i636 = 0; $_i636 < $_size632; ++$_i636)
            {
              $elem637 = null;
              $xfer += $input->readString($elem637);
              $this->success []= $elem637;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_databases_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter638)
          {
            $xfer += $output->writeString($iter638);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_database_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var \metastore\Database
   */
  public $db = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'db',
          'type' => TType::STRUCT,
          'class' => '\metastore\Database',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['db'])) {
        $this->db = $vals['db'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_database_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->db = new \metastore\Database();
            $xfer += $this->db->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_database_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->db !== null) {
      if (!is_object($this->db)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('db', TType::STRUCT, 2);
      $xfer += $this->db->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_database_result {
  static $_TSPEC;

  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_database_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_database_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_result {
  static $_TSPEC;

  /**
   * @var \metastore\Type
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Type',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Type();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_type_args {
  static $_TSPEC;

  /**
   * @var \metastore\Type
   */
  public $type = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'type',
          'type' => TType::STRUCT,
          'class' => '\metastore\Type',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['type'])) {
        $this->type = $vals['type'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_type_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->type = new \metastore\Type();
            $xfer += $this->type->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_type_args');
    if ($this->type !== null) {
      if (!is_object($this->type)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('type', TType::STRUCT, 1);
      $xfer += $this->type->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_type_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_type_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_type_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_type_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $type = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'type',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['type'])) {
        $this->type = $vals['type'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_type_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->type);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_type_args');
    if ($this->type !== null) {
      $xfer += $output->writeFieldBegin('type', TType::STRING, 1);
      $xfer += $output->writeString($this->type);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_type_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_type_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_type_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_all_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_all_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_all_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_type_all_result {
  static $_TSPEC;

  /**
   * @var array
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRUCT,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Type',
            ),
          ),
        1 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_type_all_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size639 = 0;
            $_ktype640 = 0;
            $_vtype641 = 0;
            $xfer += $input->readMapBegin($_ktype640, $_vtype641, $_size639);
            for ($_i643 = 0; $_i643 < $_size639; ++$_i643)
            {
              $key644 = '';
              $val645 = new \metastore\Type();
              $xfer += $input->readString($key644);
              $val645 = new \metastore\Type();
              $xfer += $val645->read($input);
              $this->success[$key644] = $val645;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_type_all_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $kiter646 => $viter647)
          {
            $xfer += $output->writeString($kiter646);
            $xfer += $viter647->write($output);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 1);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_fields_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_fields_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_fields_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_fields_result {
  static $_TSPEC;

  /**
   * @var \metastore\FieldSchema[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\FieldSchema',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_fields_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size648 = 0;
            $_etype651 = 0;
            $xfer += $input->readListBegin($_etype651, $_size648);
            for ($_i652 = 0; $_i652 < $_size648; ++$_i652)
            {
              $elem653 = null;
              $elem653 = new \metastore\FieldSchema();
              $xfer += $elem653->read($input);
              $this->success []= $elem653;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\UnknownTableException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_fields_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter654)
          {
            $xfer += $iter654->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_fields_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_fields_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_fields_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 3);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_fields_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\FieldSchema[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\FieldSchema',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_fields_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size655 = 0;
            $_etype658 = 0;
            $xfer += $input->readListBegin($_etype658, $_size655);
            for ($_i659 = 0; $_i659 < $_size655; ++$_i659)
            {
              $elem660 = null;
              $elem660 = new \metastore\FieldSchema();
              $xfer += $elem660->read($input);
              $this->success []= $elem660;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\UnknownTableException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_fields_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter661)
          {
            $xfer += $iter661->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_schema_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_schema_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_schema_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_schema_result {
  static $_TSPEC;

  /**
   * @var \metastore\FieldSchema[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\FieldSchema',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_schema_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size662 = 0;
            $_etype665 = 0;
            $xfer += $input->readListBegin($_etype665, $_size662);
            for ($_i666 = 0; $_i666 < $_size662; ++$_i666)
            {
              $elem667 = null;
              $elem667 = new \metastore\FieldSchema();
              $xfer += $elem667->read($input);
              $this->success []= $elem667;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\UnknownTableException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_schema_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter668)
          {
            $xfer += $iter668->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_schema_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $table_name = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'table_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['table_name'])) {
        $this->table_name = $vals['table_name'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_schema_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_schema_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->table_name !== null) {
      $xfer += $output->writeFieldBegin('table_name', TType::STRING, 2);
      $xfer += $output->writeString($this->table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 3);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_schema_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\FieldSchema[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\FieldSchema',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_schema_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size669 = 0;
            $_etype672 = 0;
            $xfer += $input->readListBegin($_etype672, $_size669);
            for ($_i673 = 0; $_i673 < $_size669; ++$_i673)
            {
              $elem674 = null;
              $elem674 = new \metastore\FieldSchema();
              $xfer += $elem674->read($input);
              $this->success []= $elem674;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\UnknownTableException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_schema_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter675)
          {
            $xfer += $iter675->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_args {
  static $_TSPEC;

  /**
   * @var \metastore\Table
   */
  public $tbl = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tbl'])) {
        $this->tbl = $vals['tbl'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tbl = new \metastore\Table();
            $xfer += $this->tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_args');
    if ($this->tbl !== null) {
      if (!is_object($this->tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tbl', TType::STRUCT, 1);
      $xfer += $this->tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_result {
  static $_TSPEC;

  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\NoSuchObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var \metastore\Table
   */
  public $tbl = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        2 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tbl'])) {
        $this->tbl = $vals['tbl'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tbl = new \metastore\Table();
            $xfer += $this->tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_with_environment_context_args');
    if ($this->tbl !== null) {
      if (!is_object($this->tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tbl', TType::STRUCT, 1);
      $xfer += $this->tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 2);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\NoSuchObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_with_constraints_args {
  static $_TSPEC;

  /**
   * @var \metastore\Table
   */
  public $tbl = null;
  /**
   * @var \metastore\SQLPrimaryKey[]
   */
  public $primaryKeys = null;
  /**
   * @var \metastore\SQLForeignKey[]
   */
  public $foreignKeys = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        2 => array(
          'var' => 'primaryKeys',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\SQLPrimaryKey',
            ),
          ),
        3 => array(
          'var' => 'foreignKeys',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\SQLForeignKey',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['tbl'])) {
        $this->tbl = $vals['tbl'];
      }
      if (isset($vals['primaryKeys'])) {
        $this->primaryKeys = $vals['primaryKeys'];
      }
      if (isset($vals['foreignKeys'])) {
        $this->foreignKeys = $vals['foreignKeys'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_with_constraints_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->tbl = new \metastore\Table();
            $xfer += $this->tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->primaryKeys = array();
            $_size676 = 0;
            $_etype679 = 0;
            $xfer += $input->readListBegin($_etype679, $_size676);
            for ($_i680 = 0; $_i680 < $_size676; ++$_i680)
            {
              $elem681 = null;
              $elem681 = new \metastore\SQLPrimaryKey();
              $xfer += $elem681->read($input);
              $this->primaryKeys []= $elem681;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->foreignKeys = array();
            $_size682 = 0;
            $_etype685 = 0;
            $xfer += $input->readListBegin($_etype685, $_size682);
            for ($_i686 = 0; $_i686 < $_size682; ++$_i686)
            {
              $elem687 = null;
              $elem687 = new \metastore\SQLForeignKey();
              $xfer += $elem687->read($input);
              $this->foreignKeys []= $elem687;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_with_constraints_args');
    if ($this->tbl !== null) {
      if (!is_object($this->tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tbl', TType::STRUCT, 1);
      $xfer += $this->tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->primaryKeys !== null) {
      if (!is_array($this->primaryKeys)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('primaryKeys', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRUCT, count($this->primaryKeys));
        {
          foreach ($this->primaryKeys as $iter688)
          {
            $xfer += $iter688->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->foreignKeys !== null) {
      if (!is_array($this->foreignKeys)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('foreignKeys', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRUCT, count($this->foreignKeys));
        {
          foreach ($this->foreignKeys as $iter689)
          {
            $xfer += $iter689->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_create_table_with_constraints_result {
  static $_TSPEC;

  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_create_table_with_constraints_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\AlreadyExistsException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\NoSuchObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_create_table_with_constraints_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_constraint_args {
  static $_TSPEC;

  /**
   * @var \metastore\DropConstraintRequest
   */
  public $req = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'req',
          'type' => TType::STRUCT,
          'class' => '\metastore\DropConstraintRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['req'])) {
        $this->req = $vals['req'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_constraint_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->req = new \metastore\DropConstraintRequest();
            $xfer += $this->req->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_constraint_args');
    if ($this->req !== null) {
      if (!is_object($this->req)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('req', TType::STRUCT, 1);
      $xfer += $this->req->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_constraint_result {
  static $_TSPEC;

  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_constraint_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_constraint_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 2);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_primary_key_args {
  static $_TSPEC;

  /**
   * @var \metastore\AddPrimaryKeyRequest
   */
  public $req = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'req',
          'type' => TType::STRUCT,
          'class' => '\metastore\AddPrimaryKeyRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['req'])) {
        $this->req = $vals['req'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_primary_key_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->req = new \metastore\AddPrimaryKeyRequest();
            $xfer += $this->req->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_primary_key_args');
    if ($this->req !== null) {
      if (!is_object($this->req)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('req', TType::STRUCT, 1);
      $xfer += $this->req->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_primary_key_result {
  static $_TSPEC;

  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_primary_key_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_primary_key_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_foreign_key_args {
  static $_TSPEC;

  /**
   * @var \metastore\AddForeignKeyRequest
   */
  public $req = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'req',
          'type' => TType::STRUCT,
          'class' => '\metastore\AddForeignKeyRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['req'])) {
        $this->req = $vals['req'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_foreign_key_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->req = new \metastore\AddForeignKeyRequest();
            $xfer += $this->req->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_foreign_key_args');
    if ($this->req !== null) {
      if (!is_object($this->req)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('req', TType::STRUCT, 1);
      $xfer += $this->req->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_foreign_key_result {
  static $_TSPEC;

  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_foreign_key_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_foreign_key_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var bool
   */
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 3);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_result {
  static $_TSPEC;

  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 2);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $name = null;
  /**
   * @var bool
   */
  public $deleteData = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_with_environment_context_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 2);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 3);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_table_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_table_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_table_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 2);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_tables_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $pattern = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'pattern',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['pattern'])) {
        $this->pattern = $vals['pattern'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_tables_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->pattern);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_tables_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pattern !== null) {
      $xfer += $output->writeFieldBegin('pattern', TType::STRING, 2);
      $xfer += $output->writeString($this->pattern);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_tables_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_tables_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size690 = 0;
            $_etype693 = 0;
            $xfer += $input->readListBegin($_etype693, $_size690);
            for ($_i694 = 0; $_i694 < $_size690; ++$_i694)
            {
              $elem695 = null;
              $xfer += $input->readString($elem695);
              $this->success []= $elem695;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_tables_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter696)
          {
            $xfer += $output->writeString($iter696);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_tables_by_type_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $pattern = null;
  /**
   * @var string
   */
  public $tableType = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'pattern',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'tableType',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['pattern'])) {
        $this->pattern = $vals['pattern'];
      }
      if (isset($vals['tableType'])) {
        $this->tableType = $vals['tableType'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_tables_by_type_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->pattern);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tableType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_tables_by_type_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->pattern !== null) {
      $xfer += $output->writeFieldBegin('pattern', TType::STRING, 2);
      $xfer += $output->writeString($this->pattern);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tableType !== null) {
      $xfer += $output->writeFieldBegin('tableType', TType::STRING, 3);
      $xfer += $output->writeString($this->tableType);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_tables_by_type_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_tables_by_type_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size697 = 0;
            $_etype700 = 0;
            $xfer += $input->readListBegin($_etype700, $_size697);
            for ($_i701 = 0; $_i701 < $_size697; ++$_i701)
            {
              $elem702 = null;
              $xfer += $input->readString($elem702);
              $this->success []= $elem702;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_tables_by_type_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter703)
          {
            $xfer += $output->writeString($iter703);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_meta_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_patterns = null;
  /**
   * @var string
   */
  public $tbl_patterns = null;
  /**
   * @var string[]
   */
  public $tbl_types = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_patterns',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_patterns',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'tbl_types',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_patterns'])) {
        $this->db_patterns = $vals['db_patterns'];
      }
      if (isset($vals['tbl_patterns'])) {
        $this->tbl_patterns = $vals['tbl_patterns'];
      }
      if (isset($vals['tbl_types'])) {
        $this->tbl_types = $vals['tbl_types'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_meta_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_patterns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_patterns);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->tbl_types = array();
            $_size704 = 0;
            $_etype707 = 0;
            $xfer += $input->readListBegin($_etype707, $_size704);
            for ($_i708 = 0; $_i708 < $_size704; ++$_i708)
            {
              $elem709 = null;
              $xfer += $input->readString($elem709);
              $this->tbl_types []= $elem709;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_meta_args');
    if ($this->db_patterns !== null) {
      $xfer += $output->writeFieldBegin('db_patterns', TType::STRING, 1);
      $xfer += $output->writeString($this->db_patterns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_patterns !== null) {
      $xfer += $output->writeFieldBegin('tbl_patterns', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_patterns);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_types !== null) {
      if (!is_array($this->tbl_types)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tbl_types', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->tbl_types));
        {
          foreach ($this->tbl_types as $iter710)
          {
            $xfer += $output->writeString($iter710);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_meta_result {
  static $_TSPEC;

  /**
   * @var \metastore\TableMeta[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\TableMeta',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_meta_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size711 = 0;
            $_etype714 = 0;
            $xfer += $input->readListBegin($_etype714, $_size711);
            for ($_i715 = 0; $_i715 < $_size711; ++$_i715)
            {
              $elem716 = null;
              $elem716 = new \metastore\TableMeta();
              $xfer += $elem716->read($input);
              $this->success []= $elem716;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_meta_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter717)
          {
            $xfer += $iter717->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_tables_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_tables_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_tables_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_all_tables_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_all_tables_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size718 = 0;
            $_etype721 = 0;
            $xfer += $input->readListBegin($_etype721, $_size718);
            for ($_i722 = 0; $_i722 < $_size718; ++$_i722)
            {
              $elem723 = null;
              $xfer += $input->readString($elem723);
              $this->success []= $elem723;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_all_tables_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter724)
          {
            $xfer += $output->writeString($iter724);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $tbl_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_result {
  static $_TSPEC;

  /**
   * @var \metastore\Table
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Table();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_objects_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string[]
   */
  public $tbl_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_names'])) {
        $this->tbl_names = $vals['tbl_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_objects_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::LST) {
            $this->tbl_names = array();
            $_size725 = 0;
            $_etype728 = 0;
            $xfer += $input->readListBegin($_etype728, $_size725);
            for ($_i729 = 0; $_i729 < $_size725; ++$_i729)
            {
              $elem730 = null;
              $xfer += $input->readString($elem730);
              $this->tbl_names []= $elem730;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_objects_by_name_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_names !== null) {
      if (!is_array($this->tbl_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('tbl_names', TType::LST, 2);
      {
        $output->writeListBegin(TType::STRING, count($this->tbl_names));
        {
          foreach ($this->tbl_names as $iter731)
          {
            $xfer += $output->writeString($iter731);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_objects_by_name_result {
  static $_TSPEC;

  /**
   * @var \metastore\Table[]
   */
  public $success = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Table',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_objects_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size732 = 0;
            $_etype735 = 0;
            $xfer += $input->readListBegin($_etype735, $_size732);
            for ($_i736 = 0; $_i736 < $_size732; ++$_i736)
            {
              $elem737 = null;
              $elem737 = new \metastore\Table();
              $xfer += $elem737->read($input);
              $this->success []= $elem737;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_objects_by_name_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter738)
          {
            $xfer += $iter738->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_req_args {
  static $_TSPEC;

  /**
   * @var \metastore\GetTableRequest
   */
  public $req = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'req',
          'type' => TType::STRUCT,
          'class' => '\metastore\GetTableRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['req'])) {
        $this->req = $vals['req'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_req_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->req = new \metastore\GetTableRequest();
            $xfer += $this->req->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_req_args');
    if ($this->req !== null) {
      if (!is_object($this->req)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('req', TType::STRUCT, 1);
      $xfer += $this->req->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_req_result {
  static $_TSPEC;

  /**
   * @var \metastore\GetTableResult
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\GetTableResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_req_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\GetTableResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_req_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_objects_by_name_req_args {
  static $_TSPEC;

  /**
   * @var \metastore\GetTablesRequest
   */
  public $req = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'req',
          'type' => TType::STRUCT,
          'class' => '\metastore\GetTablesRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['req'])) {
        $this->req = $vals['req'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_objects_by_name_req_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->req = new \metastore\GetTablesRequest();
            $xfer += $this->req->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_objects_by_name_req_args');
    if ($this->req !== null) {
      if (!is_object($this->req)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('req', TType::STRUCT, 1);
      $xfer += $this->req->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_objects_by_name_req_result {
  static $_TSPEC;

  /**
   * @var \metastore\GetTablesResult
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidOperationException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\GetTablesResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_objects_by_name_req_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\GetTablesResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidOperationException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_objects_by_name_req_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_names_by_filter_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $filter = null;
  /**
   * @var int
   */
  public $max_tables = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'filter',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_tables',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['max_tables'])) {
        $this->max_tables = $vals['max_tables'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_names_by_filter_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->filter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_tables);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_names_by_filter_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      $xfer += $output->writeFieldBegin('filter', TType::STRING, 2);
      $xfer += $output->writeString($this->filter);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_tables !== null) {
      $xfer += $output->writeFieldBegin('max_tables', TType::I16, 3);
      $xfer += $output->writeI16($this->max_tables);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_names_by_filter_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidOperationException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_names_by_filter_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size739 = 0;
            $_etype742 = 0;
            $xfer += $input->readListBegin($_etype742, $_size739);
            for ($_i743 = 0; $_i743 < $_size739; ++$_i743)
            {
              $elem744 = null;
              $xfer += $input->readString($elem744);
              $this->success []= $elem744;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidOperationException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_names_by_filter_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter745)
          {
            $xfer += $output->writeString($iter745);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Table
   */
  public $new_tbl = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_tbl'])) {
        $this->new_tbl = $vals['new_tbl'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_tbl = new \metastore\Table();
            $xfer += $this->new_tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_tbl !== null) {
      if (!is_object($this->new_tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_tbl', TType::STRUCT, 3);
      $xfer += $this->new_tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Table
   */
  public $new_tbl = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_tbl'])) {
        $this->new_tbl = $vals['new_tbl'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_tbl = new \metastore\Table();
            $xfer += $this->new_tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_with_environment_context_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_tbl !== null) {
      if (!is_object($this->new_tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_tbl', TType::STRUCT, 3);
      $xfer += $this->new_tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_with_cascade_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Table
   */
  public $new_tbl = null;
  /**
   * @var bool
   */
  public $cascade = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_tbl',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        4 => array(
          'var' => 'cascade',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_tbl'])) {
        $this->new_tbl = $vals['new_tbl'];
      }
      if (isset($vals['cascade'])) {
        $this->cascade = $vals['cascade'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_with_cascade_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_tbl = new \metastore\Table();
            $xfer += $this->new_tbl->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->cascade);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_with_cascade_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_tbl !== null) {
      if (!is_object($this->new_tbl)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_tbl', TType::STRUCT, 3);
      $xfer += $this->new_tbl->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->cascade !== null) {
      $xfer += $output->writeFieldBegin('cascade', TType::BOOL, 4);
      $xfer += $output->writeBool($this->cascade);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_table_with_cascade_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_table_with_cascade_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_table_with_cascade_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_args {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $new_part = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_args');
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 1);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $new_part = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        2 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_with_environment_context_args');
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 1);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 2);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partition_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partition_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_args {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $new_parts = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_parts',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_parts'])) {
        $this->new_parts = $vals['new_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::LST) {
            $this->new_parts = array();
            $_size746 = 0;
            $_etype749 = 0;
            $xfer += $input->readListBegin($_etype749, $_size746);
            for ($_i750 = 0; $_i750 < $_size746; ++$_i750)
            {
              $elem751 = null;
              $elem751 = new \metastore\Partition();
              $xfer += $elem751->read($input);
              $this->new_parts []= $elem751;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_args');
    if ($this->new_parts !== null) {
      if (!is_array($this->new_parts)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_parts', TType::LST, 1);
      {
        $output->writeListBegin(TType::STRUCT, count($this->new_parts));
        {
          foreach ($this->new_parts as $iter752)
          {
            $xfer += $iter752->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_pspec_args {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionSpec[]
   */
  public $new_parts = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_parts',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\PartitionSpec',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_parts'])) {
        $this->new_parts = $vals['new_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_pspec_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::LST) {
            $this->new_parts = array();
            $_size753 = 0;
            $_etype756 = 0;
            $xfer += $input->readListBegin($_etype756, $_size753);
            for ($_i757 = 0; $_i757 < $_size753; ++$_i757)
            {
              $elem758 = null;
              $elem758 = new \metastore\PartitionSpec();
              $xfer += $elem758->read($input);
              $this->new_parts []= $elem758;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_pspec_args');
    if ($this->new_parts !== null) {
      if (!is_array($this->new_parts)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_parts', TType::LST, 1);
      {
        $output->writeListBegin(TType::STRUCT, count($this->new_parts));
        {
          foreach ($this->new_parts as $iter759)
          {
            $xfer += $iter759->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_pspec_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_pspec_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_pspec_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size760 = 0;
            $_etype763 = 0;
            $xfer += $input->readListBegin($_etype763, $_size760);
            for ($_i764 = 0; $_i764 < $_size760; ++$_i764)
            {
              $elem765 = null;
              $xfer += $input->readString($elem765);
              $this->part_vals []= $elem765;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter766)
          {
            $xfer += $output->writeString($iter766);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_req_args {
  static $_TSPEC;

  /**
   * @var \metastore\AddPartitionsRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\AddPartitionsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_req_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\AddPartitionsRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_req_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_partitions_req_result {
  static $_TSPEC;

  /**
   * @var \metastore\AddPartitionsResult
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\AddPartitionsResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_partitions_req_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\AddPartitionsResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_partitions_req_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size767 = 0;
            $_etype770 = 0;
            $xfer += $input->readListBegin($_etype770, $_size767);
            for ($_i771 = 0; $_i771 < $_size767; ++$_i771)
            {
              $elem772 = null;
              $xfer += $input->readString($elem772);
              $this->part_vals []= $elem772;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter773)
          {
            $xfer += $output->writeString($iter773);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_append_partition_by_name_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_append_partition_by_name_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_append_partition_by_name_with_environment_context_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var bool
   */
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size774 = 0;
            $_etype777 = 0;
            $xfer += $input->readListBegin($_etype777, $_size774);
            for ($_i778 = 0; $_i778 < $_size774; ++$_i778)
            {
              $elem779 = null;
              $xfer += $input->readString($elem779);
              $this->part_vals []= $elem779;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter780)
          {
            $xfer += $output->writeString($iter780);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var bool
   */
  public $deleteData = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        5 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size781 = 0;
            $_etype784 = 0;
            $xfer += $input->readListBegin($_etype784, $_size781);
            for ($_i785 = 0; $_i785 < $_size781; ++$_i785)
            {
              $elem786 = null;
              $xfer += $input->readString($elem786);
              $this->part_vals []= $elem786;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter787)
          {
            $xfer += $output->writeString($iter787);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 5);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_with_environment_context_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;
  /**
   * @var bool
   */
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;
  /**
   * @var bool
   */
  public $deleteData = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        5 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 5);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partition_by_name_with_environment_context_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partitions_req_args {
  static $_TSPEC;

  /**
   * @var \metastore\DropPartitionsRequest
   */
  public $req = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'req',
          'type' => TType::STRUCT,
          'class' => '\metastore\DropPartitionsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['req'])) {
        $this->req = $vals['req'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partitions_req_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->req = new \metastore\DropPartitionsRequest();
            $xfer += $this->req->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partitions_req_args');
    if ($this->req !== null) {
      if (!is_object($this->req)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('req', TType::STRUCT, 1);
      $xfer += $this->req->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_partitions_req_result {
  static $_TSPEC;

  /**
   * @var \metastore\DropPartitionsResult
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\DropPartitionsResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_partitions_req_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\DropPartitionsResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_partitions_req_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size788 = 0;
            $_etype791 = 0;
            $xfer += $input->readListBegin($_etype791, $_size788);
            for ($_i792 = 0; $_i792 < $_size788; ++$_i792)
            {
              $elem793 = null;
              $xfer += $input->readString($elem793);
              $this->part_vals []= $elem793;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter794)
          {
            $xfer += $output->writeString($iter794);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_exchange_partition_args {
  static $_TSPEC;

  /**
   * @var array
   */
  public $partitionSpecs = null;
  /**
   * @var string
   */
  public $source_db = null;
  /**
   * @var string
   */
  public $source_table_name = null;
  /**
   * @var string
   */
  public $dest_db = null;
  /**
   * @var string
   */
  public $dest_table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'partitionSpecs',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        2 => array(
          'var' => 'source_db',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'source_table_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'dest_db',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'dest_table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['partitionSpecs'])) {
        $this->partitionSpecs = $vals['partitionSpecs'];
      }
      if (isset($vals['source_db'])) {
        $this->source_db = $vals['source_db'];
      }
      if (isset($vals['source_table_name'])) {
        $this->source_table_name = $vals['source_table_name'];
      }
      if (isset($vals['dest_db'])) {
        $this->dest_db = $vals['dest_db'];
      }
      if (isset($vals['dest_table_name'])) {
        $this->dest_table_name = $vals['dest_table_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_exchange_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::MAP) {
            $this->partitionSpecs = array();
            $_size795 = 0;
            $_ktype796 = 0;
            $_vtype797 = 0;
            $xfer += $input->readMapBegin($_ktype796, $_vtype797, $_size795);
            for ($_i799 = 0; $_i799 < $_size795; ++$_i799)
            {
              $key800 = '';
              $val801 = '';
              $xfer += $input->readString($key800);
              $xfer += $input->readString($val801);
              $this->partitionSpecs[$key800] = $val801;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->source_db);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->source_table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dest_db);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dest_table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_exchange_partition_args');
    if ($this->partitionSpecs !== null) {
      if (!is_array($this->partitionSpecs)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('partitionSpecs', TType::MAP, 1);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->partitionSpecs));
        {
          foreach ($this->partitionSpecs as $kiter802 => $viter803)
          {
            $xfer += $output->writeString($kiter802);
            $xfer += $output->writeString($viter803);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->source_db !== null) {
      $xfer += $output->writeFieldBegin('source_db', TType::STRING, 2);
      $xfer += $output->writeString($this->source_db);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->source_table_name !== null) {
      $xfer += $output->writeFieldBegin('source_table_name', TType::STRING, 3);
      $xfer += $output->writeString($this->source_table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->dest_db !== null) {
      $xfer += $output->writeFieldBegin('dest_db', TType::STRING, 4);
      $xfer += $output->writeString($this->dest_db);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->dest_table_name !== null) {
      $xfer += $output->writeFieldBegin('dest_table_name', TType::STRING, 5);
      $xfer += $output->writeString($this->dest_table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_exchange_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_exchange_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidObjectException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_exchange_partition_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_exchange_partitions_args {
  static $_TSPEC;

  /**
   * @var array
   */
  public $partitionSpecs = null;
  /**
   * @var string
   */
  public $source_db = null;
  /**
   * @var string
   */
  public $source_table_name = null;
  /**
   * @var string
   */
  public $dest_db = null;
  /**
   * @var string
   */
  public $dest_table_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'partitionSpecs',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        2 => array(
          'var' => 'source_db',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'source_table_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'dest_db',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'dest_table_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['partitionSpecs'])) {
        $this->partitionSpecs = $vals['partitionSpecs'];
      }
      if (isset($vals['source_db'])) {
        $this->source_db = $vals['source_db'];
      }
      if (isset($vals['source_table_name'])) {
        $this->source_table_name = $vals['source_table_name'];
      }
      if (isset($vals['dest_db'])) {
        $this->dest_db = $vals['dest_db'];
      }
      if (isset($vals['dest_table_name'])) {
        $this->dest_table_name = $vals['dest_table_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_exchange_partitions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::MAP) {
            $this->partitionSpecs = array();
            $_size804 = 0;
            $_ktype805 = 0;
            $_vtype806 = 0;
            $xfer += $input->readMapBegin($_ktype805, $_vtype806, $_size804);
            for ($_i808 = 0; $_i808 < $_size804; ++$_i808)
            {
              $key809 = '';
              $val810 = '';
              $xfer += $input->readString($key809);
              $xfer += $input->readString($val810);
              $this->partitionSpecs[$key809] = $val810;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->source_db);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->source_table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dest_db);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dest_table_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_exchange_partitions_args');
    if ($this->partitionSpecs !== null) {
      if (!is_array($this->partitionSpecs)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('partitionSpecs', TType::MAP, 1);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->partitionSpecs));
        {
          foreach ($this->partitionSpecs as $kiter811 => $viter812)
          {
            $xfer += $output->writeString($kiter811);
            $xfer += $output->writeString($viter812);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->source_db !== null) {
      $xfer += $output->writeFieldBegin('source_db', TType::STRING, 2);
      $xfer += $output->writeString($this->source_db);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->source_table_name !== null) {
      $xfer += $output->writeFieldBegin('source_table_name', TType::STRING, 3);
      $xfer += $output->writeString($this->source_table_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->dest_db !== null) {
      $xfer += $output->writeFieldBegin('dest_db', TType::STRING, 4);
      $xfer += $output->writeString($this->dest_db);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->dest_table_name !== null) {
      $xfer += $output->writeFieldBegin('dest_table_name', TType::STRING, 5);
      $xfer += $output->writeString($this->dest_table_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_exchange_partitions_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_exchange_partitions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size813 = 0;
            $_etype816 = 0;
            $xfer += $input->readListBegin($_etype816, $_size813);
            for ($_i817 = 0; $_i817 < $_size813; ++$_i817)
            {
              $elem818 = null;
              $elem818 = new \metastore\Partition();
              $xfer += $elem818->read($input);
              $this->success []= $elem818;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidObjectException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_exchange_partitions_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter819)
          {
            $xfer += $iter819->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_with_auth_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var string
   */
  public $user_name = null;
  /**
   * @var string[]
   */
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_with_auth_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size820 = 0;
            $_etype823 = 0;
            $xfer += $input->readListBegin($_etype823, $_size820);
            for ($_i824 = 0; $_i824 < $_size820; ++$_i824)
            {
              $elem825 = null;
              $xfer += $input->readString($elem825);
              $this->part_vals []= $elem825;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size826 = 0;
            $_etype829 = 0;
            $xfer += $input->readListBegin($_etype829, $_size826);
            for ($_i830 = 0; $_i830 < $_size826; ++$_i830)
            {
              $elem831 = null;
              $xfer += $input->readString($elem831);
              $this->group_names []= $elem831;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_with_auth_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter832)
          {
            $xfer += $output->writeString($iter832);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 4);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 5);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter833)
          {
            $xfer += $output->writeString($iter833);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_with_auth_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_with_auth_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_with_auth_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_by_name_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Partition();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_by_name_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 3);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size834 = 0;
            $_etype837 = 0;
            $xfer += $input->readListBegin($_etype837, $_size834);
            for ($_i838 = 0; $_i838 < $_size834; ++$_i838)
            {
              $elem839 = null;
              $elem839 = new \metastore\Partition();
              $xfer += $elem839->read($input);
              $this->success []= $elem839;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter840)
          {
            $xfer += $iter840->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_with_auth_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_parts = -1;
  /**
   * @var string
   */
  public $user_name = null;
  /**
   * @var string[]
   */
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        4 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        5 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_with_auth_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size841 = 0;
            $_etype844 = 0;
            $xfer += $input->readListBegin($_etype844, $_size841);
            for ($_i845 = 0; $_i845 < $_size841; ++$_i845)
            {
              $elem846 = null;
              $xfer += $input->readString($elem846);
              $this->group_names []= $elem846;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_with_auth_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 3);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 4);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 5);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter847)
          {
            $xfer += $output->writeString($iter847);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_with_auth_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_with_auth_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size848 = 0;
            $_etype851 = 0;
            $xfer += $input->readListBegin($_etype851, $_size848);
            for ($_i852 = 0; $_i852 < $_size848; ++$_i852)
            {
              $elem853 = null;
              $elem853 = new \metastore\Partition();
              $xfer += $elem853->read($input);
              $this->success []= $elem853;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_with_auth_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter854)
          {
            $xfer += $iter854->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_pspec_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_parts',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_pspec_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_pspec_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I32, 3);
      $xfer += $output->writeI32($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_pspec_result {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionSpec[]
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\PartitionSpec',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_pspec_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size855 = 0;
            $_etype858 = 0;
            $xfer += $input->readListBegin($_etype858, $_size855);
            for ($_i859 = 0; $_i859 < $_size855; ++$_i859)
            {
              $elem860 = null;
              $elem860 = new \metastore\PartitionSpec();
              $xfer += $elem860->read($input);
              $this->success []= $elem860;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_pspec_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter861)
          {
            $xfer += $iter861->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 3);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size862 = 0;
            $_etype865 = 0;
            $xfer += $input->readListBegin($_etype865, $_size862);
            for ($_i866 = 0; $_i866 < $_size862; ++$_i866)
            {
              $elem867 = null;
              $xfer += $input->readString($elem867);
              $this->success []= $elem867;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter868)
          {
            $xfer += $output->writeString($iter868);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 1);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_values_args {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionValuesRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionValuesRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_values_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\PartitionValuesRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_values_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_values_result {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionValuesResponse
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionValuesResponse',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_values_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\PartitionValuesResponse();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_values_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size869 = 0;
            $_etype872 = 0;
            $xfer += $input->readListBegin($_etype872, $_size869);
            for ($_i873 = 0; $_i873 < $_size869; ++$_i873)
            {
              $elem874 = null;
              $xfer += $input->readString($elem874);
              $this->part_vals []= $elem874;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter875)
          {
            $xfer += $output->writeString($iter875);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size876 = 0;
            $_etype879 = 0;
            $xfer += $input->readListBegin($_etype879, $_size876);
            for ($_i880 = 0; $_i880 < $_size876; ++$_i880)
            {
              $elem881 = null;
              $elem881 = new \metastore\Partition();
              $xfer += $elem881->read($input);
              $this->success []= $elem881;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter882)
          {
            $xfer += $iter882->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_with_auth_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var int
   */
  public $max_parts = -1;
  /**
   * @var string
   */
  public $user_name = null;
  /**
   * @var string[]
   */
  public $group_names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        5 => array(
          'var' => 'user_name',
          'type' => TType::STRING,
          ),
        6 => array(
          'var' => 'group_names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
      if (isset($vals['user_name'])) {
        $this->user_name = $vals['user_name'];
      }
      if (isset($vals['group_names'])) {
        $this->group_names = $vals['group_names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_with_auth_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size883 = 0;
            $_etype886 = 0;
            $xfer += $input->readListBegin($_etype886, $_size883);
            for ($_i887 = 0; $_i887 < $_size883; ++$_i887)
            {
              $elem888 = null;
              $xfer += $input->readString($elem888);
              $this->part_vals []= $elem888;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->user_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::LST) {
            $this->group_names = array();
            $_size889 = 0;
            $_etype892 = 0;
            $xfer += $input->readListBegin($_etype892, $_size889);
            for ($_i893 = 0; $_i893 < $_size889; ++$_i893)
            {
              $elem894 = null;
              $xfer += $input->readString($elem894);
              $this->group_names []= $elem894;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_with_auth_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter895)
          {
            $xfer += $output->writeString($iter895);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->user_name !== null) {
      $xfer += $output->writeFieldBegin('user_name', TType::STRING, 5);
      $xfer += $output->writeString($this->user_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->group_names !== null) {
      if (!is_array($this->group_names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('group_names', TType::LST, 6);
      {
        $output->writeListBegin(TType::STRING, count($this->group_names));
        {
          foreach ($this->group_names as $iter896)
          {
            $xfer += $output->writeString($iter896);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_ps_with_auth_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_ps_with_auth_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size897 = 0;
            $_etype900 = 0;
            $xfer += $input->readListBegin($_etype900, $_size897);
            for ($_i901 = 0; $_i901 < $_size897; ++$_i901)
            {
              $elem902 = null;
              $elem902 = new \metastore\Partition();
              $xfer += $elem902->read($input);
              $this->success []= $elem902;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_ps_with_auth_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter903)
          {
            $xfer += $iter903->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_ps_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_ps_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size904 = 0;
            $_etype907 = 0;
            $xfer += $input->readListBegin($_etype907, $_size904);
            for ($_i908 = 0; $_i908 < $_size904; ++$_i908)
            {
              $elem909 = null;
              $xfer += $input->readString($elem909);
              $this->part_vals []= $elem909;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_ps_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter910)
          {
            $xfer += $output->writeString($iter910);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_names_ps_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_names_ps_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size911 = 0;
            $_etype914 = 0;
            $xfer += $input->readListBegin($_etype914, $_size911);
            for ($_i915 = 0; $_i915 < $_size911; ++$_i915)
            {
              $elem916 = null;
              $xfer += $input->readString($elem916);
              $this->success []= $elem916;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_names_ps_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter917)
          {
            $xfer += $output->writeString($iter917);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_filter_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $filter = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'filter',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_filter_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->filter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_filter_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      $xfer += $output->writeFieldBegin('filter', TType::STRING, 3);
      $xfer += $output->writeString($this->filter);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I16, 4);
      $xfer += $output->writeI16($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_filter_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_filter_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size918 = 0;
            $_etype921 = 0;
            $xfer += $input->readListBegin($_etype921, $_size918);
            for ($_i922 = 0; $_i922 < $_size918; ++$_i922)
            {
              $elem923 = null;
              $elem923 = new \metastore\Partition();
              $xfer += $elem923->read($input);
              $this->success []= $elem923;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_filter_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter924)
          {
            $xfer += $iter924->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_part_specs_by_filter_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $filter = null;
  /**
   * @var int
   */
  public $max_parts = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'filter',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'max_parts',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
      if (isset($vals['max_parts'])) {
        $this->max_parts = $vals['max_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_part_specs_by_filter_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->filter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->max_parts);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_part_specs_by_filter_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      $xfer += $output->writeFieldBegin('filter', TType::STRING, 3);
      $xfer += $output->writeString($this->filter);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_parts !== null) {
      $xfer += $output->writeFieldBegin('max_parts', TType::I32, 4);
      $xfer += $output->writeI32($this->max_parts);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_part_specs_by_filter_result {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionSpec[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\PartitionSpec',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_part_specs_by_filter_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size925 = 0;
            $_etype928 = 0;
            $xfer += $input->readListBegin($_etype928, $_size925);
            for ($_i929 = 0; $_i929 < $_size925; ++$_i929)
            {
              $elem930 = null;
              $elem930 = new \metastore\PartitionSpec();
              $xfer += $elem930->read($input);
              $this->success []= $elem930;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_part_specs_by_filter_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter931)
          {
            $xfer += $iter931->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_expr_args {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionsByExprRequest
   */
  public $req = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'req',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionsByExprRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['req'])) {
        $this->req = $vals['req'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_expr_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->req = new \metastore\PartitionsByExprRequest();
            $xfer += $this->req->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_expr_args');
    if ($this->req !== null) {
      if (!is_object($this->req)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('req', TType::STRUCT, 1);
      $xfer += $this->req->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_expr_result {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionsByExprResult
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionsByExprResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_expr_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\PartitionsByExprResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_expr_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_num_partitions_by_filter_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $filter = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'filter',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['filter'])) {
        $this->filter = $vals['filter'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_num_partitions_by_filter_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->filter);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_num_partitions_by_filter_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->filter !== null) {
      $xfer += $output->writeFieldBegin('filter', TType::STRING, 3);
      $xfer += $output->writeString($this->filter);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_num_partitions_by_filter_result {
  static $_TSPEC;

  /**
   * @var int
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::I32,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_num_partitions_by_filter_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_num_partitions_by_filter_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::I32, 0);
      $xfer += $output->writeI32($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_names_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $names = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'names',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['names'])) {
        $this->names = $vals['names'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_names_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->names = array();
            $_size932 = 0;
            $_etype935 = 0;
            $xfer += $input->readListBegin($_etype935, $_size932);
            for ($_i936 = 0; $_i936 < $_size932; ++$_i936)
            {
              $elem937 = null;
              $xfer += $input->readString($elem937);
              $this->names []= $elem937;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_names_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->names !== null) {
      if (!is_array($this->names)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('names', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->names));
        {
          foreach ($this->names as $iter938)
          {
            $xfer += $output->writeString($iter938);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_by_names_result {
  static $_TSPEC;

  /**
   * @var \metastore\Partition[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_by_names_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size939 = 0;
            $_etype942 = 0;
            $xfer += $input->readListBegin($_etype942, $_size939);
            for ($_i943 = 0; $_i943 < $_size939; ++$_i943)
            {
              $elem944 = null;
              $elem944 = new \metastore\Partition();
              $xfer += $elem944->read($input);
              $this->success []= $elem944;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_by_names_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter945)
          {
            $xfer += $iter945->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Partition
   */
  public $new_part = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 3);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partitions_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Partition[]
   */
  public $new_parts = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_parts',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_parts'])) {
        $this->new_parts = $vals['new_parts'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partitions_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->new_parts = array();
            $_size946 = 0;
            $_etype949 = 0;
            $xfer += $input->readListBegin($_etype949, $_size946);
            for ($_i950 = 0; $_i950 < $_size946; ++$_i950)
            {
              $elem951 = null;
              $elem951 = new \metastore\Partition();
              $xfer += $elem951->read($input);
              $this->new_parts []= $elem951;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partitions_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_parts !== null) {
      if (!is_array($this->new_parts)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_parts', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRUCT, count($this->new_parts));
        {
          foreach ($this->new_parts as $iter952)
          {
            $xfer += $iter952->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partitions_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partitions_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partitions_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partitions_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Partition[]
   */
  public $new_parts = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_parts',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Partition',
            ),
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_parts'])) {
        $this->new_parts = $vals['new_parts'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partitions_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->new_parts = array();
            $_size953 = 0;
            $_etype956 = 0;
            $xfer += $input->readListBegin($_etype956, $_size953);
            for ($_i957 = 0; $_i957 < $_size953; ++$_i957)
            {
              $elem958 = null;
              $elem958 = new \metastore\Partition();
              $xfer += $elem958->read($input);
              $this->new_parts []= $elem958;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partitions_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_parts !== null) {
      if (!is_array($this->new_parts)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_parts', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRUCT, count($this->new_parts));
        {
          foreach ($this->new_parts as $iter959)
          {
            $xfer += $iter959->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partitions_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partitions_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partitions_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_with_environment_context_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var \metastore\Partition
   */
  public $new_part = null;
  /**
   * @var \metastore\EnvironmentContext
   */
  public $environment_context = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        4 => array(
          'var' => 'environment_context',
          'type' => TType::STRUCT,
          'class' => '\metastore\EnvironmentContext',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
      if (isset($vals['environment_context'])) {
        $this->environment_context = $vals['environment_context'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_with_environment_context_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->environment_context = new \metastore\EnvironmentContext();
            $xfer += $this->environment_context->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_with_environment_context_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 3);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->environment_context !== null) {
      if (!is_object($this->environment_context)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('environment_context', TType::STRUCT, 4);
      $xfer += $this->environment_context->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_partition_with_environment_context_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_partition_with_environment_context_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_partition_with_environment_context_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_rename_partition_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var \metastore\Partition
   */
  public $new_part = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'new_part',
          'type' => TType::STRUCT,
          'class' => '\metastore\Partition',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['new_part'])) {
        $this->new_part = $vals['new_part'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_rename_partition_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size960 = 0;
            $_etype963 = 0;
            $xfer += $input->readListBegin($_etype963, $_size960);
            for ($_i964 = 0; $_i964 < $_size960; ++$_i964)
            {
              $elem965 = null;
              $xfer += $input->readString($elem965);
              $this->part_vals []= $elem965;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->new_part = new \metastore\Partition();
            $xfer += $this->new_part->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_rename_partition_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 3);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter966)
          {
            $xfer += $output->writeString($iter966);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_part !== null) {
      if (!is_object($this->new_part)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_part', TType::STRUCT, 4);
      $xfer += $this->new_part->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_rename_partition_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_rename_partition_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_rename_partition_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_has_valid_characters_args {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $part_vals = null;
  /**
   * @var bool
   */
  public $throw_exception = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'part_vals',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        2 => array(
          'var' => 'throw_exception',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['throw_exception'])) {
        $this->throw_exception = $vals['throw_exception'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_has_valid_characters_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::LST) {
            $this->part_vals = array();
            $_size967 = 0;
            $_etype970 = 0;
            $xfer += $input->readListBegin($_etype970, $_size967);
            for ($_i971 = 0; $_i971 < $_size967; ++$_i971)
            {
              $elem972 = null;
              $xfer += $input->readString($elem972);
              $this->part_vals []= $elem972;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->throw_exception);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_has_valid_characters_args');
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::LST, 1);
      {
        $output->writeListBegin(TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $iter973)
          {
            $xfer += $output->writeString($iter973);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->throw_exception !== null) {
      $xfer += $output->writeFieldBegin('throw_exception', TType::BOOL, 2);
      $xfer += $output->writeBool($this->throw_exception);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_has_valid_characters_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_has_valid_characters_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_has_valid_characters_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_config_value_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $name = null;
  /**
   * @var string
   */
  public $defaultValue = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'defaultValue',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['name'])) {
        $this->name = $vals['name'];
      }
      if (isset($vals['defaultValue'])) {
        $this->defaultValue = $vals['defaultValue'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_config_value_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->defaultValue);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_config_value_args');
    if ($this->name !== null) {
      $xfer += $output->writeFieldBegin('name', TType::STRING, 1);
      $xfer += $output->writeString($this->name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->defaultValue !== null) {
      $xfer += $output->writeFieldBegin('defaultValue', TType::STRING, 2);
      $xfer += $output->writeString($this->defaultValue);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_config_value_result {
  static $_TSPEC;

  /**
   * @var string
   */
  public $success = null;
  /**
   * @var \metastore\ConfigValSecurityException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRING,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\ConfigValSecurityException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_config_value_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\ConfigValSecurityException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_config_value_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::STRING, 0);
      $xfer += $output->writeString($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_vals_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_vals_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_vals_args');
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 1);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_vals_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_vals_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size974 = 0;
            $_etype977 = 0;
            $xfer += $input->readListBegin($_etype977, $_size974);
            for ($_i978 = 0; $_i978 < $_size974; ++$_i978)
            {
              $elem979 = null;
              $xfer += $input->readString($elem979);
              $this->success []= $elem979;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_vals_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter980)
          {
            $xfer += $output->writeString($iter980);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_spec_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $part_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_spec_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_spec_args');
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 1);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_partition_name_to_spec_result {
  static $_TSPEC;

  /**
   * @var array
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_partition_name_to_spec_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::MAP) {
            $this->success = array();
            $_size981 = 0;
            $_ktype982 = 0;
            $_vtype983 = 0;
            $xfer += $input->readMapBegin($_ktype982, $_vtype983, $_size981);
            for ($_i985 = 0; $_i985 < $_size981; ++$_i985)
            {
              $key986 = '';
              $val987 = '';
              $xfer += $input->readString($key986);
              $xfer += $input->readString($val987);
              $this->success[$key986] = $val987;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_partition_name_to_spec_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::MAP, 0);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->success));
        {
          foreach ($this->success as $kiter988 => $viter989)
          {
            $xfer += $output->writeString($kiter988);
            $xfer += $output->writeString($viter989);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_markPartitionForEvent_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var array
   */
  public $part_vals = null;
  /**
   * @var int
   */
  public $eventType = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'eventType',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['eventType'])) {
        $this->eventType = $vals['eventType'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_markPartitionForEvent_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::MAP) {
            $this->part_vals = array();
            $_size990 = 0;
            $_ktype991 = 0;
            $_vtype992 = 0;
            $xfer += $input->readMapBegin($_ktype991, $_vtype992, $_size990);
            for ($_i994 = 0; $_i994 < $_size990; ++$_i994)
            {
              $key995 = '';
              $val996 = '';
              $xfer += $input->readString($key995);
              $xfer += $input->readString($val996);
              $this->part_vals[$key995] = $val996;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->eventType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_markPartitionForEvent_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::MAP, 3);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $kiter997 => $viter998)
          {
            $xfer += $output->writeString($kiter997);
            $xfer += $output->writeString($viter998);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->eventType !== null) {
      $xfer += $output->writeFieldBegin('eventType', TType::I32, 4);
      $xfer += $output->writeI32($this->eventType);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_markPartitionForEvent_result {
  static $_TSPEC;

  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o4 = null;
  /**
   * @var \metastore\UnknownPartitionException
   */
  public $o5 = null;
  /**
   * @var \metastore\InvalidPartitionException
   */
  public $o6 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        5 => array(
          'var' => 'o5',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownPartitionException',
          ),
        6 => array(
          'var' => 'o6',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidPartitionException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
      if (isset($vals['o5'])) {
        $this->o5 = $vals['o5'];
      }
      if (isset($vals['o6'])) {
        $this->o6 = $vals['o6'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_markPartitionForEvent_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\UnknownTableException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->o5 = new \metastore\UnknownPartitionException();
            $xfer += $this->o5->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRUCT) {
            $this->o6 = new \metastore\InvalidPartitionException();
            $xfer += $this->o6->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_markPartitionForEvent_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o5 !== null) {
      $xfer += $output->writeFieldBegin('o5', TType::STRUCT, 5);
      $xfer += $this->o5->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o6 !== null) {
      $xfer += $output->writeFieldBegin('o6', TType::STRUCT, 6);
      $xfer += $this->o6->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_isPartitionMarkedForEvent_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var array
   */
  public $part_vals = null;
  /**
   * @var int
   */
  public $eventType = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_vals',
          'type' => TType::MAP,
          'ktype' => TType::STRING,
          'vtype' => TType::STRING,
          'key' => array(
            'type' => TType::STRING,
          ),
          'val' => array(
            'type' => TType::STRING,
            ),
          ),
        4 => array(
          'var' => 'eventType',
          'type' => TType::I32,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_vals'])) {
        $this->part_vals = $vals['part_vals'];
      }
      if (isset($vals['eventType'])) {
        $this->eventType = $vals['eventType'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_isPartitionMarkedForEvent_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::MAP) {
            $this->part_vals = array();
            $_size999 = 0;
            $_ktype1000 = 0;
            $_vtype1001 = 0;
            $xfer += $input->readMapBegin($_ktype1000, $_vtype1001, $_size999);
            for ($_i1003 = 0; $_i1003 < $_size999; ++$_i1003)
            {
              $key1004 = '';
              $val1005 = '';
              $xfer += $input->readString($key1004);
              $xfer += $input->readString($val1005);
              $this->part_vals[$key1004] = $val1005;
            }
            $xfer += $input->readMapEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::I32) {
            $xfer += $input->readI32($this->eventType);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_isPartitionMarkedForEvent_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_vals !== null) {
      if (!is_array($this->part_vals)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('part_vals', TType::MAP, 3);
      {
        $output->writeMapBegin(TType::STRING, TType::STRING, count($this->part_vals));
        {
          foreach ($this->part_vals as $kiter1006 => $viter1007)
          {
            $xfer += $output->writeString($kiter1006);
            $xfer += $output->writeString($viter1007);
          }
        }
        $output->writeMapEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->eventType !== null) {
      $xfer += $output->writeFieldBegin('eventType', TType::I32, 4);
      $xfer += $output->writeI32($this->eventType);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_isPartitionMarkedForEvent_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\UnknownDBException
   */
  public $o3 = null;
  /**
   * @var \metastore\UnknownTableException
   */
  public $o4 = null;
  /**
   * @var \metastore\UnknownPartitionException
   */
  public $o5 = null;
  /**
   * @var \metastore\InvalidPartitionException
   */
  public $o6 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownDBException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownTableException',
          ),
        5 => array(
          'var' => 'o5',
          'type' => TType::STRUCT,
          'class' => '\metastore\UnknownPartitionException',
          ),
        6 => array(
          'var' => 'o6',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidPartitionException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
      if (isset($vals['o5'])) {
        $this->o5 = $vals['o5'];
      }
      if (isset($vals['o6'])) {
        $this->o6 = $vals['o6'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_isPartitionMarkedForEvent_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\UnknownDBException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\UnknownTableException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 5:
          if ($ftype == TType::STRUCT) {
            $this->o5 = new \metastore\UnknownPartitionException();
            $xfer += $this->o5->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 6:
          if ($ftype == TType::STRUCT) {
            $this->o6 = new \metastore\InvalidPartitionException();
            $xfer += $this->o6->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_isPartitionMarkedForEvent_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o5 !== null) {
      $xfer += $output->writeFieldBegin('o5', TType::STRUCT, 5);
      $xfer += $this->o5->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o6 !== null) {
      $xfer += $output->writeFieldBegin('o6', TType::STRUCT, 6);
      $xfer += $this->o6->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_index_args {
  static $_TSPEC;

  /**
   * @var \metastore\Index
   */
  public $new_index = null;
  /**
   * @var \metastore\Table
   */
  public $index_table = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'new_index',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        2 => array(
          'var' => 'index_table',
          'type' => TType::STRUCT,
          'class' => '\metastore\Table',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['new_index'])) {
        $this->new_index = $vals['new_index'];
      }
      if (isset($vals['index_table'])) {
        $this->index_table = $vals['index_table'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_index_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->new_index = new \metastore\Index();
            $xfer += $this->new_index->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->index_table = new \metastore\Table();
            $xfer += $this->index_table->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_index_args');
    if ($this->new_index !== null) {
      if (!is_object($this->new_index)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_index', TType::STRUCT, 1);
      $xfer += $this->new_index->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->index_table !== null) {
      if (!is_object($this->index_table)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('index_table', TType::STRUCT, 2);
      $xfer += $this->index_table->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_add_index_result {
  static $_TSPEC;

  /**
   * @var \metastore\Index
   */
  public $success = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\AlreadyExistsException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\AlreadyExistsException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_add_index_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Index();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\AlreadyExistsException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_add_index_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_index_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $dbname = null;
  /**
   * @var string
   */
  public $base_tbl_name = null;
  /**
   * @var string
   */
  public $idx_name = null;
  /**
   * @var \metastore\Index
   */
  public $new_idx = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'dbname',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'base_tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'idx_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'new_idx',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['dbname'])) {
        $this->dbname = $vals['dbname'];
      }
      if (isset($vals['base_tbl_name'])) {
        $this->base_tbl_name = $vals['base_tbl_name'];
      }
      if (isset($vals['idx_name'])) {
        $this->idx_name = $vals['idx_name'];
      }
      if (isset($vals['new_idx'])) {
        $this->new_idx = $vals['new_idx'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_index_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->dbname);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->base_tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->idx_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->new_idx = new \metastore\Index();
            $xfer += $this->new_idx->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_index_args');
    if ($this->dbname !== null) {
      $xfer += $output->writeFieldBegin('dbname', TType::STRING, 1);
      $xfer += $output->writeString($this->dbname);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->base_tbl_name !== null) {
      $xfer += $output->writeFieldBegin('base_tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->base_tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->idx_name !== null) {
      $xfer += $output->writeFieldBegin('idx_name', TType::STRING, 3);
      $xfer += $output->writeString($this->idx_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->new_idx !== null) {
      if (!is_object($this->new_idx)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('new_idx', TType::STRUCT, 4);
      $xfer += $this->new_idx->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_alter_index_result {
  static $_TSPEC;

  /**
   * @var \metastore\InvalidOperationException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidOperationException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_alter_index_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\InvalidOperationException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_alter_index_result');
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_index_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $index_name = null;
  /**
   * @var bool
   */
  public $deleteData = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'index_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'deleteData',
          'type' => TType::BOOL,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['index_name'])) {
        $this->index_name = $vals['index_name'];
      }
      if (isset($vals['deleteData'])) {
        $this->deleteData = $vals['deleteData'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_index_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->index_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->deleteData);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_index_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->index_name !== null) {
      $xfer += $output->writeFieldBegin('index_name', TType::STRING, 3);
      $xfer += $output->writeString($this->index_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->deleteData !== null) {
      $xfer += $output->writeFieldBegin('deleteData', TType::BOOL, 4);
      $xfer += $output->writeBool($this->deleteData);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_drop_index_by_name_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_drop_index_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_drop_index_by_name_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_by_name_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $index_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'index_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['index_name'])) {
        $this->index_name = $vals['index_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_by_name_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->index_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_by_name_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->index_name !== null) {
      $xfer += $output->writeFieldBegin('index_name', TType::STRING, 3);
      $xfer += $output->writeString($this->index_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_by_name_result {
  static $_TSPEC;

  /**
   * @var \metastore\Index
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\Index',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_by_name_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\Index();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_by_name_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_indexes_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_indexes = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_indexes',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_indexes'])) {
        $this->max_indexes = $vals['max_indexes'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_indexes_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_indexes);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_indexes_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_indexes !== null) {
      $xfer += $output->writeFieldBegin('max_indexes', TType::I16, 3);
      $xfer += $output->writeI16($this->max_indexes);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_indexes_result {
  static $_TSPEC;

  /**
   * @var \metastore\Index[]
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRUCT,
          'elem' => array(
            'type' => TType::STRUCT,
            'class' => '\metastore\Index',
            ),
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_indexes_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size1008 = 0;
            $_etype1011 = 0;
            $xfer += $input->readListBegin($_etype1011, $_size1008);
            for ($_i1012 = 0; $_i1012 < $_size1008; ++$_i1012)
            {
              $elem1013 = null;
              $elem1013 = new \metastore\Index();
              $xfer += $elem1013->read($input);
              $this->success []= $elem1013;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_indexes_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRUCT, count($this->success));
        {
          foreach ($this->success as $iter1014)
          {
            $xfer += $iter1014->write($output);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_names_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var int
   */
  public $max_indexes = -1;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'max_indexes',
          'type' => TType::I16,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['max_indexes'])) {
        $this->max_indexes = $vals['max_indexes'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_names_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::I16) {
            $xfer += $input->readI16($this->max_indexes);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_names_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->max_indexes !== null) {
      $xfer += $output->writeFieldBegin('max_indexes', TType::I16, 3);
      $xfer += $output->writeI16($this->max_indexes);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_index_names_result {
  static $_TSPEC;

  /**
   * @var string[]
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::LST,
          'etype' => TType::STRING,
          'elem' => array(
            'type' => TType::STRING,
            ),
          ),
        1 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_index_names_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::LST) {
            $this->success = array();
            $_size1015 = 0;
            $_etype1018 = 0;
            $xfer += $input->readListBegin($_etype1018, $_size1015);
            for ($_i1019 = 0; $_i1019 < $_size1015; ++$_i1019)
            {
              $elem1020 = null;
              $xfer += $input->readString($elem1020);
              $this->success []= $elem1020;
            }
            $xfer += $input->readListEnd();
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_index_names_result');
    if ($this->success !== null) {
      if (!is_array($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::LST, 0);
      {
        $output->writeListBegin(TType::STRING, count($this->success));
        {
          foreach ($this->success as $iter1021)
          {
            $xfer += $output->writeString($iter1021);
          }
        }
        $output->writeListEnd();
      }
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 1);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_primary_keys_args {
  static $_TSPEC;

  /**
   * @var \metastore\PrimaryKeysRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\PrimaryKeysRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_primary_keys_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\PrimaryKeysRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_primary_keys_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_primary_keys_result {
  static $_TSPEC;

  /**
   * @var \metastore\PrimaryKeysResponse
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\PrimaryKeysResponse',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_primary_keys_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\PrimaryKeysResponse();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_primary_keys_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_foreign_keys_args {
  static $_TSPEC;

  /**
   * @var \metastore\ForeignKeysRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\ForeignKeysRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_foreign_keys_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\ForeignKeysRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_foreign_keys_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_foreign_keys_result {
  static $_TSPEC;

  /**
   * @var \metastore\ForeignKeysResponse
   */
  public $success = null;
  /**
   * @var \metastore\MetaException
   */
  public $o1 = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\ForeignKeysResponse',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_foreign_keys_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\ForeignKeysResponse();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\MetaException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\NoSuchObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_foreign_keys_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_table_column_statistics_args {
  static $_TSPEC;

  /**
   * @var \metastore\ColumnStatistics
   */
  public $stats_obj = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'stats_obj',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['stats_obj'])) {
        $this->stats_obj = $vals['stats_obj'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_table_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->stats_obj = new \metastore\ColumnStatistics();
            $xfer += $this->stats_obj->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_table_column_statistics_args');
    if ($this->stats_obj !== null) {
      if (!is_object($this->stats_obj)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('stats_obj', TType::STRUCT, 1);
      $xfer += $this->stats_obj->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_table_column_statistics_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_table_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_table_column_statistics_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_partition_column_statistics_args {
  static $_TSPEC;

  /**
   * @var \metastore\ColumnStatistics
   */
  public $stats_obj = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'stats_obj',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['stats_obj'])) {
        $this->stats_obj = $vals['stats_obj'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_partition_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->stats_obj = new \metastore\ColumnStatistics();
            $xfer += $this->stats_obj->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_partition_column_statistics_args');
    if ($this->stats_obj !== null) {
      if (!is_object($this->stats_obj)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('stats_obj', TType::STRUCT, 1);
      $xfer += $this->stats_obj->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_update_partition_column_statistics_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_update_partition_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_update_partition_column_statistics_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_column_statistics_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $col_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'col_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['col_name'])) {
        $this->col_name = $vals['col_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->col_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_column_statistics_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->col_name !== null) {
      $xfer += $output->writeFieldBegin('col_name', TType::STRING, 3);
      $xfer += $output->writeString($this->col_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_column_statistics_result {
  static $_TSPEC;

  /**
   * @var \metastore\ColumnStatistics
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\ColumnStatistics();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidInputException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_column_statistics_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_column_statistics_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;
  /**
   * @var string
   */
  public $col_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'col_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['col_name'])) {
        $this->col_name = $vals['col_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->col_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_column_statistics_args');
    if ($this->db_name !== null) {
      $xfer += $output->writeFieldBegin('db_name', TType::STRING, 1);
      $xfer += $output->writeString($this->db_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->tbl_name !== null) {
      $xfer += $output->writeFieldBegin('tbl_name', TType::STRING, 2);
      $xfer += $output->writeString($this->tbl_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->part_name !== null) {
      $xfer += $output->writeFieldBegin('part_name', TType::STRING, 3);
      $xfer += $output->writeString($this->part_name);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->col_name !== null) {
      $xfer += $output->writeFieldBegin('col_name', TType::STRING, 4);
      $xfer += $output->writeString($this->col_name);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partition_column_statistics_result {
  static $_TSPEC;

  /**
   * @var \metastore\ColumnStatistics
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\ColumnStatistics',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partition_column_statistics_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\ColumnStatistics();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\InvalidInputException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidObjectException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partition_column_statistics_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_statistics_req_args {
  static $_TSPEC;

  /**
   * @var \metastore\TableStatsRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\TableStatsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_statistics_req_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\TableStatsRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_statistics_req_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_table_statistics_req_result {
  static $_TSPEC;

  /**
   * @var \metastore\TableStatsResult
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\TableStatsResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_table_statistics_req_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\TableStatsResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_table_statistics_req_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_statistics_req_args {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionsStatsRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionsStatsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_statistics_req_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\PartitionsStatsRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_statistics_req_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_partitions_statistics_req_result {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionsStatsResult
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionsStatsResult',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_partitions_statistics_req_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\PartitionsStatsResult();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_partitions_statistics_req_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_aggr_stats_for_args {
  static $_TSPEC;

  /**
   * @var \metastore\PartitionsStatsRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\PartitionsStatsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_aggr_stats_for_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\PartitionsStatsRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_aggr_stats_for_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_get_aggr_stats_for_result {
  static $_TSPEC;

  /**
   * @var \metastore\AggrStats
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o2 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::STRUCT,
          'class' => '\metastore\AggrStats',
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_get_aggr_stats_for_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::STRUCT) {
            $this->success = new \metastore\AggrStats();
            $xfer += $this->success->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\MetaException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_get_aggr_stats_for_result');
    if ($this->success !== null) {
      if (!is_object($this->success)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('success', TType::STRUCT, 0);
      $xfer += $this->success->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_set_aggr_stats_for_args {
  static $_TSPEC;

  /**
   * @var \metastore\SetPartitionsStatsRequest
   */
  public $request = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'request',
          'type' => TType::STRUCT,
          'class' => '\metastore\SetPartitionsStatsRequest',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['request'])) {
        $this->request = $vals['request'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_set_aggr_stats_for_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->request = new \metastore\SetPartitionsStatsRequest();
            $xfer += $this->request->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_set_aggr_stats_for_args');
    if ($this->request !== null) {
      if (!is_object($this->request)) {
        throw new TProtocolException('Bad type in structure.', TProtocolException::INVALID_DATA);
      }
      $xfer += $output->writeFieldBegin('request', TType::STRUCT, 1);
      $xfer += $this->request->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_set_aggr_stats_for_result {
  static $_TSPEC;

  /**
   * @var bool
   */
  public $success = null;
  /**
   * @var \metastore\NoSuchObjectException
   */
  public $o1 = null;
  /**
   * @var \metastore\InvalidObjectException
   */
  public $o2 = null;
  /**
   * @var \metastore\MetaException
   */
  public $o3 = null;
  /**
   * @var \metastore\InvalidInputException
   */
  public $o4 = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        0 => array(
          'var' => 'success',
          'type' => TType::BOOL,
          ),
        1 => array(
          'var' => 'o1',
          'type' => TType::STRUCT,
          'class' => '\metastore\NoSuchObjectException',
          ),
        2 => array(
          'var' => 'o2',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidObjectException',
          ),
        3 => array(
          'var' => 'o3',
          'type' => TType::STRUCT,
          'class' => '\metastore\MetaException',
          ),
        4 => array(
          'var' => 'o4',
          'type' => TType::STRUCT,
          'class' => '\metastore\InvalidInputException',
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['success'])) {
        $this->success = $vals['success'];
      }
      if (isset($vals['o1'])) {
        $this->o1 = $vals['o1'];
      }
      if (isset($vals['o2'])) {
        $this->o2 = $vals['o2'];
      }
      if (isset($vals['o3'])) {
        $this->o3 = $vals['o3'];
      }
      if (isset($vals['o4'])) {
        $this->o4 = $vals['o4'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_set_aggr_stats_for_result';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 0:
          if ($ftype == TType::BOOL) {
            $xfer += $input->readBool($this->success);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 1:
          if ($ftype == TType::STRUCT) {
            $this->o1 = new \metastore\NoSuchObjectException();
            $xfer += $this->o1->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRUCT) {
            $this->o2 = new \metastore\InvalidObjectException();
            $xfer += $this->o2->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRUCT) {
            $this->o3 = new \metastore\MetaException();
            $xfer += $this->o3->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRUCT) {
            $this->o4 = new \metastore\InvalidInputException();
            $xfer += $this->o4->read($input);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_set_aggr_stats_for_result');
    if ($this->success !== null) {
      $xfer += $output->writeFieldBegin('success', TType::BOOL, 0);
      $xfer += $output->writeBool($this->success);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o1 !== null) {
      $xfer += $output->writeFieldBegin('o1', TType::STRUCT, 1);
      $xfer += $this->o1->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o2 !== null) {
      $xfer += $output->writeFieldBegin('o2', TType::STRUCT, 2);
      $xfer += $this->o2->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o3 !== null) {
      $xfer += $output->writeFieldBegin('o3', TType::STRUCT, 3);
      $xfer += $this->o3->write($output);
      $xfer += $output->writeFieldEnd();
    }
    if ($this->o4 !== null) {
      $xfer += $output->writeFieldBegin('o4', TType::STRUCT, 4);
      $xfer += $this->o4->write($output);
      $xfer += $output->writeFieldEnd();
    }
    $xfer += $output->writeFieldStop();
    $xfer += $output->writeStructEnd();
    return $xfer;
  }

}

class ThriftHiveMetastore_delete_partition_column_statistics_args {
  static $_TSPEC;

  /**
   * @var string
   */
  public $db_name = null;
  /**
   * @var string
   */
  public $tbl_name = null;
  /**
   * @var string
   */
  public $part_name = null;
  /**
   * @var string
   */
  public $col_name = null;

  public function __construct($vals=null) {
    if (!isset(self::$_TSPEC)) {
      self::$_TSPEC = array(
        1 => array(
          'var' => 'db_name',
          'type' => TType::STRING,
          ),
        2 => array(
          'var' => 'tbl_name',
          'type' => TType::STRING,
          ),
        3 => array(
          'var' => 'part_name',
          'type' => TType::STRING,
          ),
        4 => array(
          'var' => 'col_name',
          'type' => TType::STRING,
          ),
        );
    }
    if (is_array($vals)) {
      if (isset($vals['db_name'])) {
        $this->db_name = $vals['db_name'];
      }
      if (isset($vals['tbl_name'])) {
        $this->tbl_name = $vals['tbl_name'];
      }
      if (isset($vals['part_name'])) {
        $this->part_name = $vals['part_name'];
      }
      if (isset($vals['col_name'])) {
        $this->col_name = $vals['col_name'];
      }
    }
  }

  public function getName() {
    return 'ThriftHiveMetastore_delete_partition_column_statistics_args';
  }

  public function read($input)
  {
    $xfer = 0;
    $fname = null;
    $ftype = 0;
    $fid = 0;
    $xfer += $input->readStructBegin($fname);
    while (true)
    {
      $xfer += $input->readFieldBegin($fname, $ftype, $fid);
      if ($ftype == TType::STOP) {
        break;
      }
      switch ($fid)
      {
        case 1:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->db_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 2:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->tbl_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 3:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->part_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        case 4:
          if ($ftype == TType::STRING) {
            $xfer += $input->readString($this->col_name);
          } else {
            $xfer += $input->skip($ftype);
          }
          break;
        default:
          $xfer += $input->skip($ftype);
          break;
      }
      $xfer += $input->readFieldEnd();
    }
    $xfer += $input->readStructEnd();
    return $xfer;
  }

  public function write($output) {
    $xfer = 0;
    $xfer += $output->writeStructBegin('ThriftHiveMetastore_delete_par