/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.AsyncContentProvider;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;

public class DeferredContentProvider
implements AsyncContentProvider,
Callback,
Closeable {
    private static final AsyncChunk CLOSE = new AsyncChunk(BufferUtil.EMPTY_BUFFER, (Callback)Callback.Adapter.INSTANCE);
    private final Object lock = this;
    private final Queue<AsyncChunk> chunks = new ArrayQueue(4, 64, this.lock);
    private final AtomicReference<AsyncContentProvider.Listener> listener = new AtomicReference();
    private final DeferredContentProviderIterator iterator = new DeferredContentProviderIterator();
    private final AtomicBoolean closed = new AtomicBoolean();
    private int size;
    private Throwable failure;

    public DeferredContentProvider(ByteBuffer ... buffers) {
        for (ByteBuffer buffer : buffers) {
            this.offer(buffer);
        }
    }

    @Override
    public void setListener(AsyncContentProvider.Listener listener) {
        if (!this.listener.compareAndSet(null, listener)) {
            throw new IllegalStateException(String.format("The same %s instance cannot be used in multiple requests", AsyncContentProvider.class.getName()));
        }
    }

    @Override
    public long getLength() {
        return -1L;
    }

    public boolean offer(ByteBuffer buffer) {
        return this.offer(buffer, (Callback)Callback.Adapter.INSTANCE);
    }

    public boolean offer(ByteBuffer buffer, Callback callback) {
        return this.offer(new AsyncChunk(buffer, callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean offer(AsyncChunk chunk) {
        Throwable failure;
        boolean result = false;
        Object object = this.lock;
        synchronized (object) {
            failure = this.failure;
            if (failure == null && (result = this.chunks.offer(chunk)) && chunk != CLOSE) {
                ++this.size;
            }
        }
        if (failure != null) {
            chunk.callback.failed(failure);
        } else if (result) {
            this.notifyListener();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.chunks.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                while (true) {
                    if (this.failure != null) {
                        throw new IOException(this.failure);
                    }
                    if (this.size != 0) {
                        this.lock.wait();
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
        }
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.offer(CLOSE);
        }
    }

    public void succeeded() {
    }

    public void failed(Throwable failure) {
        this.iterator.failed(failure);
    }

    private void notifyListener() {
        AsyncContentProvider.Listener listener = this.listener.get();
        if (listener != null) {
            listener.onContent();
        }
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return this.iterator;
    }

    private static class AsyncChunk {
        private final ByteBuffer buffer;
        private final Callback callback;

        private AsyncChunk(ByteBuffer buffer, Callback callback) {
            this.buffer = Objects.requireNonNull(buffer);
            this.callback = Objects.requireNonNull(callback);
        }
    }

    private class DeferredContentProviderIterator
    implements Iterator<ByteBuffer>,
    Callback {
        private AsyncChunk current;

        private DeferredContentProviderIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = DeferredContentProvider.this.lock;
            synchronized (object) {
                return DeferredContentProvider.this.chunks.peek() != CLOSE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer next() {
            Object object = DeferredContentProvider.this.lock;
            synchronized (object) {
                AsyncChunk chunk = this.current = (AsyncChunk)DeferredContentProvider.this.chunks.poll();
                if (chunk == CLOSE) {
                    throw new NoSuchElementException();
                }
                return chunk == null ? null : chunk.buffer;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void succeeded() {
            AsyncChunk chunk;
            Object object = DeferredContentProvider.this.lock;
            synchronized (object) {
                chunk = this.current;
                if (chunk != null) {
                    --DeferredContentProvider.this.size;
                    DeferredContentProvider.this.lock.notify();
                }
            }
            if (chunk != null) {
                chunk.callback.succeeded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void failed(Throwable x) {
            ArrayList chunks = new ArrayList();
            Object object = DeferredContentProvider.this.lock;
            synchronized (object) {
                DeferredContentProvider.this.failure = x;
                chunks.addAll(DeferredContentProvider.this.chunks);
                DeferredContentProvider.this.clear();
                this.current = null;
                DeferredContentProvider.this.lock.notify();
            }
            for (AsyncChunk chunk : chunks) {
                chunk.callback.failed(x);
            }
        }
    }
}

