/*
 * Decompiled with CFR 0.152.
 */
package io.druid.data.input.impl;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.metamx.common.parsers.TimestampParser;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

public class TimestampSpec {
    private static final String DEFAULT_COLUMN = "timestamp";
    private static final String DEFAULT_FORMAT = "auto";
    private static final DateTime DEFAULT_MISSING_VALUE = null;
    private final String timestampColumn;
    private final String timestampFormat;
    private final Function<Object, DateTime> timestampConverter;
    private final DateTime missingValue;
    private ParseCtx parseCtx = new ParseCtx();

    @JsonCreator
    public TimestampSpec(@JsonProperty(value="column") String timestampColumn, @JsonProperty(value="format") String format, @JsonProperty(value="missingValue") DateTime missingValue) {
        this.timestampColumn = timestampColumn == null ? DEFAULT_COLUMN : timestampColumn;
        this.timestampFormat = format == null ? DEFAULT_FORMAT : format;
        this.timestampConverter = TimestampParser.createObjectTimestampParser((String)this.timestampFormat);
        this.missingValue = missingValue == null ? DEFAULT_MISSING_VALUE : missingValue;
    }

    @JsonProperty(value="column")
    public String getTimestampColumn() {
        return this.timestampColumn;
    }

    @JsonProperty(value="format")
    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    @JsonProperty(value="missingValue")
    public DateTime getMissingValue() {
        return this.missingValue;
    }

    public DateTime extractTimestamp(Map<String, Object> input) {
        Object o = input.get(this.timestampColumn);
        DateTime extracted = this.missingValue;
        if (o != null) {
            if (o.equals(this.parseCtx.lastTimeObject)) {
                extracted = this.parseCtx.lastDateTime;
            } else {
                ParseCtx newCtx = new ParseCtx();
                newCtx.lastTimeObject = o;
                newCtx.lastDateTime = extracted = (DateTime)this.timestampConverter.apply(o);
                this.parseCtx = newCtx;
            }
        }
        return extracted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimestampSpec that = (TimestampSpec)o;
        if (!this.timestampColumn.equals(that.timestampColumn)) {
            return false;
        }
        if (!this.timestampFormat.equals(that.timestampFormat)) {
            return false;
        }
        return !(this.missingValue == null ? that.missingValue != null : !this.missingValue.equals((Object)that.missingValue));
    }

    public int hashCode() {
        int result = this.timestampColumn.hashCode();
        result = 31 * result + this.timestampFormat.hashCode();
        result = 31 * result + (this.missingValue != null ? this.missingValue.hashCode() : 0);
        return result;
    }

    public static TimestampSpec mergeTimestampSpec(List<TimestampSpec> toMerge) {
        if (toMerge == null || toMerge.size() == 0) {
            return null;
        }
        TimestampSpec result = toMerge.get(0);
        for (int i = 1; i < toMerge.size(); ++i) {
            if (toMerge.get(i) == null || Objects.equals(result, toMerge.get(i))) continue;
            return null;
        }
        return result;
    }

    private static class ParseCtx {
        Object lastTimeObject = null;
        DateTime lastDateTime = null;

        private ParseCtx() {
        }
    }
}

