/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.initialization;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.core.Emitter;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.guice.LazySingleton;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Self;
import io.druid.server.DruidNode;
import io.druid.server.initialization.ComposingEmitterModule;
import io.druid.server.initialization.HttpEmitterModule;
import io.druid.server.initialization.LogEmitterModule;
import io.druid.server.initialization.NoopEmitterModule;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class EmitterModule
implements Module {
    private static final Logger log = new Logger(EmitterModule.class);
    private static final String EMITTER_PROPERTY = "druid.emitter";
    private final Properties props;

    @Inject
    public EmitterModule(Properties props) {
        this.props = props;
    }

    public void configure(Binder binder) {
        String emitterType = this.props.getProperty(EMITTER_PROPERTY, "");
        binder.install((Module)new NoopEmitterModule());
        binder.install((Module)new LogEmitterModule());
        binder.install((Module)new HttpEmitterModule());
        binder.install((Module)new ComposingEmitterModule());
        binder.bind(Emitter.class).toProvider((Provider)new EmitterProvider(emitterType)).in(LazySingleton.class);
    }

    @Provides
    @ManageLifecycle
    public ServiceEmitter getServiceEmitter(@Self Supplier<DruidNode> configSupplier, Emitter emitter) {
        DruidNode config = (DruidNode)configSupplier.get();
        ServiceEmitter retVal = new ServiceEmitter(config.getServiceName(), config.getHostAndPort(), emitter);
        EmittingLogger.registerEmitter((ServiceEmitter)retVal);
        return retVal;
    }

    private static class EmitterProvider
    implements Provider<Emitter> {
        private final String emitterType;
        private Emitter emitter = null;

        EmitterProvider(String emitterType) {
            this.emitterType = emitterType;
        }

        @Inject
        public void inject(Injector injector) {
            List emitterBindings = injector.findBindingsByType((TypeLiteral)new TypeLiteral<Emitter>(){});
            this.emitter = this.findEmitter(this.emitterType, emitterBindings);
            if (this.emitter == null) {
                this.emitter = this.findEmitter("noop", emitterBindings);
            }
            if (this.emitter == null) {
                ArrayList knownTypes = Lists.newArrayList();
                for (Binding binding : emitterBindings) {
                    Annotation annotation = binding.getKey().getAnnotation();
                    if (annotation == null) continue;
                    knownTypes.add(((Named)annotation).value());
                }
                throw new ISE("Unknown emitter type[%s]=[%s], known types[%s]", new Object[]{EmitterModule.EMITTER_PROPERTY, this.emitterType, knownTypes});
            }
        }

        private Emitter findEmitter(String emitterType, List<Binding<Emitter>> emitterBindings) {
            for (Binding<Emitter> binding : emitterBindings) {
                if (!Names.named((String)emitterType).equals(binding.getKey().getAnnotation())) continue;
                return (Emitter)binding.getProvider().get();
            }
            return null;
        }

        public Emitter get() {
            if (this.emitter == null) {
                throw new ISE("Emitter was null, that's bad!", new Object[0]);
            }
            return this.emitter;
        }
    }
}

