/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.initialization;

import com.fasterxml.jackson.databind.Module;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provides;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.core.ComposingEmitter;
import com.metamx.emitter.core.Emitter;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.ManageLifecycle;
import io.druid.initialization.DruidModule;
import io.druid.server.initialization.ComposingEmitterConfig;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;

public class ComposingEmitterModule
implements DruidModule {
    private static Logger log = new Logger(ComposingEmitterModule.class);

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.emitter.composing", ComposingEmitterConfig.class);
    }

    public List<? extends Module> getJacksonModules() {
        return Collections.EMPTY_LIST;
    }

    @Provides
    @ManageLifecycle
    @Named(value="composing")
    public Emitter getEmitter(ComposingEmitterConfig config, final Injector injector) {
        log.info("Creating Composing Emitter with %s", new Object[]{config.getEmitters()});
        List emitters = Lists.transform(config.getEmitters(), (Function)new Function<String, Emitter>(){

            public Emitter apply(String s) {
                return (Emitter)injector.getInstance(Key.get(Emitter.class, (Annotation)Names.named((String)s)));
            }
        });
        return new ComposingEmitter(emitters);
    }
}

