/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.metamx.common.IAE;
import com.metamx.common.RE;
import com.metamx.common.logger.Logger;
import io.druid.audit.AuditInfo;
import io.druid.common.utils.ServletResourceUtils;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.server.lookup.cache.LookupCoordinatorManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="/druid/coordinator/v1/lookups")
public class LookupCoordinatorResource {
    private static final Logger LOG = new Logger(LookupCoordinatorResource.class);
    private final LookupCoordinatorManager lookupCoordinatorManager;
    private final ObjectMapper smileMapper;
    private final ObjectMapper jsonMapper;

    @Inject
    public LookupCoordinatorResource(LookupCoordinatorManager lookupCoordinatorManager, @Smile ObjectMapper smileMapper, @Json ObjectMapper jsonMapper) {
        this.smileMapper = smileMapper;
        this.jsonMapper = jsonMapper;
        this.lookupCoordinatorManager = lookupCoordinatorManager;
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    public Response getTiers(@DefaultValue(value="false") @QueryParam(value="discover") boolean discover) {
        try {
            if (discover) {
                return Response.ok().entity(this.lookupCoordinatorManager.discoverTiers()).build();
            }
            Map<String, Map<String, Map<String, Object>>> knownLookups = this.lookupCoordinatorManager.getKnownLookups();
            if (knownLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok().entity(knownLookups.keySet()).build();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error getting list of lookups", new Object[0]);
            return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Consumes(value={"application/json", "application/x-jackson-smile"})
    public Response updateAllLookups(InputStream in, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        try {
            Map map;
            boolean isSmile = "application/x-jackson-smile".equals(req.getContentType());
            ObjectMapper mapper = isSmile ? this.smileMapper : this.jsonMapper;
            try {
                map = (Map)mapper.readValue(in, (TypeReference)new TypeReference<Map<String, Map<String, Map<String, Object>>>>(){});
            }
            catch (IOException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
            }
            if (this.lookupCoordinatorManager.updateLookups(map, new AuditInfo(author, comment, req.getRemoteAddr()))) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)map).build();
            }
            throw new RuntimeException("Unknown error updating configuration");
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error creating new lookups", new Object[0]);
            return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @DELETE
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/{tier}/{lookup}")
    public Response deleteLookup(@PathParam(value="tier") String tier, @PathParam(value="lookup") String lookup, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, @Context HttpServletRequest req) {
        try {
            if (Strings.isNullOrEmpty((String)tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)new NullPointerException("`tier` required"))).build();
            }
            if (Strings.isNullOrEmpty((String)lookup)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)new IAE("`lookup` required", new Object[0]))).build();
            }
            if (this.lookupCoordinatorManager.deleteLookup(tier, lookup, new AuditInfo(author, comment, req.getRemoteAddr()))) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error deleting lookup [%s]", new Object[]{lookup});
            return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @POST
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/{tier}/{lookup}")
    public Response createOrUpdateLookup(@PathParam(value="tier") String tier, @PathParam(value="lookup") String lookup, @HeaderParam(value="X-Druid-Author") @DefaultValue(value="") String author, @HeaderParam(value="X-Druid-Comment") @DefaultValue(value="") String comment, InputStream in, @Context HttpServletRequest req) {
        try {
            Map lookupSpec;
            if (Strings.isNullOrEmpty((String)tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)new NullPointerException("`tier` required"))).build();
            }
            if (Strings.isNullOrEmpty((String)lookup)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)new IAE("`lookup` required", new Object[0]))).build();
            }
            boolean isSmile = "application/x-jackson-smile".equals(req.getContentType());
            ObjectMapper mapper = isSmile ? this.smileMapper : this.jsonMapper;
            try {
                lookupSpec = (Map)mapper.readValue(in, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
            }
            if (this.lookupCoordinatorManager.updateLookup(tier, lookup, lookupSpec, new AuditInfo(author, comment, req.getRemoteAddr()))) {
                return Response.status((Response.Status)Response.Status.ACCEPTED).build();
            }
            throw new RuntimeException("Unknown error updating configuration");
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error updating tier [%s] lookup [%s]", new Object[]{tier, lookup});
            return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/{tier}/{lookup}")
    public Response getSpecificLookup(@PathParam(value="tier") String tier, @PathParam(value="lookup") String lookup) {
        try {
            if (Strings.isNullOrEmpty((String)tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)new NullPointerException("`tier` required"))).build();
            }
            if (Strings.isNullOrEmpty((String)lookup)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)new NullPointerException("`lookup` required"))).build();
            }
            Map<String, Object> map = this.lookupCoordinatorManager.getLookup(tier, lookup);
            if (map == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ServletResourceUtils.sanitizeException((Throwable)new RE("lookup [%s] not found", new Object[]{lookup}))).build();
            }
            return Response.ok().entity(map).build();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error getting lookup [%s]", new Object[]{lookup});
            return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }

    @GET
    @Produces(value={"application/json", "application/x-jackson-smile"})
    @Path(value="/{tier}")
    public Response getSpecificTier(@PathParam(value="tier") String tier) {
        try {
            if (Strings.isNullOrEmpty((String)tier)) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)ServletResourceUtils.sanitizeException((Throwable)new NullPointerException("`tier` required"))).build();
            }
            Map<String, Map<String, Map<String, Object>>> map = this.lookupCoordinatorManager.getKnownLookups();
            if (map == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ServletResourceUtils.sanitizeException((Throwable)new RE("No lookups found", new Object[0]))).build();
            }
            Map<String, Map<String, Object>> tierLookups = map.get(tier);
            if (tierLookups == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)ServletResourceUtils.sanitizeException((Throwable)new RE("Tier [%s] not found", new Object[]{tier}))).build();
            }
            return Response.ok().entity(tierLookups.keySet()).build();
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error getting tier [%s]", new Object[]{tier});
            return Response.serverError().entity((Object)ServletResourceUtils.sanitizeException((Throwable)e)).build();
        }
    }
}

