/*
 * Decompiled with CFR 0.152.
 */
package io.druid.server.coordination;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.curator.announcement.Announcer;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.server.coordination.DruidServerMetadata;
import io.druid.server.initialization.ZkPathsConfig;
import org.apache.curator.utils.ZKPaths;

public abstract class AbstractDataSegmentAnnouncer
implements DataSegmentAnnouncer {
    private static final Logger log = new Logger(AbstractDataSegmentAnnouncer.class);
    private final DruidServerMetadata server;
    private final ZkPathsConfig config;
    private final Announcer announcer;
    private final ObjectMapper jsonMapper;
    private final Object lock = new Object();
    private volatile boolean started = false;

    protected AbstractDataSegmentAnnouncer(DruidServerMetadata server, ZkPathsConfig config, Announcer announcer, ObjectMapper jsonMapper) {
        this.server = server;
        this.config = config;
        this.announcer = announcer;
        this.jsonMapper = jsonMapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        Object object = this.lock;
        synchronized (object) {
            if (this.started) {
                return;
            }
            try {
                String path = this.makeAnnouncementPath();
                log.info("Announcing self[%s] at [%s]", new Object[]{this.server, path});
                this.announcer.announce(path, this.jsonMapper.writeValueAsBytes((Object)this.server), false);
            }
            catch (JsonProcessingException e) {
                throw Throwables.propagate((Throwable)e);
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.started) {
                return;
            }
            log.info("Stopping %s with config[%s]", new Object[]{this.getClass(), this.config});
            this.announcer.unannounce(this.makeAnnouncementPath());
            this.started = false;
        }
    }

    private String makeAnnouncementPath() {
        return ZKPaths.makePath((String)this.config.getAnnouncementsPath(), (String)this.server.getName());
    }
}

