/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.google.common.base.Preconditions;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.segment.IndexIO;
import io.druid.segment.QueryableIndex;
import io.druid.segment.loading.QueryableIndexFactory;
import io.druid.segment.loading.SegmentLoadingException;
import java.io.File;
import java.io.IOException;

public class MMappedQueryableIndexFactory
implements QueryableIndexFactory {
    private static final Logger log = new Logger(MMappedQueryableIndexFactory.class);
    private final IndexIO indexIO;

    @Inject
    public MMappedQueryableIndexFactory(IndexIO indexIO) {
        this.indexIO = (IndexIO)Preconditions.checkNotNull((Object)indexIO, (Object)"Null IndexIO");
    }

    @Override
    public QueryableIndex factorize(File parentDir) throws SegmentLoadingException {
        try {
            return this.indexIO.loadIndex(parentDir);
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, "%s", new Object[]{e.getMessage()});
        }
    }
}

