/*
 * Decompiled with CFR 0.152.
 */
package io.druid.metadata;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import io.druid.metadata.MetadataStorageActionHandler;
import io.druid.metadata.MetadataStorageActionHandlerFactory;
import io.druid.metadata.MetadataStorageActionHandlerTypes;
import io.druid.metadata.MetadataStorageTablesConfig;
import io.druid.metadata.SQLMetadataConnector;
import io.druid.metadata.SQLMetadataStorageActionHandler;

public class SQLMetadataStorageActionHandlerFactory
implements MetadataStorageActionHandlerFactory {
    private final SQLMetadataConnector connector;
    private final MetadataStorageTablesConfig config;
    private final ObjectMapper jsonMapper;

    @Inject
    public SQLMetadataStorageActionHandlerFactory(SQLMetadataConnector connector, MetadataStorageTablesConfig config, ObjectMapper jsonMapper) {
        this.connector = connector;
        this.config = config;
        this.jsonMapper = jsonMapper;
    }

    public <A, B, C, D> MetadataStorageActionHandler<A, B, C, D> create(String entryType, MetadataStorageActionHandlerTypes<A, B, C, D> payloadTypes) {
        return new SQLMetadataStorageActionHandler<A, B, C, D>(this.connector, this.jsonMapper, payloadTypes, entryType, this.config.getEntryTable(entryType), this.config.getLogTable(entryType), this.config.getLockTable(entryType));
    }
}

