/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.name.Names;
import io.druid.client.cache.Cache;
import io.druid.client.cache.CacheProvider;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Global;
import java.lang.annotation.Annotation;

public class CacheModule
implements Module {
    public static final String DRUID_GLOBAL_CACHE_PREFIX = "druid.cache";
    public final String prefix;

    public CacheModule() {
        this.prefix = DRUID_GLOBAL_CACHE_PREFIX;
    }

    public CacheModule(String prefix) {
        this.prefix = prefix;
    }

    public void configure(Binder binder) {
        binder.bind(Cache.class).toProvider(Key.get(CacheProvider.class, Global.class)).in(ManageLifecycle.class);
        JsonConfigProvider.bind((Binder)binder, (String)this.prefix, CacheProvider.class, Global.class);
        binder.install((Module)new HybridCacheModule(this.prefix));
    }

    public static class HybridCacheModule
    implements Module {
        private final String prefix;

        public HybridCacheModule(String prefix) {
            this.prefix = prefix;
        }

        public void configure(Binder binder) {
            JsonConfigProvider.bind((Binder)binder, (String)(this.prefix + ".l1"), CacheProvider.class, (Annotation)Names.named((String)"l1"));
            JsonConfigProvider.bind((Binder)binder, (String)(this.prefix + ".l2"), CacheProvider.class, (Annotation)Names.named((String)"l2"));
        }
    }
}

