/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.cache;

import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import net.spy.memcached.transcoders.SerializingTranscoder;

public class LZ4Transcoder
extends SerializingTranscoder {
    private final LZ4Factory lz4Factory = LZ4Factory.fastestInstance();

    public LZ4Transcoder() {
    }

    public LZ4Transcoder(int max) {
        super(max);
    }

    protected byte[] compress(byte[] in) {
        if (in == null) {
            throw new NullPointerException("Can't compress null");
        }
        LZ4Compressor compressor = this.lz4Factory.fastCompressor();
        byte[] out = new byte[compressor.maxCompressedLength(in.length)];
        int compressedLength = compressor.compress(in, 0, in.length, out, 0);
        this.getLogger().debug("Compressed %d bytes to %d", new Object[]{in.length, compressedLength});
        return ByteBuffer.allocate(4 + compressedLength).putInt(in.length).put(out, 0, compressedLength).array();
    }

    protected byte[] decompress(byte[] in) {
        byte[] out = null;
        if (in != null) {
            LZ4FastDecompressor decompressor = this.lz4Factory.fastDecompressor();
            int size = ByteBuffer.wrap(in).getInt();
            out = new byte[size];
            decompressor.decompress(in, 4, out, 0, out.length);
        }
        return out == null ? null : out;
    }
}

