/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.cache;

import java.util.AbstractQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BytesBoundedLinkedQueue<E>
extends AbstractQueue<E>
implements BlockingQueue<E> {
    private final Queue<E> delegate;
    private final AtomicLong currentSize = new AtomicLong(0L);
    private final Lock putLock = new ReentrantLock();
    private final Condition notFull = this.putLock.newCondition();
    private final Lock takeLock = new ReentrantLock();
    private final Condition notEmpty = this.takeLock.newCondition();
    private final AtomicInteger elementCount = new AtomicInteger(0);
    private long capacity;

    public BytesBoundedLinkedQueue(long capacity) {
        this.delegate = new ConcurrentLinkedQueue();
        this.capacity = capacity;
    }

    private static void checkNotNull(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
    }

    private void checkSize(E e) {
        if (this.getBytesSize(e) > this.capacity) {
            throw new IllegalArgumentException(String.format("cannot add element of size[%d] greater than capacity[%d]", this.getBytesSize(e), this.capacity));
        }
    }

    public abstract long getBytesSize(E var1);

    public void elementAdded(E e) {
        this.currentSize.addAndGet(this.getBytesSize(e));
        this.elementCount.getAndIncrement();
    }

    public void elementRemoved(E e) {
        this.currentSize.addAndGet(-1L * this.getBytesSize(e));
        this.elementCount.getAndDecrement();
    }

    private void fullyUnlock() {
        this.takeLock.unlock();
        this.putLock.unlock();
    }

    private void fullyLock() {
        this.takeLock.lock();
        this.putLock.lock();
    }

    private void signalNotEmpty() {
        this.takeLock.lock();
        try {
            this.notEmpty.signal();
        }
        finally {
            this.takeLock.unlock();
        }
    }

    private void signalNotFull() {
        this.putLock.lock();
        try {
            this.notFull.signal();
        }
        finally {
            this.putLock.unlock();
        }
    }

    @Override
    public int size() {
        return this.elementCount.get();
    }

    @Override
    public void put(E e) throws InterruptedException {
        while (!this.offer(e, Long.MAX_VALUE, TimeUnit.NANOSECONDS)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        BytesBoundedLinkedQueue.checkNotNull(e);
        this.checkSize(e);
        long nanos = unit.toNanos(timeout);
        boolean added = false;
        this.putLock.lockInterruptibly();
        try {
            while (this.currentSize.get() + this.getBytesSize(e) > this.capacity) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.notFull.awaitNanos(nanos);
            }
            this.delegate.add(e);
            this.elementAdded(e);
            added = true;
        }
        finally {
            this.putLock.unlock();
        }
        if (added) {
            this.signalNotEmpty();
        }
        return added;
    }

    @Override
    public E take() throws InterruptedException {
        E e;
        this.takeLock.lockInterruptibly();
        try {
            while (this.elementCount.get() == 0) {
                this.notEmpty.await();
            }
            e = this.delegate.remove();
            this.elementRemoved(e);
        }
        finally {
            this.takeLock.unlock();
        }
        if (e != null) {
            this.signalNotFull();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        long currentByteSize;
        int delegateSize;
        this.fullyLock();
        try {
            delegateSize = this.elementCount.get();
            currentByteSize = this.currentSize.get();
        }
        finally {
            this.fullyUnlock();
        }
        if (delegateSize == 0) {
            return (int)Math.min(this.capacity, Integer.MAX_VALUE);
        }
        if (this.capacity > currentByteSize) {
            long averageElementSize = currentByteSize / (long)delegateSize;
            return (int)((this.capacity - currentByteSize) / averageElementSize);
        }
        return 0;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        return this.drainTo(c, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        this.takeLock.lock();
        try {
            n = Math.min(maxElements, this.elementCount.get());
            if (n < 0) {
                int n2 = 0;
                return n2;
            }
            for (int i = 0; i < n; ++i) {
                E e = this.delegate.remove();
                this.elementRemoved(e);
                c.add(e);
            }
        }
        finally {
            this.takeLock.unlock();
        }
        if (n > 0) {
            this.signalNotFull();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E e) {
        BytesBoundedLinkedQueue.checkNotNull(e);
        this.checkSize(e);
        boolean added = false;
        this.putLock.lock();
        try {
            if (this.currentSize.get() + this.getBytesSize(e) > this.capacity) {
                boolean bl = false;
                return bl;
            }
            added = this.delegate.add(e);
            if (added) {
                this.elementAdded(e);
            }
        }
        finally {
            this.putLock.unlock();
        }
        if (added) {
            this.signalNotEmpty();
        }
        return added;
    }

    @Override
    public E poll() {
        E e = null;
        this.takeLock.lock();
        try {
            e = this.delegate.poll();
            if (e != null) {
                this.elementRemoved(e);
            }
        }
        finally {
            this.takeLock.unlock();
        }
        if (e != null) {
            this.signalNotFull();
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        E e = null;
        this.takeLock.lockInterruptibly();
        try {
            while (this.elementCount.get() == 0) {
                if (nanos <= 0L) {
                    E e2 = null;
                    return e2;
                }
                nanos = this.notEmpty.awaitNanos(nanos);
            }
            e = this.delegate.poll();
            if (e != null) {
                this.elementRemoved(e);
            }
        }
        finally {
            this.takeLock.unlock();
        }
        if (e != null) {
            this.signalNotFull();
        }
        return e;
    }

    @Override
    public E peek() {
        this.takeLock.lock();
        try {
            E e = this.delegate.peek();
            return e;
        }
        finally {
            this.takeLock.unlock();
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr(this.delegate.iterator());
    }

    private class Itr
    implements Iterator<E> {
        private final Iterator<E> delegate;
        private E lastReturned;

        Itr(Iterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            BytesBoundedLinkedQueue.this.fullyLock();
            try {
                boolean bl = this.delegate.hasNext();
                return bl;
            }
            finally {
                BytesBoundedLinkedQueue.this.fullyUnlock();
            }
        }

        @Override
        public E next() {
            BytesBoundedLinkedQueue.this.fullyLock();
            try {
                Object e = this.lastReturned = this.delegate.next();
                return e;
            }
            finally {
                BytesBoundedLinkedQueue.this.fullyUnlock();
            }
        }

        @Override
        public void remove() {
            BytesBoundedLinkedQueue.this.fullyLock();
            try {
                if (this.lastReturned == null) {
                    throw new IllegalStateException();
                }
                this.delegate.remove();
                BytesBoundedLinkedQueue.this.elementRemoved(this.lastReturned);
                BytesBoundedLinkedQueue.this.signalNotFull();
                this.lastReturned = null;
            }
            finally {
                BytesBoundedLinkedQueue.this.fullyUnlock();
            }
        }
    }
}

