/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mesos;

import java.util.Collection;
import org.apache.mesos.MesosNativeLibrary;
import org.apache.mesos.Protos;
import org.apache.mesos.Scheduler;
import org.apache.mesos.SchedulerDriver;

public class MesosSchedulerDriver
implements SchedulerDriver {
    private final Scheduler scheduler;
    private final Protos.FrameworkInfo framework;
    private final String master;
    private final Protos.Credential credential;
    private long __scheduler;
    private long __driver;

    public MesosSchedulerDriver(Scheduler scheduler, Protos.FrameworkInfo framework, String master) {
        if (scheduler == null) {
            throw new NullPointerException("Not expecting a null Scheduler");
        }
        if (framework == null) {
            throw new NullPointerException("Not expecting a null FrameworkInfo");
        }
        if (master == null) {
            throw new NullPointerException("Not expecting a null master");
        }
        this.scheduler = scheduler;
        this.framework = framework;
        this.master = master;
        this.credential = null;
        this.initialize();
    }

    public MesosSchedulerDriver(Scheduler scheduler, Protos.FrameworkInfo framework, String master, Protos.Credential credential) {
        if (scheduler == null) {
            throw new NullPointerException("Not expecting a null Scheduler");
        }
        if (framework == null) {
            throw new NullPointerException("Not expecting a null FrameworkInfo");
        }
        if (master == null) {
            throw new NullPointerException("Not expecting a null master");
        }
        if (credential == null) {
            throw new NullPointerException("Not expecting a null credential");
        }
        this.scheduler = scheduler;
        this.framework = framework;
        this.master = master;
        this.credential = credential;
        this.initialize();
    }

    @Override
    public native Protos.Status start();

    @Override
    public native Protos.Status stop(boolean var1);

    @Override
    public Protos.Status stop() {
        return this.stop(false);
    }

    @Override
    public native Protos.Status abort();

    @Override
    public native Protos.Status join();

    @Override
    public Protos.Status run() {
        Protos.Status status = this.start();
        return status != Protos.Status.DRIVER_RUNNING ? status : this.join();
    }

    @Override
    public native Protos.Status requestResources(Collection<Protos.Request> var1);

    @Override
    public Protos.Status launchTasks(Protos.OfferID offerId, Collection<Protos.TaskInfo> tasks) {
        return this.launchTasks(offerId, tasks, Protos.Filters.newBuilder().build());
    }

    @Override
    public native Protos.Status launchTasks(Protos.OfferID var1, Collection<Protos.TaskInfo> var2, Protos.Filters var3);

    @Override
    public Protos.Status launchTasks(Collection<Protos.OfferID> offerIds, Collection<Protos.TaskInfo> tasks) {
        return this.launchTasks(offerIds, tasks, Protos.Filters.newBuilder().build());
    }

    @Override
    public native Protos.Status launchTasks(Collection<Protos.OfferID> var1, Collection<Protos.TaskInfo> var2, Protos.Filters var3);

    @Override
    public native Protos.Status killTask(Protos.TaskID var1);

    @Override
    public Protos.Status declineOffer(Protos.OfferID offerId) {
        return this.declineOffer(offerId, Protos.Filters.newBuilder().build());
    }

    @Override
    public native Protos.Status declineOffer(Protos.OfferID var1, Protos.Filters var2);

    @Override
    public native Protos.Status reviveOffers();

    @Override
    public native Protos.Status sendFrameworkMessage(Protos.ExecutorID var1, Protos.SlaveID var2, byte[] var3);

    @Override
    public native Protos.Status reconcileTasks(Collection<Protos.TaskStatus> var1);

    protected native void initialize();

    protected native void finalize();

    static {
        MesosNativeLibrary.load();
    }
}

