/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.slideram;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.registry.client.binding.RegistryTypeUtils;
import org.apache.hadoop.registry.client.types.ServiceRecord;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.slider.common.SliderKeys;
import org.apache.slider.common.tools.ConfigHelper;
import org.apache.slider.common.tools.SliderFileSystem;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.conf.AggregateConf;
import org.apache.slider.core.conf.MapOperations;
import org.apache.slider.core.exceptions.BadCommandArgumentsException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.core.launch.ContainerLauncher;
import org.apache.slider.core.registry.docstore.PublishedConfiguration;
import org.apache.slider.providers.AbstractProviderService;
import org.apache.slider.providers.ProviderCore;
import org.apache.slider.providers.ProviderRole;
import org.apache.slider.providers.agent.AgentKeys;

public class SliderAMProviderService
extends AbstractProviderService
implements ProviderCore,
AgentKeys,
SliderKeys {
    public SliderAMProviderService() {
        super("SliderAMProviderService");
    }

    @Override
    public String getHumanName() {
        return "Slider Application";
    }

    @Override
    public Configuration loadProviderConfigurationInformation(File confDir) throws BadCommandArgumentsException, IOException {
        return null;
    }

    @Override
    public void buildContainerLaunchContext(ContainerLauncher containerLauncher, AggregateConf instanceDefinition, Container container, String role, SliderFileSystem sliderFileSystem, Path generatedConfPath, MapOperations resourceComponent, MapOperations appComponent, Path containerTmpDirPath) throws IOException, SliderException {
    }

    @Override
    public List<ProviderRole> getRoles() {
        return new ArrayList<ProviderRole>(0);
    }

    @Override
    public void validateInstanceDefinition(AggregateConf instanceDefinition) throws SliderException {
    }

    @Override
    public void applyInitialRegistryDefinitions(URL amWebURI, URL agentOpsURI, URL agentStatusURI, ServiceRecord serviceRecord) throws IOException {
        super.applyInitialRegistryDefinitions(amWebURI, agentOpsURI, agentStatusURI, serviceRecord);
        YarnConfiguration defaultYarnConfig = new YarnConfiguration();
        this.amState.getPublishedSliderConfigurations().put("complete-config", new PublishedConfiguration("Complete slider application settings", (Iterable<Map.Entry<String, String>>)this.getConfig(), this.getConfig()));
        this.amState.getPublishedSliderConfigurations().put("yarn-site", new PublishedConfiguration("YARN site settings", (Iterable<Map.Entry<String, String>>)ConfigHelper.loadFromResource("yarn-site.xml"), (Configuration)defaultYarnConfig));
        this.amState.getPublishedSliderConfigurations().put("core-site", new PublishedConfiguration("Core site settings", (Iterable<Map.Entry<String, String>>)ConfigHelper.loadFromResource("core-site.xml"), (Configuration)defaultYarnConfig));
        this.amState.getPublishedSliderConfigurations().put("hdfs-site", new PublishedConfiguration("HDFS site settings", (Iterable<Map.Entry<String, String>>)ConfigHelper.loadFromResource("hdfs-site.xml"), (Configuration)new HdfsConfiguration(true)));
        try {
            URL managementAPI = new URL(amWebURI, "ws/v1/slider/mgmt");
            URL registryREST = new URL(amWebURI, "ws/v1/slider/registry");
            URL publisherURL = new URL(amWebURI, "ws/v1/slider/publisher");
            String configurationsURL = SliderUtils.appendToURL(publisherURL.toExternalForm(), "slider");
            String exportsURL = SliderUtils.appendToURL(publisherURL.toExternalForm(), "exports");
            serviceRecord.addExternalEndpoint(RegistryTypeUtils.webEndpoint((String)"http://", (URI[])new URI[]{amWebURI.toURI()}));
            serviceRecord.addExternalEndpoint(RegistryTypeUtils.webEndpoint((String)"classpath:org.apache.slider.client.rest", (URI[])new URI[]{amWebURI.toURI()}));
            serviceRecord.addExternalEndpoint(RegistryTypeUtils.restEndpoint((String)"classpath:org.apache.slider.management", (URI[])new URI[]{managementAPI.toURI()}));
            serviceRecord.addExternalEndpoint(RegistryTypeUtils.restEndpoint((String)"classpath:org.apache.slider.publisher", (URI[])new URI[]{publisherURL.toURI()}));
            serviceRecord.addExternalEndpoint(RegistryTypeUtils.restEndpoint((String)"classpath:org.apache.slider.registry", (URI[])new URI[]{registryREST.toURI()}));
            serviceRecord.addExternalEndpoint(RegistryTypeUtils.restEndpoint((String)"classpath:org.apache.slider.publisher.configurations", (URI[])new URI[]{new URI(configurationsURL)}));
            serviceRecord.addExternalEndpoint(RegistryTypeUtils.restEndpoint((String)"classpath:org.apache.slider.publisher.exports", (URI[])new URI[]{new URI(exportsURL)}));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }
}

