/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slider.providers.agent.application.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.slider.common.tools.SliderUtils;
import org.apache.slider.core.exceptions.BadConfigException;
import org.apache.slider.core.exceptions.SliderException;
import org.apache.slider.providers.agent.application.metadata.AbstractComponent;
import org.apache.slider.providers.agent.application.metadata.ComponentCommand;
import org.apache.slider.providers.agent.application.metadata.ComponentExport;
import org.apache.slider.providers.agent.application.metadata.DockerContainer;
import org.apache.slider.providers.agent.application.metadata.Metainfo;
import org.codehaus.jackson.annotate.JsonProperty;

public class Component
extends AbstractComponent {
    String category = "MASTER";
    String publishConfig = Boolean.FALSE.toString();
    String minInstanceCount = "0";
    String maxInstanceCount;
    String autoStartOnFailure = Boolean.FALSE.toString();
    String appExports;
    String compExports;
    String type = "STANDARD";
    List<ComponentExport> componentExports = new ArrayList<ComponentExport>();
    List<DockerContainer> dockerContainers = new ArrayList<DockerContainer>();

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getPublishConfig() {
        return this.publishConfig;
    }

    public void setPublishConfig(String publishConfig) {
        this.publishConfig = publishConfig;
    }

    public String getAutoStartOnFailure() {
        return this.autoStartOnFailure;
    }

    public void setAutoStartOnFailure(String autoStartOnFailure) {
        this.autoStartOnFailure = autoStartOnFailure;
    }

    public String getAppExports() {
        return this.appExports;
    }

    public void setAppExports(String appExports) {
        this.appExports = appExports;
    }

    public String getCompExports() {
        return this.compExports;
    }

    public void setCompExports(String compExports) {
        this.compExports = compExports;
    }

    public String getMinInstanceCount() {
        return this.minInstanceCount;
    }

    @JsonProperty(value="dockerContainers")
    public List<DockerContainer> getDockerContainers() {
        return this.dockerContainers;
    }

    public Boolean getAutoStartOnFailureBoolean() {
        if (SliderUtils.isUnset(this.getAutoStartOnFailure())) {
            return Boolean.FALSE;
        }
        return Boolean.parseBoolean(this.getAutoStartOnFailure());
    }

    public int getMinInstanceCountInt() throws BadConfigException {
        if (SliderUtils.isUnset(this.minInstanceCount)) {
            return 0;
        }
        try {
            return Integer.parseInt(this.minInstanceCount);
        }
        catch (NumberFormatException nfe) {
            throw new BadConfigException(nfe, "Invalid value for minInstanceCount for %s", this.name);
        }
    }

    public int getMaxInstanceCountInt() throws BadConfigException {
        if (SliderUtils.isUnset(this.maxInstanceCount)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(this.maxInstanceCount);
        }
        catch (NumberFormatException nfe) {
            throw new BadConfigException(nfe, "Invalid value for maxInstanceCount for %s", this.name);
        }
    }

    public void setMinInstanceCount(String minInstanceCount) {
        this.minInstanceCount = minInstanceCount;
    }

    public String getMaxInstanceCount() {
        return this.maxInstanceCount;
    }

    public void setMaxInstanceCount(String maxInstanceCount) {
        this.maxInstanceCount = maxInstanceCount;
    }

    public void addComponentExport(ComponentExport export) {
        this.componentExports.add(export);
    }

    public List<ComponentExport> getComponentExports() {
        return this.componentExports;
    }

    public Boolean getRequiresAutoRestart() {
        return Boolean.parseBoolean(this.autoStartOnFailure);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\n\"name\": ").append(this.name);
        sb.append(",\n\"category\": ").append(this.category);
        sb.append(",\n\"commandScript\" :").append(this.commandScript);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void validate(String version) throws SliderException {
        Metainfo.checkNonNull(this.getName(), "name", "component");
        Metainfo.checkNonNull(this.getCategory(), "category", "component");
        if (!(this.getCategory().equals("MASTER") || this.getCategory().equals("SLAVE") || this.getCategory().equals("CLIENT"))) {
            throw new SliderException("Invalid category for the component " + this.getCategory());
        }
        Metainfo.checkNonNull(this.getType(), "type", "component");
        if (!this.getType().equals("DOCKER") && !this.getType().equals("STANDARD")) {
            throw new SliderException("Invalid type for the component " + this.getType());
        }
        if (version.equals(Metainfo.VERSION_TWO_ZERO)) {
            if (this.getType().equals("DOCKER")) {
                throw new SliderException("DOCKER is not supported in version " + Metainfo.VERSION_TWO_ZERO);
            }
            if (this.getCommands().size() > 0) {
                throw new SliderException("commands are not supported in version " + Metainfo.VERSION_TWO_ZERO);
            }
        }
        if (this.commandScript != null) {
            this.commandScript.validate(version);
        }
        if (version.equals(Metainfo.VERSION_TWO_ONE)) {
            for (ComponentCommand cc : this.getCommands()) {
                cc.validate(version);
            }
        }
    }
}

