/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.data;

import com.google.common.base.Supplier;
import com.google.common.primitives.Ints;
import com.metamx.common.IAE;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressionFactory;
import io.druid.segment.data.IndexedLongs;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.WritableByteChannel;

public class CompressedLongsIndexedSupplier
implements Supplier<IndexedLongs> {
    public static final byte LZF_VERSION = 1;
    public static final byte version = 2;
    private final int totalSize;
    private final int sizePer;
    private final ByteBuffer buffer;
    private final Supplier<IndexedLongs> supplier;
    private final CompressedObjectStrategy.CompressionStrategy compression;
    private final CompressionFactory.LongEncodingFormat encoding;

    CompressedLongsIndexedSupplier(int totalSize, int sizePer, ByteBuffer buffer, Supplier<IndexedLongs> supplier, CompressedObjectStrategy.CompressionStrategy compression, CompressionFactory.LongEncodingFormat encoding) {
        this.totalSize = totalSize;
        this.sizePer = sizePer;
        this.buffer = buffer;
        this.supplier = supplier;
        this.compression = compression;
        this.encoding = encoding;
    }

    public int size() {
        return this.totalSize;
    }

    public IndexedLongs get() {
        return (IndexedLongs)this.supplier.get();
    }

    public long getSerializedSize() {
        return this.buffer.remaining() + 1 + 4 + 4 + 1 + (this.encoding == CompressionFactory.LEGACY_LONG_ENCODING_FORMAT ? 0 : 1);
    }

    public void writeToChannel(WritableByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(new byte[]{2}));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.totalSize)));
        channel.write(ByteBuffer.wrap(Ints.toByteArray((int)this.sizePer)));
        if (this.encoding == CompressionFactory.LEGACY_LONG_ENCODING_FORMAT) {
            channel.write(ByteBuffer.wrap(new byte[]{this.compression.getId()}));
        } else {
            channel.write(ByteBuffer.wrap(new byte[]{CompressionFactory.setEncodingFlag(this.compression.getId())}));
            channel.write(ByteBuffer.wrap(new byte[]{this.encoding.getId()}));
        }
        channel.write(this.buffer.asReadOnlyBuffer());
    }

    public static CompressedLongsIndexedSupplier fromByteBuffer(ByteBuffer buffer, ByteOrder order) {
        byte versionFromBuffer = buffer.get();
        if (versionFromBuffer == 1 || versionFromBuffer == 2) {
            int totalSize = buffer.getInt();
            int sizePer = buffer.getInt();
            CompressedObjectStrategy.CompressionStrategy compression = CompressedObjectStrategy.CompressionStrategy.LZF;
            CompressionFactory.LongEncodingFormat encoding = CompressionFactory.LEGACY_LONG_ENCODING_FORMAT;
            if (versionFromBuffer == 2) {
                byte compressionId = buffer.get();
                if (CompressionFactory.hasEncodingFlag(compressionId)) {
                    encoding = CompressionFactory.LongEncodingFormat.forId(buffer.get());
                    compressionId = CompressionFactory.clearEncodingFlag(compressionId);
                }
                compression = CompressedObjectStrategy.CompressionStrategy.forId(compressionId);
            }
            Supplier<IndexedLongs> supplier = CompressionFactory.getLongSupplier(totalSize, sizePer, buffer.asReadOnlyBuffer(), order, encoding, compression);
            return new CompressedLongsIndexedSupplier(totalSize, sizePer, buffer, supplier, compression, encoding);
        }
        throw new IAE("Unknown version[%s]", new Object[]{versionFromBuffer});
    }
}

