/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment;

import com.google.common.base.Function;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closer;
import com.google.common.io.Files;
import com.metamx.collections.bitmap.BitmapFactory;
import com.metamx.collections.bitmap.ImmutableBitmap;
import com.metamx.collections.bitmap.MutableBitmap;
import com.metamx.collections.spatial.ImmutableRTree;
import com.metamx.collections.spatial.RTree;
import com.metamx.collections.spatial.split.LinearGutmanSplitStrategy;
import com.metamx.collections.spatial.split.SplitStrategy;
import com.metamx.common.ByteBufferUtils;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.collections.CombiningIterable;
import io.druid.segment.DimensionMergerV9;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.IndexSpec;
import io.druid.segment.IndexableAdapter;
import io.druid.segment.ProgressIndicator;
import io.druid.segment.column.ColumnCapabilities;
import io.druid.segment.column.ColumnDescriptor;
import io.druid.segment.column.ValueType;
import io.druid.segment.data.BitmapSerdeFactory;
import io.druid.segment.data.ByteBufferWriter;
import io.druid.segment.data.CompressedObjectStrategy;
import io.druid.segment.data.CompressedVSizeIndexedV3Writer;
import io.druid.segment.data.CompressedVSizeIntsIndexedWriter;
import io.druid.segment.data.GenericIndexed;
import io.druid.segment.data.GenericIndexedWriter;
import io.druid.segment.data.IOPeon;
import io.druid.segment.data.Indexed;
import io.druid.segment.data.IndexedInts;
import io.druid.segment.data.IndexedIntsWriter;
import io.druid.segment.data.IndexedRTree;
import io.druid.segment.data.ListIndexed;
import io.druid.segment.data.VSizeIndexedIntsWriter;
import io.druid.segment.data.VSizeIndexedWriter;
import io.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class StringDimensionMergerV9
implements DimensionMergerV9<int[]> {
    private static final Logger log = new Logger(StringDimensionMergerV9.class);
    protected static final ListIndexed EMPTY_STR_DIM_VAL = new ListIndexed<String>(Arrays.asList(""), String.class);
    protected static final int[] EMPTY_STR_DIM_ARRAY = new int[]{0};
    protected static final Splitter SPLITTER = Splitter.on((String)",");
    private IndexedIntsWriter encodedValueWriter;
    protected String dimensionName;
    protected GenericIndexedWriter<String> dictionaryWriter;
    protected GenericIndexedWriter<ImmutableBitmap> bitmapWriter;
    protected ByteBufferWriter<ImmutableRTree> spatialWriter;
    protected ArrayList<IntBuffer> dimConversions;
    protected int cardinality = 0;
    protected boolean convertMissingValues = false;
    protected boolean hasNull = false;
    protected MutableBitmap nullRowsBitmap;
    protected IOPeon ioPeon;
    protected int rowCount = 0;
    protected ColumnCapabilities capabilities;
    protected final File outDir;
    protected List<IndexableAdapter> adapters;
    protected ProgressIndicator progress;
    protected final IndexSpec indexSpec;

    public StringDimensionMergerV9(String dimensionName, IndexSpec indexSpec, File outDir, IOPeon ioPeon, ColumnCapabilities capabilities, ProgressIndicator progress) {
        this.dimensionName = dimensionName;
        this.indexSpec = indexSpec;
        this.capabilities = capabilities;
        this.outDir = outDir;
        this.ioPeon = ioPeon;
        this.progress = progress;
        this.nullRowsBitmap = indexSpec.getBitmapSerdeFactory().getBitmapFactory().makeEmptyMutableBitmap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeMergedValueMetadata(List<IndexableAdapter> adapters) throws IOException {
        boolean dimHasValues = false;
        boolean dimAbsentFromSomeIndex = false;
        long dimStartTime = System.currentTimeMillis();
        this.adapters = adapters;
        this.dimConversions = Lists.newArrayListWithCapacity((int)adapters.size());
        for (int i = 0; i < adapters.size(); ++i) {
            this.dimConversions.add(null);
        }
        int numMergeIndex = 0;
        Indexed<Object> dimValueLookup = null;
        Indexed[] dimValueLookups = new Indexed[adapters.size() + 1];
        for (int i = 0; i < adapters.size(); ++i) {
            Indexed<Comparable> dimValues = adapters.get(i).getDimValueLookup(this.dimensionName);
            if (!this.isNullColumn(dimValues)) {
                dimHasValues = true;
                this.hasNull |= dimValues.indexOf(null) >= 0;
                dimValueLookup = dimValues;
                dimValueLookups[i] = dimValueLookup;
                ++numMergeIndex;
                continue;
            }
            dimAbsentFromSomeIndex = true;
        }
        boolean bl = this.convertMissingValues = dimHasValues && dimAbsentFromSomeIndex;
        if (this.convertMissingValues && !this.hasNull) {
            this.hasNull = true;
            dimValueLookup = EMPTY_STR_DIM_VAL;
            dimValueLookups[adapters.size()] = dimValueLookup;
            ++numMergeIndex;
        }
        String dictFilename = String.format("%s.dim_values", this.dimensionName);
        this.dictionaryWriter = new GenericIndexedWriter<String>(this.ioPeon, dictFilename, GenericIndexed.STRING_STRATEGY);
        this.dictionaryWriter.open();
        this.cardinality = 0;
        if (numMergeIndex > 1) {
            void var11_12;
            IndexMerger.DictionaryMergeIterator iterator = new IndexMerger.DictionaryMergeIterator(dimValueLookups, true);
            while (iterator.hasNext()) {
                this.dictionaryWriter.write(iterator.next());
            }
            boolean bl2 = false;
            while (var11_12 < adapters.size()) {
                if (dimValueLookups[var11_12] != null && iterator.needConversion((int)var11_12)) {
                    this.dimConversions.set((int)var11_12, iterator.conversions[var11_12]);
                }
                ++var11_12;
            }
            this.cardinality = iterator.counter;
        } else if (numMergeIndex == 1) {
            for (String string : dimValueLookup) {
                this.dictionaryWriter.write(string);
            }
            this.cardinality = dimValueLookup.size();
        }
        log.info("Completed dim[%s] conversions with cardinality[%,d] in %,d millis.", new Object[]{this.dimensionName, this.cardinality, System.currentTimeMillis() - dimStartTime});
        this.dictionaryWriter.close();
        this.setupEncodedValueWriter();
    }

    protected void setupEncodedValueWriter() throws IOException {
        CompressedObjectStrategy.CompressionStrategy compressionStrategy = this.indexSpec.getDimensionCompression();
        String filenameBase = String.format("%s.forward_dim", this.dimensionName);
        this.encodedValueWriter = this.capabilities.hasMultipleValues() ? (compressionStrategy != CompressedObjectStrategy.CompressionStrategy.UNCOMPRESSED ? CompressedVSizeIndexedV3Writer.create(this.ioPeon, filenameBase, this.cardinality, compressionStrategy) : new VSizeIndexedWriter(this.ioPeon, filenameBase, this.cardinality)) : (compressionStrategy != CompressedObjectStrategy.CompressionStrategy.UNCOMPRESSED ? CompressedVSizeIntsIndexedWriter.create(this.ioPeon, filenameBase, this.cardinality, compressionStrategy) : new VSizeIndexedIntsWriter(this.ioPeon, filenameBase, this.cardinality));
        this.encodedValueWriter.open();
    }

    @Override
    public int[] convertSegmentRowValuesToMergedRowValues(int[] segmentRow, int segmentIndexNumber) {
        int[] dimVals = segmentRow;
        if (dimVals == null) {
            return (int[])(this.convertMissingValues ? EMPTY_STR_DIM_ARRAY : null);
        }
        int[] newDimVals = new int[dimVals.length];
        IntBuffer converter = this.dimConversions.get(segmentIndexNumber);
        for (int i = 0; i < dimVals.length; ++i) {
            newDimVals[i] = converter != null ? converter.get(dimVals[i]) : dimVals[i];
        }
        return newDimVals;
    }

    @Override
    public void processMergedRow(int[] rowValues) throws IOException {
        int[] vals = rowValues;
        if (vals == null || vals.length == 0) {
            this.nullRowsBitmap.add(this.rowCount);
        } else if (this.hasNull && vals.length == 1 && vals[0] == 0) {
            this.nullRowsBitmap.add(this.rowCount);
        }
        this.processMergedRowHelper(vals);
        ++this.rowCount;
    }

    protected void processMergedRowHelper(int[] vals) throws IOException {
        this.encodedValueWriter.add(vals);
    }

    @Override
    public void writeIndexes(List<IntBuffer> segmentRowNumConversions, Closer closer) throws IOException {
        long dimStartTime = System.currentTimeMillis();
        BitmapSerdeFactory bitmapSerdeFactory = this.indexSpec.getBitmapSerdeFactory();
        String bmpFilename = String.format("%s.inverted", this.dimensionName);
        this.bitmapWriter = new GenericIndexedWriter<ImmutableBitmap>(this.ioPeon, bmpFilename, this.indexSpec.getBitmapSerdeFactory().getObjectStrategy());
        this.bitmapWriter.open();
        File dimValueFile = IndexIO.makeDimFile(this.outDir, this.dimensionName);
        try (FileOutputStream fos = new FileOutputStream(dimValueFile);){
            ByteStreams.copy(this.dictionaryWriter.combineStreams(), (OutputStream)fos);
        }
        final MappedByteBuffer dimValsMapped = Files.map((File)dimValueFile);
        try (Closeable dimValsMappedUnmapper = new Closeable(){

            @Override
            public void close() {
                ByteBufferUtils.unmap((MappedByteBuffer)dimValsMapped);
            }
        };){
            GenericIndexed<String> dimVals = GenericIndexed.read(dimValsMapped, GenericIndexed.STRING_STRATEGY);
            BitmapFactory bmpFactory = bitmapSerdeFactory.getBitmapFactory();
            RTree tree = null;
            boolean hasSpatial = this.capabilities.hasSpatialIndexes();
            if (hasSpatial) {
                BitmapFactory bitmapFactory = this.indexSpec.getBitmapSerdeFactory().getBitmapFactory();
                this.spatialWriter = new ByteBufferWriter<ImmutableRTree>(this.ioPeon, String.format("%s.spatial", this.dimensionName), new IndexedRTree.ImmutableRTreeObjectStrategy(bitmapFactory));
                this.spatialWriter.open();
                tree = new RTree(2, (SplitStrategy)new LinearGutmanSplitStrategy(0, 50, bmpFactory), bmpFactory);
            }
            IndexSeeker[] dictIdSeeker = this.toIndexSeekers(this.adapters, this.dimConversions, this.dimensionName);
            for (int dictId = 0; dictId < dimVals.size(); ++dictId) {
                String dimVal;
                this.progress.progress();
                ArrayList convertedInverteds = Lists.newArrayListWithCapacity((int)this.adapters.size());
                for (int j = 0; j < this.adapters.size(); ++j) {
                    int seekedDictId = dictIdSeeker[j].seek(dictId);
                    if (seekedDictId == -1) continue;
                    convertedInverteds.add(new ConvertingIndexedInts(this.adapters.get(j).getBitmapIndex(this.dimensionName, seekedDictId), segmentRowNumConversions.get(j)));
                }
                MutableBitmap bitset = bmpFactory.makeEmptyMutableBitmap();
                for (Integer row : CombiningIterable.createSplatted((Iterable)convertedInverteds, (Comparator)Ordering.natural().nullsFirst())) {
                    if (row == -1) continue;
                    bitset.add(row.intValue());
                }
                ImmutableBitmap bitmapToWrite = bitmapSerdeFactory.getBitmapFactory().makeImmutableBitmap(bitset);
                if (dictId == 0 && Iterables.getFirst(dimVals, (Object)"") == null) {
                    bitmapToWrite = bmpFactory.makeImmutableBitmap(this.nullRowsBitmap).union(bitmapToWrite);
                }
                this.bitmapWriter.write(bitmapToWrite);
                if (!hasSpatial || (dimVal = (String)dimVals.get(dictId)) == null) continue;
                ArrayList stringCoords = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)dimVal));
                float[] coords = new float[stringCoords.size()];
                for (int j = 0; j < coords.length; ++j) {
                    coords[j] = Float.valueOf((String)stringCoords.get(j)).floatValue();
                }
                tree.insert(coords, bitset);
            }
            if (hasSpatial) {
                this.spatialWriter.write(ImmutableRTree.newImmutableFromMutable(tree));
                this.spatialWriter.close();
            }
            log.info("Completed dim[%s] inverted with cardinality[%,d] in %,d millis.", new Object[]{this.dimensionName, dimVals.size(), System.currentTimeMillis() - dimStartTime});
        }
        this.bitmapWriter.close();
        this.encodedValueWriter.close();
    }

    @Override
    public boolean canSkip() {
        return this.cardinality == 0;
    }

    @Override
    public ColumnDescriptor makeColumnDescriptor() {
        boolean hasMultiValue = this.capabilities.hasMultipleValues();
        CompressedObjectStrategy.CompressionStrategy compressionStrategy = this.indexSpec.getDimensionCompression();
        BitmapSerdeFactory bitmapSerdeFactory = this.indexSpec.getBitmapSerdeFactory();
        ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
        builder.setValueType(ValueType.STRING);
        builder.setHasMultipleValues(hasMultiValue);
        DictionaryEncodedColumnPartSerde.SerializerBuilder partBuilder = DictionaryEncodedColumnPartSerde.serializerBuilder().withDictionary(this.dictionaryWriter).withValue(this.encodedValueWriter, hasMultiValue, compressionStrategy != CompressedObjectStrategy.CompressionStrategy.UNCOMPRESSED).withBitmapSerdeFactory(bitmapSerdeFactory).withBitmapIndex(this.bitmapWriter).withSpatialIndex(this.spatialWriter).withByteOrder(IndexIO.BYTE_ORDER);
        ColumnDescriptor serdeficator = builder.addSerde(partBuilder.build()).build();
        return serdeficator;
    }

    protected IndexSeeker[] toIndexSeekers(List<IndexableAdapter> adapters, ArrayList<IntBuffer> dimConversions, String dimension) {
        IndexSeeker[] seekers = new IndexSeeker[adapters.size()];
        for (int i = 0; i < adapters.size(); ++i) {
            Indexed<Comparable> dimValueLookup;
            IntBuffer dimConversion = dimConversions.get(i);
            seekers[i] = dimConversion != null ? new IndexSeekerWithConversion((IntBuffer)dimConversion.asReadOnlyBuffer().rewind()) : new IndexSeekerWithoutConversion((dimValueLookup = adapters.get(i).getDimValueLookup(dimension)) == null ? 0 : dimValueLookup.size());
        }
        return seekers;
    }

    protected boolean isNullColumn(Iterable<String> dimValues) {
        if (dimValues == null) {
            return true;
        }
        for (String val : dimValues) {
            if (val == null) continue;
            return false;
        }
        return true;
    }

    public static class ConvertingIndexedInts
    implements Iterable<Integer> {
        private final IndexedInts baseIndex;
        private final IntBuffer conversionBuffer;

        public ConvertingIndexedInts(IndexedInts baseIndex, IntBuffer conversionBuffer) {
            this.baseIndex = baseIndex;
            this.conversionBuffer = conversionBuffer;
        }

        public int size() {
            return this.baseIndex.size();
        }

        public int get(int index) {
            return this.conversionBuffer.get(this.baseIndex.get(index));
        }

        @Override
        public Iterator<Integer> iterator() {
            return Iterators.transform(this.baseIndex.iterator(), (Function)new Function<Integer, Integer>(){

                public Integer apply(@Nullable Integer input) {
                    return ConvertingIndexedInts.this.conversionBuffer.get(input);
                }
            });
        }
    }

    protected class IndexSeekerWithConversion
    implements IndexSeeker {
        private final IntBuffer dimConversions;
        private int currIndex;
        private int currVal;
        private int lastVal;

        IndexSeekerWithConversion(IntBuffer dimConversions) {
            this.dimConversions = dimConversions;
            this.currIndex = 0;
            this.currVal = -1;
            this.lastVal = -1;
        }

        @Override
        public int seek(int dictId) {
            if (this.dimConversions == null) {
                return -1;
            }
            if (this.lastVal != -1) {
                if (dictId <= this.lastVal) {
                    throw new ISE("Value dictId[%d] is less than the last value dictId[%d] I have, cannot be.", new Object[]{dictId, this.lastVal});
                }
                return -1;
            }
            if (this.currVal == -1) {
                this.currVal = this.dimConversions.get();
            }
            if (this.currVal == dictId) {
                int ret = this.currIndex++;
                if (this.dimConversions.hasRemaining()) {
                    this.currVal = this.dimConversions.get();
                } else {
                    this.lastVal = dictId;
                }
                return ret;
            }
            if (this.currVal < dictId) {
                throw new ISE("Skipped currValue dictId[%d], currIndex[%d]; incoming value dictId[%d]", new Object[]{this.currVal, this.currIndex, dictId});
            }
            return -1;
        }
    }

    protected class IndexSeekerWithoutConversion
    implements IndexSeeker {
        private final int limit;

        public IndexSeekerWithoutConversion(int limit) {
            this.limit = limit;
        }

        @Override
        public int seek(int dictId) {
            return dictId < this.limit ? dictId : -1;
        }
    }

    protected static interface IndexSeeker {
        public static final int NOT_EXIST = -1;
        public static final int NOT_INIT = -1;

        public int seek(int var1);
    }
}

