/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.servlet;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.hive.service.cli.operation.SQLOperationDisplay;
import org.apache.hive.service.cli.session.SessionManager;
import org.apache.hive.tmpl.QueryProfileTmpl;

public class QueryProfileServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(QueryProfileServlet.class);

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String opId = request.getParameter("operationId");
        ServletContext ctx = this.getServletContext();
        SessionManager sessionManager = (SessionManager)ctx.getAttribute("hive.sm");
        OperationManager opManager = sessionManager.getOperationManager();
        SQLOperationDisplay sod = opManager.getSQLOperationDisplay(opId);
        if (sod == null) {
            LOG.debug("No display object found for operation {} ", (Object)opId);
            return;
        }
        new QueryProfileTmpl().render(response.getWriter(), sod);
    }
}

