/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hive.com.google.common.base.Joiner;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.filter.AbstractFilter;
import org.apache.logging.log4j.core.layout.PatternLayout;

public class LogDivertAppender
extends AbstractOutputStreamAppender<StringOutputStreamManager> {
    private static final Logger LOG = LoggerFactory.getLogger(LogDivertAppender.class.getName());
    private static LoggerContext context = (LoggerContext)LogManager.getContext(false);
    private static Configuration configuration = context.getConfiguration();
    public static final Layout<? extends Serializable> verboseLayout = PatternLayout.createLayout("%d{yy/MM/dd HH:mm:ss} %p %c{2}: %m%n", null, configuration, null, null, true, false, null, null);
    public static final Layout<? extends Serializable> nonVerboseLayout = PatternLayout.createLayout("%-5p : %m%n", null, configuration, null, null, true, false, null, null);
    private final OperationManager operationManager;
    private final StringOutputStreamManager manager;
    private boolean isVerbose;
    private final Layout<? extends Serializable> layout;

    protected LogDivertAppender(String name, Filter filter, StringOutputStreamManager manager, OperationManager operationManager, OperationLog.LoggingLevel loggingMode) {
        super(name, null, filter, false, true, manager);
        this.operationManager = operationManager;
        this.manager = manager;
        this.isVerbose = loggingMode == OperationLog.LoggingLevel.VERBOSE;
        this.layout = this.getDefaultLayout();
    }

    public Layout<? extends Serializable> getDefaultLayout() {
        org.apache.logging.log4j.Logger root = LogManager.getRootLogger();
        Layout<? extends Serializable> layout = null;
        for (Appender ap : ((org.apache.logging.log4j.core.Logger)root).getAppenders().values()) {
            if (!ap.getClass().equals(ConsoleAppender.class)) continue;
            layout = ap.getLayout();
            break;
        }
        return layout;
    }

    public static LogDivertAppender createInstance(OperationManager operationManager, OperationLog.LoggingLevel loggingMode) {
        return new LogDivertAppender("LogDivertAppender", new NameFilter(loggingMode, operationManager), new StringOutputStreamManager(new ByteArrayOutputStream(), "StringStream", null), operationManager, loggingMode);
    }

    public String getOutput() {
        return new String(this.manager.getStream().toByteArray());
    }

    @Override
    public void start() {
        super.start();
    }

    @Override
    public Layout<? extends Serializable> getLayout() {
        OperationLog log = this.operationManager.getOperationLogByThread();
        if (log != null) {
            boolean bl = this.isVerbose = log.getOpLoggingLevel() == OperationLog.LoggingLevel.VERBOSE;
        }
        if (this.isVerbose) {
            return verboseLayout;
        }
        return this.layout == null ? nonVerboseLayout : this.layout;
    }

    @Override
    public void append(LogEvent event) {
        super.append(event);
        String logOutput = this.getOutput();
        this.manager.reset();
        OperationLog log = this.operationManager.getOperationLogByThread();
        if (log == null) {
            LOG.debug(" ---+++=== Dropped log event from thread " + event.getThreadName());
            return;
        }
        log.writeOperationLog(logOutput);
    }

    static /* synthetic */ Logger access$000() {
        return LOG;
    }

    protected static class StringOutputStreamManager
    extends OutputStreamManager {
        ByteArrayOutputStream stream;

        protected StringOutputStreamManager(ByteArrayOutputStream os, String streamName, Layout<?> layout) {
            super(os, streamName, layout, true);
            this.stream = os;
        }

        public ByteArrayOutputStream getStream() {
            return this.stream;
        }

        public void reset() {
            this.stream.reset();
        }
    }

    private static class NameFilter
    extends AbstractFilter {
        private Pattern namePattern;
        private OperationLog.LoggingLevel loggingMode;
        private final OperationManager operationManager;
        private static final Pattern verboseExcludeNamePattern = Pattern.compile(Joiner.on("|").join(new String[]{LogDivertAppender.access$000().getName(), OperationLog.class.getName(), OperationManager.class.getName()}));
        private static final Pattern executionIncludeNamePattern = Pattern.compile(Joiner.on("|").join(new String[]{"org.apache.hadoop.mapreduce.JobSubmitter", "org.apache.hadoop.mapreduce.Job", "SessionState", Task.class.getName(), Driver.class.getName(), "org.apache.hadoop.hive.ql.exec.spark.status.SparkJobMonitor"}));
        private static final Pattern performanceIncludeNamePattern = Pattern.compile(executionIncludeNamePattern.pattern() + "|" + PerfLogger.class.getName());

        private void setCurrentNamePattern(OperationLog.LoggingLevel mode) {
            if (mode == OperationLog.LoggingLevel.VERBOSE) {
                this.namePattern = verboseExcludeNamePattern;
            } else if (mode == OperationLog.LoggingLevel.EXECUTION) {
                this.namePattern = executionIncludeNamePattern;
            } else if (mode == OperationLog.LoggingLevel.PERFORMANCE) {
                this.namePattern = performanceIncludeNamePattern;
            }
        }

        public NameFilter(OperationLog.LoggingLevel loggingMode, OperationManager op) {
            this.operationManager = op;
            this.loggingMode = loggingMode;
            this.setCurrentNamePattern(loggingMode);
        }

        @Override
        public Filter.Result filter(LogEvent event) {
            boolean isMatch;
            boolean excludeMatches;
            OperationLog log = this.operationManager.getOperationLogByThread();
            boolean bl = excludeMatches = this.loggingMode == OperationLog.LoggingLevel.VERBOSE;
            if (log == null) {
                return Filter.Result.DENY;
            }
            OperationLog.LoggingLevel currentLoggingMode = log.getOpLoggingLevel();
            if (currentLoggingMode == OperationLog.LoggingLevel.NONE) {
                return Filter.Result.DENY;
            }
            if (currentLoggingMode != this.loggingMode) {
                this.loggingMode = currentLoggingMode;
                excludeMatches = this.loggingMode == OperationLog.LoggingLevel.VERBOSE;
                this.setCurrentNamePattern(this.loggingMode);
            }
            if (excludeMatches == (isMatch = this.namePattern.matcher(event.getLoggerName()).matches())) {
                return Filter.Result.DENY;
            }
            return Filter.Result.NEUTRAL;
        }
    }
}

