/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hive.com.google.common.collect.ArrayListMultimap;
import org.apache.hive.com.google.common.collect.Iterables;
import org.apache.hive.com.google.common.collect.Multimap;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.hive.service.cli.operation.TableTypeMapping;

public class ClassicTableTypeMapping
implements TableTypeMapping {
    private static final Logger LOG = LoggerFactory.getLogger(ClassicTableTypeMapping.class);
    private final Map<String, String> hiveToClientMap = new HashMap<String, String>();
    private final Multimap<String, String> clientToHiveMap = ArrayListMultimap.create();

    public ClassicTableTypeMapping() {
        this.hiveToClientMap.put(TableType.MANAGED_TABLE.name(), ClassicTableTypes.TABLE.name());
        this.hiveToClientMap.put(TableType.EXTERNAL_TABLE.name(), ClassicTableTypes.TABLE.name());
        this.hiveToClientMap.put(TableType.VIRTUAL_VIEW.name(), ClassicTableTypes.VIEW.name());
        this.hiveToClientMap.put(TableType.MATERIALIZED_VIEW.toString(), ClassicTableTypes.MATERIALIZED_VIEW.toString());
        this.clientToHiveMap.putAll(ClassicTableTypes.TABLE.name(), Arrays.asList(TableType.MANAGED_TABLE.name(), TableType.EXTERNAL_TABLE.name()));
        this.clientToHiveMap.put(ClassicTableTypes.VIEW.name(), TableType.VIRTUAL_VIEW.name());
        this.clientToHiveMap.put(ClassicTableTypes.MATERIALIZED_VIEW.toString(), TableType.MATERIALIZED_VIEW.toString());
    }

    @Override
    public String[] mapToHiveType(String clientTypeName) {
        Collection<String> hiveTableType = this.clientToHiveMap.get(clientTypeName.toUpperCase());
        if (hiveTableType == null) {
            LOG.warn("Not supported client table type " + clientTypeName);
            return new String[]{clientTypeName};
        }
        return Iterables.toArray(hiveTableType, String.class);
    }

    @Override
    public String mapToClientType(String hiveTypeName) {
        String clientTypeName = this.hiveToClientMap.get(hiveTypeName);
        if (clientTypeName == null) {
            LOG.warn("Invalid hive table type " + hiveTypeName);
            return hiveTypeName;
        }
        return clientTypeName;
    }

    @Override
    public Set<String> getTableTypeNames() {
        HashSet<String> typeNameSet = new HashSet<String>();
        for (ClassicTableTypes typeNames : ClassicTableTypes.values()) {
            typeNameSet.add(typeNames.name());
        }
        return typeNameSet;
    }

    public static enum ClassicTableTypes {
        TABLE,
        VIEW,
        MATERIALIZED_VIEW;

    }
}

