/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.auth.ldap;

import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.security.sasl.AuthenticationException;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.hive.service.auth.ldap.DirSearchFactory;
import org.apache.hive.service.auth.ldap.LdapSearch;

public final class LdapSearchFactory
implements DirSearchFactory {
    private static final Logger LOG = LoggerFactory.getLogger(LdapSearchFactory.class);

    @Override
    public DirSearch getInstance(HiveConf conf, String principal, String password) throws AuthenticationException {
        try {
            DirContext ctx = LdapSearchFactory.createDirContext(conf, principal, password);
            return new LdapSearch(conf, ctx);
        }
        catch (NamingException e) {
            LOG.debug("Could not connect to the LDAP Server:Authentication failed for {}", (Object)principal);
            throw new AuthenticationException("Error validating LDAP user", e);
        }
    }

    private static DirContext createDirContext(HiveConf conf, String principal, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        String ldapUrl = conf.getVar(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_URL);
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapUrl);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.principal", principal);
        LOG.debug("Connecting using principal {} to ldap url {}", (Object)principal, (Object)ldapUrl);
        return new InitialDirContext(env);
    }
}

