/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.jamon.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationReflector {
    private Map<String, Annotation> m_annotations = new HashMap<String, Annotation>();

    public AnnotationReflector(Class<?> p_class) {
        for (Annotation annotation : p_class.getAnnotations()) {
            this.m_annotations.put(annotation.annotationType().getName(), annotation);
        }
    }

    public <T extends Annotation> T getAnnotation(Class<T> p_class) {
        Annotation annotation = this.m_annotations.get(p_class.getName());
        return (T)((Annotation)p_class.cast(this.proxyAnnotation(p_class, annotation)));
    }

    private Object proxyAnnotation(Class<?> p_class, final Object p_annotation) {
        return p_class.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{p_class}, new InvocationHandler(){

            public Object invoke(Object p_proxy, Method p_method, Object[] p_args) throws Throwable {
                Object result = p_annotation.getClass().getMethod(p_method.getName(), new Class[0]).invoke(p_annotation, new Object[0]);
                return AnnotationReflector.this.maybeProxyAnnotation(p_method.getReturnType(), result);
            }
        }));
    }

    private Object maybeProxyAnnotation(Class<?> p_type, Object p_object) {
        if (p_object == null) {
            return null;
        }
        if (p_type.isAnnotation()) {
            return this.proxyAnnotation(p_type, p_object);
        }
        if (p_type.isArray() && p_type.getComponentType().isAnnotation()) {
            int arrayLength = Array.getLength(p_object);
            Object array = Array.newInstance(p_type.getComponentType(), arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                Array.set(array, i, this.proxyAnnotation(p_type.getComponentType(), Array.get(p_object, i)));
            }
            return array;
        }
        return p_object;
    }
}

