/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.log4j.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationFactory;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.builder.api.AppenderComponentBuilder;
import org.apache.logging.log4j.core.config.builder.api.ConfigurationBuilder;
import org.apache.logging.log4j.core.config.builder.api.LayoutComponentBuilder;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.status.StatusLogger;

public class Log4j1ConfigurationFactory
extends ConfigurationFactory {
    private Map<String, String> buildClassToPropertyPrefixMap(Properties properties, String[] sortedAppenderNames) {
        String prefix = "log4j.appender.";
        int preLength = "log4j.appender.".length();
        HashMap<String, String> map = new HashMap<String, String>(sortedAppenderNames.length);
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Object value;
            String name;
            String key;
            Object keyObj = entry.getKey();
            if (keyObj == null || !(key = keyObj.toString()).startsWith("log4j.appender.") || key.indexOf(46, preLength) >= 0 || Arrays.binarySearch(sortedAppenderNames, name = key.substring(preLength)) < 0 || (value = entry.getValue()) == null) continue;
            map.put(name, value.toString());
        }
        return map;
    }

    private void buildConsoleAppender(Properties properties, String name, ConfigurationBuilder<BuiltConfiguration> builder) {
        AppenderComponentBuilder appenderBuilder = builder.newAppender(name, "CONSOLE");
        this.buildConsoleAppenderTarget(properties, name, builder, appenderBuilder);
        this.buildAppenderLayout(properties, name, builder, appenderBuilder);
        this.buildConsoleAppenderFollow(properties, name, builder, appenderBuilder);
        builder.add(appenderBuilder);
    }

    private void buildAppenderLayout(Properties properties, String name, ConfigurationBuilder<BuiltConfiguration> builder, AppenderComponentBuilder appenderBuilder) {
        String layoutValue = this.getLog4jAppenderValue(properties, name, "layout", null);
        if (layoutValue != null) {
            String cpValue = this.getLog4jAppenderValue(properties, name, "layout.ConversionPattern", null);
            switch (layoutValue) {
                case "org.apache.hive.org.apache.log4j.PatternLayout": {
                    appenderBuilder.add(this.newPatternLayout(builder, cpValue));
                    break;
                }
                case "org.apache.hive.org.apache.log4j.EnhancedPatternLayout": {
                    appenderBuilder.add(this.newPatternLayout(builder, cpValue));
                    break;
                }
                case "org.apache.hive.org.apache.log4j.SimpleLayout": {
                    appenderBuilder.add(this.newPatternLayout(builder, "%level - %m%n"));
                    break;
                }
                case "org.apache.hive.org.apache.log4j.TTCCLayout": {
                    appenderBuilder.add(this.newPatternLayout(builder, "%relative [%threadName] %level %logger - %m%n"));
                    break;
                }
                case "org.apache.hive.org.apache.log4j.HTMLLayout": {
                    appenderBuilder.add(builder.newLayout("HtmlLayout"));
                    break;
                }
                case "org.apache.hive.org.apache.log4j.XMLLayout": {
                    appenderBuilder.add(builder.newLayout("XmlLayout"));
                    break;
                }
                default: {
                    this.reportWarning("Unsupported value for console appender layout: " + layoutValue);
                }
            }
        }
    }

    private LayoutComponentBuilder newPatternLayout(ConfigurationBuilder<BuiltConfiguration> builder, String pattern) {
        LayoutComponentBuilder layoutBuilder = builder.newLayout("PatternLayout");
        if (pattern != null) {
            layoutBuilder.addAttribute("pattern", pattern);
        }
        return layoutBuilder;
    }

    private void buildConsoleAppenderTarget(Properties properties, String name, ConfigurationBuilder<BuiltConfiguration> builder, AppenderComponentBuilder appenderBuilder) {
        String value = this.getLog4jAppenderValue(properties, name, "Target", "System.out");
        if (value != null) {
            ConsoleAppender.Target target;
            switch (value) {
                case "System.out": {
                    target = ConsoleAppender.Target.SYSTEM_OUT;
                    break;
                }
                case "System.err": {
                    target = ConsoleAppender.Target.SYSTEM_ERR;
                    break;
                }
                default: {
                    this.reportWarning("Unknow value for console Target: " + value);
                    target = null;
                }
            }
            if (target != null) {
                appenderBuilder.addAttribute("target", target);
            }
        }
    }

    private void buildConsoleAppenderFollow(Properties properties, String name, ConfigurationBuilder<BuiltConfiguration> builder, AppenderComponentBuilder appenderBuilder) {
        String value = this.getLog4jAppenderValue(properties, name, "Follow", "false");
        if (value != null) {
            appenderBuilder.addAttribute("follow", Boolean.valueOf(value));
        }
    }

    Configuration createConfiguration(String configName, URI configLocation, ConfigurationBuilder<BuiltConfiguration> builder) throws IOException {
        builder.setConfigurationName(configName);
        Properties properties = this.load(configLocation);
        if (properties == null) {
            return null;
        }
        String debugValue = this.getLog4jValue(properties, "debug");
        if (Boolean.valueOf(debugValue).booleanValue()) {
            builder.setStatusLevel(Level.DEBUG);
        }
        String[] sortedAppenderNamesC = this.buildRootLogger(builder, this.getRootCategoryValue(properties));
        String[] sortedAppenderNamesL = this.buildRootLogger(builder, this.getRootLoggerValue(properties));
        String[] sortedAppenderNames = sortedAppenderNamesL.length > 0 ? sortedAppenderNamesL : sortedAppenderNamesC;
        Map<String, String> classNameToProperty = this.buildClassToPropertyPrefixMap(properties, sortedAppenderNames);
        block6: for (Map.Entry<String, String> entry : classNameToProperty.entrySet()) {
            String appenderName = entry.getKey();
            switch (entry.getValue()) {
                case "org.apache.hive.org.apache.log4j.ConsoleAppender": {
                    this.buildConsoleAppender(properties, appenderName, builder);
                    continue block6;
                }
            }
            this.reportWarning("Ignoring appender " + appenderName + "; consider porting your configuration file to the current Log4j format.");
        }
        this.buildLoggers(properties, "log4j.category.", builder);
        this.buildLoggers(properties, "log4j.logger.", builder);
        return (Configuration)builder.build();
    }

    private String[] buildRootLogger(ConfigurationBuilder<BuiltConfiguration> builder, String rootLoggerValue) {
        if (rootLoggerValue == null) {
            return new String[0];
        }
        String[] rootLoggerParts = rootLoggerValue.split("\\s*,\\s*");
        Level rootLoggerLevel = rootLoggerParts.length > 0 ? Level.valueOf(rootLoggerParts[0]) : Level.ERROR;
        builder.add(builder.newRootLogger(rootLoggerLevel));
        Object[] sortedAppenderNames = Arrays.copyOfRange(rootLoggerParts, 1, rootLoggerParts.length);
        Arrays.sort(sortedAppenderNames);
        return sortedAppenderNames;
    }

    private void buildLoggers(Properties properties, String prefix, ConfigurationBuilder<BuiltConfiguration> builder) {
        int preLength = prefix.length();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key;
            Object keyObj = entry.getKey();
            if (keyObj == null || !(key = keyObj.toString()).startsWith(prefix)) continue;
            String name = key.substring(preLength);
            Object value = entry.getValue();
            if (value == null) continue;
            builder.add(builder.newLogger(name, Level.valueOf(value.toString())));
        }
    }

    @Override
    public Configuration getConfiguration(ConfigurationSource source) {
        return this.getConfiguration(source.toString(), null);
    }

    @Override
    public Configuration getConfiguration(String name, URI configLocation) {
        try {
            return this.createConfiguration(name, configLocation, Log4j1ConfigurationFactory.newConfigurationBuilder());
        }
        catch (IOException e) {
            StatusLogger.getLogger().error(e);
            return null;
        }
    }

    private String getLog4jAppenderValue(Properties properties, String appenderName, String attributeName, String defaultValue) {
        return properties.getProperty("log4j.appender." + appenderName + "." + attributeName, defaultValue);
    }

    private String getLog4jValue(Properties properties, String key) {
        return properties.getProperty("log4j." + key);
    }

    private String getRootCategoryValue(Properties properties) {
        return this.getLog4jValue(properties, "rootCategory");
    }

    private String getRootLoggerValue(Properties properties) {
        return this.getLog4jValue(properties, "rootLogger");
    }

    @Override
    protected String[] getSupportedTypes() {
        return new String[]{"*.properties", ".xml"};
    }

    private Properties load(URI uri) throws IOException {
        Properties properties = this.toProperties(uri);
        String rootCategoryValue = this.getRootCategoryValue(properties);
        String rootLoggerValue = this.getRootLoggerValue(properties);
        if (rootCategoryValue == null && rootLoggerValue == null) {
            return null;
        }
        return properties;
    }

    private void reportWarning(String msg) {
        StatusLogger.getLogger().warn("Log4j version 1 to 2 configuration bridge: " + msg);
    }

    private Properties toProperties(URI uri) throws IOException {
        Properties properties;
        try (InputStream in = uri.toURL().openStream();){
            properties = new Properties();
            if (uri.toString().endsWith(".xml")) {
                properties.loadFromXML(in);
            } else {
                properties.load(in);
            }
        }
        return properties;
    }
}

