/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.org.apache.commons.math.ode;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.hive.org.apache.commons.math.ConvergenceException;
import org.apache.hive.org.apache.commons.math.MaxEvaluationsExceededException;
import org.apache.hive.org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.hive.org.apache.commons.math.ode.DerivativeException;
import org.apache.hive.org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.hive.org.apache.commons.math.ode.FirstOrderIntegrator;
import org.apache.hive.org.apache.commons.math.ode.IntegratorException;
import org.apache.hive.org.apache.commons.math.ode.events.CombinedEventsManager;
import org.apache.hive.org.apache.commons.math.ode.events.EventException;
import org.apache.hive.org.apache.commons.math.ode.events.EventHandler;
import org.apache.hive.org.apache.commons.math.ode.events.EventState;
import org.apache.hive.org.apache.commons.math.ode.sampling.AbstractStepInterpolator;
import org.apache.hive.org.apache.commons.math.ode.sampling.StepHandler;
import org.apache.hive.org.apache.commons.math.util.FastMath;
import org.apache.hive.org.apache.commons.math.util.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIntegrator
implements FirstOrderIntegrator {
    protected Collection<StepHandler> stepHandlers;
    protected double stepStart;
    protected double stepSize;
    protected boolean isLastStep;
    protected boolean resetOccurred;
    private Collection<EventState> eventsStates;
    private boolean statesInitialized;
    private final String name;
    private int maxEvaluations;
    private int evaluations;
    private transient FirstOrderDifferentialEquations equations;

    public AbstractIntegrator(String name) {
        this.name = name;
        this.stepHandlers = new ArrayList<StepHandler>();
        this.stepStart = Double.NaN;
        this.stepSize = Double.NaN;
        this.eventsStates = new ArrayList<EventState>();
        this.statesInitialized = false;
        this.setMaxEvaluations(-1);
        this.resetEvaluations();
    }

    protected AbstractIntegrator() {
        this(null);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addStepHandler(StepHandler handler) {
        this.stepHandlers.add(handler);
    }

    @Override
    public Collection<StepHandler> getStepHandlers() {
        return Collections.unmodifiableCollection(this.stepHandlers);
    }

    @Override
    public void clearStepHandlers() {
        this.stepHandlers.clear();
    }

    @Override
    public void addEventHandler(EventHandler handler, double maxCheckInterval, double convergence, int maxIterationCount) {
        this.eventsStates.add(new EventState(handler, maxCheckInterval, convergence, maxIterationCount));
    }

    @Override
    public Collection<EventHandler> getEventHandlers() {
        ArrayList<EventHandler> list = new ArrayList<EventHandler>();
        for (EventState state : this.eventsStates) {
            list.add(state.getEventHandler());
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public void clearEventHandlers() {
        this.eventsStates.clear();
    }

    protected boolean requiresDenseOutput() {
        if (!this.eventsStates.isEmpty()) {
            return true;
        }
        for (StepHandler handler : this.stepHandlers) {
            if (!handler.requiresDenseOutput()) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getCurrentStepStart() {
        return this.stepStart;
    }

    @Override
    public double getCurrentSignedStepsize() {
        return this.stepSize;
    }

    @Override
    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations < 0 ? Integer.MAX_VALUE : maxEvaluations;
    }

    @Override
    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    @Override
    public int getEvaluations() {
        return this.evaluations;
    }

    protected void resetEvaluations() {
        this.evaluations = 0;
    }

    protected void setEquations(FirstOrderDifferentialEquations equations) {
        this.equations = equations;
    }

    public void computeDerivatives(double t, double[] y, double[] yDot) throws DerivativeException {
        if (++this.evaluations > this.maxEvaluations) {
            throw new DerivativeException(new MaxEvaluationsExceededException(this.maxEvaluations));
        }
        this.equations.computeDerivatives(t, y, yDot);
    }

    protected void setStateInitialized(boolean stateInitialized) {
        this.statesInitialized = stateInitialized;
    }

    protected double acceptStep(AbstractStepInterpolator interpolator, double[] y, double[] yDot, double tEnd) throws DerivativeException, IntegratorException {
        try {
            double previousT = interpolator.getGlobalPreviousTime();
            double currentT = interpolator.getGlobalCurrentTime();
            this.resetOccurred = false;
            if (!this.statesInitialized) {
                for (EventState state : this.eventsStates) {
                    state.reinitializeBegin(interpolator);
                }
                this.statesInitialized = true;
            }
            final int orderingSign = interpolator.isForward() ? 1 : -1;
            TreeSet<EventState> occuringEvents = new TreeSet<EventState>(new Comparator<EventState>(){

                @Override
                public int compare(EventState es0, EventState es1) {
                    return orderingSign * Double.compare(es0.getEventTime(), es1.getEventTime());
                }
            });
            for (EventState state : this.eventsStates) {
                if (!state.evaluateStep(interpolator)) continue;
                occuringEvents.add(state);
            }
            while (!occuringEvents.isEmpty()) {
                Iterator iterator = occuringEvents.iterator();
                EventState currentEvent = (EventState)iterator.next();
                iterator.remove();
                double eventT = currentEvent.getEventTime();
                interpolator.setSoftPreviousTime(previousT);
                interpolator.setSoftCurrentTime(eventT);
                interpolator.setInterpolatedTime(eventT);
                double[] eventY = interpolator.getInterpolatedState();
                currentEvent.stepAccepted(eventT, eventY);
                this.isLastStep = currentEvent.stop();
                for (StepHandler handler : this.stepHandlers) {
                    handler.handleStep(interpolator, this.isLastStep);
                }
                if (this.isLastStep) {
                    System.arraycopy(eventY, 0, y, 0, y.length);
                    return eventT;
                }
                if (currentEvent.reset(eventT, eventY)) {
                    System.arraycopy(eventY, 0, y, 0, y.length);
                    this.computeDerivatives(eventT, y, yDot);
                    this.resetOccurred = true;
                    return eventT;
                }
                previousT = eventT;
                interpolator.setSoftPreviousTime(eventT);
                interpolator.setSoftCurrentTime(currentT);
                if (!currentEvent.evaluateStep(interpolator)) continue;
                occuringEvents.add(currentEvent);
            }
            interpolator.setInterpolatedTime(currentT);
            double[] currentY = interpolator.getInterpolatedState();
            for (EventState state : this.eventsStates) {
                state.stepAccepted(currentT, currentY);
                this.isLastStep = this.isLastStep || state.stop();
            }
            this.isLastStep = this.isLastStep || MathUtils.equals(currentT, tEnd, 1);
            for (StepHandler handler : this.stepHandlers) {
                handler.handleStep(interpolator, this.isLastStep);
            }
            return currentT;
        }
        catch (EventException se) {
            Throwable cause = se.getCause();
            if (cause != null && cause instanceof DerivativeException) {
                throw (DerivativeException)cause;
            }
            throw new IntegratorException(se);
        }
        catch (ConvergenceException ce) {
            throw new IntegratorException(ce);
        }
    }

    protected void sanityChecks(FirstOrderDifferentialEquations ode, double t0, double[] y0, double t, double[] y) throws IntegratorException {
        if (ode.getDimension() != y0.length) {
            throw new IntegratorException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, ode.getDimension(), y0.length);
        }
        if (ode.getDimension() != y.length) {
            throw new IntegratorException(LocalizedFormats.DIMENSIONS_MISMATCH_SIMPLE, ode.getDimension(), y.length);
        }
        if (FastMath.abs(t - t0) <= 1.0E-12 * FastMath.max(FastMath.abs(t0), FastMath.abs(t))) {
            throw new IntegratorException(LocalizedFormats.TOO_SMALL_INTEGRATION_INTERVAL, FastMath.abs(t - t0));
        }
    }

    @Deprecated
    protected CombinedEventsManager addEndTimeChecker(double startTime, double endTime, CombinedEventsManager manager) {
        CombinedEventsManager newManager = new CombinedEventsManager();
        for (EventState state : manager.getEventsStates()) {
            newManager.addEventHandler(state.getEventHandler(), state.getMaxCheckInterval(), state.getConvergence(), state.getMaxIterationCount());
        }
        newManager.addEventHandler(new EndTimeChecker(endTime), Double.POSITIVE_INFINITY, FastMath.ulp(FastMath.max(FastMath.abs(startTime), FastMath.abs(endTime))), 100);
        return newManager;
    }

    @Deprecated
    private static class EndTimeChecker
    implements EventHandler {
        private final double endTime;

        public EndTimeChecker(double endTime) {
            this.endTime = endTime;
        }

        public int eventOccurred(double t, double[] y, boolean increasing) {
            return 0;
        }

        public double g(double t, double[] y) {
            return t - this.endTime;
        }

        public void resetState(double t, double[] y) {
        }
    }
}

