/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.javolution.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.hive.javolution.context.LocalContext;
import org.apache.hive.javolution.util.FastCollection;
import org.apache.hive.javolution.util.FastComparator;
import org.apache.hive.javolution.util.FastMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LocalMap<K, V>
implements Map<K, V> {
    private final LocalContext.Reference _mapRef = new LocalContext.Reference(new FastMap().shared());

    public LocalMap<K, V> setKeyComparator(FastComparator<? super K> keyComparator) {
        this.localMap().setKeyComparator(keyComparator);
        return this;
    }

    public LocalMap<K, V> setValueComparator(FastComparator<? super V> valueComparator) {
        this.localMap().setValueComparator(valueComparator);
        return this;
    }

    public V putDefault(K key, V defaultValue) {
        return ((FastMap)this._mapRef.getDefault()).put(key, defaultValue);
    }

    public V getDefault(K key) {
        return ((FastMap)this._mapRef.getDefault()).get(key);
    }

    @Override
    public int size() {
        return ((FastMap)this._mapRef.get()).size();
    }

    @Override
    public boolean isEmpty() {
        return ((FastMap)this._mapRef.get()).isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return ((FastMap)this._mapRef.get()).containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return ((FastMap)this._mapRef.get()).containsValue(value);
    }

    @Override
    public V get(Object key) {
        return ((FastMap)this._mapRef.get()).get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.localMap().put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.localMap().putAll(map);
    }

    @Override
    public V remove(Object key) {
        return this.put(key, null);
    }

    @Override
    public void clear() {
        FastMap<K, V> localMap = this.localMap();
        FastCollection.Record e = localMap.head();
        FastMap.Entry<K, V> end = localMap.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            ((FastMap.Entry)e).setValue(null);
        }
    }

    @Override
    public Set<K> keySet() {
        return this.localMap().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.localMap().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.localMap().entrySet();
    }

    private FastMap<K, V> localMap() {
        FastMap localMap = (FastMap)this._mapRef.getLocal();
        return localMap != null ? localMap : this.newLocalMap();
    }

    private FastMap newLocalMap() {
        FastMap parentMap = (FastMap)this._mapRef.get();
        FastMap localMap = FastMap.newInstance();
        localMap.shared();
        localMap.setKeyComparator(parentMap.getKeyComparator());
        localMap.setValueComparator(parentMap.getValueComparator());
        localMap.putAll(parentMap);
        this._mapRef.set(localMap);
        return localMap;
    }
}

