/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.javolution.testing;

import org.apache.hive.javolution.context.Context;
import org.apache.hive.javolution.context.LogContext;
import org.apache.hive.javolution.context.ObjectFactory;
import org.apache.hive.javolution.lang.Configurable;
import org.apache.hive.javolution.lang.MathLib;
import org.apache.hive.javolution.testing.AssertionException;
import org.apache.hive.javolution.testing.TestCase;
import org.apache.hive.javolution.testing.TestContext;
import org.apache.hive.javolution.testing.TestSuite;
import org.apache.hive.javolution.text.Text;
import org.apache.hive.javolution.text.TextBuilder;

public abstract class TimeContext
extends TestContext {
    public static final Class<? extends TimeContext> REGRESSION = Regression.class;
    public static final Configurable<Integer> TEST_DURATION_MS = new Configurable(new Integer(1000)){};
    public static final Configurable<Class<? extends TimeContext>> DEFAULT = new Configurable(Default.class){};
    private long _minimumPs;
    private long _averagePs;
    private long _maximumPs;

    public static void enter() {
        Context.enter(DEFAULT.get());
    }

    public static void exit() {
        Context.exit(TimeContext.class);
    }

    public static long getMinimumTime(String unit) {
        LogContext ctx = LogContext.getCurrentLogContext();
        if (ctx instanceof TimeContext) {
            return TimeContext.picosecondTo(unit, ((TimeContext)ctx).getMinimumTimeInPicoSeconds());
        }
        return -1L;
    }

    public static long getAverageTime(String unit) {
        LogContext ctx = LogContext.getCurrentLogContext();
        if (ctx instanceof TimeContext) {
            return TimeContext.picosecondTo(unit, ((TimeContext)ctx).getAverageTimeInPicoSeconds());
        }
        return -1L;
    }

    public static long getMaximumTime(String unit) {
        LogContext ctx = LogContext.getCurrentLogContext();
        if (ctx instanceof TimeContext) {
            return TimeContext.picosecondTo(unit, ((TimeContext)ctx).getMaximumTimeInPicoSeconds());
        }
        return -1L;
    }

    private static long picosecondTo(String unit, long picoseconds) {
        if (unit.equals("ps")) {
            return picoseconds;
        }
        if (unit.equals("ns")) {
            return picoseconds / 1000L;
        }
        if (unit.equals("us")) {
            return picoseconds / 1000000L;
        }
        if (unit.equals("ms")) {
            return picoseconds / 1000000000L;
        }
        if (unit.equals("s")) {
            return picoseconds / 1000000000000L;
        }
        throw new IllegalArgumentException("Unit " + unit + " not recognized");
    }

    public long getMinimumTimeInPicoSeconds() {
        return this._minimumPs;
    }

    public long getAverageTimeInPicoSeconds() {
        return this._averagePs;
    }

    public long getMaximumTimeInPicoSeconds() {
        return this._maximumPs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(TestCase testCase) throws Exception {
        if (testCase.isIgnored()) {
            return;
        }
        System.gc();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this._minimumPs = Long.MAX_VALUE;
        this._maximumPs = 0L;
        this._averagePs = 0L;
        long totalCount = 0L;
        long totalDuration = 0L;
        long maximumDurationPs = (long)TEST_DURATION_MS.get().intValue() * 1000000000L;
        while (true) {
            testCase.setUp();
            try {
                long start = TimeContext.nanoTime();
                testCase.execute();
                long duration = (TimeContext.nanoTime() - start) * 1000L;
                int count = testCase.count();
                totalCount += (long)count;
                totalDuration += duration;
                long singleExecutionDuration = duration / (long)count;
                if (singleExecutionDuration < this._minimumPs) {
                    this._minimumPs = singleExecutionDuration;
                }
                if (singleExecutionDuration > this._maximumPs) {
                    this._maximumPs = singleExecutionDuration;
                }
                if (totalDuration < maximumDurationPs) continue;
                this._averagePs = totalDuration / totalCount;
                testCase.validate();
            }
            finally {
                testCase.tearDown();
                continue;
            }
            break;
        }
    }

    private static long nanoTime() {
        return System.nanoTime();
    }

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Default();
            }
        }, Default.class);
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Regression();
            }
        }, Regression.class);
    }

    private static final class Regression
    extends TimeContext {
        private Regression() {
        }

        protected boolean doAssert(boolean value, CharSequence message) {
            if (!value) {
                throw new AssertionException(((Object)message).toString());
            }
            return value;
        }

        protected void logMessage(String category, CharSequence message) {
        }

        public boolean isLogged(String category) {
            return false;
        }
    }

    private static final class Default
    extends TimeContext {
        private int _passedCount;
        private int _failedCount;
        private int _ignoredCount;
        private boolean _isPassed;

        private Default() {
        }

        protected void enterAction() {
            this._ignoredCount = 0;
            this._failedCount = 0;
            this._passedCount = 0;
        }

        protected void exitAction() {
            this.logMessage("test", Text.valueOf((Object)"---------------------------------------------------"));
            this.logMessage("test", Text.valueOf((Object)("SUMMARY - PASSED: " + this._passedCount + ", FAILED: " + this._failedCount + ", IGNORED: " + this._ignoredCount)));
        }

        protected void doRun(TestSuite testSuite) throws Exception {
            this.logMessage("test", Text.valueOf((Object)"---------------------------------------------------"));
            this.logMessage("test", Text.valueOf((Object)"Executes Test Suite: ").plus(testSuite.getName()));
            this.logMessage("test", Text.valueOf((Object)""));
            super.doRun(testSuite);
        }

        protected boolean doAssert(boolean value, CharSequence message) {
            if (!value) {
                this._isPassed = false;
                return super.doAssert(value, message);
            }
            return value;
        }

        protected void logMessage(String category, CharSequence message) {
            if (category.equals("error")) {
                System.err.print("[");
                System.err.print(category);
                System.err.print("] ");
                System.err.println(message);
                System.err.flush();
            } else {
                System.out.print("[");
                System.out.print(category);
                System.out.print("] ");
                System.out.println(message);
                System.out.flush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun(TestCase testCase) {
            if (testCase.isIgnored()) {
                this.logWarning(Text.valueOf((Object)"Ignore ").plus(testCase.getName()));
                ++this._ignoredCount;
                return;
            }
            this._isPassed = true;
            try {
                super.doRun(testCase);
            }
            catch (Throwable error) {
                this._isPassed = false;
                this.logError(error, null);
            }
            finally {
                if (this._isPassed) {
                    ++this._passedCount;
                } else {
                    ++this._failedCount;
                }
            }
            TextBuilder tmp = TextBuilder.newInstance();
            try {
                tmp.append(testCase.getName());
                tmp.setLength(40, ' ');
                tmp.append(" - Average: ");
                Default.appendTime(this.getAverageTimeInPicoSeconds(), tmp);
                tmp.append(", Minimum: ");
                Default.appendTime(this.getMinimumTimeInPicoSeconds(), tmp);
                tmp.append(", Maximum: ");
                Default.appendTime(this.getMaximumTimeInPicoSeconds(), tmp);
                this.logMessage("time", tmp);
            }
            finally {
                TextBuilder.recycle(tmp);
            }
        }

        private static TextBuilder appendTime(long picoseconds, TextBuilder tb) {
            long divisor;
            String unit;
            if (picoseconds > 1000000000000L) {
                unit = " s";
                divisor = 1000000000000L;
            } else if (picoseconds > 1000000000L) {
                unit = " ms";
                divisor = 1000000000L;
            } else if (picoseconds > 1000000L) {
                unit = " us";
                divisor = 1000000L;
            } else if (picoseconds > 1000L) {
                unit = " ns";
                divisor = 1000L;
            } else {
                unit = " ps";
                divisor = 1L;
            }
            long value = picoseconds / divisor;
            tb.append(value);
            int fracDigits = 3 - MathLib.digitLength(value);
            if (fracDigits > 0) {
                tb.append(".");
            }
            int i = 0;
            int j = 10;
            while (i < fracDigits) {
                tb.append(picoseconds * (long)j / divisor % 10L);
                ++i;
                j *= 10;
            }
            return tb.append(unit);
        }
    }
}

