/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.javolution.testing;

import org.apache.hive.javolution.context.Context;
import org.apache.hive.javolution.context.LogContext;
import org.apache.hive.javolution.context.ObjectFactory;
import org.apache.hive.javolution.lang.Configurable;
import org.apache.hive.javolution.lang.MathLib;
import org.apache.hive.javolution.testing.AssertionException;
import org.apache.hive.javolution.testing.TestCase;
import org.apache.hive.javolution.testing.TestSuite;
import org.apache.hive.javolution.text.Text;
import org.apache.hive.javolution.text.TextBuilder;
import org.apache.hive.javolution.util.FastTable;

public abstract class TestContext
extends LogContext {
    public static final Configurable<Class<? extends TestContext>> DEFAULT = new Configurable(Default.class){};
    public static final Class<? extends LogContext> CONSOLE = Console.class;
    public static final Class<? extends TestContext> REGRESSION = Regression.class;

    public static void enter() {
        Context.enter(DEFAULT.get());
    }

    public static void exit() {
        Context.exit(TestContext.class);
    }

    public static void run(TestSuite testSuite) throws Exception {
        TestContext testContext = (TestContext)LogContext.getCurrentLogContext();
        testContext.doRun(testSuite);
    }

    public static void run(TestCase testCase) throws Exception {
        TestContext testContext = (TestContext)LogContext.getCurrentLogContext();
        testContext.doRun(testCase);
    }

    public static boolean assertEquals(Object expected, Object actual, CharSequence message) {
        boolean ok = expected == null && actual == null || expected != null && expected.equals(actual);
        message = ok || message != null ? message : Text.valueOf(expected).plus(" expected but found ").plus(actual);
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        return ctx.doAssert(ok, message);
    }

    public static boolean assertEquals(Object expected, Object actual) {
        return TestContext.assertEquals(expected, actual, null);
    }

    public static boolean assertSame(Object expected, Object actual, CharSequence message) {
        boolean ok = expected == actual;
        message = ok || message != null ? message : Text.valueOf(expected).plus(" expected but found a different instance ").plus(actual);
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        return ctx.doAssert(ok, message);
    }

    public static boolean assertSame(Object expected, Object actual) {
        return TestContext.assertSame(expected, actual, null);
    }

    public static boolean assertTrue(boolean actual, CharSequence message) {
        return TestContext.assertEquals(Boolean.TRUE, actual ? Boolean.TRUE : Boolean.FALSE, message);
    }

    public static boolean assertTrue(boolean actual) {
        return TestContext.assertTrue(actual, null);
    }

    public static boolean assertFalse(boolean actual, CharSequence message) {
        return TestContext.assertEquals(Boolean.FALSE, actual ? Boolean.TRUE : Boolean.FALSE, message);
    }

    public static boolean assertFalse(boolean actual) {
        return TestContext.assertFalse(actual, null);
    }

    public static boolean assertNull(Object actual, CharSequence message) {
        return TestContext.assertEquals(null, actual, message);
    }

    public static boolean assertNull(Object actual) {
        return TestContext.assertNull(actual, null);
    }

    public static boolean assertNotNull(Object actual, CharSequence message) {
        boolean ok = actual != null;
        message = ok || message != null ? message : Text.valueOf((Object)"Not null expected but found null");
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        return ctx.doAssert(ok, message);
    }

    public static boolean assertNotNull(Object actual) {
        return TestContext.assertNotNull(actual, null);
    }

    public static boolean assertEquals(int expected, int actual, CharSequence message) {
        boolean ok = expected == actual;
        message = ok || message != null ? message : Text.valueOf((Object)(expected + " expected but found " + actual));
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        return ctx.doAssert(ok, message);
    }

    public static boolean assertEquals(int expected, int actual) {
        return TestContext.assertEquals(expected, actual, null);
    }

    public static boolean assertEquals(long expected, long actual, CharSequence message) {
        boolean ok = expected == actual;
        message = ok || message != null ? message : Text.valueOf((Object)(expected + " expected but found " + actual));
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        return ctx.doAssert(ok, message);
    }

    public static boolean assertEquals(long expected, long actual) {
        return TestContext.assertEquals(expected, actual, null);
    }

    public static boolean assertEquals(double expected, double actual, CharSequence message) {
        boolean ok = expected == actual || Double.isNaN(expected) && Double.isNaN(actual);
        message = ok || message != null ? message : Text.valueOf((Object)(expected + " expected but found " + actual));
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        return ctx.doAssert(ok, message);
    }

    public static boolean assertEquals(double expected, double actual) {
        return TestContext.assertEquals(expected, actual, null);
    }

    public static boolean assertEquals(double expected, double actual, double delta, CharSequence message) {
        boolean ok = expected == actual || Double.isNaN(expected) && Double.isNaN(actual);
        message = ok || message != null ? message : Text.valueOf((Object)(expected + " expected but found " + actual));
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        return ctx.doAssert(ok, message);
    }

    public static boolean assertEquals(double expected, double actual, double delta) {
        return TestContext.assertEquals(expected, actual, delta, null);
    }

    public static boolean assertArrayEquals(Object[] expected, Object[] actual, CharSequence message) {
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        if (expected == actual) {
            return ctx.doAssert(true, message);
        }
        if (expected == null) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)"Null array expected but found actual array not null"));
        }
        if (actual == null) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)"Not null array expected but found actual array null"));
        }
        if (expected.length != actual.length) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)("Array of size " + expected.length + " expected but found array of actual size " + actual.length)));
        }
        for (int i = 0; i < expected.length; ++i) {
            Object e = expected[i];
            Object a = actual[i];
            if ((e == null || e.equals(a)) && e == a) continue;
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)("Array element at " + i + ", expected " + e + " but found " + a)));
        }
        return ctx.doAssert(true, message);
    }

    public static boolean assertArrayEquals(Object[] expected, Object[] actual) {
        return TestContext.assertArrayEquals(expected, actual, null);
    }

    public static boolean assertArrayEquals(boolean[] expected, boolean[] actual, CharSequence message) {
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        if (expected == actual) {
            return ctx.doAssert(true, message);
        }
        if (expected == null) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)"Null array expected but found actual array not null"));
        }
        if (actual == null) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)"Not null array expected but found actual array null"));
        }
        if (expected.length != actual.length) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)("Array of size " + expected.length + " expected but found array of actual size " + actual.length)));
        }
        for (int i = 0; i < expected.length; ++i) {
            boolean e = expected[i];
            boolean a = actual[i];
            if (e == a) continue;
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)("Array element at " + i + ", expected " + e + " but found " + a)));
        }
        return ctx.doAssert(true, message);
    }

    public static boolean assertArrayEquals(boolean[] expected, boolean[] actual) {
        return TestContext.assertArrayEquals(expected, actual, null);
    }

    public static boolean assertArrayEquals(int[] expected, int[] actual, CharSequence message) {
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        if (expected == actual) {
            return ctx.doAssert(true, message);
        }
        if (expected == null) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)"Null array expected but found actual array not null"));
        }
        if (actual == null) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)"Not null array expected but found actual array null"));
        }
        if (expected.length != actual.length) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)("Array of size " + expected.length + " expected but found array of actual size " + actual.length)));
        }
        for (int i = 0; i < expected.length; ++i) {
            int e = expected[i];
            int a = actual[i];
            if (e == a) continue;
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)("Array element at " + i + ", expected " + e + " but found " + a)));
        }
        return ctx.doAssert(true, message);
    }

    public static boolean assertArrayEquals(int[] expected, int[] actual) {
        return TestContext.assertArrayEquals(expected, actual, null);
    }

    public static boolean assertArrayEquals(long[] expected, long[] actual, CharSequence message) {
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        if (expected == actual) {
            return ctx.doAssert(true, message);
        }
        if (expected == null) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)"Null array expected but found actual array not null"));
        }
        if (actual == null) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)"Not null array expected but found actual array null"));
        }
        if (expected.length != actual.length) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)("Array of size " + expected.length + " expected but found array of actual size " + actual.length)));
        }
        for (int i = 0; i < expected.length; ++i) {
            long e = expected[i];
            long a = actual[i];
            if (e == a) continue;
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)("Array element at " + i + ", expected " + e + " but found " + a)));
        }
        return ctx.doAssert(true, message);
    }

    public static boolean assertArrayEquals(long[] expected, long[] actual) {
        return TestContext.assertArrayEquals(expected, actual, null);
    }

    public static boolean assertArrayEquals(double[] expected, double[] actual, double delta, CharSequence message) {
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        if (expected == actual) {
            return ctx.doAssert(true, message);
        }
        if (expected == null) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)"Null array expected but found actual array not null"));
        }
        if (actual == null) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)"Not null array expected but found actual array null"));
        }
        if (expected.length != actual.length) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)("Array of size " + expected.length + " expected but found array of actual size " + actual.length)));
        }
        for (int i = 0; i < expected.length; ++i) {
            double e = expected[i];
            double a = actual[i];
            if (!(MathLib.abs(e - a) > delta)) continue;
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)("Array element at " + i + ", expected " + e + " but found " + a)));
        }
        return ctx.doAssert(true, message);
    }

    public static boolean assertArrayEquals(double[] expected, double[] actual, double delta) {
        return TestContext.assertArrayEquals(expected, actual, delta, null);
    }

    public static boolean assertException(Class exceptionClass, Runnable logic, CharSequence message) {
        Throwable exception = null;
        try {
            logic.run();
        }
        catch (Throwable e) {
            exception = e;
        }
        TestContext ctx = (TestContext)LogContext.getCurrentLogContext();
        if (exception == null) {
            return ctx.doAssert(false, message != null ? message : Text.valueOf((Object)"Expected exception instance of ").plus(exceptionClass.getName()).plus(" but no exception has been raised"));
        }
        boolean ok = exceptionClass.isInstance(exception);
        message = ok || message != null ? message : Text.valueOf((Object)"Expected instance of ").plus(exceptionClass.getName()).plus(" but actual exception is instance of ").plus(exception.getClass().getName());
        return ctx.doAssert(ok, message);
    }

    public static boolean assertException(Class exceptionClass, Runnable logic) {
        return TestContext.assertException(exceptionClass, logic, null);
    }

    public static boolean fail(CharSequence message) {
        return TestContext.assertTrue(false, message);
    }

    public static boolean fail() {
        return TestContext.fail(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(TestSuite testSuite) throws Exception {
        testSuite.setUp();
        try {
            FastTable tests = testSuite._tests;
            for (int i = 0; i < tests.size(); ++i) {
                this.doRun((TestCase)tests.get(i));
            }
        }
        finally {
            testSuite.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRun(TestCase testCase) throws Exception {
        if (testCase.isIgnored()) {
            return;
        }
        testCase.setUp();
        try {
            testCase.execute();
            testCase.validate();
        }
        finally {
            testCase.tearDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doAssert(boolean value, CharSequence message) {
        if (value) {
            return true;
        }
        Error error = new Error();
        StackTraceElement[] trace = error.getStackTrace();
        TextBuilder tmp = TextBuilder.newInstance();
        try {
            tmp.append(message);
            for (int i = 1; i < trace.length; ++i) {
                if (!trace[i].getMethodName().equals("validate")) continue;
                tmp.append("\n\tat ");
                tmp.append(trace[i]);
                break;
            }
            this.logError(null, tmp);
        }
        finally {
            TextBuilder.recycle(tmp);
        }
        return false;
    }

    static {
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Default();
            }
        }, Default.class);
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Console();
            }
        }, CONSOLE);
        ObjectFactory.setInstance(new ObjectFactory(){

            protected Object create() {
                return new Regression();
            }
        }, Regression.class);
    }

    private static class Regression
    extends TestContext {
        private Regression() {
        }

        protected boolean doAssert(boolean value, CharSequence message) {
            if (!value) {
                throw new AssertionException(((Object)message).toString());
            }
            return value;
        }

        protected boolean isLogged(String category) {
            return false;
        }

        protected void logMessage(String category, CharSequence message) {
        }
    }

    private static class Console
    extends Default {
        private Console() {
        }
    }

    private static class Default
    extends TestContext {
        private int _passedCount;
        private int _failedCount;
        private int _ignoredCount;
        private boolean _isPassed;

        private Default() {
        }

        protected void enterAction() {
            this._ignoredCount = 0;
            this._failedCount = 0;
            this._passedCount = 0;
        }

        protected void exitAction() {
            this.logMessage("test", Text.valueOf((Object)"---------------------------------------------------"));
            this.logMessage("test", Text.valueOf((Object)("SUMMARY - PASSED: " + this._passedCount + ", FAILED: " + this._failedCount + ", IGNORED: " + this._ignoredCount)));
        }

        protected void doRun(TestSuite testSuite) throws Exception {
            this.logMessage("test", Text.valueOf((Object)"---------------------------------------------------"));
            this.logMessage("test", Text.valueOf((Object)"Executes Test Suite: ").plus(testSuite.getName()));
            this.logMessage("test", Text.valueOf((Object)""));
            super.doRun(testSuite);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void doRun(TestCase testCase) {
            if (testCase.isIgnored()) {
                this.logWarning(Text.valueOf((Object)"Ignore ").plus(testCase.getName()));
                ++this._ignoredCount;
                return;
            }
            this.logMessage("test", Text.valueOf((Object)testCase.getName()));
            this._isPassed = true;
            try {
                super.doRun(testCase);
            }
            catch (Throwable error) {
                this._isPassed = false;
                this.logError(error, null);
            }
            finally {
                if (this._isPassed) {
                    ++this._passedCount;
                } else {
                    ++this._failedCount;
                }
            }
        }

        protected boolean doAssert(boolean value, CharSequence message) {
            if (!value) {
                this._isPassed = false;
                return super.doAssert(value, message);
            }
            return value;
        }

        protected void logMessage(String category, CharSequence message) {
            if (category.equals("error")) {
                System.err.print("[");
                System.err.print(category);
                System.err.print("] ");
                System.err.println(message);
                System.err.flush();
            } else {
                System.out.print("[");
                System.out.print(category);
                System.out.print("] ");
                System.out.println(message);
                System.out.flush();
            }
        }
    }
}

