/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.javolution.lang;

import java.util.Random;

public final class MathLib {
    private static final Random RANDOM = new Random();
    private static final byte[] BIT_LENGTH = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final long MASK_63 = Long.MAX_VALUE;
    private static final long MASK_32 = 0xFFFFFFFFL;
    private static final int[] POW5_INT = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
    private static final double LOG2_DIV_LOG10 = 0.3010299956639812;
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    public static final double HALF_PI = 1.5707963267948966;
    public static final double TWO_PI = Math.PI * 2;
    public static final double FOUR_PI = Math.PI * 4;
    public static final double PI_SQUARE = Math.PI * Math.PI;
    public static final double LOG2 = 0.6931471805599453;
    public static final double LOG10 = 2.302585092994046;
    public static final double SQRT2 = 1.4142135623730951;
    public static final double NaN = Double.NaN;
    public static final double Infinity = Double.POSITIVE_INFINITY;
    private static double INV_LOG10 = 0.4342944819032518;
    private static final double NORMALIZATION_FACTOR = 4.656612873077393E-10;
    static final double[] atanhi = new double[]{0.4636476090008061, 0.7853981633974483, 0.982793723247329, 1.5707963267948966};
    static final double[] atanlo = new double[]{2.2698777452961687E-17, 3.061616997868383E-17, 1.3903311031230998E-17, 6.123233995736766E-17};
    static final double[] aT = new double[]{0.3333333333333293, -0.19999999999876483, 0.14285714272503466, -0.11111110405462356, 0.09090887133436507, -0.0769187620504483, 0.06661073137387531, -0.058335701337905735, 0.049768779946159324, -0.036531572744216916, 0.016285820115365782};
    static final double one = 1.0;
    static final double huge = 1.0E300;
    static final double ln2_hi = 0.6931471803691238;
    static final double ln2_lo = 1.9082149292705877E-10;
    static final double two54 = 1.8014398509481984E16;
    static final double Lg1 = 0.6666666666666735;
    static final double Lg2 = 0.3999999999940942;
    static final double Lg3 = 0.2857142874366239;
    static final double Lg4 = 0.22222198432149784;
    static final double Lg5 = 0.1818357216161805;
    static final double Lg6 = 0.15313837699209373;
    static final double Lg7 = 0.14798198605116586;
    static final double zero = 0.0;
    static final double[] halF = new double[]{0.5, -0.5};
    static final double twom1000 = 9.332636185032189E-302;
    static final double o_threshold = 709.782712893384;
    static final double u_threshold = -745.1332191019411;
    static final double[] ln2HI = new double[]{0.6931471803691238, -0.6931471803691238};
    static final double[] ln2LO = new double[]{1.9082149292705877E-10, -1.9082149292705877E-10};
    static final double invln2 = 1.4426950408889634;
    static final double P1 = 0.16666666666666602;
    static final double P2 = -0.0027777777777015593;
    static final double P3 = 6.613756321437934E-5;
    static final double P4 = -1.6533902205465252E-6;
    static final double P5 = 4.1381367970572385E-8;

    private MathLib() {
    }

    public static int random(int min, int max) {
        int next = RANDOM.nextInt();
        if (next >= min && next <= max) {
            return next;
        }
        if ((next -= Integer.MIN_VALUE) >= min && next <= max) {
            return next;
        }
        int interval = 1 + max - min;
        if (interval <= 0) {
            throw new Error("Interval [" + min + ".." + max + "] error");
        }
        return MathLib.abs(next % interval) + min;
    }

    public static long random(long min, long max) {
        long next = RANDOM.nextLong();
        if (next >= min && next <= max) {
            return next;
        }
        if ((next += Long.MIN_VALUE) >= min && next <= max) {
            return next;
        }
        long interval = 1L + max - min;
        if (interval <= 0L) {
            throw new Error("Interval error");
        }
        return MathLib.abs(next % interval) + min;
    }

    public static float random(float min, float max) {
        return (float)MathLib.random((double)min, (double)max);
    }

    public static double random(double min, double max) {
        double next = RANDOM.nextDouble();
        return min + next * max - next * min;
    }

    public static int bitLength(int i) {
        if (i < 0) {
            ++i;
            i = -i;
        }
        return i < 65536 ? (i < 256 ? BIT_LENGTH[i] : BIT_LENGTH[i >>> 8] + 8) : (i < 0x1000000 ? BIT_LENGTH[i >>> 16] + 16 : BIT_LENGTH[i >>> 24] + 24);
    }

    public static int bitLength(long l) {
        int i = (int)(l >> 32);
        if (i > 0) {
            return i < 65536 ? (i < 256 ? BIT_LENGTH[i] + 32 : BIT_LENGTH[i >>> 8] + 40) : (i < 0x1000000 ? BIT_LENGTH[i >>> 16] + 48 : BIT_LENGTH[i >>> 24] + 56);
        }
        if (i < 0) {
            return MathLib.bitLength(-(++l));
        }
        i = (int)l;
        return i < 0 ? 32 : (i < 65536 ? (i < 256 ? BIT_LENGTH[i] : BIT_LENGTH[i >>> 8] + 8) : (i < 0x1000000 ? BIT_LENGTH[i >>> 16] + 16 : BIT_LENGTH[i >>> 24] + 24));
    }

    public static int bitCount(long longValue) {
        longValue -= longValue >>> 1 & 0x5555555555555555L;
        longValue = (longValue & 0x3333333333333333L) + (longValue >>> 2 & 0x3333333333333333L);
        longValue = longValue + (longValue >>> 4) & 0xF0F0F0F0F0F0F0FL;
        longValue += longValue >>> 8;
        longValue += longValue >>> 16;
        longValue += longValue >>> 32;
        return (int)longValue & 0x7F;
    }

    public static int numberOfLeadingZeros(long longValue) {
        if (longValue == 0L) {
            return 64;
        }
        int n = 1;
        int x = (int)(longValue >>> 32);
        if (x == 0) {
            n += 32;
            x = (int)longValue;
        }
        if (x >>> 16 == 0) {
            n += 16;
            x <<= 16;
        }
        if (x >>> 24 == 0) {
            n += 8;
            x <<= 8;
        }
        if (x >>> 28 == 0) {
            n += 4;
            x <<= 4;
        }
        if (x >>> 30 == 0) {
            n += 2;
            x <<= 2;
        }
        return n -= x >>> 31;
    }

    public static int numberOfTrailingZeros(long longValue) {
        int x;
        if (longValue == 0L) {
            return 64;
        }
        int n = 63;
        int y = (int)longValue;
        if (y != 0) {
            n -= 32;
            x = y;
        } else {
            x = (int)(longValue >>> 32);
        }
        y = x << 16;
        if (y != 0) {
            n -= 16;
            x = y;
        }
        if ((y = x << 8) != 0) {
            n -= 8;
            x = y;
        }
        if ((y = x << 4) != 0) {
            n -= 4;
            x = y;
        }
        if ((y = x << 2) != 0) {
            n -= 2;
            x = y;
        }
        return n - (x << 1 >>> 31);
    }

    public static int digitLength(int i) {
        if (i >= 0) {
            return i >= 100000 ? (i >= 10000000 ? (i >= 1000000000 ? 10 : (i >= 100000000 ? 9 : 8)) : (i >= 1000000 ? 7 : 6)) : (i >= 100 ? (i >= 10000 ? 5 : (i >= 1000 ? 4 : 3)) : (i >= 10 ? 2 : 1));
        }
        if (i == Integer.MIN_VALUE) {
            return 10;
        }
        return MathLib.digitLength(-i);
    }

    public static int digitLength(long l) {
        if (l >= 0L) {
            return l <= Integer.MAX_VALUE ? MathLib.digitLength((int)l) : (l >= 100000000000000L ? (l >= 10000000000000000L ? (l >= 1000000000000000000L ? 19 : (l >= 100000000000000000L ? 18 : 17)) : (l >= 1000000000000000L ? 16 : 15)) : (l >= 100000000000L ? (l >= 10000000000000L ? 14 : (l >= 1000000000000L ? 13 : 12)) : (l >= 10000000000L ? 11 : 10)));
        }
        if (l == Long.MIN_VALUE) {
            return 19;
        }
        return MathLib.digitLength(-l);
    }

    public static double toDoublePow2(long m, int n) {
        long bits;
        if (m == 0L) {
            return 0.0;
        }
        if (m == Long.MIN_VALUE) {
            return MathLib.toDoublePow2(-4611686018427387904L, n + 1);
        }
        if (m < 0L) {
            return -MathLib.toDoublePow2(-m, n);
        }
        int bitLength = MathLib.bitLength(m);
        int shift = bitLength - 53;
        long exp = 1075L + (long)n + (long)shift;
        if (exp >= 2047L) {
            return Double.POSITIVE_INFINITY;
        }
        if (exp <= 0L) {
            if (exp <= -54L) {
                return 0.0;
            }
            return MathLib.toDoublePow2(m, n + 54) / 1.8014398509481984E16;
        }
        long l = bits = shift > 0 ? (m >> shift) + (m >> shift - 1 & 1L) : m << -shift;
        if (bits >> 52 != 1L && ++exp >= 2047L) {
            return Double.POSITIVE_INFINITY;
        }
        bits &= 0xFFFFFFFFFFFFFL;
        return Double.longBitsToDouble(bits |= exp << 52);
    }

    public static double toDoublePow10(long m, int n) {
        if (m == 0L) {
            return 0.0;
        }
        if (m == Long.MIN_VALUE) {
            return MathLib.toDoublePow10(-922337203685477580L, n + 1);
        }
        if (m < 0L) {
            return -MathLib.toDoublePow10(-m, n);
        }
        if (n >= 0) {
            if (n > 308) {
                return Double.POSITIVE_INFINITY;
            }
            long x0 = 0L;
            long x1 = 0L;
            long x2 = m & 0xFFFFFFFFL;
            long x3 = m >>> 32;
            int pow2 = 0;
            while (n != 0) {
                int i = n >= POW5_INT.length ? POW5_INT.length - 1 : n;
                int coef = POW5_INT[i];
                if ((int)x0 != 0) {
                    x0 *= (long)coef;
                }
                if ((int)x1 != 0) {
                    x1 *= (long)coef;
                }
                x2 *= (long)coef;
                x3 *= (long)coef;
                x1 &= 0xFFFFFFFFL;
                x2 &= 0xFFFFFFFFL;
                pow2 += i;
                n -= i;
                long carry = (x3 += (x2 += (x1 += (x0 &= 0xFFFFFFFFL) >>> 32) >>> 32) >>> 32) >>> 32;
                if (carry == 0L) continue;
                x0 = x1;
                x1 = x2;
                x2 = x3 & 0xFFFFFFFFL;
                x3 = carry;
                pow2 += 32;
            }
            int shift = 31 - MathLib.bitLength(x3);
            long mantissa = shift < 0 ? x3 << 31 | x2 >>> 1 : (x3 << 32 | x2) << shift | x1 >>> 32 - shift;
            return MathLib.toDoublePow2(mantissa, pow2 -= shift);
        }
        if (n < -344) {
            return 0.0;
        }
        long x1 = m;
        long x0 = 0L;
        int pow2 = 0;
        while (true) {
            int shift = 63 - MathLib.bitLength(x1);
            x1 <<= shift;
            x1 |= x0 >>> 63 - shift;
            x0 = x0 << shift & Long.MAX_VALUE;
            pow2 -= shift;
            if (n == 0) break;
            int i = -n >= POW5_INT.length ? POW5_INT.length - 1 : -n;
            int divisor = POW5_INT[i];
            long wh = x1 >>> 32;
            long qh = wh / (long)divisor;
            long r = wh - qh * (long)divisor;
            long wl = r << 32 | x1 & 0xFFFFFFFFL;
            long ql = wl / (long)divisor;
            r = wl - ql * (long)divisor;
            x1 = qh << 32 | ql;
            wh = r << 31 | x0 >>> 32;
            qh = wh / (long)divisor;
            r = wh - qh * (long)divisor;
            wl = r << 32 | x0 & 0xFFFFFFFFL;
            ql = wl / (long)divisor;
            x0 = qh << 32 | ql;
            n += i;
            pow2 -= i;
        }
        return MathLib.toDoublePow2(x1, pow2);
    }

    public static long toLongPow2(double d, int n) {
        long bits = Double.doubleToLongBits(d);
        boolean isNegative = bits >> 63 != 0L;
        int exp = (int)(bits >> 52) & 0x7FF;
        long m = bits & 0xFFFFFFFFFFFFFL;
        if (exp == 2047) {
            throw new ArithmeticException("Cannot convert to long (Infinity or NaN)");
        }
        if (exp == 0) {
            if (m == 0L) {
                return 0L;
            }
            return MathLib.toLongPow2(d * 1.8014398509481984E16, n - 54);
        }
        m |= 0x10000000000000L;
        long shift = (long)exp - 1023L - 52L + (long)n;
        if (shift <= -64L) {
            return 0L;
        }
        if (shift >= 11L) {
            throw new ArithmeticException("Cannot convert to long (overflow)");
        }
        m = shift >= 0L ? m << (int)shift : (m >> (int)(-shift)) + (m >> (int)(-(shift + 1L)) & 1L);
        return isNegative ? -m : m;
    }

    public static long toLongPow10(double d, int n) {
        long bits = Double.doubleToLongBits(d);
        boolean isNegative = bits >> 63 != 0L;
        int exp = (int)(bits >> 52) & 0x7FF;
        long m = bits & 0xFFFFFFFFFFFFFL;
        if (exp == 2047) {
            throw new ArithmeticException("Cannot convert to long (Infinity or NaN)");
        }
        if (exp == 0) {
            if (m == 0L) {
                return 0L;
            }
            return MathLib.toLongPow10(d * 1.0E16, n - 16);
        }
        m |= 0x10000000000000L;
        int pow2 = exp - 1023 - 52;
        if (n >= 0) {
            long x0 = 0L;
            long x1 = 0L;
            long x2 = m & 0xFFFFFFFFL;
            long x3 = m >>> 32;
            while (n != 0) {
                int i = n >= POW5_INT.length ? POW5_INT.length - 1 : n;
                int coef = POW5_INT[i];
                if ((int)x0 != 0) {
                    x0 *= (long)coef;
                }
                if ((int)x1 != 0) {
                    x1 *= (long)coef;
                }
                x2 *= (long)coef;
                x3 *= (long)coef;
                x1 &= 0xFFFFFFFFL;
                x2 &= 0xFFFFFFFFL;
                pow2 += i;
                n -= i;
                long carry = (x3 += (x2 += (x1 += (x0 &= 0xFFFFFFFFL) >>> 32) >>> 32) >>> 32) >>> 32;
                if (carry == 0L) continue;
                x0 = x1;
                x1 = x2;
                x2 = x3 & 0xFFFFFFFFL;
                x3 = carry;
                pow2 += 32;
            }
            int shift = 31 - MathLib.bitLength(x3);
            pow2 -= shift;
            m = shift < 0 ? x3 << 31 | x2 >>> 1 : (x3 << 32 | x2) << shift | x1 >>> 32 - shift;
        } else {
            long x1 = m;
            long x0 = 0L;
            while (true) {
                int shift = 63 - MathLib.bitLength(x1);
                x1 <<= shift;
                x1 |= x0 >>> 63 - shift;
                x0 = x0 << shift & Long.MAX_VALUE;
                pow2 -= shift;
                if (n == 0) break;
                int i = -n >= POW5_INT.length ? POW5_INT.length - 1 : -n;
                int divisor = POW5_INT[i];
                long wh = x1 >>> 32;
                long qh = wh / (long)divisor;
                long r = wh - qh * (long)divisor;
                long wl = r << 32 | x1 & 0xFFFFFFFFL;
                long ql = wl / (long)divisor;
                r = wl - ql * (long)divisor;
                x1 = qh << 32 | ql;
                wh = r << 31 | x0 >>> 32;
                qh = wh / (long)divisor;
                r = wh - qh * (long)divisor;
                wl = r << 32 | x0 & 0xFFFFFFFFL;
                ql = wl / (long)divisor;
                x0 = qh << 32 | ql;
                n += i;
                pow2 -= i;
            }
            m = x1;
        }
        if (pow2 > 0) {
            throw new ArithmeticException("Overflow");
        }
        if (pow2 < -63) {
            return 0L;
        }
        m = (m >> -pow2) + (m >> -(pow2 + 1) & 1L);
        return isNegative ? -m : m;
    }

    public static int floorLog2(double d) {
        if (d <= 0.0) {
            throw new ArithmeticException("Negative number or zero");
        }
        long bits = Double.doubleToLongBits(d);
        int exp = (int)(bits >> 52) & 0x7FF;
        if (exp == 2047) {
            throw new ArithmeticException("Infinity or NaN");
        }
        if (exp == 0) {
            return MathLib.floorLog2(d * 1.8014398509481984E16) - 54;
        }
        return exp - 1023;
    }

    public static int floorLog10(double d) {
        int guess = (int)(0.3010299956639812 * (double)MathLib.floorLog2(d));
        double pow10 = MathLib.toDoublePow10(1L, guess);
        if (pow10 <= d && pow10 * 10.0 > d) {
            return guess;
        }
        if (pow10 > d) {
            return guess - 1;
        }
        return guess + 1;
    }

    public static double toRadians(double degrees) {
        return degrees * (Math.PI / 180);
    }

    public static double toDegrees(double radians) {
        return radians * 57.29577951308232;
    }

    public static double sqrt(double x) {
        return Math.sqrt(x);
    }

    public static double rem(double x, double y) {
        double tmp = x / y;
        if (MathLib.abs(tmp) <= 9.223372036854776E18) {
            return x - (double)MathLib.round(tmp) * y;
        }
        return Double.NaN;
    }

    public static double ceil(double x) {
        return Math.ceil(x);
    }

    public static double floor(double x) {
        return Math.floor(x);
    }

    public static double sin(double radians) {
        return Math.sin(radians);
    }

    public static double cos(double radians) {
        return Math.cos(radians);
    }

    public static double tan(double radians) {
        return Math.tan(radians);
    }

    public static double asin(double x) {
        if (x < -1.0 || x > 1.0) {
            return Double.NaN;
        }
        if (x == -1.0) {
            return -1.5707963267948966;
        }
        if (x == 1.0) {
            return 1.5707963267948966;
        }
        return MathLib.atan(x / MathLib.sqrt(1.0 - x * x));
    }

    public static double acos(double x) {
        return 1.5707963267948966 - MathLib.asin(x);
    }

    public static double atan(double x) {
        return MathLib._atan(x);
    }

    public static double atan2(double y, double x) {
        double epsilon = 1.0E-128;
        if (MathLib.abs(x) > 1.0E-128) {
            double temp = MathLib.atan(MathLib.abs(y) / MathLib.abs(x));
            if (x < 0.0) {
                temp = Math.PI - temp;
            }
            if (y < 0.0) {
                temp = Math.PI * 2 - temp;
            }
            return temp;
        }
        if (y > 1.0E-128) {
            return 1.5707963267948966;
        }
        if (y < -1.0E-128) {
            return 4.71238898038469;
        }
        return 0.0;
    }

    public static double sinh(double x) {
        return (MathLib.exp(x) - MathLib.exp(-x)) * 0.5;
    }

    public static double cosh(double x) {
        return (MathLib.exp(x) + MathLib.exp(-x)) * 0.5;
    }

    public static double tanh(double x) {
        return (MathLib.exp(2.0 * x) - 1.0) / (MathLib.exp(2.0 * x) + 1.0);
    }

    public static double exp(double x) {
        return MathLib._ieee754_exp(x);
    }

    public static double log(double x) {
        return MathLib._ieee754_log(x);
    }

    public static double log10(double x) {
        return MathLib.log(x) * INV_LOG10;
    }

    public static double pow(double x, double y) {
        return Math.pow(x, y);
    }

    public static int round(float f) {
        return (int)MathLib.floor(f + 0.5f);
    }

    public static long round(double d) {
        return (long)MathLib.floor(d + 0.5);
    }

    public static double random() {
        return (double)MathLib.random(0, Integer.MAX_VALUE) * 4.656612873077393E-10;
    }

    public static int abs(int i) {
        return i < 0 ? -i : i;
    }

    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static float abs(float f) {
        return f < 0.0f ? -f : f;
    }

    public static double abs(double d) {
        return d < 0.0 ? -d : d;
    }

    public static int max(int x, int y) {
        return x >= y ? x : y;
    }

    public static long max(long x, long y) {
        return x >= y ? x : y;
    }

    public static float max(float x, float y) {
        return x >= y ? x : y;
    }

    public static double max(double x, double y) {
        return x >= y ? x : y;
    }

    public static int min(int x, int y) {
        return x < y ? x : y;
    }

    public static long min(long x, long y) {
        return x < y ? x : y;
    }

    public static float min(float x, float y) {
        return x < y ? x : y;
    }

    public static double min(double x, double y) {
        return x < y ? x : y;
    }

    static double _atan(double x) {
        int id;
        long xBits = Double.doubleToLongBits(x);
        int __HIx = (int)(xBits >> 32);
        int __LOx = (int)xBits;
        int hx = __HIx;
        int ix = hx & Integer.MAX_VALUE;
        if (ix >= 0x44100000) {
            if (ix > 0x7FF00000 || ix == 0x7FF00000 && __LOx != 0) {
                return x + x;
            }
            if (hx > 0) {
                return atanhi[3] + atanlo[3];
            }
            return -atanhi[3] - atanlo[3];
        }
        if (ix < 1071382528) {
            if (ix < 1042284544 && 1.0E300 + x > 1.0) {
                return x;
            }
            id = -1;
        } else {
            x = MathLib.abs(x);
            if (ix < 0x3FF30000) {
                if (ix < 1072037888) {
                    id = 0;
                    x = (2.0 * x - 1.0) / (2.0 + x);
                } else {
                    id = 1;
                    x = (x - 1.0) / (x + 1.0);
                }
            } else if (ix < 1073971200) {
                id = 2;
                x = (x - 1.5) / (1.0 + 1.5 * x);
            } else {
                id = 3;
                x = -1.0 / x;
            }
        }
        double z = x * x;
        double w = z * z;
        double s1 = z * (aT[0] + w * (aT[2] + w * (aT[4] + w * (aT[6] + w * (aT[8] + w * aT[10])))));
        double s2 = w * (aT[1] + w * (aT[3] + w * (aT[5] + w * (aT[7] + w * aT[9]))));
        if (id < 0) {
            return x - x * (s1 + s2);
        }
        z = atanhi[id] - (x * (s1 + s2) - atanlo[id] - x);
        return hx < 0 ? -z : z;
    }

    static double _ieee754_log(double x) {
        long xBits = Double.doubleToLongBits(x);
        int hx = (int)(xBits >> 32);
        int lx = (int)xBits;
        int k = 0;
        if (hx < 0x100000) {
            if ((hx & Integer.MAX_VALUE | lx) == 0) {
                return Double.NEGATIVE_INFINITY;
            }
            if (hx < 0) {
                return (x - x) / 0.0;
            }
            k -= 54;
            xBits = Double.doubleToLongBits(x *= 1.8014398509481984E16);
            hx = (int)(xBits >> 32);
        }
        if (hx >= 0x7FF00000) {
            return x + x;
        }
        k += (hx >> 20) - 1023;
        int i = (hx &= 0xFFFFF) + 614244 & 0x100000;
        xBits = Double.doubleToLongBits(x);
        int HIx = hx | i ^ 0x3FF00000;
        xBits = ((long)HIx & 0xFFFFFFFFL) << 32 | xBits & 0xFFFFFFFFL;
        x = Double.longBitsToDouble(xBits);
        k += i >> 20;
        double f = x - 1.0;
        if ((0xFFFFF & 2 + hx) < 3) {
            if (f == 0.0) {
                if (k == 0) {
                    return 0.0;
                }
                double dk = k;
                return dk * 0.6931471803691238 + dk * 1.9082149292705877E-10;
            }
            double R = f * f * (0.5 - 0.3333333333333333 * f);
            if (k == 0) {
                return f - R;
            }
            double dk = k;
            return dk * 0.6931471803691238 - (R - dk * 1.9082149292705877E-10 - f);
        }
        double s = f / (2.0 + f);
        double dk = k;
        double z = s * s;
        i = hx - 398458;
        double w = z * z;
        int j = 440401 - hx;
        double t1 = w * (0.3999999999940942 + w * (0.22222198432149784 + w * 0.15313837699209373));
        double t2 = z * (0.6666666666666735 + w * (0.2857142874366239 + w * (0.1818357216161805 + w * 0.14798198605116586)));
        double R = t2 + t1;
        if ((i |= j) > 0) {
            double hfsq = 0.5 * f * f;
            if (k == 0) {
                return f - (hfsq - s * (hfsq + R));
            }
            return dk * 0.6931471803691238 - (hfsq - (s * (hfsq + R) + dk * 1.9082149292705877E-10) - f);
        }
        if (k == 0) {
            return f - s * (f - R);
        }
        return dk * 0.6931471803691238 - (s * (f - R) - dk * 1.9082149292705877E-10 - f);
    }

    static double _ieee754_exp(double x) {
        double t;
        double hi = 0.0;
        double lo = 0.0;
        int k = 0;
        long xBits = Double.doubleToLongBits(x);
        int __HIx = (int)(xBits >> 32);
        int __LOx = (int)xBits;
        int hx = __HIx;
        int xsb = hx >> 31 & 1;
        if ((hx &= Integer.MAX_VALUE) >= 1082535490) {
            if (hx >= 0x7FF00000) {
                if ((hx & 0xFFFFF | __LOx) != 0) {
                    return x + x;
                }
                return xsb == 0 ? x : 0.0;
            }
            if (x > 709.782712893384) {
                return Double.POSITIVE_INFINITY;
            }
            if (x < -745.1332191019411) {
                return 0.0;
            }
        }
        if (hx > 1071001154) {
            if (hx < 1072734898) {
                hi = x - ln2HI[xsb];
                lo = ln2LO[xsb];
                k = 1 - xsb - xsb;
            } else {
                k = (int)(1.4426950408889634 * x + halF[xsb]);
                t = k;
                hi = x - t * ln2HI[0];
                lo = t * ln2LO[0];
            }
            x = hi - lo;
        } else if (hx < 0x3E300000) {
            if (1.0E300 + x > 1.0) {
                return 1.0 + x;
            }
        } else {
            k = 0;
        }
        t = x * x;
        double c = x - t * (0.16666666666666602 + t * (-0.0027777777777015593 + t * (6.613756321437934E-5 + t * (-1.6533902205465252E-6 + t * 4.1381367970572385E-8))));
        if (k == 0) {
            return 1.0 - (x * c / (c - 2.0) - x);
        }
        double y = 1.0 - (lo - x * c / (2.0 - c) - hi);
        long yBits = Double.doubleToLongBits(y);
        int __HIy = (int)(yBits >> 32);
        if (k >= -1021) {
            yBits = ((long)(__HIy += k << 20) & 0xFFFFFFFFL) << 32 | yBits & 0xFFFFFFFFL;
            y = Double.longBitsToDouble(yBits);
            return y;
        }
        yBits = ((long)(__HIy += k + 1000 << 20) & 0xFFFFFFFFL) << 32 | yBits & 0xFFFFFFFFL;
        y = Double.longBitsToDouble(yBits);
        return y * 9.332636185032189E-302;
    }
}

