/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.javolution.context;

import java.util.Map;
import org.apache.hive.javolution.context.Context;
import org.apache.hive.javolution.util.FastCollection;
import org.apache.hive.javolution.util.FastMap;
import org.apache.hive.javolution.xml.XMLFormat;
import org.apache.hive.javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentContext
extends Context {
    private static PersistentContext _PersistentContext = new PersistentContext();
    private final FastMap _idToValue = new FastMap();
    static final XMLFormat PERSISTENT_CONTEXT_XML = new XMLFormat(PersistentContext.class){

        public void read(XMLFormat.InputElement xml, Object obj) throws XMLStreamException {
            PersistentContext ctx = (PersistentContext)obj;
            ctx.getIdToValue().putAll((FastMap)xml.get("References"));
        }

        public void write(Object obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            PersistentContext ctx = (PersistentContext)obj;
            xml.add(ctx.getIdToValue(), "References");
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCurrentPersistentContext(PersistentContext ctx) {
        _PersistentContext = ctx;
        FastMap fastMap = Reference.INSTANCES;
        synchronized (fastMap) {
            FastCollection.Record e = Reference.INSTANCES.head();
            FastMap.Entry end = Reference.INSTANCES.tail();
            while ((e = ((FastMap.Entry)e).getNext()) != end) {
                Reference reference = (Reference)((FastMap.Entry)e).getValue();
                if (!ctx._idToValue.containsKey(reference._id)) continue;
                reference.set(ctx._idToValue.get(reference._id));
            }
        }
    }

    public static PersistentContext getCurrentPersistentContext() {
        return _PersistentContext;
    }

    public Map<String, Object> getIdToValue() {
        return this._idToValue;
    }

    @Override
    protected void enterAction() {
        throw new UnsupportedOperationException("Cannot enter persistent context (already in)");
    }

    @Override
    protected void exitAction() {
        throw new UnsupportedOperationException("Cannot exit persistent context (always in)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reference<T>
    implements org.apache.hive.javolution.lang.Reference<T> {
        private static final FastMap INSTANCES = new FastMap();
        private final String _id;
        private T _value;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reference(String id, T defaultValue) {
            this._id = id;
            this._value = defaultValue;
            FastMap fastMap = INSTANCES;
            synchronized (fastMap) {
                if (INSTANCES.containsKey(id)) {
                    throw new IllegalArgumentException("Identifier " + id + " already in use");
                }
                INSTANCES.put(id, this);
            }
            if (_PersistentContext._idToValue.containsKey(id)) {
                this.set(_PersistentContext._idToValue.get(id));
            } else {
                _PersistentContext._idToValue.put(id, defaultValue);
            }
        }

        @Override
        public T get() {
            return this._value;
        }

        @Override
        public void set(T value) {
            this._value = value;
            this.notifyChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMinimum(T value) {
            Reference reference = this;
            synchronized (reference) {
                if (value instanceof Comparable) {
                    T prevValue = this.get();
                    if (((Comparable)value).compareTo(prevValue) > 0) {
                        this.set(value);
                    }
                } else if (value instanceof Integer) {
                    T prevValue = this.get();
                    if ((Integer)value > (Integer)prevValue) {
                        this.set(value);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMaximum(T value) {
            Reference reference = this;
            synchronized (reference) {
                if (value instanceof Comparable) {
                    T prevValue = this.get();
                    if (((Comparable)value).compareTo(prevValue) < 0) {
                        this.set(value);
                    }
                } else if (value instanceof Integer) {
                    T prevValue = this.get();
                    if ((Integer)value < (Integer)prevValue) {
                        this.set(value);
                    }
                } else {
                    throw new IllegalArgumentException();
                }
            }
        }

        public String toString() {
            return String.valueOf(this.get());
        }

        protected void notifyChange() {
        }
    }
}

