/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.javolution.context;

import javax.realtime.MemoryArea;
import javax.realtime.RealtimeThread;
import org.apache.hive.javolution.context.ConcurrentContext;
import org.apache.hive.javolution.context.ConcurrentException;
import org.apache.hive.javolution.lang.Reflection;

class ConcurrentThread
extends RealtimeThread {
    private volatile Runnable _logic;
    private MemoryArea _memoryArea;
    private int _priority;
    private ConcurrentContext.Default _context;
    private boolean _terminate;
    private String _name = "ConcurrentThread-" + this.getCount();
    private Thread _parent;
    private static int _Count;
    private static final Reflection.Method SET_NAME;
    private static final Reflection.Method SET_DAEMON;

    public ConcurrentThread() {
        if (SET_NAME != null) {
            SET_NAME.invoke((Object)this, (Object)this._name);
        }
        if (SET_DAEMON != null) {
            SET_DAEMON.invoke((Object)this, (Object)Boolean.TRUE);
        }
    }

    private synchronized int getCount() {
        return _Count++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run() {
        while (true) {
            ConcurrentThread concurrentThread = this;
            synchronized (concurrentThread) {
                try {
                    while (this._logic == null && !this._terminate) {
                        this.wait();
                    }
                }
                catch (InterruptedException e) {
                    throw new ConcurrentException(e);
                }
            }
            if (this._terminate) return;
            try {
                Thread current = Thread.currentThread();
                if (current.getPriority() != this._priority) {
                    current.setPriority(this._priority);
                }
                this._context.started();
                this._memoryArea.executeInArea(this._logic);
                continue;
            }
            catch (Throwable error) {
                this._context.error(error);
                continue;
            }
            finally {
                this._context.completed();
                this._parent = null;
                this._context = null;
                this._logic = null;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Runnable logic, ConcurrentContext.Default context) {
        if (this._logic != null) {
            return false;
        }
        ConcurrentThread concurrentThread = this;
        synchronized (concurrentThread) {
            if (this._logic != null) {
                return false;
            }
            this._memoryArea = RealtimeThread.getCurrentMemoryArea();
            this._parent = Thread.currentThread();
            this._priority = this._parent.getPriority();
            this._context = context;
            this._logic = logic;
            this.notify();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        ConcurrentThread concurrentThread = this;
        synchronized (concurrentThread) {
            this._terminate = true;
            this.notify();
        }
    }

    public String toString() {
        return this._name + " from " + this.getSource();
    }

    public Thread getSource() {
        return this._parent instanceof ConcurrentThread ? ((ConcurrentThread)this._parent).getSource() : this._parent;
    }

    static {
        SET_NAME = Reflection.getInstance().getMethod("java.lang.Thread.setName(String)");
        SET_DAEMON = Reflection.getInstance().getMethod("java.lang.Thread.setDaemon(boolean)");
    }
}

