/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.scheduler;

import java.util.concurrent.CancellationException;
import org.apache.hive.com.google.common.util.concurrent.FutureCallback;
import org.apache.hive.org.slf4j.Logger;

public final class LoggingFutureCallback
implements FutureCallback<Void> {
    private final String componentName;
    private final Logger LOG;

    public LoggingFutureCallback(String componentName, Logger log) {
        this.componentName = componentName;
        this.LOG = log;
    }

    @Override
    public void onSuccess(Void result) {
        this.LOG.info("{} exited", (Object)this.componentName);
    }

    @Override
    public void onFailure(Throwable t) {
        if (t instanceof CancellationException) {
            this.LOG.info("{} was cancelled", (Object)this.componentName, (Object)t.getMessage());
        } else {
            this.LOG.warn("{} exited with error", (Object)this.componentName, (Object)t);
        }
    }
}

