/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.helpers;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.protocol.LlapTaskUmbilicalProtocol;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.tez.common.security.JobTokenIdentifier;
import org.apache.tez.common.security.JobTokenSecretManager;

public class LlapTaskUmbilicalServer {
    private static final Logger LOG = LoggerFactory.getLogger(LlapTaskUmbilicalServer.class);
    protected volatile Server server;
    private final InetSocketAddress address;
    private final AtomicBoolean started = new AtomicBoolean(true);

    public LlapTaskUmbilicalServer(Configuration conf, LlapTaskUmbilicalProtocol umbilical, int numHandlers, String tokenIdentifier, Token<JobTokenIdentifier> token) throws IOException {
        JobTokenSecretManager jobTokenSecretManager = new JobTokenSecretManager();
        jobTokenSecretManager.addTokenForJob(tokenIdentifier, token);
        this.server = new RPC.Builder(conf).setProtocol(LlapTaskUmbilicalProtocol.class).setBindAddress("0.0.0.0").setPort(0).setInstance((Object)umbilical).setNumHandlers(numHandlers).setSecretManager((SecretManager)jobTokenSecretManager).build();
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.server.refreshServiceAcl(conf, (PolicyProvider)new LlapUmbilicalExternalPolicyProvider());
        }
        this.server.start();
        this.address = NetUtils.getConnectAddress((Server)this.server);
        LOG.info("Started TaskUmbilicalServer: " + umbilical.getClass().getName() + " at address: " + this.address + " with numHandlers=" + numHandlers);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public void shutdownServer() {
        if (this.started.get()) {
            this.started.set(false);
            this.server.stop();
        }
    }

    public static class LlapUmbilicalExternalPolicyProvider
    extends PolicyProvider {
        private static final Service[] services = new Service[]{new Service("security.job.task.protocol.acl", LlapTaskUmbilicalProtocol.class)};

        public Service[] getServices() {
            return (Service[])services.clone();
        }
    }
}

