/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.security;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.llap.security.LlapTokenIdentifier;
import org.apache.hadoop.hive.llap.security.LlapTokenLocalClient;
import org.apache.hadoop.hive.llap.security.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;

public class LlapTokenLocalClientImpl
implements LlapTokenLocalClient {
    private static final Logger LOG = LoggerFactory.getLogger(LlapTokenLocalClientImpl.class);
    private final SecretManager secretManager;

    public LlapTokenLocalClientImpl(Configuration conf, String clusterId) {
        this.secretManager = SecretManager.createSecretManager(conf, clusterId);
    }

    @Override
    public Token<LlapTokenIdentifier> createToken(String appId, String user, boolean isSignatureRequired) throws IOException {
        try {
            Token<LlapTokenIdentifier> token = this.secretManager.createLlapToken(appId, user, isSignatureRequired);
            if (LOG.isInfoEnabled()) {
                LOG.info("Created a LLAP delegation token locally: " + token);
            }
            return token;
        }
        catch (Exception ex) {
            throw ex instanceof IOException ? (IOException)ex : new IOException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.secretManager.stopThreads();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

