/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.io.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.management.ObjectName;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.io.Allocator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.cache.BuddyAllocator;
import org.apache.hadoop.hive.llap.cache.BufferUsageManager;
import org.apache.hadoop.hive.llap.cache.EvictionDispatcher;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.LowLevelCacheMemoryManager;
import org.apache.hadoop.hive.llap.cache.LowLevelCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelFifoCachePolicy;
import org.apache.hadoop.hive.llap.cache.LowLevelLrfuCachePolicy;
import org.apache.hadoop.hive.llap.cache.SerDeLowLevelCacheImpl;
import org.apache.hadoop.hive.llap.cache.SimpleAllocator;
import org.apache.hadoop.hive.llap.cache.SimpleBufferManager;
import org.apache.hadoop.hive.llap.daemon.impl.LlapDaemon;
import org.apache.hadoop.hive.llap.daemon.impl.StatsRecordingThreadPool;
import org.apache.hadoop.hive.llap.io.api.LlapIo;
import org.apache.hadoop.hive.llap.io.api.impl.LlapInputFormat;
import org.apache.hadoop.hive.llap.io.decode.ColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.GenericColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.decode.OrcColumnVectorProducer;
import org.apache.hadoop.hive.llap.io.metadata.OrcMetadataCache;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonCacheMetrics;
import org.apache.hadoop.hive.llap.metrics.LlapDaemonIOMetrics;
import org.apache.hadoop.hive.llap.metrics.MetricsUtils;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hive.com.google.common.primitives.Ints;
import org.apache.hive.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;

public class LlapIoImpl
implements LlapIo<VectorizedRowBatch> {
    public static final Logger LOG = LoggerFactory.getLogger("LlapIoImpl");
    public static final Logger ORC_LOGGER = LoggerFactory.getLogger("LlapIoOrc");
    public static final Logger CACHE_LOGGER = LoggerFactory.getLogger("LlapIoCache");
    public static final Logger LOCKING_LOGGER = LoggerFactory.getLogger("LlapIoLocking");
    private static final String MODE_CACHE = "cache";
    private final ColumnVectorProducer orcCvp;
    private final ColumnVectorProducer genericCvp;
    private final ExecutorService executor;
    private final LlapDaemonCacheMetrics cacheMetrics;
    private final LlapDaemonIOMetrics ioMetrics;
    private ObjectName buddyAllocatorMXBean;
    private final Allocator allocator;

    /*
     * WARNING - void declaration
     */
    private LlapIoImpl(Configuration conf) throws IOException {
        void var11_17;
        String ioMode = HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_IO_MEMORY_MODE);
        boolean useLowLevelCache = MODE_CACHE.equalsIgnoreCase(ioMode);
        LOG.info("Initializing LLAP IO in {} mode", (Object)(useLowLevelCache ? MODE_CACHE : "none"));
        String displayName = "LlapDaemonCacheMetrics-" + MetricsUtils.getHostName();
        String sessionId = conf.get("llap.daemon.metrics.sessionid");
        this.cacheMetrics = LlapDaemonCacheMetrics.create(displayName, sessionId);
        displayName = "LlapDaemonIOMetrics-" + MetricsUtils.getHostName();
        Object[] strIntervals = HiveConf.getTrimmedStringsVar(conf, HiveConf.ConfVars.LLAP_IO_DECODING_METRICS_PERCENTILE_INTERVALS);
        ArrayList<Integer> intervalList = new ArrayList<Integer>();
        if (strIntervals != null) {
            for (String string : strIntervals) {
                try {
                    intervalList.add(Integer.valueOf(string));
                }
                catch (NumberFormatException e) {
                    LOG.warn("Ignoring IO decoding metrics interval {} from {} as it is invalid", (Object)string, (Object)Arrays.toString(strIntervals));
                }
            }
        }
        this.ioMetrics = LlapDaemonIOMetrics.create(displayName, sessionId, Ints.toArray(intervalList));
        LOG.info("Started llap daemon metrics with displayName: {} sessionId: {}", (Object)displayName, (Object)sessionId);
        OrcMetadataCache metadataCache = null;
        LowLevelCache cache = null;
        SerDeLowLevelCacheImpl serdeCache = null;
        Object var11_14 = null;
        boolean isEncodeEnabled = HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_IO_ENCODE_ENABLED);
        if (useLowLevelCache) {
            boolean isSplitCache;
            boolean useLrfu = HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_USE_LRFU);
            long totalMemorySize = HiveConf.getSizeVar(conf, HiveConf.ConfVars.LLAP_IO_MEMORY_MAX_SIZE);
            int minAllocSize = (int)HiveConf.getSizeVar(conf, HiveConf.ConfVars.LLAP_ALLOCATOR_MIN_ALLOC);
            float metadataFraction = HiveConf.getFloatVar(conf, HiveConf.ConfVars.LLAP_IO_METADATA_FRACTION);
            long metaMem = 0L;
            boolean bl = isSplitCache = metadataFraction > 0.0f;
            if (isSplitCache) {
                metaMem = (long)((float)LlapDaemon.getTotalHeapSize() * metadataFraction);
            }
            LowLevelCachePolicy cachePolicy = useLrfu ? new LowLevelLrfuCachePolicy(minAllocSize, totalMemorySize, conf) : new LowLevelFifoCachePolicy();
            LowLevelCacheMemoryManager memManager = new LowLevelCacheMemoryManager(totalMemorySize, cachePolicy, this.cacheMetrics);
            LowLevelCachePolicy metaCachePolicy = null;
            LowLevelCacheMemoryManager metaMemManager = null;
            if (isSplitCache) {
                metaCachePolicy = useLrfu ? new LowLevelLrfuCachePolicy(minAllocSize, metaMem, conf) : new LowLevelFifoCachePolicy();
                metaMemManager = new LowLevelCacheMemoryManager(metaMem, metaCachePolicy, this.cacheMetrics);
            } else {
                metaCachePolicy = cachePolicy;
                metaMemManager = memManager;
            }
            this.cacheMetrics.setCacheCapacityTotal(totalMemorySize + metaMem);
            BuddyAllocator allocator = new BuddyAllocator(conf, memManager, this.cacheMetrics);
            this.allocator = allocator;
            LowLevelCacheImpl cacheImpl = new LowLevelCacheImpl(this.cacheMetrics, cachePolicy, allocator, true);
            cache = cacheImpl;
            if (isEncodeEnabled) {
                SerDeLowLevelCacheImpl serdeCacheImpl;
                serdeCache = serdeCacheImpl = new SerDeLowLevelCacheImpl(this.cacheMetrics, cachePolicy, allocator);
            }
            boolean useGapCache = HiveConf.getBoolVar(conf, HiveConf.ConfVars.LLAP_CACHE_ENABLE_ORC_GAP_CACHE);
            metadataCache = new OrcMetadataCache(metaMemManager, metaCachePolicy, useGapCache);
            EvictionDispatcher e = new EvictionDispatcher(cache, serdeCache, metadataCache, allocator);
            if (isSplitCache) {
                metaCachePolicy.setEvictionListener(e);
            }
            cachePolicy.setEvictionListener(e);
            cachePolicy.setParentDebugDumper(cacheImpl);
            cacheImpl.startThreads();
            LowLevelCacheImpl lowLevelCacheImpl = cacheImpl;
        } else {
            SimpleBufferManager sbm;
            this.allocator = new SimpleAllocator(conf);
            SimpleBufferManager simpleBufferManager = sbm = new SimpleBufferManager(this.allocator, this.cacheMetrics);
            cache = sbm;
        }
        int numThreads = HiveConf.getIntVar(conf, HiveConf.ConfVars.LLAP_IO_THREADPOOL_SIZE);
        this.executor = new StatsRecordingThreadPool(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat("IO-Elevator-Thread-%d").setDaemon(true).build());
        this.orcCvp = new OrcColumnVectorProducer(metadataCache, cache, (BufferUsageManager)var11_17, conf, this.cacheMetrics, this.ioMetrics);
        this.genericCvp = isEncodeEnabled ? new GenericColumnVectorProducer(serdeCache, (BufferUsageManager)var11_17, conf, this.cacheMetrics, this.ioMetrics) : null;
        LOG.info("LLAP IO initialized");
        this.registerMXBeans();
    }

    private void registerMXBeans() {
        this.buddyAllocatorMXBean = MBeans.register((String)"LlapDaemon", (String)"BuddyAllocatorInfo", (Object)this.allocator);
    }

    @Override
    public InputFormat<NullWritable, VectorizedRowBatch> getInputFormat(InputFormat sourceInputFormat, Deserializer sourceSerDe) {
        ColumnVectorProducer cvp = this.genericCvp;
        if (sourceInputFormat instanceof OrcInputFormat) {
            cvp = this.orcCvp;
        } else if (cvp == null) {
            LOG.warn("LLAP encode is disabled; cannot use for " + sourceInputFormat.getClass());
            return null;
        }
        return new LlapInputFormat(sourceInputFormat, sourceSerDe, cvp, this.executor);
    }

    @Override
    public void close() {
        LOG.info("Closing LlapIoImpl..");
        if (this.buddyAllocatorMXBean != null) {
            MBeans.unregister((ObjectName)this.buddyAllocatorMXBean);
            this.buddyAllocatorMXBean = null;
        }
        this.executor.shutdownNow();
    }
}

