/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.counters;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hive.org.slf4j.Logger;
import org.apache.hive.org.slf4j.LoggerFactory;
import org.apache.tez.common.counters.TezCounters;

public class FragmentCountersMap {
    private static final Logger LOG = LoggerFactory.getLogger(FragmentCountersMap.class);
    private static final ConcurrentMap<String, TezCounters> perFragmentCounters = new ConcurrentHashMap<String, TezCounters>();

    public static void registerCountersForFragment(String identifier, TezCounters tezCounters) {
        if (perFragmentCounters.putIfAbsent(identifier, tezCounters) != null) {
            LOG.warn("Not registering duplicate counters for fragment with tez identifier string=" + identifier);
        }
    }

    public static TezCounters getCountersForFragment(String identifier) {
        return (TezCounters)perFragmentCounters.get(identifier);
    }

    public static void unregisterCountersForFragment(String identifier) {
        perFragmentCounters.remove(identifier);
    }
}

