/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.cache;

import org.apache.hadoop.hive.llap.cache.EvictionAwareAllocator;
import org.apache.hadoop.hive.llap.cache.EvictionListener;
import org.apache.hadoop.hive.llap.cache.LlapCacheableBuffer;
import org.apache.hadoop.hive.llap.cache.LlapDataBuffer;
import org.apache.hadoop.hive.llap.cache.LowLevelCache;
import org.apache.hadoop.hive.llap.cache.SerDeLowLevelCacheImpl;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileEstimateErrors;
import org.apache.hadoop.hive.llap.io.metadata.OrcFileMetadata;
import org.apache.hadoop.hive.llap.io.metadata.OrcMetadataCache;
import org.apache.hadoop.hive.llap.io.metadata.OrcStripeMetadata;

public final class EvictionDispatcher
implements EvictionListener {
    private final LowLevelCache dataCache;
    private final SerDeLowLevelCacheImpl serdeCache;
    private final OrcMetadataCache metadataCache;
    private final EvictionAwareAllocator allocator;

    public EvictionDispatcher(LowLevelCache dataCache, SerDeLowLevelCacheImpl serdeCache, OrcMetadataCache metadataCache, EvictionAwareAllocator allocator) {
        this.dataCache = dataCache;
        this.metadataCache = metadataCache;
        this.serdeCache = serdeCache;
        this.allocator = allocator;
    }

    @Override
    public void notifyEvicted(LlapCacheableBuffer buffer) {
        buffer.notifyEvicted(this);
    }

    public void notifyEvicted(LlapDataBuffer buffer) {
        this.dataCache.notifyEvicted(buffer);
        if (this.serdeCache != null) {
            this.serdeCache.notifyEvicted(buffer);
        }
        this.allocator.deallocateEvicted(buffer);
    }

    public void notifyEvicted(OrcFileMetadata buffer) {
        this.metadataCache.notifyEvicted(buffer);
    }

    public void notifyEvicted(OrcStripeMetadata buffer) {
        this.metadataCache.notifyEvicted(buffer);
    }

    public void notifyEvicted(OrcFileEstimateErrors buffer) {
        this.metadataCache.notifyEvicted(buffer);
    }
}

