/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.security.AuthMethod;
import org.apache.hadoop.hbase.security.HBaseSaslRpcClient;
import org.apache.hadoop.hbase.security.SaslStatus;
import org.apache.hadoop.hbase.security.SaslUtil;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
public class SaslClientHandler
extends ChannelDuplexHandler {
    public static final Log LOG = LogFactory.getLog(SaslClientHandler.class);
    private final boolean fallbackAllowed;
    private final UserGroupInformation ticket;
    private final SaslClient saslClient;
    private final SaslExceptionHandler exceptionHandler;
    private final SaslSuccessfulConnectHandler successfulConnectHandler;
    private byte[] saslToken;
    private boolean firstRead = true;
    private int retryCount = 0;
    private Random random;

    public SaslClientHandler(UserGroupInformation ticket, AuthMethod method, Token<? extends TokenIdentifier> token, String serverPrincipal, boolean fallbackAllowed, String rpcProtection, SaslExceptionHandler exceptionHandler, SaslSuccessfulConnectHandler successfulConnectHandler) throws IOException {
        this.ticket = ticket;
        this.fallbackAllowed = fallbackAllowed;
        this.exceptionHandler = exceptionHandler;
        this.successfulConnectHandler = successfulConnectHandler;
        SaslUtil.initSaslProperties(rpcProtection);
        switch (method) {
            case DIGEST: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating SASL " + AuthMethod.DIGEST.getMechanismName() + " client to authenticate to service at " + token.getService());
                }
                this.saslClient = this.createDigestSaslClient(new String[]{AuthMethod.DIGEST.getMechanismName()}, "default", new HBaseSaslRpcClient.SaslClientCallbackHandler(token));
                break;
            }
            case KERBEROS: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Creating SASL " + AuthMethod.KERBEROS.getMechanismName() + " client. Server's Kerberos principal name is " + serverPrincipal);
                }
                if (serverPrincipal == null || serverPrincipal.isEmpty()) {
                    throw new IOException("Failed to specify server's Kerberos principal name");
                }
                String[] names = SaslUtil.splitKerberosName(serverPrincipal);
                if (names.length != 3) {
                    throw new IOException("Kerberos principal does not have the expected format: " + serverPrincipal);
                }
                this.saslClient = this.createKerberosSaslClient(new String[]{AuthMethod.KERBEROS.getMechanismName()}, names[0], names[1]);
                break;
            }
            default: {
                throw new IOException("Unknown authentication method " + (Object)((Object)method));
            }
        }
        if (this.saslClient == null) {
            throw new IOException("Unable to find SASL client implementation");
        }
    }

    protected SaslClient createDigestSaslClient(String[] mechanismNames, String saslDefaultRealm, CallbackHandler saslClientCallbackHandler) throws IOException {
        return Sasl.createSaslClient(mechanismNames, null, null, saslDefaultRealm, SaslUtil.SASL_PROPS, saslClientCallbackHandler);
    }

    protected SaslClient createKerberosSaslClient(String[] mechanismNames, String userFirstPart, String userSecondPart) throws IOException {
        return Sasl.createSaslClient(mechanismNames, null, userFirstPart, userSecondPart, SaslUtil.SASL_PROPS, null);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        this.saslClient.dispose();
    }

    private byte[] evaluateChallenge(final byte[] challenge) throws Exception {
        return (byte[])this.ticket.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<byte[]>(){

            @Override
            public byte[] run() throws Exception {
                return SaslClientHandler.this.saslClient.evaluateChallenge(challenge);
            }
        });
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.saslToken = new byte[0];
        if (this.saslClient.hasInitialResponse()) {
            this.saslToken = this.evaluateChallenge(this.saslToken);
        }
        if (this.saslToken != null) {
            this.writeSaslToken(ctx, this.saslToken);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Have sent token of size " + this.saslToken.length + " from initSASLContext.");
            }
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf in = (ByteBuf)msg;
        if (!this.saslClient.isComplete()) {
            while (!this.saslClient.isComplete() && in.isReadable()) {
                SaslClientHandler.readStatus(in);
                int len = in.readInt();
                if (this.firstRead) {
                    this.firstRead = false;
                    if (len == -88) {
                        if (!this.fallbackAllowed) {
                            throw new IOException("Server asks us to fall back to SIMPLE auth, but this client is configured to only allow secure connections.");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Server asks us to fall back to simple auth.");
                        }
                        this.saslClient.dispose();
                        ctx.pipeline().remove((ChannelHandler)this);
                        this.successfulConnectHandler.onSuccess(ctx.channel());
                        return;
                    }
                }
                this.saslToken = new byte[len];
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Will read input token of size " + this.saslToken.length + " for processing by initSASLContext");
                }
                in.readBytes(this.saslToken);
                this.saslToken = this.evaluateChallenge(this.saslToken);
                if (this.saslToken == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Will send token of size " + this.saslToken.length + " from initSASLContext.");
                }
                this.writeSaslToken(ctx, this.saslToken);
            }
            if (this.saslClient.isComplete()) {
                boolean useWrap;
                String qop = (String)this.saslClient.getNegotiatedProperty("javax.security.sasl.qop");
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SASL client context established. Negotiated QoP: " + qop);
                }
                boolean bl = useWrap = qop != null && !"auth".equalsIgnoreCase(qop);
                if (!useWrap) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
                this.successfulConnectHandler.onSuccess(ctx.channel());
            }
        } else {
            try {
                int length = in.readInt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Actual length is " + length);
                }
                this.saslToken = new byte[length];
                in.readBytes(this.saslToken);
            }
            catch (IndexOutOfBoundsException e) {
                return;
            }
            try {
                ByteBuf b = ctx.channel().alloc().buffer(this.saslToken.length);
                b.writeBytes(this.saslClient.unwrap(this.saslToken, 0, this.saslToken.length));
                ctx.fireChannelRead((Object)b);
            }
            catch (SaslException se) {
                try {
                    this.saslClient.dispose();
                }
                catch (SaslException ignored) {
                    LOG.debug("Ignoring SASL exception", ignored);
                }
                throw se;
            }
        }
    }

    private void writeSaslToken(final ChannelHandlerContext ctx, byte[] saslToken) {
        ByteBuf b = ctx.alloc().buffer(4 + saslToken.length);
        b.writeInt(saslToken.length);
        b.writeBytes(saslToken, 0, saslToken.length);
        ctx.writeAndFlush((Object)b).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    SaslClientHandler.this.exceptionCaught(ctx, future.cause());
                }
            }
        });
    }

    private static void readStatus(ByteBuf inStream) throws RemoteException {
        int status2 = inStream.readInt();
        if (status2 != SaslStatus.SUCCESS.state) {
            throw new RemoteException(inStream.toString(Charset.forName("UTF-8")), inStream.toString(Charset.forName("UTF-8")));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        this.saslClient.dispose();
        ctx.close();
        if (this.random == null) {
            this.random = new Random();
        }
        this.exceptionHandler.handle(this.retryCount++, this.random, cause);
    }

    public void write(final ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (!this.saslClient.isComplete()) {
            super.write(ctx, msg, promise);
        } else {
            ByteBuf in = (ByteBuf)msg;
            try {
                this.saslToken = this.saslClient.wrap(in.array(), in.readerIndex(), in.readableBytes());
            }
            catch (SaslException se) {
                try {
                    this.saslClient.dispose();
                }
                catch (SaslException ignored) {
                    LOG.debug("Ignoring SASL exception", ignored);
                }
                promise.setFailure((Throwable)se);
            }
            if (this.saslToken != null) {
                ByteBuf out = ctx.channel().alloc().buffer(4 + this.saslToken.length);
                out.writeInt(this.saslToken.length);
                out.writeBytes(this.saslToken, 0, this.saslToken.length);
                ctx.write((Object)out).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            SaslClientHandler.this.exceptionCaught(ctx, future.cause());
                        }
                    }
                });
                this.saslToken = null;
            }
        }
    }

    public static interface SaslSuccessfulConnectHandler {
        public void onSuccess(Channel var1);
    }

    public static interface SaslExceptionHandler {
        public void handle(int var1, Random var2, Throwable var3);
    }
}

