/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.master;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.cleaner.BaseLogCleanerDelegate;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationQueuesClient;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hive.com.google.common.base.Predicate;
import org.apache.hive.com.google.common.collect.ImmutableSet;
import org.apache.hive.com.google.common.collect.Iterables;
import org.apache.hive.com.google.common.collect.Sets;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class ReplicationLogCleaner
extends BaseLogCleanerDelegate
implements Abortable {
    private static final Log LOG = LogFactory.getLog(ReplicationLogCleaner.class);
    private ZooKeeperWatcher zkw;
    private ReplicationQueuesClient replicationQueues;
    private boolean stopped = false;
    private boolean aborted;

    @Override
    public Iterable<FileStatus> getDeletableFiles(Iterable<FileStatus> files) {
        if (this.getConf() == null) {
            return files;
        }
        final Set<String> wals = this.loadWALsFromQueues();
        return Iterables.filter(files, new Predicate<FileStatus>(){

            @Override
            public boolean apply(FileStatus file) {
                String wal = file.getPath().getName();
                boolean logInReplicationQueue = wals.contains(wal);
                if (LOG.isDebugEnabled()) {
                    if (logInReplicationQueue) {
                        LOG.debug("Found log in ZK, keeping: " + wal);
                    } else {
                        LOG.debug("Didn't find this log in ZK, deleting: " + wal);
                    }
                }
                return !logInReplicationQueue;
            }
        });
    }

    private Set<String> loadWALsFromQueues() {
        List<String> rss = this.replicationQueues.getListOfReplicators();
        if (rss == null) {
            LOG.debug("Didn't find any region server that replicates, won't prevent any deletions.");
            return ImmutableSet.of();
        }
        HashSet<String> wals = Sets.newHashSet();
        for (String rs : rss) {
            List<String> listOfPeers = this.replicationQueues.getAllQueues(rs);
            if (listOfPeers == null) continue;
            for (String id : listOfPeers) {
                List<String> peersWals = this.replicationQueues.getLogsInQueue(rs, id);
                if (peersWals == null) continue;
                wals.addAll(peersWals);
            }
        }
        return wals;
    }

    @Override
    public void setConf(Configuration config) {
        if (!config.getBoolean("hbase.replication", true)) {
            LOG.warn("Not configured - allowing all wals to be deleted");
            return;
        }
        Configuration conf = new Configuration(config);
        super.setConf(conf);
        try {
            this.zkw = new ZooKeeperWatcher(conf, "replicationLogCleaner", null);
            this.replicationQueues = ReplicationFactory.getReplicationQueuesClient(this.zkw, conf, this);
            this.replicationQueues.init();
        }
        catch (ReplicationException e) {
            LOG.error("Error while configuring " + this.getClass().getName(), e);
        }
        catch (IOException e) {
            LOG.error("Error while configuring " + this.getClass().getName(), e);
        }
    }

    @Override
    public void stop(String why) {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        if (this.zkw != null) {
            LOG.info("Stopping " + this.zkw);
            this.zkw.close();
        }
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void abort(String why, Throwable e) {
        LOG.warn("Aborting ReplicationLogCleaner because " + why, e);
        this.aborted = true;
        this.stop(why);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }
}

