/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWALSource;
import org.apache.hadoop.hbase.regionserver.wal.WALActionsListener;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
public class MetricsWAL
extends WALActionsListener.Base {
    static final Log LOG = LogFactory.getLog(MetricsWAL.class);
    private final MetricsWALSource source;

    public MetricsWAL() {
        this(CompatibilitySingletonFactory.getInstance(MetricsWALSource.class));
    }

    @VisibleForTesting
    MetricsWAL(MetricsWALSource s) {
        this.source = s;
    }

    @Override
    public void postSync(long timeInNanos, int handlerSyncs) {
        this.source.incrementSyncTime(timeInNanos / 1000000L);
    }

    @Override
    public void postAppend(long size, long time) {
        this.source.incrementAppendCount();
        this.source.incrementAppendTime(time);
        this.source.incrementAppendSize(size);
        if (time > 1000L) {
            this.source.incrementSlowAppendCount();
            LOG.warn(String.format("%s took %d ms appending an edit to wal; len~=%s", Thread.currentThread().getName(), time, StringUtils.humanReadableInt((long)size)));
        }
    }

    @Override
    public void logRollRequested(boolean underReplicated) {
        this.source.incrementLogRollRequested();
        if (underReplicated) {
            this.source.incrementLowReplicationLogRoll();
        }
    }
}

