/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.RSRpcServices;
import org.apache.hadoop.hbase.regionserver.StoreConfigInformation;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreUtils;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionPolicy;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.com.google.common.base.Predicate;
import org.apache.hive.com.google.common.collect.Collections2;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
public class RatioBasedCompactionPolicy
extends CompactionPolicy {
    private static final Log LOG = LogFactory.getLog(RatioBasedCompactionPolicy.class);
    private final Random random = new Random();

    public RatioBasedCompactionPolicy(Configuration conf, StoreConfigInformation storeConfigInfo) {
        super(conf, storeConfigInfo);
    }

    private ArrayList<StoreFile> getCurrentEligibleFiles(ArrayList<StoreFile> candidateFiles, List<StoreFile> filesCompacting) {
        if (!filesCompacting.isEmpty()) {
            StoreFile last = filesCompacting.get(filesCompacting.size() - 1);
            int idx = candidateFiles.indexOf(last);
            Preconditions.checkArgument(idx != -1);
            candidateFiles.subList(0, idx + 1).clear();
        }
        return candidateFiles;
    }

    public List<StoreFile> preSelectCompactionForCoprocessor(Collection<StoreFile> candidates, List<StoreFile> filesCompacting) {
        return this.getCurrentEligibleFiles(new ArrayList<StoreFile>(candidates), filesCompacting);
    }

    public CompactionRequest selectCompaction(Collection<StoreFile> candidateFiles, List<StoreFile> filesCompacting, boolean isUserCompaction, boolean mayUseOffPeak, boolean forceMajor) throws IOException {
        boolean isAllFiles;
        ArrayList<StoreFile> candidateSelection = new ArrayList<StoreFile>(candidateFiles);
        int futureFiles = filesCompacting.isEmpty() ? 0 : 1;
        boolean mayBeStuck = (long)(candidateFiles.size() - filesCompacting.size() + futureFiles) >= this.storeConfigInfo.getBlockingFileCount();
        candidateSelection = this.getCurrentEligibleFiles(candidateSelection, filesCompacting);
        LOG.debug("Selecting compaction from " + candidateFiles.size() + " store files, " + filesCompacting.size() + " compacting, " + candidateSelection.size() + " eligible, " + this.storeConfigInfo.getBlockingFileCount() + " blocking");
        boolean bl = isAllFiles = candidateFiles.size() == candidateSelection.size();
        if (!forceMajor || !isAllFiles) {
            candidateSelection = this.skipLargeFiles(candidateSelection);
            isAllFiles = candidateFiles.size() == candidateSelection.size();
        }
        boolean isTryingMajor = forceMajor && isAllFiles && isUserCompaction || (forceMajor && isAllFiles || this.isMajorCompaction(candidateSelection)) && candidateSelection.size() < this.comConf.getMaxFilesToCompact();
        boolean isAfterSplit = StoreUtils.hasReferences(candidateSelection);
        if (!isTryingMajor && !isAfterSplit) {
            candidateSelection = this.filterBulk(candidateSelection);
            candidateSelection = this.applyCompactionPolicy(candidateSelection, mayUseOffPeak, mayBeStuck);
            candidateSelection = this.checkMinFilesCriteria(candidateSelection);
        }
        candidateSelection = this.removeExcessFiles(candidateSelection, isUserCompaction, isTryingMajor);
        isAllFiles = candidateFiles.size() == candidateSelection.size();
        CompactionRequest result = new CompactionRequest(candidateSelection);
        result.setOffPeak(!candidateSelection.isEmpty() && !isAllFiles && mayUseOffPeak);
        result.setIsMajor(isTryingMajor && isAllFiles, isAllFiles);
        return result;
    }

    private ArrayList<StoreFile> skipLargeFiles(ArrayList<StoreFile> candidates) {
        int pos;
        for (pos = 0; pos < candidates.size() && !candidates.get(pos).isReference() && candidates.get(pos).getReader().length() > this.comConf.getMaxCompactSize(); ++pos) {
        }
        if (pos > 0) {
            LOG.debug("Some files are too large. Excluding " + pos + " files from compaction candidates");
            candidates.subList(0, pos).clear();
        }
        return candidates;
    }

    private ArrayList<StoreFile> filterBulk(ArrayList<StoreFile> candidates) {
        candidates.removeAll(Collections2.filter(candidates, new Predicate<StoreFile>(){

            @Override
            public boolean apply(StoreFile input) {
                return input.excludeFromMinorCompaction();
            }
        }));
        return candidates;
    }

    private ArrayList<StoreFile> removeExcessFiles(ArrayList<StoreFile> candidates, boolean isUserCompaction, boolean isMajorCompaction) {
        int excess = candidates.size() - this.comConf.getMaxFilesToCompact();
        if (excess > 0) {
            if (isMajorCompaction && isUserCompaction) {
                LOG.debug("Warning, compacting more than " + this.comConf.getMaxFilesToCompact() + " files because of a user-requested major compaction");
            } else {
                LOG.debug("Too many admissible files. Excluding " + excess + " files from compaction candidates");
                candidates.subList(this.comConf.getMaxFilesToCompact(), candidates.size()).clear();
            }
        }
        return candidates;
    }

    private ArrayList<StoreFile> checkMinFilesCriteria(ArrayList<StoreFile> candidates) {
        int minFiles = this.comConf.getMinFilesToCompact();
        if (candidates.size() < minFiles) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Not compacting files because we only have " + candidates.size() + " files ready for compaction. Need " + minFiles + " to initiate.");
            }
            candidates.clear();
        }
        return candidates;
    }

    ArrayList<StoreFile> applyCompactionPolicy(ArrayList<StoreFile> candidates, boolean mayUseOffPeak, boolean mayBeStuck) throws IOException {
        int filesToLeave;
        if (candidates.isEmpty()) {
            return candidates;
        }
        int start = 0;
        double ratio = this.comConf.getCompactionRatio();
        if (mayUseOffPeak) {
            ratio = this.comConf.getCompactionRatioOffPeak();
            LOG.info("Running an off-peak compaction, selection ratio = " + ratio);
        }
        int countOfFiles = candidates.size();
        long[] fileSizes = new long[countOfFiles];
        long[] sumSize = new long[countOfFiles];
        for (int i = countOfFiles - 1; i >= 0; --i) {
            StoreFile file = candidates.get(i);
            fileSizes[i] = file.getReader().length();
            int tooFar = i + this.comConf.getMaxFilesToCompact() - 1;
            sumSize[i] = fileSizes[i] + (i + 1 < countOfFiles ? sumSize[i + 1] : 0L) - (tooFar < countOfFiles ? fileSizes[tooFar] : 0L);
        }
        while (countOfFiles - start >= this.comConf.getMinFilesToCompact() && fileSizes[start] > Math.max(this.comConf.getMinCompactSize(), (long)((double)sumSize[start + 1] * ratio))) {
            ++start;
        }
        if (start < countOfFiles) {
            LOG.info("Default compaction algorithm has selected " + (countOfFiles - start) + " files from " + countOfFiles + " candidates");
        } else if (mayBeStuck && (filesToLeave = candidates.size() - this.comConf.getMinFilesToCompact()) >= 0) {
            start = filesToLeave;
        }
        candidates.subList(0, start).clear();
        return candidates;
    }

    @Override
    public boolean isMajorCompaction(Collection<StoreFile> filesToCompact) throws IOException {
        boolean result = false;
        long mcTime = this.getNextMajorCompactTime(filesToCompact);
        if (filesToCompact == null || filesToCompact.isEmpty() || mcTime == 0L) {
            return result;
        }
        long lowTimestamp = StoreUtils.getLowestTimestamp(filesToCompact);
        long now = System.currentTimeMillis();
        if (lowTimestamp > 0L && lowTimestamp < now - mcTime) {
            long cfTtl = this.storeConfigInfo.getStoreFileTtl();
            if (filesToCompact.size() == 1) {
                long oldest;
                StoreFile sf = filesToCompact.iterator().next();
                Long minTimestamp = sf.getMinimumTimestamp();
                long l = oldest = minTimestamp == null ? Long.MIN_VALUE : now - minTimestamp;
                if (sf.isMajorCompaction() && (cfTtl == Integer.MAX_VALUE || oldest < cfTtl)) {
                    float blockLocalityIndex = sf.getHDFSBlockDistribution().getBlockLocalityIndex(RSRpcServices.getHostname(this.comConf.conf, false));
                    if (blockLocalityIndex < this.comConf.getMinLocalityToForceCompact()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Major compaction triggered on only store " + this + "; to make hdfs blocks local, current blockLocalityIndex is " + blockLocalityIndex + " (min " + this.comConf.getMinLocalityToForceCompact() + ")");
                        }
                        result = true;
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipping major compaction of " + this + " because one (major) compacted file only, oldestTime " + oldest + "ms is < ttl=" + cfTtl + " and blockLocalityIndex is " + blockLocalityIndex + " (min " + this.comConf.getMinLocalityToForceCompact() + ")");
                    }
                } else if (cfTtl != Integer.MAX_VALUE && oldest > cfTtl) {
                    LOG.debug("Major compaction triggered on store " + this + ", because keyvalues outdated; time since last major compaction " + (now - lowTimestamp) + "ms");
                    result = true;
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Major compaction triggered on store " + this + "; time since last major compaction " + (now - lowTimestamp) + "ms");
                }
                result = true;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextMajorCompactTime(Collection<StoreFile> filesToCompact) {
        double jitterPct;
        long ret = this.comConf.getMajorCompactionPeriod();
        if (ret > 0L && (jitterPct = (double)this.comConf.getMajorCompactionJitter()) > 0.0) {
            long jitter = Math.round((double)ret * jitterPct);
            Integer seed = StoreUtils.getDeterministicRandomSeed(filesToCompact);
            if (seed != null) {
                double rnd = -1.0;
                RatioBasedCompactionPolicy ratioBasedCompactionPolicy = this;
                synchronized (ratioBasedCompactionPolicy) {
                    this.random.setSeed(seed.intValue());
                    rnd = this.random.nextDouble();
                }
                ret += jitter - Math.round((double)(2L * jitter) * rnd);
            } else {
                ret = 0L;
            }
        }
        return ret;
    }

    @Override
    public boolean throttleCompaction(long compactionSize) {
        return compactionSize > this.comConf.getThrottlePoint();
    }

    public boolean needsCompaction(Collection<StoreFile> storeFiles, List<StoreFile> filesCompacting) {
        int numCandidates = storeFiles.size() - filesCompacting.size();
        return numCandidates >= this.comConf.getMinFilesToCompact();
    }
}

