/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.compactions;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.compactions.CurrentHourProvider;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
public abstract class OffPeakHours {
    private static final Log LOG = LogFactory.getLog(OffPeakHours.class);
    public static final OffPeakHours DISABLED = new OffPeakHours(){

        @Override
        public boolean isOffPeakHour() {
            return false;
        }

        @Override
        public boolean isOffPeakHour(int targetHour) {
            return false;
        }
    };

    public static OffPeakHours getInstance(Configuration conf) {
        int startHour = conf.getInt("hbase.offpeak.start.hour", -1);
        int endHour = conf.getInt("hbase.offpeak.end.hour", -1);
        return OffPeakHours.getInstance(startHour, endHour);
    }

    public static OffPeakHours getInstance(int startHour, int endHour) {
        if (startHour == -1 && endHour == -1) {
            return DISABLED;
        }
        if (!OffPeakHours.isValidHour(startHour) || !OffPeakHours.isValidHour(endHour)) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Ignoring invalid start/end hour for peak hour : start = " + startHour + " end = " + endHour + ". Valid numbers are [0-23]");
            }
            return DISABLED;
        }
        if (startHour == endHour) {
            return DISABLED;
        }
        return new OffPeakHoursImpl(startHour, endHour);
    }

    private static boolean isValidHour(int hour) {
        return 0 <= hour && hour <= 23;
    }

    public abstract boolean isOffPeakHour(int var1);

    public abstract boolean isOffPeakHour();

    private static class OffPeakHoursImpl
    extends OffPeakHours {
        final int startHour;
        final int endHour;

        OffPeakHoursImpl(int startHour, int endHour) {
            this.startHour = startHour;
            this.endHour = endHour;
        }

        @Override
        public boolean isOffPeakHour() {
            return this.isOffPeakHour(CurrentHourProvider.getCurrentHour());
        }

        @Override
        public boolean isOffPeakHour(int targetHour) {
            if (this.startHour <= this.endHour) {
                return this.startHour <= targetHour && targetHour < this.endHour;
            }
            return targetHour < this.endHour || this.startHour <= targetHour;
        }
    }
}

