/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.SplitTransactionImpl;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
class SplitRequest
implements Runnable {
    static final Log LOG = LogFactory.getLog(SplitRequest.class);
    private final HRegion parent;
    private final byte[] midKey;
    private final HRegionServer server;
    private TableLockManager.TableLock tableLock;

    SplitRequest(Region region, byte[] midKey, HRegionServer hrs) {
        Preconditions.checkNotNull(hrs);
        this.parent = (HRegion)region;
        this.midKey = midKey;
        this.server = hrs;
    }

    public String toString() {
        return "regionName=" + this.parent + ", midKey=" + Bytes.toStringBinary(this.midKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block43: {
            if (this.server.isStopping() || this.server.isStopped()) {
                LOG.debug("Skipping split because server is stopping=" + this.server.isStopping() + " or stopped=" + this.server.isStopped());
                return;
            }
            boolean success = false;
            this.server.metricsRegionServer.incrSplitRequest();
            long startTime = EnvironmentEdgeManager.currentTime();
            SplitTransactionImpl st = new SplitTransactionImpl(this.parent, this.midKey);
            try {
                this.tableLock = this.server.getTableLockManager().readLock(this.parent.getTableDesc().getTableName(), "SPLIT_REGION:" + this.parent.getRegionInfo().getRegionNameAsString());
                try {
                    this.tableLock.acquire();
                }
                catch (IOException ex) {
                    this.tableLock = null;
                    throw ex;
                }
                if (!st.prepare()) {
                    return;
                }
                try {
                    st.execute(this.server, this.server);
                    success = true;
                }
                catch (Exception e) {
                    block46: {
                        block44: {
                            block45: {
                                if (this.server.isStopping() || this.server.isStopped()) {
                                    LOG.info("Skip rollback/cleanup of failed split of " + this.parent.getRegionInfo().getRegionNameAsString() + " because server is" + (this.server.isStopping() ? " stopping" : " stopped"), e);
                                    if (this.parent.getCoprocessorHost() != null) {
                                        try {
                                            this.parent.getCoprocessorHost().postCompleteSplit();
                                        }
                                        catch (IOException io) {
                                            LOG.error("Split failed " + this, RemoteExceptionHandler.checkIOException(io));
                                        }
                                    }
                                    if (this.parent.shouldForceSplit()) {
                                        this.parent.clearSplit();
                                    }
                                    this.releaseTableLock();
                                    long endTime = EnvironmentEdgeManager.currentTime();
                                    this.server.metricsRegionServer.updateSplitTime(endTime - startTime);
                                    if (success) {
                                        this.server.metricsRegionServer.incrSplitSuccess();
                                        LOG.info("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTime(), (long)startTime));
                                    }
                                    LOG.info("Split transaction journal:\n\t" + StringUtils.join((CharSequence)"\n\t", st.getJournal()));
                                    return;
                                }
                                if (!(e instanceof DroppedSnapshotException)) break block44;
                                this.server.abort("Replay of WAL required. Forcing server shutdown", e);
                                if (this.parent.getCoprocessorHost() == null) break block45;
                                try {
                                    this.parent.getCoprocessorHost().postCompleteSplit();
                                }
                                catch (IOException io) {
                                    LOG.error("Split failed " + this, RemoteExceptionHandler.checkIOException(io));
                                }
                            }
                            if (this.parent.shouldForceSplit()) {
                                this.parent.clearSplit();
                            }
                            this.releaseTableLock();
                            long endTime = EnvironmentEdgeManager.currentTime();
                            this.server.metricsRegionServer.updateSplitTime(endTime - startTime);
                            if (success) {
                                this.server.metricsRegionServer.incrSplitSuccess();
                                LOG.info("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTime(), (long)startTime));
                            }
                            LOG.info("Split transaction journal:\n\t" + StringUtils.join((CharSequence)"\n\t", st.getJournal()));
                            return;
                        }
                        try {
                            LOG.info("Running rollback/cleanup of failed split of " + this.parent.getRegionInfo().getRegionNameAsString() + "; " + e.getMessage(), e);
                            if (st.rollback(this.server, this.server)) {
                                LOG.info("Successful rollback of failed split of " + this.parent.getRegionInfo().getRegionNameAsString());
                            } else {
                                this.server.abort("Abort; we got an error after point-of-no-return");
                            }
                        }
                        catch (RuntimeException ee) {
                            String msg = "Failed rollback of failed split of " + this.parent.getRegionInfo().getRegionNameAsString() + " -- aborting server";
                            LOG.info(msg, ee);
                            this.server.abort(msg + " -- Cause: " + ee.getMessage());
                        }
                        if (this.parent.getCoprocessorHost() == null) break block46;
                        try {
                            this.parent.getCoprocessorHost().postCompleteSplit();
                        }
                        catch (IOException io) {
                            LOG.error("Split failed " + this, RemoteExceptionHandler.checkIOException(io));
                        }
                    }
                    if (this.parent.shouldForceSplit()) {
                        this.parent.clearSplit();
                    }
                    this.releaseTableLock();
                    long endTime = EnvironmentEdgeManager.currentTime();
                    this.server.metricsRegionServer.updateSplitTime(endTime - startTime);
                    if (success) {
                        this.server.metricsRegionServer.incrSplitSuccess();
                        LOG.info("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTime(), (long)startTime));
                    }
                    LOG.info("Split transaction journal:\n\t" + StringUtils.join((CharSequence)"\n\t", st.getJournal()));
                    return;
                    catch (IOException ex) {
                        LOG.error("Split failed " + this, RemoteExceptionHandler.checkIOException(ex));
                        this.server.checkFileSystem();
                        break block43;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (this.parent.getCoprocessorHost() != null) {
                    try {
                        this.parent.getCoprocessorHost().postCompleteSplit();
                    }
                    catch (IOException io) {
                        LOG.error("Split failed " + this, RemoteExceptionHandler.checkIOException(io));
                    }
                }
                if (this.parent.shouldForceSplit()) {
                    this.parent.clearSplit();
                }
                this.releaseTableLock();
                long endTime = EnvironmentEdgeManager.currentTime();
                this.server.metricsRegionServer.updateSplitTime(endTime - startTime);
                if (success) {
                    this.server.metricsRegionServer.incrSplitSuccess();
                    LOG.info("Region split, hbase:meta updated, and report to master. Parent=" + this.parent.getRegionInfo().getRegionNameAsString() + ", new regions: " + st.getFirstDaughter().getRegionNameAsString() + ", " + st.getSecondDaughter().getRegionNameAsString() + ". Split took " + StringUtils.formatTimeDiff((long)EnvironmentEdgeManager.currentTime(), (long)startTime));
                }
                LOG.info("Split transaction journal:\n\t" + StringUtils.join((CharSequence)"\n\t", st.getJournal()));
            }
        }
    }

    protected void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.error("Could not release the table lock (something is really wrong). Aborting this server to avoid holding the lock forever.");
                this.server.abort("Abort; we got an error when releasing the table lock on " + this.parent.getRegionInfo().getRegionNameAsString());
            }
        }
    }
}

