/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.NotAllMetaRegionsOnlineException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.procedure2.ProcedureResult;
import org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class ProcedureSyncWait {
    private static final Log LOG = LogFactory.getLog(ProcedureSyncWait.class);

    private ProcedureSyncWait() {
    }

    public static byte[] submitAndWaitProcedure(ProcedureExecutor<MasterProcedureEnv> procExec, Procedure proc) throws IOException {
        long procId = procExec.submitProcedure(proc);
        return ProcedureSyncWait.waitForProcedureToComplete(procExec, procId);
    }

    public static byte[] waitForProcedureToComplete(ProcedureExecutor<MasterProcedureEnv> procExec, long procId) throws IOException {
        while (!procExec.isFinished(procId) && procExec.isRunning()) {
            Threads.sleepWithoutInterrupt(250L);
        }
        ProcedureResult result = procExec.getResult(procId);
        if (result != null) {
            if (result.isFailed()) {
                throw result.getException().unwrapRemoteException();
            }
            return result.getResult();
        }
        if (procExec.isRunning()) {
            throw new IOException("Procedure " + procId + "not found");
        }
        throw new IOException("The Master is Aborting");
    }

    public static <T> T waitFor(MasterProcedureEnv env, String purpose, Predicate<T> predicate) throws IOException {
        Configuration conf = env.getMasterConfiguration();
        long waitTime = conf.getLong("hbase.master.wait.on.region", 300000L);
        long waitingTimeForEvents = conf.getInt("hbase.master.event.waiting.time", 1000);
        return ProcedureSyncWait.waitFor(env, waitTime, waitingTimeForEvents, purpose, predicate);
    }

    public static <T> T waitFor(MasterProcedureEnv env, long waitTime, long waitingTimeForEvents, String purpose, Predicate<T> predicate) throws IOException {
        long done = EnvironmentEdgeManager.currentTime() + waitTime;
        do {
            T result;
            if ((result = predicate.evaluate()) != null && !result.equals(Boolean.FALSE)) {
                return result;
            }
            try {
                Thread.sleep(waitingTimeForEvents);
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted while sleeping, waiting on " + purpose);
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            LOG.debug("Waiting on " + purpose);
        } while (EnvironmentEdgeManager.currentTime() < done && env.isRunning());
        throw new TimeoutIOException("Timed out while waiting on " + purpose);
    }

    protected static void waitMetaRegions(MasterProcedureEnv env) throws IOException {
        int timeout = env.getMasterConfiguration().getInt("hbase.client.catalog.timeout", 10000);
        try {
            if (env.getMasterServices().getMetaTableLocator().waitMetaRegionLocation(env.getMasterServices().getZooKeeper(), timeout) == null) {
                throw new NotAllMetaRegionsOnlineException();
            }
        }
        catch (InterruptedException e) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(e);
        }
    }

    protected static void waitRegionServers(MasterProcedureEnv env) throws IOException {
        final ServerManager sm = env.getMasterServices().getServerManager();
        ProcedureSyncWait.waitFor(env, "server to assign region(s)", new Predicate<Boolean>(){

            @Override
            public Boolean evaluate() throws IOException {
                List<ServerName> servers = sm.createDestinationServersList();
                return servers != null && !servers.isEmpty();
            }
        });
    }

    protected static List<HRegionInfo> getRegionsFromMeta(final MasterProcedureEnv env, final TableName tableName) throws IOException {
        return ProcedureSyncWait.waitFor(env, "regions of table=" + tableName + " from meta", new Predicate<List<HRegionInfo>>(){

            @Override
            public List<HRegionInfo> evaluate() throws IOException {
                if (TableName.META_TABLE_NAME.equals(tableName)) {
                    return new MetaTableLocator().getMetaRegions(env.getMasterServices().getZooKeeper());
                }
                return MetaTableAccessor.getTableRegions(env.getMasterServices().getZooKeeper(), env.getMasterServices().getConnection(), tableName);
            }
        });
    }

    protected static void waitRegionInTransition(MasterProcedureEnv env, List<HRegionInfo> regions) throws IOException, CoordinatedStateException {
        final AssignmentManager am = env.getMasterServices().getAssignmentManager();
        final RegionStates states = am.getRegionStates();
        for (final HRegionInfo region : regions) {
            ProcedureSyncWait.waitFor(env, "regions " + region.getRegionNameAsString() + " in transition", new Predicate<Boolean>(){

                @Override
                public Boolean evaluate() throws IOException {
                    if (states.isRegionInState(region, RegionState.State.FAILED_OPEN)) {
                        am.regionOffline(region);
                    }
                    return !states.isRegionInTransition(region);
                }
            });
        }
    }

    protected static MasterQuotaManager getMasterQuotaManager(final MasterProcedureEnv env) throws IOException {
        return ProcedureSyncWait.waitFor(env, "quota manager to be available", new Predicate<MasterQuotaManager>(){

            @Override
            public MasterQuotaManager evaluate() throws IOException {
                return env.getMasterServices().getMasterQuotaManager();
            }
        });
    }

    @InterfaceAudience.Private
    public static interface Predicate<T> {
        public T evaluate() throws IOException;
    }
}

