/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.yammer.metrics.core.MetricsRegistry;
import io.netty.channel.Channel;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.CompatibilityFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.HRegionPartitioner;
import org.apache.hadoop.hbase.mapreduce.JarFinder;
import org.apache.hadoop.hbase.mapreduce.KeyValueSerialization;
import org.apache.hadoop.hbase.mapreduce.MultiTableInputFormat;
import org.apache.hadoop.hbase.mapreduce.MutationSerialization;
import org.apache.hadoop.hbase.mapreduce.PutCombiner;
import org.apache.hadoop.hbase.mapreduce.ResultSerialization;
import org.apache.hadoop.hbase.mapreduce.TableInputFormat;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hbase.mapreduce.TableReducer;
import org.apache.hadoop.hbase.mapreduce.TableSnapshotInputFormat;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.hbase.util.Base64;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;
import org.apache.hive.org.apache.zookeeper.ZooKeeper;
import org.apache.htrace.Trace;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class TableMapReduceUtil {
    static Log LOG = LogFactory.getLog(TableMapReduceUtil.class);

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table, scan, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(TableName table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table.getNameAsString(), scan, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString(table), scan, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, Class<? extends InputFormat> inputFormatClass) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table, scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, true, inputFormatClass);
    }

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, boolean initCredentials, Class<? extends InputFormat> inputFormatClass) throws IOException {
        job.setInputFormatClass(inputFormatClass);
        if (outputValueClass != null) {
            job.setMapOutputValueClass(outputValueClass);
        }
        if (outputKeyClass != null) {
            job.setMapOutputKeyClass(outputKeyClass);
        }
        job.setMapperClass(mapper);
        if (Put.class.equals(outputValueClass)) {
            job.setCombinerClass(PutCombiner.class);
        }
        Configuration conf = job.getConfiguration();
        HBaseConfiguration.merge(conf, HBaseConfiguration.create(conf));
        conf.set("hbase.mapreduce.inputtable", table);
        conf.set("hbase.mapreduce.scan", TableMapReduceUtil.convertScanToString(scan));
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName(), KeyValueSerialization.class.getName()});
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        if (initCredentials) {
            TableMapReduceUtil.initCredentials(job);
        }
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, Class<? extends InputFormat> inputFormatClass) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString(table), scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, inputFormatClass);
    }

    public static void initTableMapperJob(byte[] table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        TableMapReduceUtil.initTableMapperJob(Bytes.toString(table), scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableInputFormat.class);
    }

    public static void initTableMapperJob(String table, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        TableMapReduceUtil.initTableMapperJob(table, scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, TableInputFormat.class);
    }

    public static void resetCacheConfig(Configuration conf) {
        conf.setFloat("hfile.block.cache.size", 0.4f);
        conf.setFloat("hbase.bucketcache.size", 0.0f);
        conf.unset("hbase.bucketcache.ioengine");
    }

    public static void initTableSnapshotMapperJob(String snapshotName, Scan scan, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, Path tmpRestoreDir) throws IOException {
        TableSnapshotInputFormat.setInput(job, snapshotName, tmpRestoreDir);
        TableMapReduceUtil.initTableMapperJob(snapshotName, scan, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, false, TableSnapshotInputFormat.class);
        TableMapReduceUtil.resetCacheConfig(job.getConfiguration());
    }

    public static void initTableMapperJob(List<Scan> scans, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job) throws IOException {
        TableMapReduceUtil.initTableMapperJob(scans, mapper, outputKeyClass, outputValueClass, job, true);
    }

    public static void initTableMapperJob(List<Scan> scans, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars) throws IOException {
        TableMapReduceUtil.initTableMapperJob(scans, mapper, outputKeyClass, outputValueClass, job, addDependencyJars, true);
    }

    public static void initTableMapperJob(List<Scan> scans, Class<? extends TableMapper> mapper, Class<?> outputKeyClass, Class<?> outputValueClass, Job job, boolean addDependencyJars, boolean initCredentials) throws IOException {
        job.setInputFormatClass(MultiTableInputFormat.class);
        if (outputValueClass != null) {
            job.setMapOutputValueClass(outputValueClass);
        }
        if (outputKeyClass != null) {
            job.setMapOutputKeyClass(outputKeyClass);
        }
        job.setMapperClass(mapper);
        Configuration conf = job.getConfiguration();
        HBaseConfiguration.merge(conf, HBaseConfiguration.create(conf));
        ArrayList<String> scanStrings = new ArrayList<String>();
        for (Scan scan : scans) {
            scanStrings.add(TableMapReduceUtil.convertScanToString(scan));
        }
        job.getConfiguration().setStrings("hbase.mapreduce.scans", scanStrings.toArray(new String[scanStrings.size()]));
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        if (initCredentials) {
            TableMapReduceUtil.initCredentials(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCredentials(Job job) throws IOException {
        UserProvider userProvider = UserProvider.instantiate(job.getConfiguration());
        if (userProvider.isHadoopSecurityEnabled() && System.getenv("HADOOP_TOKEN_FILE_LOCATION") != null) {
            job.getConfiguration().set("mapreduce.job.credentials.binary", System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        if (userProvider.isHBaseSecurityEnabled()) {
            try {
                String quorumAddress = job.getConfiguration().get("hbase.mapred.output.quorum");
                User user = userProvider.getCurrent();
                if (quorumAddress != null) {
                    Configuration peerConf = HBaseConfiguration.create(job.getConfiguration());
                    ZKUtil.applyClusterKeyToConf(peerConf, quorumAddress);
                    try (Connection peerConn = ConnectionFactory.createConnection(peerConf);){
                        TokenUtil.addTokenForJob(peerConn, user, job);
                    }
                }
                try (Connection conn = ConnectionFactory.createConnection(job.getConfiguration());){
                    TokenUtil.addTokenForJob(conn, user, job);
                }
            }
            catch (InterruptedException ie) {
                LOG.info("Interrupted obtaining user authentication token");
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initCredentialsForCluster(Job job, String quorumAddress) throws IOException {
        UserProvider userProvider = UserProvider.instantiate(job.getConfiguration());
        if (userProvider.isHBaseSecurityEnabled()) {
            try {
                Configuration peerConf = HBaseConfiguration.create(job.getConfiguration());
                ZKUtil.applyClusterKeyToConf(peerConf, quorumAddress);
                try (Connection peerConn = ConnectionFactory.createConnection(peerConf);){
                    TokenUtil.addTokenForJob(peerConn, userProvider.getCurrent(), job);
                }
            }
            catch (InterruptedException e) {
                LOG.info("Interrupted obtaining user authentication token");
                Thread.interrupted();
            }
        }
    }

    static String convertScanToString(Scan scan) throws IOException {
        ClientProtos.Scan proto = ProtobufUtil.toScan(scan);
        return Base64.encodeBytes(proto.toByteArray());
    }

    static Scan convertStringToScan(String base64) throws IOException {
        ClientProtos.Scan scan;
        byte[] decoded = Base64.decode(base64);
        try {
            scan = ClientProtos.Scan.parseFrom(decoded);
        }
        catch (InvalidProtocolBufferException ipbe) {
            throw new IOException(ipbe);
        }
        return ProtobufUtil.toScan(scan);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, null);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, partitioner, null, null, null);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner, String quorumAddress, String serverClass, String serverImpl) throws IOException {
        TableMapReduceUtil.initTableReducerJob(table, reducer, job, partitioner, quorumAddress, serverClass, serverImpl, true);
    }

    public static void initTableReducerJob(String table, Class<? extends TableReducer> reducer, Job job, Class partitioner, String quorumAddress, String serverClass, String serverImpl, boolean addDependencyJars) throws IOException {
        Configuration conf = job.getConfiguration();
        HBaseConfiguration.merge(conf, HBaseConfiguration.create(conf));
        job.setOutputFormatClass(TableOutputFormat.class);
        if (reducer != null) {
            job.setReducerClass(reducer);
        }
        conf.set("hbase.mapred.outputtable", table);
        conf.setStrings("io.serializations", new String[]{conf.get("io.serializations"), MutationSerialization.class.getName(), ResultSerialization.class.getName()});
        if (quorumAddress != null) {
            ZKUtil.transformClusterKey(quorumAddress);
            conf.set("hbase.mapred.output.quorum", quorumAddress);
        }
        if (serverClass != null && serverImpl != null) {
            conf.set("hbase.mapred.output.rs.class", serverClass);
            conf.set("hbase.mapred.output.rs.impl", serverImpl);
        }
        job.setOutputKeyClass(ImmutableBytesWritable.class);
        job.setOutputValueClass(Writable.class);
        if (partitioner == HRegionPartitioner.class) {
            job.setPartitionerClass(HRegionPartitioner.class);
            int regions = MetaTableAccessor.getRegionCount(conf, TableName.valueOf(table));
            if (job.getNumReduceTasks() > regions) {
                job.setNumReduceTasks(regions);
            }
        } else if (partitioner != null) {
            job.setPartitionerClass(partitioner);
        }
        if (addDependencyJars) {
            TableMapReduceUtil.addDependencyJars(job);
        }
        TableMapReduceUtil.initCredentials(job);
    }

    public static void limitNumReduceTasks(String table, Job job) throws IOException {
        int regions = MetaTableAccessor.getRegionCount(job.getConfiguration(), TableName.valueOf(table));
        if (job.getNumReduceTasks() > regions) {
            job.setNumReduceTasks(regions);
        }
    }

    public static void setNumReduceTasks(String table, Job job) throws IOException {
        job.setNumReduceTasks(MetaTableAccessor.getRegionCount(job.getConfiguration(), TableName.valueOf(table)));
    }

    public static void setScannerCaching(Job job, int batchSize) {
        job.getConfiguration().setInt("hbase.client.scanner.caching", batchSize);
    }

    public static void addHBaseDependencyJars(Configuration conf) throws IOException {
        TableMapReduceUtil.addDependencyJars(conf, HConstants.class, ClientProtos.class, Put.class, CompatibilityFactory.class, TableMapper.class, ZooKeeper.class, Channel.class, Message.class, Lists.class, Trace.class, MetricsRegistry.class);
    }

    public static String buildDependencyClasspath(Configuration conf) {
        if (conf == null) {
            throw new IllegalArgumentException("Must provide a configuration object.");
        }
        HashSet paths = new HashSet(conf.getStringCollection("tmpjars"));
        if (paths.size() == 0) {
            throw new IllegalArgumentException("Configuration contains no tmpjars.");
        }
        StringBuilder sb = new StringBuilder();
        for (String s : paths) {
            int idx = s.indexOf(":");
            if (idx != -1) {
                s = s.substring(idx + 1);
            }
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    public static void addDependencyJars(Job job) throws IOException {
        TableMapReduceUtil.addHBaseDependencyJars(job.getConfiguration());
        try {
            TableMapReduceUtil.addDependencyJars(job.getConfiguration(), job.getMapOutputKeyClass(), job.getMapOutputValueClass(), job.getInputFormatClass(), job.getOutputKeyClass(), job.getOutputValueClass(), job.getOutputFormatClass(), job.getPartitionerClass(), job.getCombinerClass());
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
    }

    public static void addDependencyJars(Configuration conf, Class<?> ... classes) throws IOException {
        LocalFileSystem localFs = FileSystem.getLocal((Configuration)conf);
        HashSet<String> jars = new HashSet<String>();
        jars.addAll(conf.getStringCollection("tmpjars"));
        HashMap<String, String> packagedClasses = new HashMap<String, String>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            Path path = TableMapReduceUtil.findOrCreateJar(clazz, (FileSystem)localFs, packagedClasses);
            if (path == null) {
                LOG.warn("Could not find jar for class " + clazz + " in order to ship it to the cluster.");
                continue;
            }
            if (!localFs.exists(path)) {
                LOG.warn("Could not validate jar file " + path + " for class " + clazz);
                continue;
            }
            jars.add(path.toString());
        }
        if (jars.isEmpty()) {
            return;
        }
        conf.set("tmpjars", StringUtils.arrayToString((String[])jars.toArray(new String[jars.size()])));
    }

    private static Path findOrCreateJar(Class<?> my_class, FileSystem fs, Map<String, String> packagedClasses) throws IOException {
        String jar = TableMapReduceUtil.findContainingJar(my_class, packagedClasses);
        if (null == jar || jar.isEmpty()) {
            jar = TableMapReduceUtil.getJar(my_class);
            TableMapReduceUtil.updateMap(jar, packagedClasses);
        }
        if (null == jar || jar.isEmpty()) {
            return null;
        }
        LOG.debug(String.format("For class %s, using jar %s", my_class.getName(), jar));
        return new Path(jar).makeQualified(fs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMap(String jar, Map<String, String> packagedClasses) throws IOException {
        if (null == jar || jar.isEmpty()) {
            return;
        }
        ZipFile zip = null;
        try {
            zip = new ZipFile(jar);
            Enumeration<? extends ZipEntry> iter = zip.entries();
            while (iter.hasMoreElements()) {
                ZipEntry entry = iter.nextElement();
                if (!entry.getName().endsWith("class")) continue;
                packagedClasses.put(entry.getName(), jar);
            }
        }
        finally {
            if (null != zip) {
                zip.close();
            }
        }
    }

    private static String findContainingJar(Class<?> my_class, Map<String, String> packagedClasses) throws IOException {
        ClassLoader loader = my_class.getClassLoader();
        String class_file = my_class.getName().replaceAll("\\.", "/") + ".class";
        if (loader != null) {
            Enumeration<URL> itr = loader.getResources(class_file);
            while (itr.hasMoreElements()) {
                URL url = itr.nextElement();
                if (!"jar".equals(url.getProtocol())) continue;
                String toReturn = url.getPath();
                if (toReturn.startsWith("file:")) {
                    toReturn = toReturn.substring("file:".length());
                }
                toReturn = toReturn.replaceAll("\\+", "%2B");
                toReturn = URLDecoder.decode(toReturn, "UTF-8");
                return toReturn.replaceAll("!.*$", "");
            }
        }
        return packagedClasses.get(class_file);
    }

    private static String getJar(Class<?> my_class) {
        String ret = null;
        try {
            ret = JarFinder.getJar(my_class);
        }
        catch (Exception e) {
            throw new RuntimeException("getJar invocation failed.", e);
        }
        return ret;
    }
}

