/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.MapContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.StatusReporter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

public class MultithreadedTableMapper<K2, V2>
extends TableMapper<K2, V2> {
    private static final Log LOG = LogFactory.getLog(MultithreadedTableMapper.class);
    private Class<? extends Mapper<ImmutableBytesWritable, Result, K2, V2>> mapClass;
    private Mapper.Context outer;
    private ExecutorService executor;
    public static final String NUMBER_OF_THREADS = "hbase.mapreduce.multithreadedmapper.threads";
    public static final String MAPPER_CLASS = "hbase.mapreduce.multithreadedmapper.mapclass";

    public static int getNumberOfThreads(JobContext job) {
        return job.getConfiguration().getInt(NUMBER_OF_THREADS, 10);
    }

    public static void setNumberOfThreads(Job job, int threads) {
        job.getConfiguration().setInt(NUMBER_OF_THREADS, threads);
    }

    public static <K2, V2> Class<Mapper<ImmutableBytesWritable, Result, K2, V2>> getMapperClass(JobContext job) {
        return job.getConfiguration().getClass(MAPPER_CLASS, Mapper.class);
    }

    public static <K2, V2> void setMapperClass(Job job, Class<? extends Mapper<ImmutableBytesWritable, Result, K2, V2>> cls) {
        if (MultithreadedTableMapper.class.isAssignableFrom(cls)) {
            throw new IllegalArgumentException("Can't have recursive MultithreadedTableMapper instances.");
        }
        job.getConfiguration().setClass(MAPPER_CLASS, cls, Mapper.class);
    }

    public void run(Mapper.Context context) throws IOException, InterruptedException {
        this.outer = context;
        int numberOfThreads = MultithreadedTableMapper.getNumberOfThreads((JobContext)context);
        this.mapClass = MultithreadedTableMapper.getMapperClass((JobContext)context);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configuring multithread runner to use " + numberOfThreads + " threads");
        }
        this.executor = Executors.newFixedThreadPool(numberOfThreads);
        for (int i = 0; i < numberOfThreads; ++i) {
            MapRunner thread = new MapRunner(context);
            this.executor.execute(thread);
        }
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            Thread.sleep(1000L);
        }
    }

    private class MapRunner
    implements Runnable {
        private Mapper<ImmutableBytesWritable, Result, K2, V2> mapper;
        private Mapper.Context subcontext;

        MapRunner(Mapper.Context context) throws IOException, InterruptedException {
            this.mapper = (Mapper)ReflectionUtils.newInstance((Class)MultithreadedTableMapper.this.mapClass, (Configuration)context.getConfiguration());
            try {
                Constructor<?> c = context.getClass().getConstructor(Mapper.class, Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class);
                c.setAccessible(true);
                this.subcontext = (Mapper.Context)c.newInstance(new Object[]{this.mapper, MultithreadedTableMapper.this.outer.getConfiguration(), MultithreadedTableMapper.this.outer.getTaskAttemptID(), new SubMapRecordReader(), new SubMapRecordWriter(), context.getOutputCommitter(), new SubMapStatusReporter(), MultithreadedTableMapper.this.outer.getInputSplit()});
            }
            catch (Exception e) {
                try {
                    Constructor<?> c = Class.forName("org.apache.hadoop.mapreduce.task.MapContextImpl").getConstructor(Configuration.class, TaskAttemptID.class, RecordReader.class, RecordWriter.class, OutputCommitter.class, StatusReporter.class, InputSplit.class);
                    c.setAccessible(true);
                    MapContext mc = (MapContext)c.newInstance(new Object[]{MultithreadedTableMapper.this.outer.getConfiguration(), MultithreadedTableMapper.this.outer.getTaskAttemptID(), new SubMapRecordReader(), new SubMapRecordWriter(), context.getOutputCommitter(), new SubMapStatusReporter(), MultithreadedTableMapper.this.outer.getInputSplit()});
                    Class<?> wrappedMapperClass = Class.forName("org.apache.hadoop.mapreduce.lib.map.WrappedMapper");
                    Method getMapContext = wrappedMapperClass.getMethod("getMapContext", MapContext.class);
                    this.subcontext = (Mapper.Context)getMapContext.invoke(wrappedMapperClass.newInstance(), mc);
                }
                catch (Exception ee) {
                    throw new IOException(e);
                }
            }
        }

        @Override
        public void run() {
            try {
                this.mapper.run(this.subcontext);
            }
            catch (Throwable ie) {
                LOG.error("Problem in running map.", ie);
            }
        }
    }

    private class SubMapStatusReporter
    extends StatusReporter {
        private SubMapStatusReporter() {
        }

        public Counter getCounter(Enum<?> name) {
            return MultithreadedTableMapper.this.outer.getCounter(name);
        }

        public Counter getCounter(String group, String name) {
            return MultithreadedTableMapper.this.outer.getCounter(group, name);
        }

        public void progress() {
            MultithreadedTableMapper.this.outer.progress();
        }

        public void setStatus(String status2) {
            MultithreadedTableMapper.this.outer.setStatus(status2);
        }

        public float getProgress() {
            return 0.0f;
        }
    }

    private class SubMapRecordWriter
    extends RecordWriter<K2, V2> {
        private SubMapRecordWriter() {
        }

        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(K2 key, V2 value) throws IOException, InterruptedException {
            Mapper.Context context = MultithreadedTableMapper.this.outer;
            synchronized (context) {
                MultithreadedTableMapper.this.outer.write(key, value);
            }
        }
    }

    private class SubMapRecordReader
    extends RecordReader<ImmutableBytesWritable, Result> {
        private ImmutableBytesWritable key;
        private Result value;
        private Configuration conf;

        private SubMapRecordReader() {
        }

        public void close() throws IOException {
        }

        public float getProgress() throws IOException, InterruptedException {
            return 0.0f;
        }

        public void initialize(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
            this.conf = context.getConfiguration();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean nextKeyValue() throws IOException, InterruptedException {
            Mapper.Context context = MultithreadedTableMapper.this.outer;
            synchronized (context) {
                if (!MultithreadedTableMapper.this.outer.nextKeyValue()) {
                    return false;
                }
                this.key = (ImmutableBytesWritable)ReflectionUtils.copy((Configuration)MultithreadedTableMapper.this.outer.getConfiguration(), (Object)MultithreadedTableMapper.this.outer.getCurrentKey(), (Object)this.key);
                this.value = (Result)ReflectionUtils.copy((Configuration)this.conf, (Object)MultithreadedTableMapper.this.outer.getCurrentValue(), (Object)this.value);
                return true;
            }
        }

        public ImmutableBytesWritable getCurrentKey() {
            return this.key;
        }

        public Result getCurrentValue() {
            return this.value;
        }
    }
}

