/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.apache.hadoop.hbase.CompatibilitySingletonFactory;
import org.apache.hive.org.apache.commons.logging.Log;
import org.apache.hive.org.apache.commons.logging.LogFactory;

public class CompatibilityFactory {
    private static final Log LOG = LogFactory.getLog(CompatibilitySingletonFactory.class);
    public static final String EXCEPTION_START = "Could not create  ";
    public static final String EXCEPTION_END = " Is the hadoop compatibility jar on the classpath?";

    protected CompatibilityFactory() {
    }

    public static synchronized <T> T getInstance(Class<T> klass) {
        Object instance = null;
        try {
            ServiceLoader<T> loader = ServiceLoader.load(klass);
            Iterator<T> it = loader.iterator();
            instance = it.next();
            if (it.hasNext()) {
                StringBuilder msg = new StringBuilder();
                msg.append("ServiceLoader provided more than one implementation for class: ").append(klass).append(", using implementation: ").append(instance.getClass()).append(", other implementations: {");
                while (it.hasNext()) {
                    msg.append(it.next()).append(" ");
                }
                msg.append("}");
                LOG.warn(msg);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(CompatibilityFactory.createExceptionString(klass), e);
        }
        catch (Error e) {
            throw new RuntimeException(CompatibilityFactory.createExceptionString(klass), e);
        }
        if (instance == null) {
            throw new RuntimeException(CompatibilityFactory.createExceptionString(klass));
        }
        return (T)instance;
    }

    protected static String createExceptionString(Class klass) {
        return EXCEPTION_START + klass.toString() + EXCEPTION_END;
    }
}

