/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra.util;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionManager;
import co.cask.tephra.TransactionType;
import co.cask.tephra.persist.TransactionSnapshot;
import java.util.Map;
import org.apache.hive.com.google.common.primitives.Longs;

public class TxUtils {
    public static long getOldestVisibleTimestamp(Map<byte[], Long> ttlByFamily, Transaction tx) {
        long oldestVisible = tx.getVisibilityUpperBound();
        for (Long familyTTL : ttlByFamily.values()) {
            oldestVisible = Math.min(familyTTL <= 0L ? 0L : tx.getVisibilityUpperBound() - familyTTL * 1000000L, oldestVisible);
        }
        return oldestVisible;
    }

    public static long getMaxVisibleTimestamp(Transaction tx) {
        return tx.getWritePointer() < Long.MAX_VALUE ? tx.getWritePointer() + 1L : tx.getWritePointer();
    }

    public static Transaction createDummyTransaction(TransactionSnapshot snapshot) {
        return new Transaction(snapshot.getReadPointer(), Long.MAX_VALUE, Longs.toArray(snapshot.getInvalid()), Longs.toArray(snapshot.getInProgress().keySet()), TxUtils.getFirstShortInProgress(snapshot.getInProgress()), TransactionType.SHORT);
    }

    public static long getFirstShortInProgress(Map<Long, TransactionManager.InProgressTx> inProgress) {
        long firstShort = Long.MAX_VALUE;
        for (Map.Entry<Long, TransactionManager.InProgressTx> entry : inProgress.entrySet()) {
            if (entry.getValue().isLongRunning()) continue;
            firstShort = entry.getKey();
            break;
        }
        return firstShort;
    }
}

