/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.Transaction;
import co.cask.tephra.TransactionAware;
import co.cask.tephra.TransactionCodec;
import co.cask.tephra.TxConstants;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hive.com.google.common.base.Charsets;
import org.apache.hive.com.google.common.base.Objects;
import org.apache.hive.com.google.common.collect.Maps;
import org.apache.hive.com.google.common.collect.Sets;
import org.apache.hive.com.google.common.primitives.Bytes;
import org.apache.hive.com.google.common.primitives.UnsignedBytes;

public abstract class AbstractTransactionAwareTable
implements TransactionAware {
    protected final TransactionCodec txCodec;
    protected final Map<Long, Set<ActionChange>> changeSets;
    protected final TxConstants.ConflictDetection conflictLevel;
    protected Transaction tx;
    protected boolean allowNonTransactional;

    public AbstractTransactionAwareTable(TxConstants.ConflictDetection conflictLevel, boolean allowNonTransactional) {
        this.conflictLevel = conflictLevel;
        this.allowNonTransactional = allowNonTransactional;
        this.txCodec = new TransactionCodec();
        this.changeSets = Maps.newHashMap();
    }

    public boolean getAllowNonTransactional() {
        return this.allowNonTransactional;
    }

    public void setAllowNonTransactional(boolean allowNonTransactional) {
        this.allowNonTransactional = allowNonTransactional;
    }

    @Override
    public void startTx(Transaction tx) {
        this.tx = tx;
    }

    @Override
    public void updateTx(Transaction tx) {
        this.tx = tx;
    }

    @Override
    public Collection<byte[]> getTxChanges() {
        if (this.conflictLevel == TxConstants.ConflictDetection.NONE) {
            return Collections.emptyList();
        }
        TreeSet<byte[]> txChanges = new TreeSet<byte[]>(UnsignedBytes.lexicographicalComparator());
        for (Set<ActionChange> changeSet : this.changeSets.values()) {
            for (ActionChange change : changeSet) {
                txChanges.add(this.getChangeKey(change.getRow(), change.getFamily(), change.getQualifier()));
            }
        }
        return txChanges;
    }

    public byte[] getChangeKey(byte[] row, byte[] family, byte[] qualifier) {
        byte[] key;
        switch (this.conflictLevel) {
            case ROW: {
                key = Bytes.concat(this.getTableKey(), row);
                break;
            }
            case COLUMN: {
                key = Bytes.concat(this.getTableKey(), row, family, qualifier);
                break;
            }
            case NONE: {
                throw new IllegalStateException("NONE conflict detection does not support change keys");
            }
            default: {
                throw new IllegalStateException("Unknown conflict detection level: " + (Object)((Object)this.conflictLevel));
            }
        }
        return key;
    }

    @Override
    public boolean commitTx() throws Exception {
        return this.doCommit();
    }

    protected abstract boolean doCommit() throws IOException;

    @Override
    public void postTxCommit() {
        this.tx = null;
        this.changeSets.clear();
    }

    @Override
    public String getTransactionAwareName() {
        return new String(this.getTableKey(), Charsets.UTF_8);
    }

    protected abstract byte[] getTableKey();

    @Override
    public boolean rollbackTx() throws Exception {
        return this.doRollback();
    }

    protected abstract boolean doRollback() throws Exception;

    protected void addToChangeSet(byte[] row, byte[] family, byte[] qualifier) {
        long currentWritePointer = this.tx.getWritePointer();
        Set<ActionChange> changeSet = this.changeSets.get(currentWritePointer);
        if (changeSet == null) {
            changeSet = Sets.newHashSet();
            this.changeSets.put(currentWritePointer, changeSet);
        }
        switch (this.conflictLevel) {
            case ROW: 
            case NONE: {
                changeSet.add(new ActionChange(row, family));
                break;
            }
            case COLUMN: {
                changeSet.add(new ActionChange(row, family, qualifier));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown conflict detection level: " + (Object)((Object)this.conflictLevel));
            }
        }
    }

    protected class ActionChange {
        private final byte[] row;
        private final byte[] family;
        private final byte[] qualifier;

        public ActionChange(byte[] row, byte[] family) {
            this(row, family, null);
        }

        public ActionChange(byte[] row, byte[] family, byte[] qualifier) {
            this.row = row;
            this.family = family;
            this.qualifier = qualifier;
        }

        public byte[] getRow() {
            return this.row;
        }

        public byte[] getFamily() {
            return this.family;
        }

        public byte[] getQualifier() {
            return this.qualifier;
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ActionChange other = (ActionChange)o;
            return Objects.equal(this.row, other.row) && Objects.equal(this.family, other.family) && Objects.equal(this.qualifier, other.qualifier);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.row);
            result = 31 * result + (this.family != null ? Arrays.hashCode(this.family) : 0);
            result = 31 * result + (this.qualifier != null ? Arrays.hashCode(this.qualifier) : 0);
            return result;
        }
    }
}

