/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.logging;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.util.logging.FileAppender;
import org.apache.spark.util.logging.RollingFileAppender$;
import org.apache.spark.util.logging.RollingPolicy;
import org.spark_project.guava.io.Files;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-d!B\u0001\u0003\u0001\u0019a!a\u0005*pY2Lgn\u001a$jY\u0016\f\u0005\u000f]3oI\u0016\u0014(BA\u0002\u0005\u0003\u001dawnZ4j]\u001eT!!\u0002\u0004\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001d=i\u0011AA\u0005\u0003!\t\u0011ABR5mK\u0006\u0003\b/\u001a8eKJD\u0001B\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\fS:\u0004X\u000f^*ue\u0016\fWn\u0001\u0001\u0011\u0005UQR\"\u0001\f\u000b\u0005]A\u0012AA5p\u0015\u0005I\u0012\u0001\u00026bm\u0006L!a\u0007\f\u0003\u0017%s\u0007/\u001e;TiJ,\u0017-\u001c\u0005\t;\u0001\u0011\t\u0011)A\u0005=\u0005Q\u0011m\u0019;jm\u00164\u0015\u000e\\3\u0011\u0005Uy\u0012B\u0001\u0011\u0017\u0005\u00111\u0015\u000e\\3\t\u0011\t\u0002!Q1A\u0005\u0002\r\nQB]8mY&tw\rU8mS\u000eLX#\u0001\u0013\u0011\u00059)\u0013B\u0001\u0014\u0003\u00055\u0011v\u000e\u001c7j]\u001e\u0004v\u000e\\5ds\"A\u0001\u0006\u0001B\u0001B\u0003%A%\u0001\bs_2d\u0017N\\4Q_2L7-\u001f\u0011\t\u0011)\u0002!\u0011!Q\u0001\n-\nAaY8oMB\u0011A&L\u0007\u0002\r%\u0011aF\u0002\u0002\n'B\f'o[\"p]\u001aD\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\u000bEV4g-\u001a:TSj,\u0007C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$aA%oi\")\u0001\b\u0001C\u0001s\u00051A(\u001b8jiz\"bAO\u001e={yz\u0004C\u0001\b\u0001\u0011\u0015\u0011r\u00071\u0001\u0015\u0011\u0015ir\u00071\u0001\u001f\u0011\u0015\u0011s\u00071\u0001%\u0011\u0015Qs\u00071\u0001,\u0011\u001d\u0001t\u0007%AA\u0002EBq!\u0011\u0001C\u0002\u0013%!)\u0001\tnCb\u0014V\r^1j]\u0016$g)\u001b7fgV\t\u0011\u0007\u0003\u0004E\u0001\u0001\u0006I!M\u0001\u0012[\u0006D(+\u001a;bS:,GMR5mKN\u0004\u0003\"\u0002$\u0001\t\u0003:\u0015\u0001B:u_B$\u0012\u0001\u0013\t\u0003e%K!AS\u001a\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0019\u0002!\t&T\u0001\rCB\u0004XM\u001c3U_\u001aKG.\u001a\u000b\u0004\u0011:3\u0006\"B(L\u0001\u0004\u0001\u0016!\u00022zi\u0016\u001c\bc\u0001\u001aR'&\u0011!k\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003eQK!!V\u001a\u0003\t\tKH/\u001a\u0005\u0006/.\u0003\r!M\u0001\u0004Y\u0016t\u0007\"B-\u0001\t\u00139\u0015\u0001\u0003:pY2|g/\u001a:\t\u000bm\u0003A\u0011B$\u0002\u00115|g/\u001a$jY\u0016Da!\u0018\u0001\u0005\u0002\u00119\u0015A\u00043fY\u0016$Xm\u00147e\r&dWm]\u0004\u0007?\nA\tA\u00021\u0002'I{G\u000e\\5oO\u001aKG.Z!qa\u0016tG-\u001a:\u0011\u00059\tgAB\u0001\u0003\u0011\u00031!m\u0005\u0002bGB\u0011!\u0007Z\u0005\u0003KN\u0012a!\u00118z%\u00164\u0007\"\u0002\u001db\t\u00039G#\u00011\t\u000f%\f'\u0019!C\u0001U\u0006\t2\u000b\u0016*B)\u0016;\u0015l\u0018)S\u001fB+%\u000bV-\u0016\u0003-\u0004\"\u0001\\8\u000e\u00035T!A\u001c\r\u0002\t1\fgnZ\u0005\u0003a6\u0014aa\u0015;sS:<\u0007B\u0002:bA\u0003%1.\u0001\nT)J\u000bE+R$Z?B\u0013v\nU#S)f\u0003\u0003b\u0002;b\u0005\u0004%\tA[\u0001\u0011'R\u0013\u0016\tV#H3~#UIR!V\u0019RCaA^1!\u0002\u0013Y\u0017!E*U%\u0006#ViR-`\t\u00163\u0015)\u0016'UA!9\u00010\u0019b\u0001\n\u0003Q\u0017!E%O)\u0016\u0013f+\u0011'`!J{\u0005+\u0012*U3\"1!0\u0019Q\u0001\n-\f!#\u0013(U\u000bJ3\u0016\tT0Q%>\u0003VI\u0015+ZA!9A0\u0019b\u0001\n\u0003Q\u0017\u0001E%O)\u0016\u0013f+\u0011'`\t\u00163\u0015)\u0016'U\u0011\u0019q\u0018\r)A\u0005W\u0006\t\u0012J\u0014+F%Z\u000bEj\u0018#F\r\u0006+F\n\u0016\u0011\t\u0011\u0005\u0005\u0011M1A\u0005\u0002)\fQbU%[\u000b~\u0003&k\u0014)F%RK\u0006bBA\u0003C\u0002\u0006Ia[\u0001\u000f'&SVi\u0018)S\u001fB+%\u000bV-!\u0011!\tI!\u0019b\u0001\n\u0003Q\u0017\u0001D*J5\u0016{F)\u0012$B+2#\u0006bBA\u0007C\u0002\u0006Ia[\u0001\u000e'&SVi\u0018#F\r\u0006+F\n\u0016\u0011\t\u0011\u0005E\u0011M1A\u0005\u0002)\fqCU#U\u0003&sU\tR0G\u00132+5k\u0018)S\u001fB+%\u000bV-\t\u000f\u0005U\u0011\r)A\u0005W\u0006A\"+\u0012+B\u0013:+Ei\u0018$J\u0019\u0016\u001bv\f\u0015*P!\u0016\u0013F+\u0017\u0011\t\u0011\u0005e\u0011M1A\u0005\u0002\t\u000b1\u0003R#G\u0003VcEk\u0018\"V\r\u001a+%kX*J5\u0016Cq!!\bbA\u0003%\u0011'\u0001\u000bE\u000b\u001a\u000bU\u000b\u0014+`\u0005V3e)\u0012*`'&SV\t\t\u0005\b\u0003C\tG\u0011AA\u0012\u0003a9W\r^*peR,GMU8mY\u0016$wJ^3s\r&dWm\u001d\u000b\u0007\u0003K\ti$!\u0014\u0011\u000b\u0005\u001d\u0012q\u0007\u0010\u000f\t\u0005%\u00121\u0007\b\u0005\u0003W\t\t$\u0004\u0002\u0002.)\u0019\u0011qF\n\u0002\rq\u0012xn\u001c;?\u0013\u0005!\u0014bAA\u001bg\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001d\u0003w\u00111aU3r\u0015\r\t)d\r\u0005\t\u0003\u007f\ty\u00021\u0001\u0002B\u0005IA-\u001b:fGR|'/\u001f\t\u0005\u0003\u0007\nIED\u00023\u0003\u000bJ1!a\u00124\u0003\u0019\u0001&/\u001a3fM&\u0019\u0001/a\u0013\u000b\u0007\u0005\u001d3\u0007\u0003\u0005\u0002P\u0005}\u0001\u0019AA!\u00039\t7\r^5wK\u001aKG.\u001a(b[\u0016D\u0011\"a\u0015b#\u0003%\t!!\u0016\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00136+\t\t9FK\u00022\u00033Z#!a\u0017\u0011\t\u0005u\u0013qM\u0007\u0003\u0003?RA!!\u0019\u0002d\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003K\u001a\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011NA0\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class RollingFileAppender
extends FileAppender {
    public final File org$apache$spark$util$logging$RollingFileAppender$$activeFile;
    private final RollingPolicy rollingPolicy;
    private final int maxRetainedFiles;

    public static int $lessinit$greater$default$5() {
        return RollingFileAppender$.MODULE$.$lessinit$greater$default$5();
    }

    public static Seq<File> getSortedRolledOverFiles(String string, String string2) {
        return RollingFileAppender$.MODULE$.getSortedRolledOverFiles(string, string2);
    }

    public static int DEFAULT_BUFFER_SIZE() {
        return RollingFileAppender$.MODULE$.DEFAULT_BUFFER_SIZE();
    }

    public static String RETAINED_FILES_PROPERTY() {
        return RollingFileAppender$.MODULE$.RETAINED_FILES_PROPERTY();
    }

    public static String SIZE_DEFAULT() {
        return RollingFileAppender$.MODULE$.SIZE_DEFAULT();
    }

    public static String SIZE_PROPERTY() {
        return RollingFileAppender$.MODULE$.SIZE_PROPERTY();
    }

    public static String INTERVAL_DEFAULT() {
        return RollingFileAppender$.MODULE$.INTERVAL_DEFAULT();
    }

    public static String INTERVAL_PROPERTY() {
        return RollingFileAppender$.MODULE$.INTERVAL_PROPERTY();
    }

    public static String STRATEGY_DEFAULT() {
        return RollingFileAppender$.MODULE$.STRATEGY_DEFAULT();
    }

    public static String STRATEGY_PROPERTY() {
        return RollingFileAppender$.MODULE$.STRATEGY_PROPERTY();
    }

    public RollingPolicy rollingPolicy() {
        return this.rollingPolicy;
    }

    private int maxRetainedFiles() {
        return this.maxRetainedFiles;
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public void appendToFile(byte[] bytes, int len) {
        if (this.rollingPolicy().shouldRollover(len)) {
            this.rollover();
            this.rollingPolicy().rolledOver();
        }
        super.appendToFile(bytes, len);
        this.rollingPolicy().bytesWritten(len);
    }

    private void rollover() {
        try {
            this.closeFile();
            this.moveFile();
            this.openFile();
            if (this.maxRetainedFiles() > 0) {
                this.deleteOldFiles();
            }
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RollingFileAppender $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error rolling over ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, exception2);
        }
    }

    private void moveFile() {
        String rolloverSuffix = this.rollingPolicy().generateRolledOverFileSuffix();
        File rolloverFile = new File(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParentFile(), new StringBuilder().append((Object)this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getName()).append((Object)rolloverSuffix).toString()).getAbsoluteFile();
        this.logDebug((Function0<String>)new Serializable(this, rolloverFile){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RollingFileAppender $outer;
            private final File rolloverFile$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attempting to rollover file ", " to file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile, this.rolloverFile$1}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.rolloverFile$1 = rolloverFile$1;
            }
        });
        if (this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.exists()) {
            if (rolloverFile.exists()) {
                int i = 0;
                ObjectRef altRolloverFile = ObjectRef.create(null);
                do {
                    altRolloverFile.elem = new File(this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParent(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", "--", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getName(), rolloverSuffix, BoxesRunTime.boxToInteger((int)i)}))).getAbsoluteFile();
                } while (++i < 10000 && ((File)altRolloverFile.elem).exists());
                this.logWarning((Function0<String>)new Serializable(this, rolloverFile, altRolloverFile){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RollingFileAppender $outer;
                    private final File rolloverFile$1;
                    private final ObjectRef altRolloverFile$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rollover file ", " already exists, "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.rolloverFile$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rolled over ", " to file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile, (File)this.altRolloverFile$1.elem}))).toString();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.rolloverFile$1 = rolloverFile$1;
                        this.altRolloverFile$1 = altRolloverFile$1;
                    }
                });
                Files.move((File)this.org$apache$spark$util$logging$RollingFileAppender$$activeFile, (File)((File)altRolloverFile.elem));
            } else {
                Files.move((File)this.org$apache$spark$util$logging$RollingFileAppender$$activeFile, (File)rolloverFile);
                this.logInfo((Function0<String>)new Serializable(this, rolloverFile){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ RollingFileAppender $outer;
                    private final File rolloverFile$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rolled over ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile, this.rolloverFile$1}));
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.rolloverFile$1 = rolloverFile$1;
                    }
                });
            }
        } else {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RollingFileAppender $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"File ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
    }

    public void deleteOldFiles() {
        try {
            File[] rolledoverFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])this.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParentFile().listFiles(new FileFilter(this){
                private final /* synthetic */ RollingFileAppender $outer;

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean accept(File f) {
                    if (!f.getName().startsWith(this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getName())) return false;
                    File file = f;
                    File file2 = this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile;
                    if (file == null) {
                        if (file2 == null) return false;
                        return true;
                    } else if (((Object)file).equals(file2)) return false;
                    return true;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })).sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()));
            File[] filesToBeDeleted = (File[])Predef$.MODULE$.refArrayOps((Object[])rolledoverFiles).take(package$.MODULE$.max(0, rolledoverFiles.length - this.maxRetainedFiles()));
            Predef$.MODULE$.refArrayOps((Object[])filesToBeDeleted).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RollingFileAppender $outer;

                public final boolean apply(File file) {
                    this.$outer.logInfo((Function0<String>)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final File file$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting file executor log file ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.file$1.getAbsolutePath()}));
                        }
                        {
                            this.file$1 = file$1;
                        }
                    });
                    return file.delete();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Exception exception2) {
            this.logError((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RollingFileAppender $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Error cleaning logs in directory ").append((Object)this.$outer.org$apache$spark$util$logging$RollingFileAppender$$activeFile.getParentFile().getAbsolutePath()).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, exception2);
        }
    }

    public RollingFileAppender(InputStream inputStream, File activeFile, RollingPolicy rollingPolicy, SparkConf conf, int bufferSize) {
        this.org$apache$spark$util$logging$RollingFileAppender$$activeFile = activeFile;
        this.rollingPolicy = rollingPolicy;
        super(inputStream, activeFile, bufferSize);
        this.maxRetainedFiles = conf.getInt(RollingFileAppender$.MODULE$.RETAINED_FILES_PROPERTY(), -1);
    }
}

