/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.collection.unsafe.sort;

import java.util.Comparator;
import org.apache.avro.reflect.Nullable;
import org.apache.spark.memory.MemoryConsumer;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.array.LongArray;
import org.apache.spark.unsafe.memory.MemoryBlock;
import org.apache.spark.util.collection.Sorter;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparators;
import org.apache.spark.util.collection.unsafe.sort.RadixSort;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import org.apache.spark.util.collection.unsafe.sort.RecordPointerAndKeyPrefix;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSortDataFormat;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;

public final class UnsafeInMemorySorter {
    private final MemoryConsumer consumer;
    private final TaskMemoryManager memoryManager;
    @Nullable
    private final Comparator<RecordPointerAndKeyPrefix> sortComparator;
    @Nullable
    private final PrefixComparators.RadixSortSupport radixSortSupport;
    private LongArray array;
    private int pos = 0;
    private int usableCapacity = 0;
    private long initialSize;
    private long totalSortTimeNanos = 0L;

    public UnsafeInMemorySorter(MemoryConsumer consumer, TaskMemoryManager memoryManager, RecordComparator recordComparator, PrefixComparator prefixComparator, int initialSize, boolean canUseRadixSort) {
        this(consumer, memoryManager, recordComparator, prefixComparator, consumer.allocateArray(initialSize * 2), canUseRadixSort);
    }

    public UnsafeInMemorySorter(MemoryConsumer consumer, TaskMemoryManager memoryManager, RecordComparator recordComparator, PrefixComparator prefixComparator, LongArray array, boolean canUseRadixSort) {
        this.consumer = consumer;
        this.memoryManager = memoryManager;
        this.initialSize = array.size();
        if (recordComparator != null) {
            this.sortComparator = new SortComparator(recordComparator, prefixComparator, memoryManager);
            this.radixSortSupport = canUseRadixSort && prefixComparator instanceof PrefixComparators.RadixSortSupport ? (PrefixComparators.RadixSortSupport)prefixComparator : null;
        } else {
            this.sortComparator = null;
            this.radixSortSupport = null;
        }
        this.array = array;
        this.usableCapacity = this.getUsableCapacity();
    }

    private int getUsableCapacity() {
        return (int)((double)this.array.size() / (this.radixSortSupport != null ? 2.0 : 1.5));
    }

    public void free() {
        if (this.consumer != null) {
            this.consumer.freeArray(this.array);
            this.array = null;
        }
    }

    public void reset() {
        if (this.consumer != null) {
            this.consumer.freeArray(this.array);
            this.array = this.consumer.allocateArray(this.initialSize);
            this.usableCapacity = this.getUsableCapacity();
        }
        this.pos = 0;
    }

    public int numRecords() {
        return this.pos / 2;
    }

    public long getSortTimeNanos() {
        return this.totalSortTimeNanos;
    }

    public long getMemoryUsage() {
        return this.array.size() * 8L;
    }

    public boolean hasSpaceForAnotherRecord() {
        return this.pos + 1 < this.usableCapacity;
    }

    public void expandPointerArray(LongArray newArray) {
        if (newArray.size() < this.array.size()) {
            throw new OutOfMemoryError("Not enough memory to grow pointer array");
        }
        Platform.copyMemory((Object)this.array.getBaseObject(), (long)this.array.getBaseOffset(), (Object)newArray.getBaseObject(), (long)newArray.getBaseOffset(), (long)((long)this.pos * 8L));
        this.consumer.freeArray(this.array);
        this.array = newArray;
        this.usableCapacity = this.getUsableCapacity();
    }

    public void insertRecord(long recordPointer, long keyPrefix) {
        if (!this.hasSpaceForAnotherRecord()) {
            throw new IllegalStateException("There is no space for new record");
        }
        this.array.set(this.pos, recordPointer);
        ++this.pos;
        this.array.set(this.pos, keyPrefix);
        ++this.pos;
    }

    public SortedIterator getSortedIterator() {
        int offset = 0;
        long start2 = System.nanoTime();
        if (this.sortComparator != null) {
            if (this.radixSortSupport != null) {
                offset = RadixSort.sortKeyPrefixArray(this.array, this.pos / 2, 0, 7, this.radixSortSupport.sortDescending(), this.radixSortSupport.sortSigned());
            } else {
                MemoryBlock unused = new MemoryBlock(this.array.getBaseObject(), this.array.getBaseOffset() + (long)this.pos * 8L, (this.array.size() - (long)this.pos) * 8L);
                LongArray buffer = new LongArray(unused);
                Sorter<RecordPointerAndKeyPrefix, LongArray> sorter = new Sorter<RecordPointerAndKeyPrefix, LongArray>(new UnsafeSortDataFormat(buffer));
                sorter.sort(this.array, 0, this.pos / 2, this.sortComparator);
            }
        }
        this.totalSortTimeNanos += System.nanoTime() - start2;
        return new SortedIterator(this.pos / 2, offset);
    }

    public final class SortedIterator
    extends UnsafeSorterIterator
    implements Cloneable {
        private final int numRecords;
        private int position;
        private int offset;
        private Object baseObject;
        private long baseOffset;
        private long keyPrefix;
        private int recordLength;

        private SortedIterator(int numRecords, int offset) {
            this.numRecords = numRecords;
            this.position = 0;
            this.offset = offset;
        }

        public SortedIterator clone() {
            SortedIterator iter = new SortedIterator(this.numRecords, this.offset);
            iter.position = this.position;
            iter.baseObject = this.baseObject;
            iter.baseOffset = this.baseOffset;
            iter.keyPrefix = this.keyPrefix;
            iter.recordLength = this.recordLength;
            return iter;
        }

        @Override
        public int getNumRecords() {
            return this.numRecords;
        }

        @Override
        public boolean hasNext() {
            return this.position / 2 < this.numRecords;
        }

        @Override
        public void loadNext() {
            long recordPointer = UnsafeInMemorySorter.this.array.get(this.offset + this.position);
            this.baseObject = UnsafeInMemorySorter.this.memoryManager.getPage(recordPointer);
            this.baseOffset = UnsafeInMemorySorter.this.memoryManager.getOffsetInPage(recordPointer) + 4L;
            this.recordLength = Platform.getInt((Object)this.baseObject, (long)(this.baseOffset - 4L));
            this.keyPrefix = UnsafeInMemorySorter.this.array.get(this.offset + this.position + 1);
            this.position += 2;
        }

        @Override
        public Object getBaseObject() {
            return this.baseObject;
        }

        @Override
        public long getBaseOffset() {
            return this.baseOffset;
        }

        @Override
        public int getRecordLength() {
            return this.recordLength;
        }

        @Override
        public long getKeyPrefix() {
            return this.keyPrefix;
        }
    }

    private static final class SortComparator
    implements Comparator<RecordPointerAndKeyPrefix> {
        private final RecordComparator recordComparator;
        private final PrefixComparator prefixComparator;
        private final TaskMemoryManager memoryManager;

        SortComparator(RecordComparator recordComparator, PrefixComparator prefixComparator, TaskMemoryManager memoryManager) {
            this.recordComparator = recordComparator;
            this.prefixComparator = prefixComparator;
            this.memoryManager = memoryManager;
        }

        @Override
        public int compare(RecordPointerAndKeyPrefix r1, RecordPointerAndKeyPrefix r2) {
            int prefixComparisonResult = this.prefixComparator.compare(r1.keyPrefix, r2.keyPrefix);
            if (prefixComparisonResult == 0) {
                Object baseObject1 = this.memoryManager.getPage(r1.recordPointer);
                long baseOffset1 = this.memoryManager.getOffsetInPage(r1.recordPointer) + 4L;
                Object baseObject2 = this.memoryManager.getPage(r2.recordPointer);
                long baseOffset2 = this.memoryManager.getOffsetInPage(r2.recordPointer) + 4L;
                return this.recordComparator.compare(baseObject1, baseOffset1, baseObject2, baseOffset2);
            }
            return prefixComparisonResult;
        }
    }
}

